/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;

public class FeatureSetMetadata {
    static final String OUTPUT_FILE_NAME = "feature-metadata.json";
    public static final int BASE_ID = 128;
    private final Set<FeatureInfo> featureSplits;
    private static final SupplierProvider INSTANCE = new SupplierProviderImpl();

    public FeatureSetMetadata() {
        this.featureSplits = new HashSet<FeatureInfo>();
    }

    private FeatureSetMetadata(Set<FeatureInfo> featureSplits) {
        this.featureSplits = ImmutableSet.copyOf(featureSplits);
    }

    public void addFeatureSplit(String modulePath, String featureName) {
        this.featureSplits.add(new FeatureInfo(modulePath, featureName, 128 + this.featureSplits.size()));
    }

    public Integer getResOffsetFor(String modulePath) {
        Optional<FeatureInfo> featureInfo = this.featureSplits.stream().filter(metadata -> metadata.modulePath.equals(modulePath)).findFirst();
        return featureInfo.isPresent() ? Integer.valueOf(featureInfo.get().resOffset) : null;
    }

    public String getFeatureNameFor(String modulePath) {
        Optional<FeatureInfo> featureInfo = this.featureSplits.stream().filter(metadata -> metadata.modulePath.equals(modulePath)).findFirst();
        return featureInfo.isPresent() ? featureInfo.get().featureName : null;
    }

    public void save(File outputFile) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        Files.write((CharSequence)gson.toJson(this.featureSplits), (File)outputFile, (Charset)Charsets.UTF_8);
    }

    public static FeatureSetMetadata load(File input) throws IOException {
        if (input.isDirectory()) {
            input = new File(input, OUTPUT_FILE_NAME);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        Type typeToken = new TypeToken<HashSet<FeatureInfo>>(){}.getType();
        try (FileReader fileReader = new FileReader(input);){
            Set featureIds = (Set)gson.fromJson((Reader)fileReader, typeToken);
            FeatureSetMetadata featureSetMetadata = new FeatureSetMetadata(featureIds);
            return featureSetMetadata;
        }
    }

    public static SupplierProvider getInstance() {
        return INSTANCE;
    }

    private static class FeatureInfo {
        final String modulePath;
        final String featureName;
        final int resOffset;

        FeatureInfo(String modulePath, String featureName, int resOffset) {
            this.modulePath = modulePath;
            this.featureName = featureName;
            this.resOffset = resOffset;
        }
    }

    private static class SupplierProviderImpl
    implements SupplierProvider {
        private SupplierProviderImpl() {
        }

        @Override
        public Supplier<String> getFeatureNameSupplierForTask(VariantScope variantScope, Task task) {
            FileCollection fc = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_SET_METADATA);
            task.dependsOn(new Object[]{fc});
            String gradlePath = task.getProject().getPath();
            return TaskInputHelper.memoize(() -> {
                try {
                    FeatureSetMetadata featureSetMetadata = FeatureSetMetadata.load(fc.getSingleFile());
                    return featureSetMetadata.getFeatureNameFor(gradlePath);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }

        @Override
        public Supplier<Integer> getResOffsetSupplierForTask(VariantScope variantScope, Task task) {
            FileCollection fc = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_SET_METADATA);
            task.dependsOn(new Object[]{fc});
            String gradlePath = task.getProject().getPath();
            return TaskInputHelper.memoize(() -> {
                try {
                    FeatureSetMetadata featureSetMetadata = FeatureSetMetadata.load(fc.getSingleFile());
                    return featureSetMetadata.getResOffsetFor(gradlePath);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static interface SupplierProvider {
        public Supplier<String> getFeatureNameSupplierForTask(VariantScope var1, Task var2);

        public Supplier<Integer> getResOffsetSupplierForTask(VariantScope var1, Task var2);
    }
}

