/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.utils.FileUtils;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u0010H\u0007R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r8\u0003@BX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/ZipMergingTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "javaResInputFiles", "getJavaResInputFiles", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setJavaResInputFiles", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "libraryInputFiles", "getLibraryInputFiles", "setLibraryInputFiles", "Ljava/io/File;", "outputFile", "init", "", "init$gradle_core", "merge", "ConfigAction", "gradle-core"})
public class ZipMergingTask
extends AndroidVariantTask {
    @NotNull
    private BuildableArtifact libraryInputFiles;
    @NotNull
    private BuildableArtifact javaResInputFiles;
    private File outputFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getLibraryInputFiles() {
        BuildableArtifact buildableArtifact = this.libraryInputFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"libraryInputFiles");
        }
        return buildableArtifact;
    }

    private final void setLibraryInputFiles(BuildableArtifact buildableArtifact) {
        this.libraryInputFiles = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getJavaResInputFiles() {
        BuildableArtifact buildableArtifact = this.javaResInputFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaResInputFiles");
        }
        return buildableArtifact;
    }

    private final void setJavaResInputFiles(BuildableArtifact buildableArtifact) {
        this.javaResInputFiles = buildableArtifact;
    }

    public final void init$gradle_core(@NotNull BuildableArtifact libraryInputFiles, @NotNull BuildableArtifact javaResInputFiles, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)libraryInputFiles, (String)"libraryInputFiles");
        Intrinsics.checkParameterIsNotNull((Object)javaResInputFiles, (String)"javaResInputFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        this.libraryInputFiles = libraryInputFiles;
        this.javaResInputFiles = javaResInputFiles;
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void merge() throws IOException {
        byte[] buffer = new byte[8192];
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        FileUtils.cleanOutputDir((File)file.getParentFile());
        File file2 = this.outputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        Closeable closeable = new FileOutputStream(file2);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            Closeable closeable2 = new BufferedOutputStream(fos);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream bos = (BufferedOutputStream)closeable2;
                Closeable closeable3 = new ZipOutputStream(bos);
                Throwable throwable3 = null;
                try {
                    ZipOutputStream zos = (ZipOutputStream)closeable3;
                    HashSet entries = Sets.newHashSet();
                    BuildableArtifact buildableArtifact = this.libraryInputFiles;
                    if (buildableArtifact == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"libraryInputFiles");
                    }
                    Iterable iterable = buildableArtifact.getFiles();
                    BuildableArtifact buildableArtifact2 = this.javaResInputFiles;
                    if (buildableArtifact2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"javaResInputFiles");
                    }
                    for (File inputFile : CollectionsKt.union((Iterable)iterable, (Iterable)buildableArtifact2.getFiles())) {
                        Closeable closeable4 = new FileInputStream(inputFile);
                        Throwable throwable4 = null;
                        try {
                            FileInputStream fis = (FileInputStream)closeable4;
                            Closeable closeable5 = new ZipInputStream(fis);
                            Throwable throwable5 = null;
                            try {
                                ZipInputStream zis = (ZipInputStream)closeable5;
                                while (zis.getNextEntry() != null) {
                                    String entryName;
                                    ZipEntry entry;
                                    if (entry.isDirectory() || entries.contains(entryName = entry.getName())) continue;
                                    entries.add(entryName);
                                    zos.putNextEntry(entry);
                                    int count = zis.read(buffer);
                                    while (count != -1) {
                                        zos.write(buffer, 0, count);
                                        count = zis.read(buffer);
                                    }
                                    zos.closeEntry();
                                    zis.closeEntry();
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable6) {
                                throwable5 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable5, (Throwable)throwable5);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable7) {
                            throwable4 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable8) {
                    throwable3 = throwable8;
                    throw throwable8;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable10) {
            throwable = throwable10;
            throw throwable10;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/tasks/ZipMergingTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/tasks/ZipMergingTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<ZipMergingTask> {
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            String string = this.scope.getTaskName("createFullJar");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.getTaskName(\"createFullJar\")");
            return string;
        }

        @Override
        @NotNull
        public Class<ZipMergingTask> getType() {
            return ZipMergingTask.class;
        }

        @Override
        public void execute(@NotNull ZipMergingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            BuildArtifactsHolder buildArtifacts = this.scope.getArtifacts();
            File mainFullJar = buildArtifacts.appendArtifact((ArtifactType)InternalArtifactType.FULL_JAR, (Task)task, "full.jar");
            task.init$gradle_core(buildArtifacts.getOptionalFinalArtifactFiles(InternalArtifactType.LIBRARY_CLASSES), buildArtifacts.getOptionalFinalArtifactFiles(InternalArtifactType.LIBRARY_JAVA_RES), mainFullJar);
            task.setVariantName(this.scope.getFullVariantName());
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

