/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.ide.BaseModuleModelBuilder;
import com.android.build.gradle.internal.ide.DefaultAppBundleProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultAppBundleVariantBuildOutput;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/AppModelBuilder;", "Lcom/android/build/gradle/internal/ide/BaseModuleModelBuilder;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "androidBuilder", "Lcom/android/builder/core/AndroidBuilder;", "variantManager", "Lcom/android/build/gradle/internal/VariantManager;", "taskManager", "Lcom/android/build/gradle/internal/TaskManager;", "config", "Lcom/android/build/gradle/AndroidConfig;", "extraModelInfo", "Lcom/android/build/gradle/internal/ExtraModelInfo;", "ndkHandler", "Lcom/android/build/gradle/internal/ndk/NdkHandler;", "nativeLibraryFactory", "Lcom/android/build/gradle/internal/model/NativeLibraryFactory;", "projectType", "", "generation", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/builder/core/AndroidBuilder;Lcom/android/build/gradle/internal/VariantManager;Lcom/android/build/gradle/internal/TaskManager;Lcom/android/build/gradle/AndroidConfig;Lcom/android/build/gradle/internal/ExtraModelInfo;Lcom/android/build/gradle/internal/ndk/NdkHandler;Lcom/android/build/gradle/internal/model/NativeLibraryFactory;II)V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "buildMinimalisticModel", "canBuild", "", "isBaseSplit", "gradle"})
public final class AppModelBuilder
extends BaseModuleModelBuilder {
    private final VariantManager variantManager;

    @Override
    protected boolean isBaseSplit() {
        return true;
    }

    @Override
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return super.canBuild(modelName) || Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName());
    }

    @Override
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName())) {
            object = this.buildMinimalisticModel();
        } else {
            Object object2 = super.buildAll(modelName, project);
            object = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"super.buildAll(modelName, project)");
        }
        return object;
    }

    private final Object buildMinimalisticModel() {
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        Iterator<VariantScope> iterator = this.variantManager.getVariantScopes().iterator();
        while (iterator.hasNext()) {
            VariantScope variantScope;
            VariantScope variantScope2 = variantScope = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)variantScope2, (String)"variantScope");
            BuildArtifactsHolder artifacts = variantScope2.getArtifacts();
            if (!artifacts.hasArtifact(InternalArtifactType.BUNDLE)) continue;
            File bundleFile = BuildableArtifactUtil.singleFile(artifacts.getFinalArtifactFiles(InternalArtifactType.BUNDLE));
            File apkFolder = BuildableArtifactUtil.singleFile(artifacts.getFinalArtifactFiles(InternalArtifactType.SELECTED_APKS));
            variantsOutput.add((Object)new DefaultAppBundleVariantBuildOutput(variantScope.getFullVariantName(), bundleFile, apkFolder));
        }
        return new DefaultAppBundleProjectBuildOutput((ImmutableList<AppBundleVariantBuildOutput>)variantsOutput.build());
    }

    public AppModelBuilder(@NotNull GlobalScope globalScope, @NotNull AndroidBuilder androidBuilder, @NotNull VariantManager variantManager, @NotNull TaskManager taskManager, @NotNull AndroidConfig config2, @NotNull ExtraModelInfo extraModelInfo, @NotNull NdkHandler ndkHandler, @NotNull NativeLibraryFactory nativeLibraryFactory, int projectType, int generation) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)androidBuilder, (String)"androidBuilder");
        Intrinsics.checkParameterIsNotNull((Object)variantManager, (String)"variantManager");
        Intrinsics.checkParameterIsNotNull((Object)taskManager, (String)"taskManager");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)extraModelInfo, (String)"extraModelInfo");
        Intrinsics.checkParameterIsNotNull((Object)ndkHandler, (String)"ndkHandler");
        Intrinsics.checkParameterIsNotNull((Object)nativeLibraryFactory, (String)"nativeLibraryFactory");
        super(globalScope, androidBuilder, variantManager, taskManager, config2, extraModelInfo, ndkHandler, nativeLibraryFactory, projectType, generation);
        this.variantManager = variantManager;
    }
}

