/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.utils.FileUtils;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenerateApkDataTask
extends AndroidBuilderTask {
    private FileCollection apkDirectoryFileCollection;
    private File resOutputDir;
    private File manifestFile;
    private Supplier<String> mainPkgName;
    private int minSdkVersion;
    private int targetSdkVersion;

    @Input
    String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @TaskAction
    void generate() throws IOException, ProcessException, InterruptedException {
        File apkDirectory = null;
        if (this.apkDirectoryFileCollection != null) {
            Set files = this.apkDirectoryFileCollection.getFiles();
            if (files.isEmpty()) {
                return;
            }
            if (files.size() > 1) {
                throw new IllegalStateException("Wear App dependency resolve to more than one file: " + files);
            }
            apkDirectory = (File)Iterables.getOnlyElement((Iterable)files);
            if (!apkDirectory.isDirectory()) {
                throw new IllegalStateException("Wear App dependency does not resolve to a directory: " + files);
            }
        }
        AndroidBuilder builder = this.getBuilder();
        File outDir = this.getResOutputDir();
        FileUtils.cleanOutputDir((File)outDir);
        if (apkDirectory != null) {
            BuildElements apks = ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, apkDirectory);
            if (apks.isEmpty()) {
                throw new IllegalStateException("Wear App dependency resolve to zero APK");
            }
            if (apks.size() > 1) {
                throw new IllegalStateException("Wear App dependency resolve to more than one APK: " + apks.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()));
            }
            File apk = ((BuildOutput)Iterables.getOnlyElement((Iterable)apks)).getOutputFile();
            File rawDir = new File(outDir, "raw");
            FileUtils.mkdirs((File)rawDir);
            File to = new File(rawDir, "android_wear_micro_apk.apk");
            Files.copy((File)apk, (File)to);
            builder.generateApkData(apk, outDir, this.getMainPkgName(), "android_wear_micro_apk");
        } else {
            builder.generateUnbundledWearApkData(outDir, this.getMainPkgName());
        }
        AndroidBuilder.generateApkDataEntryInManifest((int)this.minSdkVersion, (int)this.targetSdkVersion, (File)this.manifestFile);
    }

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @InputFiles
    @Optional
    public FileCollection getApkFileCollection() {
        return this.apkDirectoryFileCollection;
    }

    @Input
    public String getMainPkgName() {
        return this.mainPkgName.get();
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(int minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @OutputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateApkDataTask> {
        VariantScope scope;
        FileCollection apkFileCollection;

        public ConfigAction(VariantScope scope, FileCollection apkFileCollection) {
            this.scope = scope;
            this.apkFileCollection = apkFileCollection;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("handle", "MicroApk");
        }

        @Override
        public Class<GenerateApkDataTask> getType() {
            return GenerateApkDataTask.class;
        }

        @Override
        public void execute(GenerateApkDataTask task) {
            ApkVariantData variantData = (ApkVariantData)this.scope.getVariantData();
            GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
            variantData.generateApkDataTask = task;
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setVariantName(variantConfiguration.getFullName());
            task.setResOutputDir(this.scope.getMicroApkResDirectory());
            task.apkDirectoryFileCollection = this.apkFileCollection;
            task.manifestFile = this.scope.getMicroApkManifestFile();
            task.mainPkgName = variantConfiguration::getApplicationId;
            task.minSdkVersion = variantConfiguration.getMinSdkVersion().getApiLevel();
            task.targetSdkVersion = variantConfiguration.getTargetSdkVersion().getApiLevel();
        }
    }
}

