/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.JetifyTransform;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.model.Version;
import com.android.tools.build.jetifier.processor.FileMapping;
import com.android.tools.build.jetifier.processor.Processor;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/dependency/JetifyTransform;", "Lorg/gradle/api/artifacts/transform/ArtifactTransform;", "()V", "transform", "", "Ljava/io/File;", "aarOrJarFile", "Companion", "gradle"})
public final class JetifyTransform
extends ArtifactTransform {
    @NotNull
    private static final Lazy jetifyProcessor$delegate;
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<File> transform(@NotNull File aarOrJarFile) {
        Intrinsics.checkParameterIsNotNull((Object)aarOrJarFile, (String)"aarOrJarFile");
        v0 = aarOrJarFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"aarOrJarFile.name");
        v1 = var2_2 = v0;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v2 = v1.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.endsWith$default((String)v2, (String)".aar", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v3 = aarOrJarFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"aarOrJarFile.name");
        v4 = var2_2 = v3;
        if (v4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v5 = v4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.endsWith$default((String)v5, (String)".jar", (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = false;
        }
        Preconditions.checkArgument((boolean)v6);
        if (com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$isNewSupportLibrary(JetifyTransform.Companion, aarOrJarFile)) {
            return CollectionsKt.listOf((Object)aarOrJarFile);
        }
        if (com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$isOldSupportLibrary(JetifyTransform.Companion, aarOrJarFile) && !com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$newSupportLibraryAvailable(JetifyTransform.Companion, aarOrJarFile)) {
            return CollectionsKt.listOf((Object)aarOrJarFile);
        }
        if (com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$isOldSupportLibrary(JetifyTransform.Companion, aarOrJarFile)) {
            throw (Throwable)new IllegalStateException("Dependency was not replaced with AndroidX: " + aarOrJarFile.getAbsolutePath());
        }
        outputFile = new File(this.getOutputDirectory(), "jetified-" + aarOrJarFile.getName());
        try {
            maybeTransformedFile = (File)CollectionsKt.single((Iterable)JetifyTransform.Companion.getJetifyProcessor().transform(SetsKt.setOf((Object)new FileMapping(aarOrJarFile, outputFile)), false));
        }
        catch (Exception exception) {
            throw (Throwable)new RuntimeException("Failed to transform '" + aarOrJarFile + "' using Jetifier. To disable Jetifier," + " set " + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false in your" + " gradle.properties file.", exception);
        }
        Preconditions.checkState((boolean)(Intrinsics.areEqual((Object)maybeTransformedFile, (Object)aarOrJarFile) != false || Intrinsics.areEqual((Object)maybeTransformedFile, (Object)outputFile) != false));
        Verify.verify((boolean)maybeTransformedFile.exists(), (String)("" + outputFile + " does not exist"), (Object[])new Object[0]);
        return CollectionsKt.listOf((Object)maybeTransformedFile);
    }

    @Inject
    public JetifyTransform() {
    }

    static {
        Companion = new Companion(null);
        jetifyProcessor$delegate = LazyKt.lazy((Function0)Companion.jetifyProcessor.2.INSTANCE);
    }

    @NotNull
    public static final Processor getJetifyProcessor() {
        return Companion.getJetifyProcessor();
    }

    @JvmStatic
    public static final void replaceOldSupportLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Companion.replaceOldSupportLibraries(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/dependency/JetifyTransform$Companion;", "", "()V", "jetifyProcessor", "Lcom/android/tools/build/jetifier/processor/Processor;", "jetifyProcessor$annotations", "getJetifyProcessor", "()Lcom/android/tools/build/jetifier/processor/Processor;", "jetifyProcessor$delegate", "Lkotlin/Lazy;", "getEffectiveTargetDependency", "", "targetDependency", "getNewSupportLibrary", "dependency", "Lorg/gradle/api/artifacts/component/ModuleComponentSelector;", "isNewSupportLibrary", "", "aarOrJarFile", "Ljava/io/File;", "isOldSupportLibrary", "maybeSubstituteDependency", "", "dependencySubstitution", "Lorg/gradle/api/artifacts/DependencySubstitution;", "newSupportLibraryAvailable", "oldSupportLibDep", "replaceOldSupportLibraries", "project", "Lorg/gradle/api/Project;", "gradle"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "jetifyProcessor", "getJetifyProcessor()Lcom/android/tools/build/jetifier/processor/Processor;"))};
        }

        @JvmStatic
        public static /* synthetic */ void jetifyProcessor$annotations() {
        }

        @NotNull
        public final Processor getJetifyProcessor() {
            Lazy lazy = jetifyProcessor$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (Processor)lazy.getValue();
        }

        @JvmStatic
        public final void replaceOldSupportLibraries(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            project.getConfigurations().all((Action)replaceOldSupportLibraries.1.INSTANCE);
        }

        private final void maybeSubstituteDependency(DependencySubstitution dependencySubstitution) {
            String targetDependency;
            if (!(dependencySubstitution.getRequested() instanceof ModuleComponentSelector)) {
                return;
            }
            ComponentSelector componentSelector = dependencySubstitution.getRequested();
            if (componentSelector == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentSelector");
            }
            ModuleComponentSelector requestedDependency = (ModuleComponentSelector)componentSelector;
            String newSupportLibrary = this.getNewSupportLibrary(requestedDependency);
            String string = newSupportLibrary;
            if (string == null) {
                string = requestedDependency.getDisplayName();
            }
            String string2 = targetDependency = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"targetDependency");
            String effectiveTargetDependency = this.getEffectiveTargetDependency(string2);
            if (Intrinsics.areEqual((Object)effectiveTargetDependency, (Object)requestedDependency.getDisplayName()) ^ true) {
                dependencySubstitution.useTarget((Object)effectiveTargetDependency, BooleanOption.ENABLE_JETIFIER.name() + " is enabled");
            }
        }

        private final String getNewSupportLibrary(ModuleComponentSelector dependency) {
            if (this.isOldSupportLibrary(dependency)) {
                if (!this.newSupportLibraryAvailable(dependency)) {
                    return null;
                }
                Processor processor = this.getJetifyProcessor();
                String string = dependency.getDisplayName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.displayName");
                Set newSupportLibraries = processor.mapDependency(string);
                if (newSupportLibraries == null || newSupportLibraries.isEmpty()) {
                    throw (Throwable)new IllegalStateException("Can't find substitution for " + dependency.getDisplayName());
                }
                if (newSupportLibraries.size() > 1) {
                    throw (Throwable)new IllegalStateException("Multiple substitutions exist for " + dependency.getDisplayName() + ".\n" + "They are " + newSupportLibraries + '.');
                }
                return (String)CollectionsKt.single((Iterable)newSupportLibraries);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isOldSupportLibrary(ModuleComponentSelector dependency) {
            String string = dependency.getGroup();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.group");
            if (StringsKt.startsWith$default((String)string, (String)"com.android.support", (boolean)false, (int)2, null)) return true;
            String string2 = dependency.getGroup();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dependency.group");
            if (StringsKt.startsWith$default((String)string2, (String)"android.arch", (boolean)false, (int)2, null)) return true;
            if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.android.databinding")) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isOldSupportLibrary(File aarOrJarFile) {
            String string = aarOrJarFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
            CharSequence charSequence = string;
            Regex regex = new Regex(".*com.android.support.*");
            if (regex.matches(charSequence)) return true;
            String string2 = aarOrJarFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"aarOrJarFile.absolutePath");
            charSequence = string2;
            regex = new Regex(".*android.arch.*");
            if (regex.matches(charSequence)) return true;
            String string3 = aarOrJarFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"aarOrJarFile.absolutePath");
            charSequence = string3;
            regex = new Regex(".*com.android.databinding.*");
            if (!regex.matches(charSequence)) return false;
            return true;
        }

        private final boolean newSupportLibraryAvailable(ModuleComponentSelector oldSupportLibDep) {
            String string = oldSupportLibDep.getGroup();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldSupportLibDep.group");
            return !StringsKt.startsWith$default((String)string, (String)"com.android.support.test", (boolean)false, (int)2, null);
        }

        private final boolean newSupportLibraryAvailable(File aarOrJarFile) {
            String string = aarOrJarFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
            CharSequence charSequence = string;
            Regex regex = new Regex(".*com.android.support.test.*");
            return !regex.matches(charSequence);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNewSupportLibrary(File aarOrJarFile) {
            String string = aarOrJarFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"androidx", (boolean)false, (int)2, null)) return true;
            String string2 = aarOrJarFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"aarOrJarFile.absolutePath");
            CharSequence charSequence = string2;
            Regex regex = new Regex(".*com.google.android.material.*");
            if (!regex.matches(charSequence)) return false;
            return true;
        }

        private final String getEffectiveTargetDependency(String targetDependency) {
            List parts = StringsKt.split$default((CharSequence)targetDependency, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
            String group = (String)parts.get(0);
            String module = (String)parts.get(1);
            String version = (String)parts.get(2);
            if (Intrinsics.areEqual((Object)group, (Object)"androidx.databinding")) {
                return "" + group + ':' + module + ':' + Version.ANDROID_GRADLE_PLUGIN_VERSION;
            }
            if (StringsKt.startsWith$default((String)group, (String)"androidx", (boolean)false, (int)2, null)) {
                if (Intrinsics.areEqual((Object)version, (Object)"1.0.0")) {
                    return "" + group + ':' + module + ":1.0.0-alpha1";
                }
                if (Intrinsics.areEqual((Object)version, (Object)"2.0.0-SNAPSHOT")) {
                    return "" + group + ':' + module + ":2.0.0-alpha1";
                }
            }
            return targetDependency;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isNewSupportLibrary(Companion $this, @NotNull File aarOrJarFile) {
            return $this.isNewSupportLibrary(aarOrJarFile);
        }

        public static final /* synthetic */ boolean access$isOldSupportLibrary(Companion $this, @NotNull File aarOrJarFile) {
            return $this.isOldSupportLibrary(aarOrJarFile);
        }

        public static final /* synthetic */ boolean access$newSupportLibraryAvailable(Companion $this, @NotNull File aarOrJarFile) {
            return $this.newSupportLibraryAvailable(aarOrJarFile);
        }

        public static final /* synthetic */ void access$maybeSubstituteDependency(Companion $this, @NotNull DependencySubstitution dependencySubstitution) {
            $this.maybeSubstituteDependency(dependencySubstitution);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

