/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.utils.ILogger;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class InvokeManifestMerger
extends AndroidVariantTask
implements Supplier<File> {
    private File mMainManifestFile;
    private List<File> mSecondaryManifestFiles;
    private File mOutputFile;

    @InputFile
    public File getMainManifestFile() {
        return this.mMainManifestFile;
    }

    public void setMainManifestFile(File mainManifestFile) {
        this.mMainManifestFile = mainManifestFile;
    }

    @InputFiles
    public List<File> getSecondaryManifestFiles() {
        return this.mSecondaryManifestFiles;
    }

    public void setSecondaryManifestFiles(List<File> secondaryManifestFiles) {
        this.mSecondaryManifestFiles = secondaryManifestFiles;
    }

    @OutputFile
    public File getOutputFile() {
        return this.mOutputFile;
    }

    public void setOutputFile(File outputFile) {
        this.mOutputFile = outputFile;
    }

    @TaskAction
    protected void doFullTaskAction() throws ManifestMerger2.MergeFailureException, IOException {
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ManifestMerger2.Invoker mergerInvoker = ManifestMerger2.newMerger((File)this.getMainManifestFile(), (ILogger)iLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION);
        List<File> secondaryManifestFiles = this.getSecondaryManifestFiles();
        mergerInvoker.addLibraryManifests(secondaryManifestFiles.toArray(new File[secondaryManifestFiles.size()]));
        MergingReport mergingReport = mergerInvoker.merge();
        if (mergingReport.getResult().isError()) {
            this.getLogger().error(mergingReport.getReportString());
            mergingReport.log((ILogger)iLogger);
            throw new BuildException(mergingReport.getReportString());
        }
        try (FileWriter fileWriter = new FileWriter(this.getOutputFile());){
            fileWriter.append(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED));
        }
    }

    public File get() {
        return this.getOutputFile();
    }
}

