/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant2;

import com.android.build.api.dsl.extension.VariantCallbackHandler;
import com.android.build.api.dsl.variant.Variant;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.api.dsl.sealing.SealableObject;
import com.android.build.gradle.internal.variant2.VariantCallbackHandlerImpl;
import com.android.build.gradle.internal.variant2.VariantCallbackHolder;
import com.android.build.gradle.internal.variant2.VariantPredicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0014\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/variant2/VariantModelData;", "Lcom/android/build/gradle/internal/api/dsl/sealing/SealableObject;", "Lcom/android/build/gradle/internal/variant2/VariantCallbackHolder;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "variantCallbacks", "Lcom/google/common/collect/ListMultimap;", "Lcom/android/build/gradle/internal/variant2/VariantPredicate;", "Lorg/gradle/api/Action;", "Lcom/android/build/api/dsl/variant/Variant;", "createVariantCallbackHandler", "Lcom/android/build/api/dsl/extension/VariantCallbackHandler;", "register", "", "predicate", "action", "runVariantCallbacks", "variants", "", "gradle"})
public final class VariantModelData
extends SealableObject
implements VariantCallbackHolder {
    private final ListMultimap<VariantPredicate, Action<Variant>> variantCallbacks;

    public final void runVariantCallbacks(@NotNull Collection<? extends Variant> variants) {
        Intrinsics.checkParameterIsNotNull(variants, (String)"variants");
        Set predicates = this.variantCallbacks.keySet();
        for (Variant variant : variants) {
            for (VariantPredicate predicate : predicates) {
                if (!predicate.accept(variant)) continue;
                List actions = this.variantCallbacks.get((Object)predicate);
                for (Action action2 : actions) {
                    action2.execute((Object)variant);
                }
            }
        }
    }

    @Override
    @NotNull
    public VariantCallbackHandler<Variant> createVariantCallbackHandler() {
        return new VariantCallbackHandlerImpl(this, this.getDslScope$gradle());
    }

    @Override
    public void register(@NotNull VariantPredicate predicate, @NotNull Action<Variant> action2) {
        Intrinsics.checkParameterIsNotNull((Object)predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        if (this.checkSeal()) {
            this.variantCallbacks.put((Object)predicate, action2);
        }
    }

    public VariantModelData(@NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        super(dslScope);
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"ArrayListMultimap.create()");
        this.variantCallbacks = (ListMultimap)arrayListMultimap;
    }
}

