/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.CheckInstantAppLibrariesTask;
import com.android.build.gradle.internal.tasks.InstantAppProvisionTask;
import com.android.build.gradle.internal.tasks.InstantAppSideLoadTask;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.BundleInstantApp;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class InstantAppTaskManager
extends TaskManager {
    public InstantAppTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder threadRecorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, threadRecorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        CheckInstantAppLibrariesTask checkInstantAppLibrariesTask = this.taskFactory.create(new CheckInstantAppLibrariesTask.ConfigAction(variantScope));
        File bundleDir = variantScope.getApkLocation();
        BundleInstantApp bundleTask = this.taskFactory.create(new BundleInstantApp.ConfigAction(variantScope, bundleDir));
        variantScope.getAssembleTask().dependsOn(new Object[]{bundleTask});
        bundleTask.dependsOn(new Object[]{checkInstantAppLibrariesTask});
        variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.INSTANTAPP_BUNDLE, (Collection<? extends File>)ImmutableList.of((Object)variantScope.getApkLocation()), (Task)bundleTask);
        this.taskFactory.create(new InstantAppSideLoadTask.ConfigAction(variantScope));
        this.taskFactory.create(variantScope.getTaskName("dummy"));
    }

    @Override
    public void createTasksBeforeEvaluate() {
        super.createTasksBeforeEvaluate();
        this.taskFactory.create(new InstantAppProvisionTask.ConfigAction(this.globalScope));
    }

    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.EMPTY_SCOPES;
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
    }

    @Override
    public void createGlobalLintTask() {
    }

    @Override
    public void configureGlobalLintTask(Collection<VariantScope> variants) {
    }
}

