/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.options.Option;
import com.android.builder.errors.EvalIssueReporter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\u0017\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0019\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/errors/DeprecationReporterImpl;", "Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "projectPath", "", "(Lcom/android/builder/errors/EvalIssueReporter;Ljava/lang/String;)V", "reportDeprecatedConfiguration", "", "newDslElement", "oldConfiguration", "deprecationTarget", "Lcom/android/build/gradle/internal/errors/DeprecationReporter$DeprecationTarget;", "reportDeprecatedOption", "option", "value", "reportDeprecatedUsage", "oldDslElement", "url", "reportDeprecatedValue", "dslElement", "oldValue", "newValue", "reportExperimentalOption", "Lcom/android/build/gradle/options/Option;", "reportObsoleteUsage", "reportRenamedConfiguration", "newConfiguration", "gradle"})
public final class DeprecationReporterImpl
implements DeprecationReporter {
    private final EvalIssueReporter issueReporter;
    private final String projectPath;

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime(), "" + oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name());
    }

    @Override
    public void reportDeprecatedUsage(@NotNull String newDslElement, @NotNull String oldDslElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and has been replaced with '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '\n' + "For more information, see " + url, "" + oldDslElement + "::" + newDslElement + "::" + deprecationTarget.name());
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and will be removed " + deprecationTarget.getRemovalTime(), "" + oldDslElement + "::::" + deprecationTarget.name());
    }

    @Override
    public void reportObsoleteUsage(@NotNull String oldDslElement, @NotNull String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)oldDslElement, (String)"oldDslElement");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL, EvalIssueReporter.Severity.WARNING, "DSL element '" + oldDslElement + "' is obsolete and will be removed " + deprecationTarget.getRemovalTime() + '\n' + "For more information, see " + url, "" + oldDslElement + "::::" + deprecationTarget.name());
    }

    @Override
    public void reportRenamedConfiguration(@NotNull String newConfiguration, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget, @Nullable String url) {
        Intrinsics.checkParameterIsNotNull((Object)newConfiguration, (String)"newConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        String msg = "Configuration '" + oldConfiguration + "' is obsolete and has been replaced with '" + newConfiguration + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime();
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_CONFIGURATION, EvalIssueReporter.Severity.WARNING, url != null ? "" + msg + " For more information see: " + url : msg, "" + oldConfiguration + "::" + newConfiguration + "::" + deprecationTarget.name());
    }

    @Override
    public void reportDeprecatedConfiguration(@NotNull String newDslElement, @NotNull String oldConfiguration, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)newDslElement, (String)"newDslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldConfiguration, (String)"oldConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_CONFIGURATION, EvalIssueReporter.Severity.WARNING, "Configuration '" + oldConfiguration + "' is obsolete and has been replaced with DSL element '" + newDslElement + "'.\n" + "It will be removed " + deprecationTarget.getRemovalTime(), "" + oldConfiguration + "::" + newDslElement + "::" + deprecationTarget.name());
    }

    @Override
    public void reportDeprecatedValue(@NotNull String dslElement, @NotNull String oldValue, @Nullable String newValue, @Nullable String url, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)dslElement, (String)"dslElement");
        Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.DEPRECATED_DSL_VALUE, EvalIssueReporter.Severity.WARNING, "DSL element '" + dslElement + "' has a value '" + oldValue + "' which is obsolete " + (newValue != null ? "and has been replaced with '" + newValue + "'.\n" : "and has not been replaced.\n" + "It will be removed " + deprecationTarget.getRemovalTime() + '\n'), url);
    }

    @Override
    public void reportDeprecatedOption(@NotNull String option, @Nullable String value, @NotNull DeprecationReporter.DeprecationTarget deprecationTarget) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)((Object)deprecationTarget), (String)"deprecationTarget");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, EvalIssueReporter.Severity.WARNING, "The option '" + option + "' is deprecated and should not be used anymore.\n" + (value != null ? "Use '" + option + '=' + value + "' to remove this warning.\n" : "") + "It will be removed " + deprecationTarget.getRemovalTime() + '.');
    }

    @Override
    public void reportExperimentalOption(@NotNull Option<?> option, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.issueReporter.reportIssue(EvalIssueReporter.Type.UNSUPPORTED_PROJECT_OPTION_USE, EvalIssueReporter.Severity.WARNING, "The option setting '" + option.getPropertyName() + '=' + value + "' is experimental and unsupported.\n" + (option.getDefaultValue() != null ? "The current default is '" + String.valueOf(option.getDefaultValue()) + "'\n" : "") + "Consider removing '" + option.getPropertyName() + '=' + value + "' from your gradle.properties.", option.getPropertyName());
    }

    public DeprecationReporterImpl(@NotNull EvalIssueReporter issueReporter, @NotNull String projectPath) {
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        this.issueReporter = issueReporter;
        this.projectPath = projectPath;
    }

    @Override
    public void reportDeprecatedOptions(@NotNull Set<? extends Option<?>> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        DeprecationReporter.DefaultImpls.reportDeprecatedOptions(this, options);
    }
}

