/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.crash;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginExceptionReport;
import com.android.builder.model.Version;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.analytics.crash.GoogleCrashReporter;
import com.android.utils.ILogger;
import com.google.common.base.Throwables;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/crash/PluginCrashReporter;", "", "()V", "reporter", "Lcom/android/tools/analytics/crash/CrashReporter;", "getCrashReporter", "analyticsSettings", "Lcom/android/tools/analytics/AnalyticsSettings;", "maybeReportException", "", "ex", "", "maybeReportExceptionForTest", "settings", "maybeReportExceptionImpl", "gradle"})
public final class PluginCrashReporter {
    private static final CrashReporter reporter;
    public static final PluginCrashReporter INSTANCE;

    @JvmStatic
    public static final boolean maybeReportException(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        return INSTANCE.maybeReportExceptionImpl(reporter, ex);
    }

    public final boolean maybeReportExceptionForTest(@NotNull Throwable ex, @NotNull AnalyticsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        CrashReporter crashReporter = this.getCrashReporter(settings);
        return this.maybeReportExceptionImpl(crashReporter, ex);
    }

    private final CrashReporter getCrashReporter(AnalyticsSettings analyticsSettings) {
        CrashReporter crashReporter;
        if (analyticsSettings.hasOptedIn()) {
            String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Version.ANDROID_GRADLE_PLUGIN_VERSION");
            boolean isDebugBuild = StringsKt.endsWith$default((String)string, (String)"-dev", (boolean)false, (int)2, null);
            crashReporter = (CrashReporter)new GoogleCrashReporter(false, isDebugBuild);
        } else {
            crashReporter = null;
        }
        return crashReporter;
    }

    private final boolean maybeReportExceptionImpl(CrashReporter reporter, Throwable ex) {
        if (reporter == null) {
            return false;
        }
        Throwable throwable = Throwables.getRootCause((Throwable)ex);
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"Throwables.getRootCause(ex)");
        PluginExceptionReport pluginExceptionReport = PluginExceptionReport.Companion.create(throwable);
        if (pluginExceptionReport != null) {
            PluginExceptionReport pluginExceptionReport2;
            PluginExceptionReport it = pluginExceptionReport2 = pluginExceptionReport;
            reporter.submit((CrashReport)it);
            return true;
        }
        return false;
    }

    private PluginCrashReporter() {
    }

    static {
        PluginCrashReporter pluginCrashReporter;
        INSTANCE = pluginCrashReporter = new PluginCrashReporter();
        AnalyticsSettings analyticsSettings = AnalyticsSettings.getInstance((ILogger)LoggerWrapper.getLogger(PluginCrashReporter.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)analyticsSettings, (String)"AnalyticsSettings.getIns\u2026va)\n                    )");
        reporter = pluginCrashReporter.getCrashReporter(analyticsSettings);
    }
}

