/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.internal.AppModelBuilder;
import com.android.build.gradle.internal.FeatureModelBuilder;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.MultiTypeTaskManager;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskFactoryImpl;
import com.android.build.gradle.internal.VariantDimensionData;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.AnnotationProcessorOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTaskConfigAction;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.res.GenerateLibraryRFileTask;
import com.android.build.gradle.internal.res.LinkAndroidResForBundleTask;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.res.namespaced.NamespacedResourcesTaskManager;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.CheckProguardFiles;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExtractProguardFiles;
import com.android.build.gradle.internal.tasks.ExtractTryWithResourcesSupportJar;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.LintCompile;
import com.android.build.gradle.internal.tasks.MergeAaptProguardFilesConfigAction;
import com.android.build.gradle.internal.tasks.PackageForUnitTest;
import com.android.build.gradle.internal.tasks.PrepareLintJar;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingCompilerArguments;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingGenBaseClassesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeArtifactsTransform;
import com.android.build.gradle.internal.tasks.databinding.DataBindingMergeGenClassLogTransform;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.transforms.BuiltInShrinkerTransform;
import com.android.build.gradle.internal.transforms.CustomClassTransform;
import com.android.build.gradle.internal.transforms.D8MainDexListTransform;
import com.android.build.gradle.internal.transforms.DesugarTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransformBuilder;
import com.android.build.gradle.internal.transforms.DexMergerTransform;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.build.gradle.internal.transforms.DexSplitterTransform;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.transforms.ExternalLibsMergerTransform;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.FixStackFramesTransform;
import com.android.build.gradle.internal.transforms.JacocoTransform;
import com.android.build.gradle.internal.transforms.JarMergingTransform;
import com.android.build.gradle.internal.transforms.MainDexListTransform;
import com.android.build.gradle.internal.transforms.MainDexListWriter;
import com.android.build.gradle.internal.transforms.MergeClassesTransform;
import com.android.build.gradle.internal.transforms.MergeJavaResourcesTransform;
import com.android.build.gradle.internal.transforms.MultiDexTransform;
import com.android.build.gradle.internal.transforms.PreDexTransform;
import com.android.build.gradle.internal.transforms.ProGuardTransform;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.internal.transforms.R8Transform;
import com.android.build.gradle.internal.transforms.ShrinkResourcesTransform;
import com.android.build.gradle.internal.transforms.StripDebugSymbolTransform;
import com.android.build.gradle.internal.variant.AndroidArtifactVariantData;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.BuildArtifactReportTask;
import com.android.build.gradle.tasks.CleanBuildCache;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.CopyOutputs;
import com.android.build.gradle.tasks.ExternalNativeBuildJsonTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeCleanTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.build.gradle.tasks.InstantRunResourcesApkBuilder;
import com.android.build.gradle.tasks.JavaPreCompileTask;
import com.android.build.gradle.tasks.LintFixTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import com.android.build.gradle.tasks.LintPerVariantTask;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.SplitsDiscovery;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.build.gradle.tasks.factory.JavaCompileConfigAction;
import com.android.build.gradle.tasks.factory.ProcessJavaResConfigAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.profile.Recorder;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.builder.utils.FileCache;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class TaskManager {
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    public static final String FEATURE_SUFFIX = "Feature";
    public static final String MAIN_PREBUILD = "preBuild";
    public static final String UNINSTALL_ALL = "uninstallAll";
    public static final String DEVICE_CHECK = "deviceCheck";
    public static final String DEVICE_ANDROID_TEST = "deviceAndroidTest";
    public static final String CONNECTED_CHECK = "connectedCheck";
    public static final String CONNECTED_ANDROID_TEST = "connectedAndroidTest";
    public static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    public static final String LINT = "lint";
    public static final String LINT_FIX = "lintFix";
    public static final String EXTRACT_PROGUARD_FILES = "extractProguardFiles";
    protected final Project project;
    protected final ProjectOptions projectOptions;
    protected final AndroidBuilder androidBuilder;
    protected final DataBindingBuilder dataBindingBuilder;
    protected final SdkHandler sdkHandler;
    protected final AndroidConfig extension;
    protected final ToolingModelBuilderRegistry toolingRegistry;
    protected final GlobalScope globalScope;
    protected final Recorder recorder;
    private final Logger logger;
    private final FileCache buildCache;
    protected final TaskFactory taskFactory;
    public Task createMockableJar;

    public TaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        this.globalScope = globalScope;
        this.project = project;
        this.projectOptions = projectOptions;
        this.androidBuilder = androidBuilder;
        this.dataBindingBuilder = dataBindingBuilder;
        this.sdkHandler = sdkHandler;
        this.extension = extension;
        this.toolingRegistry = toolingRegistry;
        this.recorder = recorder;
        this.logger = Logging.getLogger(this.getClass());
        this.buildCache = globalScope.getBuildCache();
        this.taskFactory = new TaskFactoryImpl(project.getTasks());
    }

    public boolean isComponentModelPlugin() {
        return false;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public abstract void createTasksForVariantScope(VariantScope var1);

    protected Collection<Object> getNdkBuildable(BaseVariantData variantData) {
        if (variantData.ndkCompileTask == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(variantData.ndkCompileTask);
    }

    public void configureScopeForNdk(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        scope.setNdkSoFolder(Collections.singleton(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/lib")));
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getName()));
        }
    }

    public void createTasksBeforeEvaluate() {
        this.taskFactory.create(UNINSTALL_ALL, (Action<DefaultTask>)((Action)uninstallAllTask -> {
            uninstallAllTask.setDescription("Uninstall all applications.");
            uninstallAllTask.setGroup(INSTALL_GROUP);
        }));
        this.taskFactory.create(DEVICE_CHECK, (Action<DefaultTask>)((Action)deviceCheckTask -> {
            deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
            deviceCheckTask.setGroup("verification");
        }));
        this.taskFactory.create(CONNECTED_CHECK, (Action<DefaultTask>)((Action)connectedCheckTask -> {
            connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
            connectedCheckTask.setGroup("verification");
        }));
        this.taskFactory.create(MAIN_PREBUILD, (Action<DefaultTask>)((Action)task -> {}));
        ExtractProguardFiles extractProguardFiles = this.taskFactory.create(EXTRACT_PROGUARD_FILES, ExtractProguardFiles.class, task -> {});
        extractProguardFiles.dependsOn(new Object[]{MAIN_PREBUILD});
        this.taskFactory.create(new SourceSetsTask.ConfigAction(this.extension));
        this.taskFactory.create(ASSEMBLE_ANDROID_TEST, (Action<DefaultTask>)((Action)assembleAndroidTestTask -> {
            assembleAndroidTestTask.setGroup(BUILD_GROUP);
            assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
        }));
        this.taskFactory.create(new LintCompile.ConfigAction(this.globalScope));
        this.createGlobalLintTask();
        this.configureCustomLintChecksConfig();
        this.globalScope.setAndroidJarConfig(TaskManager.createAndroidJarConfig(this.project));
        if (this.buildCache != null) {
            this.taskFactory.create(new CleanBuildCache.ConfigAction(this.globalScope));
        }
        this.taskFactory.create(new TaskConfigAction<ConfigAttrTask>(){

            @Override
            public String getName() {
                return "resolveConfigAttr";
            }

            @Override
            public Class<ConfigAttrTask> getType() {
                return ConfigAttrTask.class;
            }

            @Override
            public void execute(ConfigAttrTask task) {
                task.resolvable = true;
            }
        });
        this.taskFactory.create(new TaskConfigAction<ConfigAttrTask>(){

            @Override
            public String getName() {
                return "consumeConfigAttr";
            }

            @Override
            public Class<ConfigAttrTask> getType() {
                return ConfigAttrTask.class;
            }

            @Override
            public void execute(ConfigAttrTask task) {
                task.consumable = true;
            }
        });
    }

    private void configureCustomLintChecksConfig() {
        this.globalScope.setLintChecks(TaskManager.createCustomLintChecksConfig(this.project));
    }

    public static Configuration createCustomLintChecksConfig(Project project) {
        Configuration lintChecks = (Configuration)project.getConfigurations().maybeCreate("lintChecks");
        lintChecks.setVisible(false);
        lintChecks.setDescription("Configuration to apply external lint check jar");
        lintChecks.setCanBeConsumed(false);
        return lintChecks;
    }

    public void configureCustomLintChecks() {
        this.taskFactory.create(new PrepareLintJar.ConfigAction(this.globalScope));
    }

    public void createGlobalLintTask() {
        this.taskFactory.create(LINT, LintGlobalTask.class, task -> {});
        this.taskFactory.configure("check", (Action<? super Task>)((Action)it -> it.dependsOn(new Object[]{LINT})));
        this.taskFactory.create(LINT_FIX, LintFixTask.class, task -> {});
    }

    public void configureGlobalLintTask(Collection<VariantScope> variants) {
        List<VariantScope> filteredVariants = variants.stream().filter(TaskManager::isLintVariant).collect(Collectors.toList());
        if (filteredVariants.isEmpty()) {
            return;
        }
        new LintGlobalTask.GlobalConfigAction(this.globalScope, filteredVariants).execute((LintGlobalTask)this.taskFactory.findByName(LINT));
        new LintFixTask.GlobalConfigAction(this.globalScope, filteredVariants).execute((LintFixTask)this.taskFactory.findByName(LINT_FIX));
        BuildableArtifact lintJar = this.globalScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LINT_JAR);
        for (VariantScope scope : variants) {
            scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LINT_JAR, lintJar);
        }
    }

    public void createMockableJarTask() {
        FileCollection mockableJar = this.globalScope.getMockableJarArtifact();
        this.project.getDependencies().add("androidApi", (Object)this.project.files(new Object[]{this.globalScope.getAndroidBuilder().getTarget().getPath(1)}));
        this.createMockableJar = this.project.getTasks().create("createMockableJar");
        this.createMockableJar.dependsOn(new Object[]{mockableJar});
        this.globalScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MOCKABLE_JAR, mockableJar);
    }

    public static Configuration createAndroidJarConfig(Project project) {
        Configuration androidJarConfig = (Configuration)project.getConfigurations().maybeCreate("androidApi");
        androidJarConfig.setDescription("Configuration providing various types of Android JAR file");
        androidJarConfig.setCanBeConsumed(false);
        return androidJarConfig;
    }

    protected void createDependencyStreams(VariantScope variantScope) {
        this.handleJacocoDependencies(variantScope);
        TransformManager transformManager = variantScope.getTransformManager();
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-res-plus-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-native").addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.JNI)).build());
        if (this.extension.getDataBinding().isEnabled()) {
            transformManager.addStream(OriginalStream.builder(this.project, "sub-project-data-binding").addContentTypes(TransformManager.DATA_BINDING_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-data-binding").addContentTypes(TransformManager.DATA_BINDING_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "sub-project-data-binding-base-classes").addContentTypes(TransformManager.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT)).build());
            transformManager.addStream(OriginalStream.builder(this.project, "ext-libs-data-binding-base-classes").addContentTypes(TransformManager.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.CLASSES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-res-plus-native").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.RESOURCES, ExtendedContentType.NATIVE_LIBS}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.JAVA_RES)).build());
        transformManager.addStream(OriginalStream.builder(this.project, "sub-projects-native").addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.SUB_PROJECTS).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.JNI)).build());
        if (variantScope.consumesFeatureJars() || variantScope.getNeedsMainDexListForBundle()) {
            transformManager.addStream(OriginalStream.builder(this.project, "metadata-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.FEATURES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_CLASSES)).build());
        }
        if (variantScope.consumesFeatureJars()) {
            transformManager.addStream(OriginalStream.builder(this.project, "metadata-java-res").addContentTypes(TransformManager.CONTENT_RESOURCES).addScope(InternalScope.FEATURES).setArtifactCollection(variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_JAVA_RES)).build());
        }
        transformManager.addStream(OriginalStream.builder(this.project, "provided-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY).setFileCollection(variantScope.getProvidedOnlyClasspath()).build());
        if (variantScope.getTestedVariantData() != null) {
            BaseVariantData testedVariantData = variantScope.getTestedVariantData();
            VariantScope testedVariantScope = testedVariantData.getScope();
            PublishingSpecs.VariantSpec testedSpec = testedVariantScope.getPublishingSpec().getTestingSpec(variantScope.getVariantConfiguration().getType());
            PublishingSpecs.OutputSpec taskOutputSpec = testedSpec.getSpec(AndroidArtifacts.ArtifactType.CLASSES);
            ArtifactType testedOutputType = taskOutputSpec.getOutputType();
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setFileCollection((FileCollection)testedVariantScope.getArtifacts().getFinalArtifactFiles(testedOutputType).get()).build());
            transformManager.addStream(OriginalStream.builder(this.project, "tested-code-deps").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.TESTED_CODE).setArtifactCollection(testedVariantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)).build());
        }
    }

    public void createBuildArtifactReportTask(VariantScope scope) {
        this.taskFactory.create(new BuildArtifactReportTask.BuildArtifactReportConfigAction(scope));
    }

    public void createSourceSetArtifactReportTask(GlobalScope scope) {
        for (AndroidSourceSet sourceSet : scope.getExtension().getSourceSets()) {
            if (!(sourceSet instanceof DefaultAndroidSourceSet)) continue;
            this.taskFactory.create(new BuildArtifactReportTask.SourceSetReportConfigAction(scope, (DefaultAndroidSourceSet)sourceSet));
        }
    }

    public void createMergeApkManifestsTask(VariantScope variantScope) {
        AndroidArtifactVariantData androidArtifactVariantData = (AndroidArtifactVariantData)variantScope.getVariantData();
        Set<String> screenSizes = androidArtifactVariantData.getCompatibleScreens();
        this.taskFactory.create(new CompatibleScreensManifest.ConfigAction(variantScope, screenSizes));
        ManifestProcessorTask processManifestTask = this.createMergeManifestTask(variantScope);
        processManifestTask.dependsOn(new Object[]{variantScope.getCheckManifestTask()});
        if (variantScope.getMicroApkTask() != null) {
            processManifestTask.dependsOn(new Object[]{variantScope.getMicroApkTask()});
        }
    }

    private static List<String> getAdvancedProfilingTransforms(ProjectOptions options) {
        String string = options.get(StringOption.IDE_ANDROID_CUSTOM_CLASS_TRANSFORMS);
        if (string == null) {
            return ImmutableList.of();
        }
        return Splitter.on((char)',').splitToList((CharSequence)string);
    }

    protected ManifestProcessorTask createMergeManifestTask(VariantScope variantScope) {
        return this.taskFactory.create(new MergeManifests.ConfigAction(variantScope, !TaskManager.getAdvancedProfilingTransforms(this.projectOptions).isEmpty()));
    }

    public ProcessManifest createMergeLibManifestsTask(VariantScope scope) {
        ProcessManifest processManifest = this.taskFactory.create(new ProcessManifest.ConfigAction(scope));
        processManifest.dependsOn(new Object[]{scope.getCheckManifestTask()});
        scope.getVariantData().addTask(TaskContainer.TaskKind.PROCESS_MANIFEST, (Task)processManifest);
        return processManifest;
    }

    protected void createProcessTestManifestTask(VariantScope scope, VariantScope testedScope) {
        ProcessTestManifest processTestManifestTask = this.taskFactory.create(new ProcessTestManifest.ConfigAction(scope, testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS)));
        if (scope.getCheckManifestTask() != null) {
            processTestManifestTask.dependsOn(new Object[]{scope.getCheckManifestTask()});
        }
        scope.getVariantData().addTask(TaskContainer.TaskKind.PROCESS_MANIFEST, (Task)processTestManifestTask);
    }

    public void createRenderscriptTask(VariantScope scope) {
        scope.setRenderscriptCompileTask(this.taskFactory.create(new RenderscriptCompile.ConfigAction(scope)));
        GradleVariantConfiguration config2 = scope.getVariantConfiguration();
        if (config2.getType().isTestComponent()) {
            scope.getRenderscriptCompileTask().dependsOn(new Object[]{scope.getVariantData().getTaskByKind(TaskContainer.TaskKind.PROCESS_MANIFEST)});
        } else {
            scope.getRenderscriptCompileTask().dependsOn(new Object[]{scope.getPreBuildTask()});
        }
        scope.getResourceGenTask().dependsOn(new Object[]{scope.getRenderscriptCompileTask()});
        if (!config2.getRenderscriptNdkModeEnabled()) {
            scope.getSourceGenTask().dependsOn(new Object[]{scope.getRenderscriptCompileTask()});
        }
    }

    public MergeResources createMergeResourcesTask(VariantScope scope, boolean processResources, ImmutableSet<MergeResources.Flag> flags) {
        boolean unitTestRawResources = this.globalScope.getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources() && !this.projectOptions.get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
        boolean alsoOutputNotCompiledResources = scope.getType().isApk() && !scope.getType().isForTesting() && (scope.useResourceShrinker() || unitTestRawResources);
        return this.basicCreateMergeResourcesTask(scope, MergeType.MERGE, null, true, processResources, alsoOutputNotCompiledResources, flags);
    }

    public MergeResources basicCreateMergeResourcesTask(VariantScope scope, MergeType mergeType, File outputLocation, boolean includeDependencies, boolean processResources, boolean alsoOutputNotCompiledResources, ImmutableSet<MergeResources.Flag> flags) {
        File mergedOutputDir = (File)MoreObjects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir());
        String taskNamePrefix = mergeType.name().toLowerCase(Locale.ENGLISH);
        File mergedNotCompiledDir = alsoOutputNotCompiledResources ? new File(this.globalScope.getIntermediatesDir() + "/merged-not-compiled-resources/" + scope.getVariantConfiguration().getDirName()) : null;
        MergeResources mergeResourcesTask = this.taskFactory.create(new MergeResources.ConfigAction(scope, taskNamePrefix, mergedOutputDir, mergedNotCompiledDir, includeDependencies, processResources, flags));
        scope.getArtifacts().appendArtifact((ArtifactType)mergeType.getOutputType(), (Collection<? extends File>)ImmutableList.of((Object)mergedOutputDir), (Task)mergeResourcesTask);
        if (alsoOutputNotCompiledResources) {
            scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MERGED_NOT_COMPILED_RES, (Collection<? extends File>)ImmutableList.of((Object)mergedNotCompiledDir), (Task)mergeResourcesTask);
        }
        mergeResourcesTask.dependsOn(new Object[]{scope.getResourceGenTask()});
        if (this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            scope.getCompileTask().dependsOn(new Object[]{mergeResourcesTask});
        }
        scope.setResourceOutputDir(mergedOutputDir);
        return mergeResourcesTask;
    }

    public void createMergeAssetsTask(VariantScope scope) {
        MergeSourceSetFolders mergeAssetsTask = this.taskFactory.create(new MergeSourceSetFolders.MergeAppAssetConfigAction(scope));
        mergeAssetsTask.dependsOn(new Object[]{scope.getAssetGenTask()});
        scope.setMergeAssetsTask(mergeAssetsTask);
    }

    public Optional<TransformTask> createMergeJniLibFoldersTasks(VariantScope variantScope) {
        MergeSourceSetFolders mergeJniLibFoldersTask = this.taskFactory.create(new MergeSourceSetFolders.MergeJniLibFoldersConfigAction(variantScope));
        mergeJniLibFoldersTask.dependsOn(new Object[]{variantScope.getAssetGenTask()});
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "mergedJniFolder").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(variantScope.getMergeNativeLibsOutputDir()).setDependency(mergeJniLibFoldersTask.getName()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "local-ndk-build").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolders(variantScope::getNdkSoFolder).setDependency(this.getNdkBuildable(variantScope.getVariantData())).build());
        if (variantScope.getExternalNativeJsonGenerator() != null) {
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "external-native-build").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolder(variantScope.getExternalNativeJsonGenerator().getObjFolder()).setDependency(((ExternalNativeBuildTask)((Object)Preconditions.checkNotNull((Object)((Object)variantScope.getExternalNativeBuildTask())))).getName()).build());
        }
        if (variantScope.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
            Supplier<Collection<File>> supplier = () -> {
                File rsLibs;
                ImmutableList.Builder builder = ImmutableList.builder();
                if (variantScope.getRenderscriptLibOutputDir().isDirectory()) {
                    builder.add((Object)variantScope.getRenderscriptLibOutputDir());
                }
                if ((rsLibs = variantScope.getGlobalScope().getAndroidBuilder().getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
                    builder.add((Object)rsLibs);
                }
                if (variantScope.getVariantConfiguration().getRenderscriptSupportModeBlasEnabled()) {
                    File rsBlasLib = variantScope.getGlobalScope().getAndroidBuilder().getSupportBlasLibFolder();
                    if (rsBlasLib == null || !rsBlasLib.isDirectory()) {
                        throw new GradleException("Renderscript BLAS support mode is not supported in BuildTools" + rsBlasLib);
                    }
                    builder.add((Object)rsBlasLib);
                }
                return builder.build();
            };
            variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "rs-support-mode-output").addContentType(ExtendedContentType.NATIVE_LIBS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFolders(supplier).setDependency(variantScope.getRenderscriptCompileTask().getName()).build());
        }
        Set<? super QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, ExtendedContentType.NATIVE_LIBS, "mergeJniLibs", variantScope);
        return variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, mergeTransform);
    }

    public void createBuildConfigTask(VariantScope scope) {
        GenerateBuildConfig generateBuildConfigTask = this.taskFactory.create(new GenerateBuildConfig.ConfigAction(scope));
        scope.setGenerateBuildConfigTask(generateBuildConfigTask);
        scope.getSourceGenTask().dependsOn(new Object[]{generateBuildConfigTask.getName()});
        if (scope.getVariantConfiguration().getType().isTestComponent()) {
            generateBuildConfigTask.dependsOn(new Object[]{scope.getVariantData().getTaskByKind(TaskContainer.TaskKind.PROCESS_MANIFEST)});
        } else {
            generateBuildConfigTask.dependsOn(new Object[]{scope.getCheckManifestTask()});
        }
    }

    public void createGenerateResValuesTask(VariantScope scope) {
        GenerateResValues generateResValuesTask = this.taskFactory.create(new GenerateResValues.ConfigAction(scope));
        scope.getResourceGenTask().dependsOn(new Object[]{generateResValuesTask});
    }

    public void createApkProcessResTask(VariantScope scope) {
        VariantType variantType = scope.getVariantData().getVariantConfiguration().getType();
        InternalArtifactType packageOutputType = variantType.isApk() && !variantType.isForTesting() ? InternalArtifactType.FEATURE_RESOURCE_PKG : null;
        this.createApkProcessResTask(scope, packageOutputType);
        if (scope.consumesFeatureJars()) {
            this.taskFactory.create(new MergeAaptProguardFilesConfigAction(scope));
        }
    }

    private void createApkProcessResTask(VariantScope scope, InternalArtifactType packageOutputType) {
        this.createProcessResTask(scope, new File(this.globalScope.getIntermediatesDir(), "symbols/" + scope.getVariantData().getVariantConfiguration().getDirName()), packageOutputType, MergeType.MERGE, scope.getGlobalScope().getProjectBaseName());
    }

    protected boolean isLibrary() {
        return false;
    }

    public void createProcessResTask(VariantScope scope, File symbolLocation, InternalArtifactType packageOutputType, MergeType mergeType, String baseName) {
        BaseVariantData variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        this.createSplitsDiscovery(scope);
        boolean useAaptToGenerateLegacyMultidexMainDexProguardRules = scope.getNeedsMainDexList();
        if (Boolean.TRUE.equals(scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
            new NamespacedResourcesTaskManager(this.globalScope, this.taskFactory, scope).createNamespacedResourceTasks(packageOutputType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
            return;
        }
        this.createNonNamespacedResourceTasks(scope, symbolLocation, packageOutputType, mergeType, baseName, useAaptToGenerateLegacyMultidexMainDexProguardRules);
    }

    private void createNonNamespacedResourceTasks(VariantScope scope, File symbolDirectory, InternalArtifactType packageOutputType, MergeType mergeType, String baseName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules) {
        ProcessAndroidResources task;
        File symbolTableWithPackageName = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "symbol-table-with-package", scope.getVariantConfiguration().getDirName(), "package-aware-r.txt"});
        File symbolFile = new File(symbolDirectory, "R.txt");
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        if (mergeType == MergeType.PACKAGE) {
            task = this.taskFactory.create(new GenerateLibraryRFileTask.ConfigAction(scope, symbolFile, symbolTableWithPackageName));
        } else {
            task = this.taskFactory.create(this.createProcessAndroidResourcesConfigAction(scope, () -> symbolDirectory, symbolTableWithPackageName, useAaptToGenerateLegacyMultidexMainDexProguardRules, mergeType, baseName));
            if (packageOutputType != null) {
                artifacts.appendArtifact((ArtifactType)packageOutputType, artifacts.getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES));
            }
            this.taskFactory.create(new LinkAndroidResForBundleTask.ConfigAction(scope));
        }
        scope.setProcessResourcesTask(task);
        artifacts.appendArtifact((ArtifactType)InternalArtifactType.SYMBOL_LIST, (Collection<? extends File>)ImmutableList.of((Object)symbolFile), (Task)task);
        scope.getSourceGenTask().dependsOn(new Object[]{task});
        artifacts.appendArtifact((ArtifactType)InternalArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME, (Collection<? extends File>)ImmutableList.of((Object)symbolTableWithPackageName), (Task)task);
    }

    protected TaskConfigAction<LinkApplicationAndroidResourcesTask> createProcessAndroidResourcesConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolWithPackageName, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules, MergeType sourceArtifactType, String baseName) {
        return new LinkApplicationAndroidResourcesTask.ConfigAction(scope, symbolLocation, symbolWithPackageName, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceArtifactType, baseName, this.isLibrary());
    }

    public void createSplitResourcesTasks(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"Can only create split resources tasks for pure splits.");
        variantData.packageSplitResourcesTask = this.taskFactory.create(new PackageSplitRes.ConfigAction(scope));
        if (scope.getVariantConfiguration().getSigningConfig() != null) {
            variantData.packageSplitResourcesTask.dependsOn(new Object[]{this.getValidateSigningTask(scope)});
        }
    }

    public PackageSplitAbi createSplitAbiTasks(VariantScope scope) {
        PackageSplitAbi packageSplitAbiTask;
        BaseVariantData variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS), (Object)"split ABI tasks are only compatible with pure splits.");
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.extension.getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return null;
        }
        List<ApkData> fullApkDatas = variantData.getOutputScope().getSplitsByType(VariantOutput.OutputType.FULL_SPLIT);
        if (!fullApkDatas.isEmpty()) {
            throw new RuntimeException("In release 21 and later, there cannot be full splits and pure splits, found " + Joiner.on((String)",").join(fullApkDatas) + " and abi filters " + Joiner.on((String)",").join(filters));
        }
        this.taskFactory.create(new GenerateSplitAbiRes.ConfigAction(scope));
        variantData.packageSplitAbiTask = packageSplitAbiTask = this.taskFactory.create(new PackageSplitAbi.ConfigAction(scope));
        packageSplitAbiTask.dependsOn(new Object[]{scope.getNdkBuildable()});
        if (variantData.getVariantConfiguration().getSigningConfig() != null) {
            packageSplitAbiTask.dependsOn(new Object[]{this.getValidateSigningTask(variantData.getScope())});
        }
        if (scope.getExternalNativeBuildTask() != null) {
            packageSplitAbiTask.dependsOn(new Object[]{scope.getExternalNativeBuildTask()});
        }
        return packageSplitAbiTask;
    }

    public void createSplitTasks(VariantScope variantScope) {
        this.createSplitResourcesTasks(variantScope);
        this.createSplitAbiTasks(variantScope);
    }

    protected abstract Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope var1);

    public void createProcessJavaResTask(VariantScope variantScope) {
        File destinationDir = variantScope.getSourceFoldersJavaResDestinationDir();
        Sync processJavaResourcesTask = this.taskFactory.create(new ProcessJavaResConfigAction(variantScope, destinationDir));
        variantScope.setProcessJavaResourcesTask(processJavaResourcesTask);
        variantScope.getVariantData().processJavaResourcesTask = processJavaResourcesTask;
        processJavaResourcesTask.dependsOn(new Object[]{variantScope.getPreBuildTask()});
        BuildableArtifact javaRes = variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.JAVA_RES, (Collection<? extends File>)ImmutableList.of((Object)destinationDir), (Task)processJavaResourcesTask);
        variantScope.getTransformManager().addStream(OriginalStream.builder(this.project, "processed-java-res").addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)javaRes.get()).build());
    }

    public void createMergeJavaResTransform(VariantScope variantScope) {
        TransformManager transformManager = variantScope.getTransformManager();
        Set<? super QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES, "mergeJavaRes", variantScope);
        Optional<TransformTask> transformTask = transformManager.addTransform(this.taskFactory, variantScope, mergeTransform);
        variantScope.setMergeJavaResourcesTask(transformTask.orElse(null));
        File mergeJavaResOutput = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"transforms", "mergeJavaRes", variantScope.getVariantConfiguration().getDirName(), "0.jar"});
        if (transformTask.isPresent()) {
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.FEATURE_AND_RUNTIME_DEPS_JAVA_RES, (Collection<? extends File>)ImmutableList.of((Object)mergeJavaResOutput), (Task)transformTask.get());
        }
    }

    public AidlCompile createAidlTask(VariantScope scope) {
        AidlCompile aidlCompileTask = this.taskFactory.create(new AidlCompile.ConfigAction(scope));
        scope.setAidlCompileTask(aidlCompileTask);
        scope.getSourceGenTask().dependsOn(new Object[]{aidlCompileTask});
        aidlCompileTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        return aidlCompileTask;
    }

    public void createShaderTask(VariantScope scope) {
        MergeSourceSetFolders mergeShadersTask = this.taskFactory.create(new MergeSourceSetFolders.MergeShaderSourceFoldersConfigAction(scope));
        ShaderCompile shaderCompileTask = this.taskFactory.create(new ShaderCompile.ConfigAction(scope));
        shaderCompileTask.dependsOn(new Object[]{mergeShadersTask});
        scope.getAssetGenTask().dependsOn(new Object[]{shaderCompileTask});
    }

    protected abstract void postJavacCreation(VariantScope var1);

    public JavaCompile createJavacTask(VariantScope scope) {
        JavaPreCompileTask preCompileTask = this.taskFactory.create(new JavaPreCompileTask.ConfigAction(scope));
        preCompileTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        JavaCompile javacTask = this.taskFactory.create(new JavaCompileConfigAction(scope));
        scope.setJavacTask(javacTask);
        TaskManager.setupCompileTaskDependencies(scope, (Task)javacTask);
        this.postJavacCreation(scope);
        return javacTask;
    }

    public void addJavacClassesStream(VariantScope scope) {
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        FileCollection javaOutputs = (FileCollection)artifacts.getFinalArtifactFiles(InternalArtifactType.JAVAC).get();
        Preconditions.checkNotNull((Object)javaOutputs);
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "javac-output").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(javaOutputs).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "pre-javac-generated-bytecode").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPreJavacGeneratedBytecode()).build());
        scope.getTransformManager().addStream(OriginalStream.builder(this.project, "post-javac-generated-bytecode").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection(scope.getVariantData().getAllPostJavacGeneratedBytecode()).build());
        if (artifacts.hasArtifact(InternalArtifactType.RUNTIME_R_CLASS_CLASSES)) {
            scope.getTransformManager().addStream(OriginalStream.builder(this.project, "final-r-classes").addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES}).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROJECT).setFileCollection((FileCollection)artifacts.getFinalArtifactFiles(InternalArtifactType.RUNTIME_R_CLASS_CLASSES).get()).build());
        }
    }

    private static void setupCompileTaskDependencies(VariantScope scope, Task compileTask) {
        if (scope.getSourceGenTask() != null) {
            compileTask.dependsOn(new Object[]{scope.getSourceGenTask()});
        }
    }

    protected void createCompileTask(VariantScope variantScope) {
        JavaCompile javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        this.createPostCompilationTasks(variantScope);
    }

    public static void setJavaCompilerTask(Task javaCompilerTask, VariantScope scope) {
        scope.getCompileTask().dependsOn(new Object[]{javaCompilerTask});
    }

    public void createGenerateMicroApkDataTask(VariantScope scope, FileCollection config2) {
        GenerateApkDataTask generateMicroApkTask = this.taskFactory.create(new GenerateApkDataTask.ConfigAction(scope, config2));
        scope.setMicroApkTask(generateMicroApkTask);
        scope.getResourceGenTask().dependsOn(new Object[]{generateMicroApkTask});
    }

    public void createExternalNativeBuildJsonGenerators(VariantScope scope) {
        CoreExternalNativeBuild externalNativeBuild = this.extension.getExternalNativeBuild();
        ExternalNativeBuildTaskUtils.ExternalNativeBuildProjectPathResolution pathResolution = ExternalNativeBuildTaskUtils.getProjectPath(externalNativeBuild);
        if (pathResolution.errorText != null) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException(pathResolution.errorText, scope.getVariantConfiguration().getFullName()));
            return;
        }
        if (pathResolution.makeFile == null) {
            return;
        }
        scope.setExternalNativeJsonGenerator(ExternalNativeJsonGenerator.create(this.project.getPath(), this.project.getProjectDir(), this.project.getBuildDir(), pathResolution.externalNativeBuildDir, (NativeBuildSystem)((Object)Preconditions.checkNotNull((Object)((Object)pathResolution.buildSystem))), pathResolution.makeFile, this.androidBuilder, this.sdkHandler, scope));
    }

    public void createExternalNativeBuildTasks(VariantScope scope) {
        ExternalNativeJsonGenerator generator = scope.getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        ExternalNativeBuildJsonTask generateTask = this.taskFactory.create(ExternalNativeBuildJsonTask.createTaskConfigAction(generator, scope));
        generateTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        String targetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
        ExternalNativeBuildTask buildTask = this.taskFactory.create(new ExternalNativeBuildTask.ConfigAction(targetAbi, generator, scope, this.androidBuilder));
        buildTask.dependsOn(new Object[]{generateTask, scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JNI)});
        scope.setExternalNativeBuildTask(buildTask);
        scope.getCompileTask().dependsOn(new Object[]{buildTask});
        Task cleanTask = (Task)Preconditions.checkNotNull((Object)this.taskFactory.findByName("clean"));
        cleanTask.dependsOn(new Object[]{this.taskFactory.create(new ExternalNativeCleanTask.ConfigAction(generator, scope, this.androidBuilder)).getName()});
    }

    public void createNdkTasks(VariantScope scope) {
        if (ExternalNativeBuildTaskUtils.isExternalNativeBuildEnabled(this.extension.getExternalNativeBuild())) {
            return;
        }
        NdkCompile ndkCompileTask = this.taskFactory.create(new NdkCompile.ConfigAction(scope));
        ndkCompileTask.dependsOn(new Object[]{scope.getPreBuildTask()});
        if (Boolean.TRUE.equals(scope.getVariantData().getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled())) {
            ndkCompileTask.dependsOn(new Object[]{scope.getRenderscriptCompileTask()});
        }
        scope.getCompileTask().dependsOn(new Object[]{ndkCompileTask});
    }

    public static void createStripNativeLibraryTask(TaskFactory taskFactory, VariantScope scope) {
        if (!scope.getGlobalScope().getNdkHandler().isConfigured()) {
            return;
        }
        TransformManager transformManager = scope.getTransformManager();
        GlobalScope globalScope = scope.getGlobalScope();
        transformManager.addTransform(taskFactory, scope, new StripDebugSymbolTransform(globalScope.getProject(), globalScope.getNdkHandler(), globalScope.getExtension().getPackagingOptions().getDoNotStrip(), scope.getVariantConfiguration().getType().isAar(), scope.consumesFeatureJars()));
    }

    public void createUnitTestVariantTasks(TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BaseVariantData testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData(), (Object)"Not a unit test variant");
        VariantScope testedVariantScope = testedVariantData.getScope();
        boolean includeAndroidResources = this.extension.getTestOptions().getUnitTests().isIncludeAndroidResources();
        boolean enableBinaryResources = includeAndroidResources && this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.createProcessJavaResTask(variantScope);
        if (includeAndroidResources) {
            if (testedVariantScope.getType().isAar()) {
                this.createProcessTestManifestTask(variantScope, testedVariantData.getScope());
                this.createGenerateResValuesTask(variantScope);
                this.createMergeAssetsTask(variantScope);
                if (enableBinaryResources) {
                    this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
                    this.createApkProcessResTask(variantScope, InternalArtifactType.FEATURE_RESOURCE_PKG);
                    this.taskFactory.create(new PackageForUnitTest.ConfigAction(variantScope));
                } else {
                    this.createMergeResourcesTask(variantScope, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
                }
            } else if (testedVariantScope.getType().isApk()) {
                if (enableBinaryResources) {
                    variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.PROCESSED_RES, testedVariantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES));
                    variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MERGED_ASSETS, testedVariantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS));
                    this.taskFactory.create(new PackageForUnitTest.ConfigAction(variantScope));
                } else {
                    variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MERGED_RES, testedVariantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_NOT_COMPILED_RES));
                }
            } else {
                throw new IllegalStateException("Tested variant " + testedVariantScope.getFullVariantName() + " in " + this.globalScope.getProject().getPath() + " must be a library or an application to have unit tests.");
            }
            GenerateTestConfig generateTestConfig = this.taskFactory.create(new GenerateTestConfig.ConfigAction(variantScope));
            variantScope.getCompileTask().dependsOn(new Object[]{generateTestConfig});
        }
        Task compileTask = variantScope.getCompileTask();
        compileTask.dependsOn(new Object[]{variantScope.getProcessJavaResourcesTask(), testedVariantScope.getProcessJavaResourcesTask()});
        variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR, (FileCollection)this.project.files(new Object[0]));
        JavaCompile javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        javacTask.dependsOn(new Object[]{testedVariantScope.getJavacTask()});
        this.createMergeJavaResTransform(variantScope);
        this.createRunUnitTestTask(variantScope);
        variantScope.getAssembleTask().setGroup(null);
    }

    protected void createSplitsDiscovery(VariantScope variantScope) {
        if (variantScope.getVariantData().getType().getCanHaveSplits()) {
            SplitsDiscovery splitsDiscovery = this.taskFactory.create(new SplitsDiscovery.ConfigAction(variantScope));
        }
    }

    public void createAndroidTestVariantTasks(TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        this.createAnchorTasks(variantScope);
        this.createDependencyStreams(variantScope);
        this.taskFactory.create(new MainApkListPersistence.ConfigAction(variantScope));
        this.createProcessTestManifestTask(variantScope, ((BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getScope());
        this.createGenerateResValuesTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createApkProcessResTask(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        if (!this.isComponentModelPlugin()) {
            this.createNdkTasks(variantScope);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createMergeJniLibFoldersTasks(variantScope);
        this.createDataBindingTasksIfNecessary(variantScope, MergeType.MERGE);
        JavaCompile javacTask = this.createJavacTask(variantScope);
        this.addJavacClassesStream(variantScope);
        TaskManager.setJavaCompilerTask((Task)javacTask, variantScope);
        this.createPostCompilationTasks(variantScope);
        this.createPackagingTask(variantScope, null);
        this.taskFactory.configure(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)((Action)assembleTest -> assembleTest.dependsOn(new Object[]{variantData.getScope().getAssembleTask().getName()})));
        this.createConnectedTestForVariant(variantScope);
    }

    private static boolean isLintVariant(VariantScope variantScope) {
        VariantType variantType = variantScope.getVariantConfiguration().getType();
        return !variantType.isTestComponent() && !variantType.isHybrid();
    }

    public void createLintTasks(VariantScope scope) {
        if (!TaskManager.isLintVariant(scope)) {
            return;
        }
        this.taskFactory.create(new LintPerVariantTask.ConfigAction(scope));
    }

    private String getTaskPath(String taskName) {
        return this.project.getRootProject() == this.project ? ':' + taskName : this.project.getPath() + ':' + taskName;
    }

    private void maybeCreateLintVitalTask(ApkVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (!TaskManager.isLintVariant(variantScope) || variantScope.getInstantRunBuildContext().isInInstantRunMode() || ((CoreBuildType)variantConfig.getBuildType()).isDebuggable() || !this.extension.getLintOptions().isCheckReleaseBuilds()) {
            return;
        }
        LintPerVariantTask lintReleaseCheck = this.taskFactory.create(new LintPerVariantTask.VitalConfigAction(variantScope));
        if (variantData.javacTask != null) {
            lintReleaseCheck.dependsOn(new Object[]{variantData.javacTask});
        }
        variantScope.getAssembleTask().dependsOn(new Object[]{lintReleaseCheck});
        this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(this.getTaskPath(LINT))) {
                this.project.getTasks().getByName(lintReleaseCheck.getName()).setEnabled(false);
            }
        });
    }

    private void createRunUnitTestTask(VariantScope variantScope) {
        AndroidUnitTest runTestsTask = this.taskFactory.create(new AndroidUnitTest.ConfigAction(variantScope));
        this.taskFactory.configure("test", (Action<? super Task>)((Action)test -> test.dependsOn(new Object[]{runTestsTask.getName()})));
    }

    public void createTopLevelTestTasks(boolean hasFlavors) {
        DefaultTask deviceAndroidTestTask;
        DefaultTask connectedAndroidTestTask;
        this.createMockableJarTask();
        ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        if (hasFlavors) {
            connectedAndroidTestTask = this.taskFactory.create(new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.CONNECTED));
            reportTasks.add(connectedAndroidTestTask.getName());
        } else {
            connectedAndroidTestTask = this.taskFactory.create(CONNECTED_ANDROID_TEST, (Action<DefaultTask>)((Action)connectedTask -> {
                connectedTask.setGroup("verification");
                connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
            }));
        }
        this.taskFactory.configure(CONNECTED_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{connectedAndroidTestTask.getName()})));
        if (providers.size() > 1 || hasFlavors) {
            deviceAndroidTestTask = this.taskFactory.create(new AndroidReportTask.ConfigAction(this.globalScope, AndroidReportTask.ConfigAction.TaskKind.DEVICE_PROVIDER));
            reportTasks.add(deviceAndroidTestTask.getName());
        } else {
            deviceAndroidTestTask = this.taskFactory.create(DEVICE_ANDROID_TEST, (Action<DefaultTask>)((Action)providerTask -> {
                providerTask.setGroup("verification");
                providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
            }));
        }
        this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{deviceAndroidTestTask.getName()})));
        this.taskFactory.create("test", (Action<DefaultTask>)((Action)unitTestTask -> {
            unitTestTask.setGroup("verification");
            unitTestTask.setDescription("Run unit tests for all variants.");
        }));
        this.taskFactory.configure("check", (Action<? super Task>)((Action)check -> check.dependsOn(new Object[]{"test"})));
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady(taskGraph -> {
                for (String reportTask : reportTasks) {
                    if (!taskGraph.hasTask(this.getTaskPath(reportTask))) continue;
                    this.taskFactory.configure(reportTask, (Action<? super Task>)((Action)task -> ((AndroidReportTask)task).setWillRun()));
                }
            });
        }
    }

    protected void createConnectedTestForVariant(VariantScope variantScope) {
        BaseVariantData baseVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData());
        TestVariantData testVariantData = (TestVariantData)variantScope.getVariantData();
        boolean isLibrary = baseVariantData.getVariantConfiguration().getType().isAar();
        TestDataImpl testData = new TestDataImpl(testVariantData, variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK), isLibrary ? null : testVariantData.getTestedVariantData().getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK));
        testData.setExtraInstrumentationTestRunnerArgs(this.projectOptions.getExtraInstrumentationTestRunnerArgs());
        this.configureTestData(testData);
        ImmutableList artifactsTasks = ImmutableList.of((Object)variantScope.getAssembleTask(), (Object)testVariantData.getTestedVariantData().getScope().getAssembleTask());
        DeviceProviderInstrumentTestTask connectedTask = this.taskFactory.create(new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), testData, (FileCollection)this.project.files(new Object[0])));
        connectedTask.dependsOn(artifactsTasks.toArray());
        variantScope.setConnectedTask(connectedTask);
        this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{connectedTask.getName()})));
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            Configuration jacocoAntConfiguration = JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, this.getJacocoVersion(variantScope));
            Object reportTask = this.taskFactory.create(new JacocoReportTask.ConfigAction(variantScope, jacocoAntConfiguration));
            reportTask.dependsOn(new Object[]{connectedTask.getName()});
            variantScope.setCoverageReportTask((Task)reportTask);
            baseVariantData.getScope().getCoverageReportTask().dependsOn(new Object[]{reportTask});
            this.taskFactory.configure(CONNECTED_ANDROID_TEST, (Action<? super Task>)((Action)connectedAndroidTest -> connectedAndroidTest.dependsOn(new Object[]{reportTask.getName()})));
        }
        List<DeviceProvider> providers = this.extension.getDeviceProviders();
        for (DeviceProvider deviceProvider : providers) {
            DeviceProviderInstrumentTestTask providerTask = this.taskFactory.create(new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), deviceProvider, testData, (FileCollection)this.project.files(new Object[0])));
            providerTask.dependsOn(artifactsTasks.toArray());
            this.taskFactory.configure(DEVICE_ANDROID_TEST, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{providerTask.getName()})));
        }
        List<TestServer> servers = this.extension.getTestServers();
        for (TestServer testServer : servers) {
            TestServerTask serverTask = this.taskFactory.create(new TestServerTask.TestServerTaskConfigAction(variantScope, testServer));
            serverTask.dependsOn(new Object[]{variantScope.getAssembleTask()});
            this.taskFactory.configure(DEVICE_CHECK, (Action<? super Task>)((Action)deviceAndroidTest -> deviceAndroidTest.dependsOn(new Object[]{serverTask.getName()})));
        }
    }

    public void createPostCompilationTasks(VariantScope variantScope) {
        DexingType dexingType;
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull((Object)variantScope.getJavacTask());
        BaseVariantData variantData = variantScope.getVariantData();
        GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config2.getBuildType()).isTestCoverageEnabled() && !config2.getType().isForTesting() && !variantScope.getInstantRunBuildContext().isInInstantRunMode();
        if (isTestCoverageEnabled) {
            this.createJacocoTransform(variantScope);
        }
        this.maybeCreateDesugarTask(variantScope, config2.getMinSdkVersion(), transformManager);
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        this.createMergeJavaResTransform(variantScope);
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i = 0; i < count; ++i) {
            Transform transform2 = customTransforms.get(i);
            List<Object> deps = customTransformsDependencies.get(i);
            transformManager.addTransform(this.taskFactory, variantScope, transform2).ifPresent(t -> {
                if (!deps.isEmpty()) {
                    t.dependsOn(new Object[]{deps});
                }
                if (transform2.getScopes().isEmpty()) {
                    variantScope.getAssembleTask().dependsOn(new Object[]{t});
                }
            });
        }
        if (variantData.getType().isFeatureSplit()) {
            this.createMergeClassesTransform(variantScope);
        }
        VariantType type = variantData.getType();
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable() && type.isApk() && !type.isForTesting()) {
            boolean addDependencies = !type.isFeatureSplit();
            for (String jar : TaskManager.getAdvancedProfilingTransforms(this.projectOptions)) {
                if (jar == null) continue;
                transformManager.addTransform(this.taskFactory, variantScope, new CustomClassTransform(jar, addDependencies));
            }
        }
        CodeShrinker shrinker = this.maybeCreateJavaCodeShrinkerTransform(variantScope);
        this.maybeCreateResourcesShrinkerTransform(variantScope);
        if (shrinker == CodeShrinker.R8) {
            this.maybeCreateDexSplitterTransform(variantScope);
            return;
        }
        PreColdSwapTask preColdSwapTask = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            DefaultTask allActionsAnchorTask = this.createInstantRunAllActionsTasks(variantScope);
            assert (variantScope.getInstantRunTaskManager() != null);
            preColdSwapTask = variantScope.getInstantRunTaskManager().createPreColdswapTask(this.projectOptions);
            preColdSwapTask.dependsOn(new Object[]{allActionsAnchorTask});
            if (!this.usingIncrementalDexing(variantScope)) {
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Instant Run requires incremental dexing. Please remove '" + BooleanOption.ENABLE_DEX_ARCHIVE.name() + "=false' from gradle.properties"));
            }
        }
        if ((dexingType = variantScope.getDexingType()) == DexingType.LEGACY_MULTIDEX && variantScope.getVariantConfiguration().isMultiDexEnabled() && variantScope.getVariantConfiguration().getMinSdkVersionWithTargetDeviceApi().getFeatureLevel() >= 21) {
            dexingType = DexingType.NATIVE_MULTIDEX;
        }
        if (dexingType == DexingType.LEGACY_MULTIDEX) {
            boolean proguardInPipeline;
            boolean bl2 = proguardInPipeline = variantScope.getCodeShrinker() == CodeShrinker.PROGUARD;
            if (!proguardInPipeline && !this.usingIncrementalDexing(variantScope)) {
                JarMergingTransform jarMergingTransform = new JarMergingTransform(TransformManager.SCOPE_FULL_PROJECT);
                transformManager.addTransform(this.taskFactory, variantScope, jarMergingTransform).ifPresent(variantScope::addColdSwapBuildTask);
            }
        }
        if (variantScope.getNeedsMainDexList()) {
            Transform multiDexTransform = this.usingIncrementalDexing(variantScope) ? (this.projectOptions.get(BooleanOption.ENABLE_D8_MAIN_DEX_LIST) ? new D8MainDexListTransform(variantScope) : new MainDexListTransform(variantScope, extension.getDexOptions())) : new MultiDexTransform(variantScope, extension.getDexOptions(), dexingType == DexingType.LEGACY_MULTIDEX);
            transformManager.addTransform(this.taskFactory, variantScope, multiDexTransform).ifPresent(task -> {
                variantScope.addColdSwapBuildTask((DefaultTask)task);
                File mainDexListFile = variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LEGACY_MULTIDEX_MAIN_DEX_LIST, (Task)task, "mainDexList.txt");
                ((MainDexListWriter)multiDexTransform).setMainDexListOutputFile(mainDexListFile);
            });
        }
        if (variantScope.getNeedsMainDexListForBundle()) {
            D8MainDexListTransform bundleMultiDexTransform = new D8MainDexListTransform(variantScope, true);
            variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, bundleMultiDexTransform).ifPresent(task -> {
                File mainDexListFile = variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE, (Task)task, "mainDexList.txt");
                bundleMultiDexTransform.setMainDexListOutputFile(mainDexListFile);
            });
        }
        if (this.usingIncrementalDexing(variantScope)) {
            this.createNewDexTasks(variantScope, dexingType);
        } else {
            this.createDexTasks(variantScope, dexingType);
        }
        if (preColdSwapTask != null) {
            for (DefaultTask task2 : variantScope.getColdSwapBuildTasks()) {
                task2.dependsOn(new Object[]{preColdSwapTask});
            }
        }
        this.maybeCreateDexSplitterTransform(variantScope);
    }

    private void maybeCreateDesugarTask(VariantScope variantScope, AndroidVersion minSdk, TransformManager transformManager) {
        if (variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.DESUGAR) {
            BaseVariantData testedVariant;
            FileCache userCache = this.getUserIntermediatesCache();
            FixStackFramesTransform fixFrames = new FixStackFramesTransform(variantScope.getBootClasspath(), userCache);
            transformManager.addTransform(this.taskFactory, variantScope, fixFrames);
            DesugarTransform desugarTransform = new DesugarTransform(variantScope.getBootClasspath(), userCache, minSdk.getFeatureLevel(), this.androidBuilder.getJavaProcessExecutor(), this.project.getLogger().isEnabled(LogLevel.INFO), this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS), variantScope.getGlobalScope().getTmpFolder().toPath(), TaskManager.getProjectVariantId(variantScope), this.projectOptions.get(BooleanOption.ENABLE_INCREMENTAL_DESUGARING), this.enableDesugarBugFixForJacoco(variantScope));
            transformManager.addTransform(this.taskFactory, variantScope, desugarTransform);
            if (minSdk.getFeatureLevel() >= 19) {
                return;
            }
            if (variantScope.getVariantConfiguration().getType().isTestComponent() && !(testedVariant = Objects.requireNonNull(variantScope.getTestedVariantData())).getType().isAar()) {
                return;
            }
            String taskName = variantScope.getTaskName("extractTryWithResourcesSupportJar");
            ExtractTryWithResourcesSupportJar extractTryWithResources = this.taskFactory.create(new ExtractTryWithResourcesSupportJar.ConfigAction(variantScope.getTryWithResourceRuntimeSupportJar(), taskName, variantScope.getFullVariantName()));
            variantScope.getTryWithResourceRuntimeSupportJar().builtBy(new Object[]{extractTryWithResources});
            transformManager.addStream(OriginalStream.builder(this.project, "runtime-deps-try-with-resources").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.EXTERNAL_LIBRARIES).setFileCollection((FileCollection)variantScope.getTryWithResourceRuntimeSupportJar()).build());
        }
    }

    private void createNewDexTasks(VariantScope variantScope, DexingType dexingType) {
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        if (variantScope.getVariantData().getType().isTestComponent()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        boolean minified = this.runJavaCodeShrinker(variantScope);
        FileCache userLevelCache = this.getUserDexCache(minified, dexOptions.getPreDexLibraries());
        DexArchiveBuilderTransform preDexTransform = new DexArchiveBuilderTransformBuilder().setAndroidJarClasspath(() -> variantScope.getGlobalScope().getAndroidBuilder().getBootClasspath(false)).setDexOptions((com.android.builder.core.DexOptions)dexOptions).setMessageReceiver(variantScope.getGlobalScope().getMessageReceiver()).setUserLevelCache(userLevelCache).setMinSdkVersion(variantScope.getMinSdkVersion().getFeatureLevel()).setDexer(variantScope.getDexer()).setUseGradleWorkers(this.projectOptions.get(BooleanOption.ENABLE_GRADLE_WORKERS)).setInBufferSize(this.projectOptions.get(IntegerOption.DEXING_READ_BUFFER_SIZE)).setOutBufferSize(this.projectOptions.get(IntegerOption.DEXING_WRITE_BUFFER_SIZE)).setIsDebuggable(((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()).setJava8LangSupportType(variantScope.getJava8LangSupportType()).setEnableIncrementalDesugaring(this.projectOptions.get(BooleanOption.ENABLE_INCREMENTAL_DESUGARING)).setProjectVariant(TaskManager.getProjectVariantId(variantScope)).setNumberOfBuckets(this.projectOptions.get(IntegerOption.DEXING_NUMBER_OF_BUCKETS)).setIncludeFeaturesInScope(variantScope.consumesFeatureJars()).setIsInstantRun(variantScope.getInstantRunBuildContext().isInInstantRunMode()).createDexArchiveBuilderTransform();
        transformManager.addTransform(this.taskFactory, variantScope, preDexTransform).ifPresent(variantScope::addColdSwapBuildTask);
        boolean isDebuggable = ((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable();
        if (dexingType != DexingType.LEGACY_MULTIDEX && variantScope.getCodeShrinker() == null && this.extension.getTransforms().isEmpty()) {
            ExternalLibsMergerTransform externalLibsMergerTransform = new ExternalLibsMergerTransform(dexingType, variantScope.getDexMerger(), variantScope.getMinSdkVersion().getFeatureLevel(), isDebuggable, variantScope.getGlobalScope().getMessageReceiver(), DexMergerTransformCallable::new);
            transformManager.addTransform(this.taskFactory, variantScope, externalLibsMergerTransform);
        }
        DexMergerTransform dexTransform = new DexMergerTransform(dexingType, dexingType == DexingType.LEGACY_MULTIDEX ? variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LEGACY_MULTIDEX_MAIN_DEX_LIST) : null, variantScope.getGlobalScope().getMessageReceiver(), variantScope.getDexMerger(), variantScope.getMinSdkVersion().getFeatureLevel(), isDebuggable, variantScope.consumesFeatureJars());
        Optional<TransformTask> dexTask = transformManager.addTransform(this.taskFactory, variantScope, dexTransform);
        dexTask.ifPresent(variantScope::addColdSwapBuildTask);
    }

    private static String getProjectVariantId(VariantScope variantScope) {
        return variantScope.getGlobalScope().getProject().getName() + ":" + variantScope.getFullVariantName();
    }

    private boolean usingIncrementalDexing(VariantScope variantScope) {
        if (!this.projectOptions.get(BooleanOption.ENABLE_DEX_ARCHIVE)) {
            return false;
        }
        if (((CoreBuildType)variantScope.getVariantConfiguration().getBuildType()).isDebuggable()) {
            return true;
        }
        return this.projectOptions.get(BooleanOption.ENABLE_D8);
    }

    private FileCache getUserDexCache(boolean isMinifiedEnabled, boolean preDexLibraries) {
        if (!preDexLibraries || isMinifiedEnabled) {
            return null;
        }
        return this.getUserIntermediatesCache();
    }

    private FileCache getUserIntermediatesCache() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE)) {
            return this.globalScope.getBuildCache();
        }
        return null;
    }

    private void createDexTasks(VariantScope variantScope, DexingType dexingType) {
        boolean preDexEnabled;
        DexOptions dexOptions;
        TransformManager transformManager = variantScope.getTransformManager();
        AndroidBuilder androidBuilder = variantScope.getGlobalScope().getAndroidBuilder();
        if (variantScope.getVariantData().getType().isTestComponent()) {
            dexOptions = DefaultDexOptions.copyOf((com.android.builder.core.DexOptions)this.extension.getDexOptions());
            dexOptions.setAdditionalParameters((List)ImmutableList.of());
        } else {
            dexOptions = this.extension.getDexOptions();
        }
        boolean cachePreDex = dexingType.isPreDex() && dexOptions.getPreDexLibraries() && !this.runJavaCodeShrinker(variantScope);
        boolean bl = preDexEnabled = variantScope.getInstantRunBuildContext().isInInstantRunMode() || cachePreDex;
        if (preDexEnabled) {
            FileCache buildCache = cachePreDex && this.projectOptions.get(BooleanOption.ENABLE_INTERMEDIATE_ARTIFACTS_CACHE) ? this.buildCache : null;
            PreDexTransform preDexTransform = new PreDexTransform((com.android.builder.core.DexOptions)dexOptions, androidBuilder, buildCache, dexingType, variantScope.getMinSdkVersion().getFeatureLevel(), variantScope.consumesFeatureJars());
            transformManager.addTransform(this.taskFactory, variantScope, preDexTransform).ifPresent(variantScope::addColdSwapBuildTask);
        }
        if (!preDexEnabled || dexingType != DexingType.NATIVE_MULTIDEX) {
            DexTransform dexTransform = new DexTransform((com.android.builder.core.DexOptions)dexOptions, dexingType, preDexEnabled, dexingType == DexingType.LEGACY_MULTIDEX ? variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LEGACY_MULTIDEX_MAIN_DEX_LIST) : null, (TargetInfo)Preconditions.checkNotNull((Object)androidBuilder.getTargetInfo(), (Object)"Target Info not set."), androidBuilder.getDexByteCodeConverter(), variantScope.getGlobalScope().getMessageReceiver(), variantScope.getMinSdkVersion().getFeatureLevel(), variantScope.consumesFeatureJars());
            Optional<TransformTask> dexTask = transformManager.addTransform(this.taskFactory, variantScope, dexTransform);
            dexTask.ifPresent(variantScope::addColdSwapBuildTask);
        }
    }

    private boolean runJavaCodeShrinker(VariantScope variantScope) {
        return variantScope.getCodeShrinker() != null || this.isTestedAppObfuscated(variantScope);
    }

    protected boolean isTestedAppObfuscated(VariantScope variantScope) {
        return false;
    }

    private DefaultTask createInstantRunAllActionsTasks(VariantScope variantScope) {
        DefaultTask allActionAnchorTask = this.taskFactory.create(new InstantRunAnchorTaskConfigAction(variantScope));
        TransformManager transformManager = variantScope.getTransformManager();
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.SUB_PROJECTS));
        Optional<TransformTask> extractJarsTask = transformManager.addTransform(this.taskFactory, variantScope, extractJarsTransform);
        InstantRunTaskManager instantRunTaskManager = new InstantRunTaskManager(this.getLogger(), variantScope, variantScope.getTransformManager(), this.taskFactory, this.recorder);
        BuildableArtifact instantRunMergedManifests = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS);
        variantScope.setInstantRunTaskManager(instantRunTaskManager);
        AndroidVersion minSdkForDx = variantScope.getMinSdkVersion();
        BuildInfoLoaderTask buildInfoLoaderTask = instantRunTaskManager.createInstantRunAllTasks(extractJarsTask.orElse(null), (Task)allActionAnchorTask, this.getResMergingScopes(variantScope), instantRunMergedManifests, true, minSdkForDx.getFeatureLevel(), variantScope.getJava8LangSupportType() == VariantScope.Java8LangSupport.D8, variantScope.getBootClasspath(), this.androidBuilder.getMessageReceiver());
        if (variantScope.getSourceGenTask() != null) {
            variantScope.getSourceGenTask().dependsOn(new Object[]{buildInfoLoaderTask});
        }
        return allActionAnchorTask;
    }

    protected void handleJacocoDependencies(VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        GradleVariantConfiguration config2 = variantScope.getVariantConfiguration();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config2.getBuildType()).isTestCoverageEnabled() && !variantScope.getInstantRunBuildContext().isInInstantRunMode() && (!config2.getType().isTestComponent() || config2.getTestedConfig() != null && config2.getTestedConfig().getType().isAar());
        if (isTestCoverageEnabled) {
            if (variantScope.getDexer() == DexerTool.DX) {
                this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("Jacoco version is downgraded to %s because dx is used. This is due to -P%s=false flag. See https://issuetracker.google.com/37116789 for more details.", "0.7.4.201502262128", BooleanOption.ENABLE_D8.getPropertyName()));
            }
            String jacocoAgentRuntimeDependency = JacocoConfigurations.getAgentRuntimeDependency(this.getJacocoVersion(variantScope));
            this.project.getDependencies().add(variantScope.getVariantDependencies().getRuntimeClasspath().getName(), (Object)jacocoAgentRuntimeDependency);
            variantScope.getVariantDependencies().getRuntimeClasspath().resolutionStrategy(r -> r.force(new Object[]{jacocoAgentRuntimeDependency}));
        }
    }

    public String getJacocoVersion(VariantScope scope) {
        if (scope.getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return this.extension.getJacoco().getVersion();
    }

    private boolean enableDesugarBugFixForJacoco(VariantScope scope) {
        try {
            GradleVersion current = GradleVersion.parse((String)this.getJacocoVersion(scope));
            return JacocoConfigurations.MIN_WITHOUT_BROKEN_BYTECODE.compareTo(current) > 0;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public void createJacocoTransform(VariantScope variantScope) {
        JacocoTransform jacocoTransform = new JacocoTransform(JacocoConfigurations.getJacocoAntTaskConfiguration(this.project, this.getJacocoVersion(variantScope)));
        variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, jacocoTransform);
    }

    private void createDataBindingMergeArtifactsTask(VariantScope variantScope) {
        BaseVariantData testedVariantData;
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        if (type.isForTesting() && !this.extension.getDataBinding().isEnabledForTests() && !(testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getType().isAar()) {
            return;
        }
        File outFolder = new File(variantScope.getBuildFolderForDataBindingCompiler(), "dependent-lib-artifacts");
        Optional<TransformTask> dataBindingMergeTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, new DataBindingMergeArtifactsTransform(this.getLogger(), outFolder));
        dataBindingMergeTask.ifPresent(task -> variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.DATA_BINDING_DEPENDENCY_ARTIFACTS, (Collection<? extends File>)ImmutableList.of((Object)outFolder), (Task)task));
    }

    private void createDataBindingMergeBaseClassesTask(VariantScope variantScope) {
        BaseVariantData testedVariantData;
        BaseVariantData variantData = variantScope.getVariantData();
        VariantType type = variantData.getType();
        if (type.isForTesting() && !this.extension.getDataBinding().isEnabledForTests() && !(testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)variantScope.getTestedVariantData())).getType().isAar()) {
            return;
        }
        File outFolder = variantScope.getIntermediateDir(InternalArtifactType.DATA_BINDING_BASE_CLASS_LOGS_DEPENDENCY_ARTIFACTS);
        Optional<TransformTask> mergeBaseClassesTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, new DataBindingMergeGenClassLogTransform(this.getLogger(), outFolder));
        mergeBaseClassesTask.ifPresent(task -> variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.DATA_BINDING_BASE_CLASS_LOGS_DEPENDENCY_ARTIFACTS, (Collection<? extends File>)ImmutableList.of((Object)outFolder), (Task)task));
    }

    protected void createDataBindingTasksIfNecessary(VariantScope scope, MergeType mergeType) {
        BaseVariantData testedVariantData;
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        this.createDataBindingMergeBaseClassesTask(scope);
        this.createDataBindingMergeArtifactsTask(scope);
        VariantType type = scope.getType();
        if (type.isForTesting() && !this.extension.getDataBinding().isEnabledForTests() && !(testedVariantData = (BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData())).getType().isAar()) {
            return;
        }
        this.dataBindingBuilder.setDebugLogEnabled(this.getLogger().isDebugEnabled());
        DataBindingExportBuildInfoTask exportBuildInfo = this.taskFactory.create(new DataBindingExportBuildInfoTask.ConfigAction(scope));
        exportBuildInfo.dependsOn(new Object[]{scope.getSourceGenTask()});
        scope.setDataBindingExportBuildInfoTask(exportBuildInfo);
        DataBindingGenBaseClassesTask generateBaseClasses = this.taskFactory.create(new DataBindingGenBaseClassesTask.ConfigAction(scope));
        generateBaseClasses.dependsOn(new Object[]{scope.getVariantData().mergeResourcesTask});
        this.setDataBindingAnnotationProcessorParams(scope, mergeType);
    }

    private void setDataBindingAnnotationProcessorParams(VariantScope scope, MergeType mergeType) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        JavaCompileOptions javaCompileOptions = variantConfiguration.getJavaCompileOptions();
        com.android.build.gradle.api.AnnotationProcessorOptions processorOptions = javaCompileOptions.getAnnotationProcessorOptions();
        if (processorOptions instanceof AnnotationProcessorOptions) {
            AnnotationProcessorOptions options = (AnnotationProcessorOptions)processorOptions;
            if (!options.getClassNames().isEmpty() && !options.getClassNames().contains("android.databinding.annotationprocessor.ProcessDataBinding")) {
                options.className("android.databinding.annotationprocessor.ProcessDataBinding");
            }
            DataBindingCompilerArguments dataBindingArgs = DataBindingCompilerArguments.createArguments(scope, this.getLogger().isDebugEnabled(), this.dataBindingBuilder.getPrintMachineReadableOutput());
            options.compilerArgumentProvider(dataBindingArgs);
            scope.setDataBindingCompilerArguments(dataBindingArgs);
        } else {
            this.getLogger().error("Cannot setup data binding for %s because java compiler options is not an instance of AnnotationProcessorOptions", (Object)processorOptions);
        }
    }

    public void createPackagingTask(VariantScope variantScope, BuildInfoWriterTask fullBuildInfoGeneratorTask) {
        CoreSigningConfig signingConfig;
        ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        boolean signedApk = variantData.isSigned();
        InternalArtifactType manifestType = variantScope.getInstantRunBuildContext().isInInstantRunMode() ? InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS : InternalArtifactType.MERGED_MANIFESTS;
        boolean splitsArePossible = variantScope.getVariantData().getMultiOutputPolicy() == MultiOutputPolicy.SPLITS;
        BuildableArtifact manifests = variantScope.getArtifacts().getFinalArtifactFiles(manifestType);
        File finalApkLocation = variantScope.getApkLocation();
        File outputDirectory = splitsArePossible ? variantScope.getFullApkPackagesOutputDirectory() : finalApkLocation;
        InternalArtifactType taskOutputType = splitsArePossible ? InternalArtifactType.FULL_APK : InternalArtifactType.APK;
        boolean useSeparateApkForResources = variantScope.getInstantRunBuildContext().useSeparateApkForResources();
        InternalArtifactType resourceFilesInputType = variantScope.useResourceShrinker() ? InternalArtifactType.SHRUNK_PROCESSED_RES : InternalArtifactType.PROCESSED_RES;
        PackageApplication packageApp = this.taskFactory.create(new PackageApplication.StandardConfigAction(variantScope, outputDirectory, useSeparateApkForResources ? InternalArtifactType.INSTANT_RUN_MAIN_APK_RESOURCES : resourceFilesInputType, manifests, manifestType, variantScope.getOutputScope(), this.globalScope.getBuildCache(), taskOutputType));
        variantScope.getArtifacts().appendArtifact((ArtifactType)taskOutputType, (Collection<? extends File>)ImmutableList.of((Object)outputDirectory), (Task)packageApp);
        AndroidBuilderTask packageInstantRunResources = null;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode()) {
            packageInstantRunResources = this.taskFactory.create(new InstantRunResourcesApkBuilder.ConfigAction(resourceFilesInputType, variantScope));
            packageInstantRunResources.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
            packageApp.dependsOn(new Object[]{packageInstantRunResources});
            if (!useSeparateApkForResources) {
                packageInstantRunResources = this.taskFactory.create(new PackageApplication.InstantRunResourcesConfigAction(variantScope.getInstantRunResourcesFile(), variantScope, resourceFilesInputType, manifests, InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS, this.globalScope.getBuildCache(), variantScope.getOutputScope()));
            }
            packageApp.dependsOn(new Object[]{packageInstantRunResources});
        }
        Consumer<Task> configureResourcesAndAssetsDependencies = task -> {
            task.dependsOn(new Object[]{variantScope.getMergeAssetsTask()});
            if (variantScope.getProcessResourcesTask() != null) {
                task.dependsOn(new Object[]{variantScope.getProcessResourcesTask()});
            }
        };
        configureResourcesAndAssetsDependencies.accept((Task)packageApp);
        if (packageInstantRunResources != null) {
            configureResourcesAndAssetsDependencies.accept((Task)packageInstantRunResources);
        }
        if ((signingConfig = variantScope.getVariantConfiguration().getSigningConfig()) != null) {
            packageApp.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
        }
        if (variantScope.getJavacTask() != null) {
            packageApp.dependsOn(new Object[]{variantScope.getJavacTask()});
        }
        if (variantData.packageSplitResourcesTask != null) {
            packageApp.dependsOn(new Object[]{variantData.packageSplitResourcesTask});
        }
        if (variantData.packageSplitAbiTask != null) {
            packageApp.dependsOn(new Object[]{variantData.packageSplitAbiTask});
        }
        if (variantScope.getJavacTask() != null) {
            packageApp.dependsOn(new Object[]{variantScope.getJavacTask()});
        }
        variantScope.setPackageApplicationTask(packageApp);
        variantScope.getAssembleTask().dependsOn(new Object[]{packageApp.getName()});
        Preconditions.checkState((variantScope.getAssembleTask() != null ? 1 : 0) != 0);
        if (fullBuildInfoGeneratorTask != null) {
            fullBuildInfoGeneratorTask.mustRunAfter(new Object[]{packageApp.getName()});
            if (packageInstantRunResources != null) {
                fullBuildInfoGeneratorTask.mustRunAfter(new Object[]{packageInstantRunResources});
            }
            variantScope.getAssembleTask().dependsOn(new Object[]{fullBuildInfoGeneratorTask.getName()});
        }
        if (splitsArePossible) {
            CopyOutputs copyOutputsTask = this.taskFactory.create(new CopyOutputs.ConfigAction(variantScope, finalApkLocation));
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK, (Collection<? extends File>)ImmutableList.of((Object)finalApkLocation), (Task)copyOutputsTask);
            variantScope.getAssembleTask().dependsOn(new Object[]{copyOutputsTask});
        }
        if (signedApk) {
            this.createInstallTask(variantScope);
        }
        this.maybeCreateLintVitalTask(variantData);
        UninstallTask uninstallTask = this.taskFactory.create(new UninstallTask.ConfigAction(variantScope));
        this.taskFactory.configure(UNINSTALL_ALL, (Action<? super Task>)((Action)uninstallAll -> uninstallAll.dependsOn(new Object[]{uninstallTask.getName()})));
    }

    protected void createInstallTask(VariantScope variantScope) {
        this.taskFactory.create(new InstallVariantTask.ConfigAction(variantScope));
    }

    protected Task getValidateSigningTask(VariantScope variantScope) {
        File defaultDebugKeystoreLocation = GradleKeystoreHelper.getDefaultDebugKeystoreLocation();
        ValidateSigningTask.ConfigAction configAction = new ValidateSigningTask.ConfigAction(variantScope, defaultDebugKeystoreLocation);
        Object validateSigningTask = this.taskFactory.findByName(configAction.getName());
        if (validateSigningTask == null) {
            validateSigningTask = this.taskFactory.create(configAction);
        }
        return validateSigningTask;
    }

    public DefaultTask createAssembleTask(BaseVariantData variantData) {
        return this.taskFactory.create(variantData.getScope().getTaskName("assemble"), (Action<DefaultTask>)((Action)task -> variantData.addTask(TaskContainer.TaskKind.ASSEMBLE, (Task)task)));
    }

    public DefaultTask createBundleTask(BaseVariantData variantData) {
        return this.taskFactory.create(variantData.getScope().getTaskName("bundle"), (Action<DefaultTask>)((Action)task -> variantData.addTask(TaskContainer.TaskKind.BUNDLE, (Task)task)));
    }

    public DefaultTask createAssembleTask(VariantDimensionData dimensionData) {
        String sourceSetName = StringHelper.capitalize((String)dimensionData.getSourceSet().getName());
        return this.taskFactory.create("assemble" + sourceSetName, (Action<DefaultTask>)((Action)assembleTask -> {
            assembleTask.setDescription("Assembles all " + sourceSetName + " builds.");
            assembleTask.setGroup(BUILD_GROUP);
        }));
    }

    public DefaultTask createBundleTask(VariantDimensionData dimensionData) {
        String sourceSetName = StringHelper.capitalize((String)dimensionData.getSourceSet().getName());
        return this.taskFactory.create("bundle" + sourceSetName, (Action<DefaultTask>)((Action)assembleTask -> {
            assembleTask.setDescription("Creates all " + sourceSetName + " bundles.");
            assembleTask.setGroup(BUILD_GROUP);
        }));
    }

    protected CodeShrinker maybeCreateJavaCodeShrinkerTransform(VariantScope variantScope) {
        CodeShrinker codeShrinker = variantScope.getCodeShrinker();
        if (codeShrinker != null) {
            return this.doCreateJavaCodeShrinkerTransform(variantScope, codeShrinker, null);
        }
        return null;
    }

    protected final CodeShrinker doCreateJavaCodeShrinkerTransform(VariantScope variantScope, CodeShrinker codeShrinker, FileCollection mappingFileCollection) {
        Optional<TransformTask> transformTask;
        if (variantScope.getInstantRunBuildContext().isInInstantRunMode() && codeShrinker != CodeShrinker.ANDROID_GRADLE) {
            this.logger.warn("{} is disabled for variant {} because it is not compatible with Instant Run. See http://d.android.com/r/studio-ui/shrink-code-with-ir.html for details on how to enable a code shrinker that's compatible with Instant Run.", (Object)codeShrinker.name(), (Object)variantScope.getVariantConfiguration().getFullName());
            return null;
        }
        CodeShrinker createdShrinker = codeShrinker;
        switch (codeShrinker) {
            case PROGUARD: {
                transformTask = this.createProguardTransform(variantScope, mappingFileCollection);
                break;
            }
            case ANDROID_GRADLE: {
                transformTask = this.createBuiltInShrinkerTransform(variantScope);
                break;
            }
            case R8: {
                if (variantScope.getVariantConfiguration().getType().isAar()) {
                    transformTask = this.createProguardTransform(variantScope, mappingFileCollection);
                    createdShrinker = CodeShrinker.PROGUARD;
                    break;
                }
                transformTask = this.createR8Transform(variantScope, mappingFileCollection);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown value " + (Object)((Object)codeShrinker)));
            }
        }
        if (variantScope.getPostprocessingFeatures() != null && transformTask.isPresent()) {
            CheckProguardFiles checkFilesTask = this.taskFactory.create(new CheckProguardFiles.ConfigAction(variantScope));
            transformTask.get().dependsOn(new Object[]{checkFilesTask});
        }
        return createdShrinker;
    }

    private Optional<TransformTask> createBuiltInShrinkerTransform(VariantScope scope) {
        BuiltInShrinkerTransform transform2 = new BuiltInShrinkerTransform(scope);
        this.applyProguardConfigForNonTest(transform2, scope);
        if (scope.getInstantRunBuildContext().isInInstantRunMode()) {
            transform2.keep("class ** extends android.app.Application {*;}");
            transform2.keep("class com.android.tools.ir.** {*;}");
        }
        return scope.getTransformManager().addTransform(this.taskFactory, scope, transform2);
    }

    private Optional<TransformTask> createProguardTransform(VariantScope variantScope, FileCollection mappingFileCollection) {
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        ProGuardTransform transform2 = new ProGuardTransform(variantScope);
        FileCollection inputProguardMapping = testedVariantData != null && testedVariantData.getScope().getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING) ? (FileCollection)testedVariantData.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING).get() : mappingFileCollection;
        transform2.applyTestedMapping(inputProguardMapping);
        return this.applyProguardRules(variantScope, inputProguardMapping, transform2.getMappingFile(), testedVariantData, transform2);
    }

    private Optional<TransformTask> applyProguardRules(VariantScope variantScope, FileCollection inputProguardMapping, File outputProguardMapping, BaseVariantData testedVariantData, ProguardConfigurable transform2) {
        if (testedVariantData != null) {
            VariantScope testedScope = testedVariantData.getScope();
            TaskManager.applyProguardDefaultsForTest(transform2);
            Object[] objectArray = new Object[2];
            objectArray[0] = testedScope::getTestProguardFiles;
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES);
            ConfigurableFileCollection configurationFiles = this.project.files(objectArray);
            this.maybeAddFeatureProguardRules(variantScope, configurationFiles);
            transform2.setConfigurationFiles((FileCollection)configurationFiles);
        } else if (this.isTestedAppObfuscated(variantScope)) {
            TaskManager.applyProguardDefaultsForTest(transform2);
            Object[] objectArray = new Object[2];
            objectArray[0] = variantScope::getTestProguardFiles;
            objectArray[1] = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES);
            ConfigurableFileCollection configurationFiles = this.project.files(objectArray);
            this.maybeAddFeatureProguardRules(variantScope, configurationFiles);
            transform2.setConfigurationFiles((FileCollection)configurationFiles);
        } else {
            this.applyProguardConfigForNonTest(transform2, variantScope);
        }
        Optional<TransformTask> task = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, transform2);
        task.ifPresent(t -> {
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK_MAPPING, (Collection<? extends File>)ImmutableList.of((Object)Preconditions.checkNotNull((Object)outputProguardMapping)), (Task)t);
            if (inputProguardMapping != null) {
                t.dependsOn(new Object[]{inputProguardMapping});
            }
            if (testedVariantData != null) {
                t.dependsOn(new Object[]{testedVariantData.getScope().getAssembleTask()});
            }
        });
        return task;
    }

    private static void applyProguardDefaultsForTest(ProguardConfigurable transform2) {
        boolean obfuscate = transform2 instanceof ProGuardTransform;
        transform2.setActions(new PostprocessingFeatures(false, obfuscate, false));
        transform2.keep("class * {*;}");
        transform2.keep("interface * {*;}");
        transform2.keep("enum * {*;}");
        transform2.keepattributes();
    }

    private void applyProguardConfigForNonTest(ProguardConfigurable transform2, VariantScope scope) {
        GradleVariantConfiguration variantConfig = scope.getVariantConfiguration();
        PostprocessingFeatures postprocessingFeatures = scope.getPostprocessingFeatures();
        if (postprocessingFeatures != null) {
            transform2.setActions(postprocessingFeatures);
        }
        Callable<Collection> proguardConfigFiles = scope::getProguardFiles;
        InternalArtifactType aaptProguardFileType = scope.consumesFeatureJars() ? InternalArtifactType.MERGED_AAPT_PROGUARD_FILE : InternalArtifactType.AAPT_PROGUARD_FILE;
        ConfigurableFileCollection configurationFiles = this.project.files(new Object[]{proguardConfigFiles, scope.getArtifacts().getFinalArtifactFiles(aaptProguardFileType), scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES)});
        this.maybeAddFeatureProguardRules(scope, configurationFiles);
        transform2.setConfigurationFiles((FileCollection)configurationFiles);
        if (scope.getVariantData().getType().isAar()) {
            transform2.keep("class **.R");
            transform2.keep("class **.R$*");
        }
        if (variantConfig.isTestCoverageEnabled()) {
            transform2.keep("class com.vladium.** {*;}");
            transform2.keep("class org.jacoco.** {*;}");
            transform2.keep("interface org.jacoco.** {*;}");
            transform2.dontwarn("org.jacoco.**");
        }
    }

    private void maybeAddFeatureProguardRules(VariantScope variantScope, ConfigurableFileCollection configurationFiles) {
        if (variantScope.consumesFeatureJars()) {
            configurationFiles.from(new Object[]{variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES)});
        }
    }

    private Optional<TransformTask> createR8Transform(VariantScope variantScope, FileCollection mappingFileCollection) {
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        File multiDexKeepProguard = variantScope.getVariantConfiguration().getMultiDexKeepProguard();
        ConfigurableFileCollection userMainDexListProguardRules = multiDexKeepProguard != null ? this.project.files(new Object[]{multiDexKeepProguard}) : this.project.files(new Object[0]);
        File multiDexKeepFile = variantScope.getVariantConfiguration().getMultiDexKeepFile();
        ConfigurableFileCollection userMainDexListFiles = multiDexKeepFile != null ? this.project.files(new Object[]{multiDexKeepFile}) : this.project.files(new Object[0]);
        FileCollection inputProguardMapping = testedVariantData != null && testedVariantData.getScope().getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING) ? (FileCollection)testedVariantData.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING).get() : (FileCollection)MoreObjects.firstNonNull((Object)mappingFileCollection, (Object)this.project.files(new Object[0]));
        R8Transform transform2 = new R8Transform(variantScope, (FileCollection)userMainDexListFiles, (FileCollection)userMainDexListProguardRules, inputProguardMapping, variantScope.getOutputProguardMappingFile());
        return this.applyProguardRules(variantScope, inputProguardMapping, variantScope.getOutputProguardMappingFile(), testedVariantData, transform2);
    }

    private void maybeCreateDexSplitterTransform(VariantScope variantScope) {
        if (!variantScope.consumesFeatureJars()) {
            return;
        }
        File dexSplitterOutput = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"dex-splitter", variantScope.getVariantConfiguration().getDirName()});
        FileCollection featureJars = variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_CLASSES);
        BuildableArtifact mappingFileSrc = variantScope.getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING) ? variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING) : null;
        DexSplitterTransform transform2 = new DexSplitterTransform(dexSplitterOutput, featureJars, mappingFileSrc);
        Optional<TransformTask> transformTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, transform2);
        if (transformTask.isPresent()) {
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.FEATURE_DEX, (Collection<? extends File>)ImmutableList.of((Object)dexSplitterOutput), (Task)transformTask.get());
            this.publishFeatureDex(variantScope);
        } else {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Internal error, could not add the DexSplitterTransform"));
        }
    }

    private void publishFeatureDex(VariantScope variantScope) {
        Collection<String> modulePaths;
        AndroidConfig extension = this.globalScope.getExtension();
        if (extension instanceof BaseAppModuleExtension) {
            modulePaths = AppModelBuilder.getDynamicFeatures((BaseAppModuleExtension)extension, this.globalScope);
        } else if (extension instanceof FeatureExtension) {
            modulePaths = FeatureModelBuilder.getDynamicFeatures(this.globalScope);
        } else {
            return;
        }
        Configuration configuration = variantScope.getVariantData().getVariantDependency().getRuntimeElements();
        Preconditions.checkNotNull((Object)configuration, (Object)("Publishing to Runtime Element with no Runtime Elements configuration object. VariantType: " + variantScope.getType()));
        BuildableArtifact artifact = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.FEATURE_DEX);
        for (String modulePath : modulePaths) {
            Provider file = this.project.provider(() -> new File((File)Iterables.getOnlyElement((Iterable)artifact.getFiles()), modulePath.replace(":", "/")));
            ImmutableMap attributeMap = ImmutableMap.of(AndroidArtifacts.MODULE_PATH, (Object)modulePath);
            ArtifactPublishingUtil.publishArtifactToConfiguration(configuration, file, artifact, AndroidArtifacts.ArtifactType.FEATURE_DEX, (Map<Attribute<String>, String>)attributeMap);
        }
    }

    private void createMergeClassesTransform(VariantScope variantScope) {
        File outputJar = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"merged-classes", variantScope.getVariantConfiguration().getDirName(), "classes.jar"});
        MergeClassesTransform transform2 = new MergeClassesTransform(outputJar, this.globalScope.getProject().getPath());
        Optional<TransformTask> transformTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, transform2);
        if (transformTask.isPresent()) {
            variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.FEATURE_AND_RUNTIME_DEPS_CLASSES, (Collection<? extends File>)ImmutableList.of((Object)outputJar), (Task)transformTask.get());
        } else {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Internal error, could not add the MergeClassesTransform"));
        }
    }

    protected void maybeCreateResourcesShrinkerTransform(VariantScope scope) {
        if (!scope.useResourceShrinker()) {
            return;
        }
        File shrinkerOutput = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res_stripped", scope.getVariantConfiguration().getDirName()});
        ShrinkResourcesTransform shrinkResTransform = new ShrinkResourcesTransform(scope.getVariantData(), scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES), shrinkerOutput, AaptGeneration.fromProjectOptions(this.projectOptions), this.logger);
        Optional<TransformTask> shrinkTask = scope.getTransformManager().addTransform(this.taskFactory, scope, shrinkResTransform);
        if (shrinkTask.isPresent()) {
            scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.SHRUNK_PROCESSED_RES, (Collection<? extends File>)ImmutableList.of((Object)shrinkerOutput), (Task)shrinkTask.get());
        } else {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Internal error, could not add the ShrinkResourcesTransform"));
        }
    }

    public void createReportTasks(List<VariantScope> variantScopes) {
        this.taskFactory.create("androidDependencies", DependencyReportTask.class, task -> {
            task.setDescription("Displays the Android dependencies of the project.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
        this.taskFactory.create("signingReport", SigningReportTask.class, task -> {
            task.setDescription("Displays the signing info for each variant.");
            task.setVariants(variantScopes);
            task.setGroup(ANDROID_GROUP);
        });
    }

    public void createAnchorTasks(VariantScope scope) {
        this.createPreBuildTasks(scope);
        BaseVariantData variantData = scope.getVariantData();
        scope.setSourceGenTask(this.taskFactory.create(scope.getTaskName("generate", "Sources"), Task.class, task -> {
            variantData.sourceGenTask = task;
            task.dependsOn(new Object[]{"prepareLintJar"});
        }));
        scope.setResourceGenTask(this.taskFactory.create(scope.getTaskName("generate", "Resources"), Task.class, task -> {
            variantData.resourceGenTask = task;
        }));
        scope.setAssetGenTask(this.taskFactory.create(scope.getTaskName("generate", "Assets"), Task.class, task -> {
            variantData.assetGenTask = task;
        }));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.setCoverageReportTask(this.taskFactory.create(scope.getTaskName("create", "CoverageReport"), Task.class, task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
            }));
        }
        this.createCompileAnchorTask(scope);
    }

    protected DefaultTask createVariantPreBuildTask(VariantScope scope) {
        return this.createDefaultPreBuildTask(scope);
    }

    protected DefaultTask createDefaultPreBuildTask(VariantScope scope) {
        return this.taskFactory.create(scope.getTaskName("pre", "Build"), (Action<DefaultTask>)((Action)task -> {
            scope.getVariantData().preBuildTask = task;
        }));
    }

    private void createPreBuildTasks(VariantScope scope) {
        scope.setPreBuildTask(this.createVariantPreBuildTask(scope));
        scope.getPreBuildTask().dependsOn(new Object[]{MAIN_PREBUILD});
        if (this.runJavaCodeShrinker(scope)) {
            scope.getPreBuildTask().dependsOn(new Object[]{EXTRACT_PROGUARD_FILES});
        }
    }

    private void createCompileAnchorTask(final VariantScope scope) {
        final BaseVariantData variantData = scope.getVariantData();
        scope.setCompileTask(this.taskFactory.create(new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return scope.getTaskName("compile", "Sources");
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            @Override
            public void execute(Task task) {
                variantData.compileTask = task;
                variantData.compileTask.setGroup(TaskManager.BUILD_GROUP);
            }
        }));
        scope.getAssembleTask().dependsOn(new Object[]{scope.getCompileTask()});
    }

    public void createCheckManifestTask(VariantScope scope) {
        scope.setCheckManifestTask(this.taskFactory.create(this.getCheckManifestConfig(scope)));
        scope.getCheckManifestTask().dependsOn(new Object[]{scope.getPreBuildTask()});
    }

    protected CheckManifest.ConfigAction getCheckManifestConfig(VariantScope scope) {
        return new CheckManifest.ConfigAction(scope, false);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void addDataBindingDependenciesIfNecessary(DataBindingOptions options, List<VariantScope> variantScopes) {
        if (!options.isEnabled()) {
            return;
        }
        boolean useAndroidX = this.globalScope.getProjectOptions().get(BooleanOption.USE_ANDROID_X);
        String version = (String)MoreObjects.firstNonNull((Object)options.getVersion(), (Object)this.dataBindingBuilder.getCompilerVersion());
        String baseLibArtifact = useAndroidX ? "androidx.databinding:databinding-common" : "com.android.databinding:baseLibrary";
        this.project.getDependencies().add("api", (Object)(baseLibArtifact + ":" + this.dataBindingBuilder.getBaseLibraryVersion(version)));
        this.project.getDependencies().add("annotationProcessor", (Object)("androidx.databinding:databinding-compiler:" + version));
        if (options.isEnabledForTests() || this instanceof LibraryTaskManager || this instanceof MultiTypeTaskManager) {
            this.project.getDependencies().add("androidTestAnnotationProcessor", (Object)("androidx.databinding:databinding-compiler:" + version));
        }
        if (options.getAddDefaultAdapters()) {
            String libArtifact = useAndroidX ? "androidx.databinding:databinding-runtime" : "com.android.databinding:library";
            String adaptersArtifact = useAndroidX ? "androidx.databinding:databinding-adapters" : "com.android.databinding:adapters";
            this.project.getDependencies().add("api", (Object)(libArtifact + ":" + this.dataBindingBuilder.getLibraryVersion(version)));
            this.project.getDependencies().add("api", (Object)(adaptersArtifact + ":" + this.dataBindingBuilder.getBaseAdaptersVersion(version)));
        }
        this.project.getPluginManager().withPlugin("org.jetbrains.kotlin.kapt", appliedPlugin -> this.configureKotlinKaptTasksForDataBinding(this.project, variantScopes, version));
    }

    private void configureKotlinKaptTasksForDataBinding(Project project, List<VariantScope> variantScopes, String version) {
        DependencySet kaptDeps = project.getConfigurations().getByName("kapt").getAllDependencies();
        kaptDeps.forEach(dependency -> {
            if (Objects.equals(dependency.getGroup() + ":" + dependency.getName(), "androidx.databinding:databinding-compiler") && !Objects.equals(dependency.getVersion(), version)) {
                String depString = dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion();
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Data Binding annotation processor version needs to match the Android Gradle Plugin version. You can remove the kapt dependency " + depString + " and Android Gradle Plugin will inject the right version."));
            }
        });
        project.getDependencies().add("kapt", (Object)("androidx.databinding:databinding-compiler:" + version));
        Class<?> kaptTaskClass = null;
        try {
            kaptTaskClass = Class.forName("org.jetbrains.kotlin.gradle.internal.KaptTask");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Kotlin plugin is applied to the project " + project.getPath() + " but we cannot find the KaptTask. Make sure you apply the kotlin-kapt plugin because it is necessary to use kotlin with data binding.");
        }
        if (kaptTaskClass == null) {
            return;
        }
        Map<String, VariantScope> kaptTaskLookup = variantScopes.stream().collect(Collectors.toMap(variantScope -> variantScope.getVariantData().getTaskName("kapt", "Kotlin"), variantScope -> variantScope));
        project.getTasks().withType(kaptTaskClass, kaptTask -> {
            VariantScope matchingScope = (VariantScope)kaptTaskLookup.get(kaptTask.getName());
            if (matchingScope != null) {
                TaskManager.configureKaptTaskInScope(matchingScope, kaptTask);
            }
        });
    }

    private static void configureKaptTaskInScope(VariantScope scope, Task kaptTask) {
        BuildArtifactsHolder artifacts;
        if (scope.getDataBindingCompilerArguments() != null) {
            com.android.build.gradle.api.AnnotationProcessorOptions options = scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
            options.getArguments().putAll(scope.getDataBindingCompilerArguments().toMap());
            scope.getDataBindingCompilerArguments().configureInputsOutputsForTask(kaptTask);
        }
        if ((artifacts = scope.getArtifacts()).hasArtifact(InternalArtifactType.DATA_BINDING_DEPENDENCY_ARTIFACTS)) {
            kaptTask.getInputs().files(new Object[]{artifacts.getFinalArtifactFiles(InternalArtifactType.DATA_BINDING_DEPENDENCY_ARTIFACTS)}).withPathSensitivity(PathSensitivity.RELATIVE).withPropertyName("dataBindingDependencyArtifacts");
        }
        kaptTask.getOutputs().files(new Object[]{scope.getBundleArtifactFolderForDataBinding()}).withPropertyName("dataBindingArtifactOutputDir");
        if (!artifacts.hasArtifact(InternalArtifactType.DATA_BINDING_ARTIFACT)) {
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.DATA_BINDING_ARTIFACT, (Collection<? extends File>)ImmutableList.of((Object)scope.getBundleArtifactFolderForDataBinding()), kaptTask);
        }
    }

    protected void configureTestData(AbstractTestDataImpl testData) {
        testData.setAnimationsDisabled(this.extension.getTestOptions().getAnimationsDisabled());
    }

    public static enum MergeType {
        MERGE{

            @Override
            public InternalArtifactType getOutputType() {
                return InternalArtifactType.MERGED_RES;
            }
        }
        ,
        PACKAGE{

            @Override
            public InternalArtifactType getOutputType() {
                return InternalArtifactType.PACKAGED_RES;
            }
        };


        public abstract InternalArtifactType getOutputType();
    }

    public static class ConfigAttrTask
    extends DefaultTask {
        boolean consumable = false;
        boolean resolvable = false;

        @TaskAction
        public void run() {
            for (Configuration config2 : this.getProject().getConfigurations()) {
                AttributeContainer attributes2 = config2.getAttributes();
                if ((!this.consumable || !config2.isCanBeConsumed()) && (!this.resolvable || !config2.isCanBeResolved())) continue;
                System.out.println(config2.getName());
                System.out.println("\tcanBeResolved: " + config2.isCanBeResolved());
                System.out.println("\tcanBeConsumed: " + config2.isCanBeConsumed());
                for (Attribute attr : attributes2.keySet()) {
                    System.out.println("\t" + attr.getName() + ": " + attributes2.getAttribute(attr));
                }
                if (!this.consumable || !config2.isCanBeConsumed()) continue;
                for (PublishArtifact artifact : config2.getArtifacts()) {
                    System.out.println("\tArtifact: " + artifact.getName() + " (" + artifact.getFile().getName() + ")");
                }
                for (ConfigurationVariant cv : config2.getOutgoing().getVariants()) {
                    System.out.println("\tConfigurationVariant: " + cv.getName());
                    for (PublishArtifact pa : cv.getArtifacts()) {
                        System.out.println("\t\tArtifact: " + pa.getFile());
                        System.out.println("\t\tType:" + pa.getType());
                    }
                }
            }
        }
    }
}

