/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;

class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    private final File projectDir;

    NdkBuildExternalNativeJsonGenerator(NdkHandler ndkHandler, String variantName, List<JsonGenerationAbiConfiguration> abis, AndroidBuilder androidBuilder, File projectDir, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makeFile, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons, GradleBuildVariant.Builder stats) {
        super(ndkHandler, variantName, abis, androidBuilder, sdkFolder, ndkFolder, soFolder, objFolder, jsonFolder, makeFile, debuggable, buildArguments, cFlags, cppFlags, nativeBuildConfigurationsJsons, stats);
        this.projectDir = projectDir;
        this.stats.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
    }

    @Override
    void processBuildOutput(String buildOutput, String abi, int abiPlatformVersion) throws IOException {
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        this.diagnosticForAbi(abi, "parse and convert ndk-build output to build configuration JSON", new Object[0]);
        NativeBuildConfigValue buildConfig = new NativeBuildConfigValueBuilder(this.getMakeFile(), this.projectDir).addCommands(this.getBuildCommand(abi, abiPlatformVersion, applicationMk, false), this.getBuildCommand(abi, abiPlatformVersion, applicationMk, true) + " clean", this.variantName, buildOutput).build();
        if (applicationMk.exists()) {
            this.diagnosticForAbi(abi, "found application make file %s", applicationMk.getAbsolutePath());
            Preconditions.checkNotNull(buildConfig.buildFiles);
            buildConfig.buildFiles.add(applicationMk);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        File expectedJson = ExternalNativeBuildTaskUtils.getOutputJson(this.getJsonFolder(), abi);
        Files.write(expectedJson.toPath(), actualResult.getBytes(Charsets.UTF_8), new OpenOption[0]);
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(String abi, int abiPlatformVersion, File outputJson) {
        this.checkConfiguration();
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getNdkBuild()).addArgs(this.getBaseArgs(abi, abiPlatformVersion, applicationMk, false)).addArgs("APP_SHORT_COMMANDS=false").addArgs("LOCAL_SHORT_COMMANDS=false").addArgs("-B").addArgs("-n");
        return builder;
    }

    @Override
    String executeProcess(String abi, int abiPlatformVersion, File outputJsonDir) throws ProcessException, IOException {
        return ExternalNativeBuildTaskUtils.executeBuildProcessAndLogError(this.androidBuilder, this.getProcessBuilder(abi, abiPlatformVersion, outputJsonDir), false, "");
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.NDK_BUILD;
    }

    @Override
    Map<Abi, File> getStlSharedObjectFiles() {
        return Maps.newHashMap();
    }

    private String getNdkBuild() {
        String tool = "ndk-build";
        if (NdkBuildExternalNativeJsonGenerator.isWindows()) {
            tool = tool + ".cmd";
        }
        File toolFile = new File(this.getNdkFolder(), tool);
        try {
            return toolFile.getCanonicalPath();
        }
        catch (IOException e) {
            this.warn("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", e);
            return toolFile.getAbsolutePath();
        }
    }

    private File getMakeFile() {
        if (this.getMakefile().isDirectory()) {
            return new File(this.getMakefile(), "Android.mk");
        }
        return this.getMakefile();
    }

    private void checkConfiguration() {
        List<String> configurationErrors = this.getConfigurationErrors();
        if (!configurationErrors.isEmpty()) {
            throw new GradleException(Joiner.on((String)"\n").join(configurationErrors));
        }
    }

    private List<String> getBaseArgs(String abi, int abiPlatformVersion, File applicationMk, boolean removeJobsFlag) {
        ArrayList result = Lists.newArrayList();
        result.add("NDK_PROJECT_PATH=null");
        result.add("APP_BUILD_SCRIPT=" + this.getMakeFile());
        if (applicationMk.exists()) {
            result.add("NDK_APPLICATION_MK=" + applicationMk.getAbsolutePath());
        }
        result.add("APP_ABI=" + abi);
        result.add("NDK_ALL_ABIS=" + abi);
        if (this.isDebuggable()) {
            result.add("NDK_DEBUG=1");
        } else {
            result.add("NDK_DEBUG=0");
        }
        result.add("APP_PLATFORM=android-" + abiPlatformVersion);
        String ndkOut = this.getObjFolder().getParent();
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            ndkOut = ndkOut.replace('\\', '/');
        }
        result.add("NDK_OUT=" + ndkOut);
        result.add("NDK_LIBS_OUT=" + this.getSoFolder().getAbsolutePath());
        for (String flag : this.getcFlags()) {
            result.add(String.format("APP_CFLAGS+=%s", flag));
        }
        for (String flag : this.getCppFlags()) {
            result.add(String.format("APP_CPPFLAGS+=%s", flag));
        }
        boolean skipNextArgument = false;
        for (String argument : this.getBuildArguments()) {
            if (removeJobsFlag && argument.equals("-j")) {
                skipNextArgument = true;
                continue;
            }
            if (removeJobsFlag && argument.equals("--jobs")) {
                skipNextArgument = true;
                continue;
            }
            if (skipNextArgument) {
                skipNextArgument = false;
                continue;
            }
            if (removeJobsFlag && (argument.startsWith("-j") || argument.startsWith("--jobs="))) continue;
            result.add(argument);
        }
        return result;
    }

    private String getBuildCommand(String abi, int abiPlatformVersion, File applicationMk, boolean removeJobsFlag) {
        return this.getNdkBuild() + " " + Joiner.on((String)" ").join(this.getBaseArgs(abi, abiPlatformVersion, applicationMk, removeJobsFlag));
    }

    private List<String> getConfigurationErrors() {
        ArrayList messages = Lists.newArrayList();
        if (this.getMakefile().isDirectory()) {
            messages.add(String.format("Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", this.getMakefile()));
        } else if (!this.getMakefile().exists()) {
            messages.add(String.format("Gradle project ndkBuild.path is %s but that file doesn't exist", this.getMakefile()));
        }
        messages.addAll(this.getBaseConfigurationErrors());
        return messages;
    }
}

