/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;

public class JavaCompileConfigAction
implements TaskConfigAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(JavaCompileConfigAction.class);
    private final VariantScope scope;

    public JavaCompileConfigAction(VariantScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void execute(AndroidJavaCompile javacTask) {
        this.scope.getTaskContainer().setJavacTask(javacTask);
        GlobalScope globalScope = this.scope.getGlobalScope();
        Project project = globalScope.getProject();
        BuildArtifactsHolder artifacts = this.scope.getArtifacts();
        boolean isDataBindingEnabled = globalScope.getExtension().getDataBinding().isEnabled();
        javacTask.compileSdkVersion = globalScope.getExtension().getCompileSdkVersion();
        javacTask.mInstantRunBuildContext = this.scope.getInstantRunBuildContext();
        for (ConfigurableFileTree fileTree : this.scope.getVariantData().getJavaSources()) {
            javacTask.source(new Object[]{fileTree});
        }
        javacTask.getOptions().setBootstrapClasspath(this.scope.getBootClasspath());
        FileCollection classpath = this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES);
        if (!globalScope.getProjectOptions().get(BooleanOption.ENABLE_CORE_LAMBDA_STUBS) && this.scope.keepDefaultBootstrap()) {
            classpath = classpath.plus((FileCollection)project.files(new Object[]{globalScope.getAndroidBuilder().getBootClasspath(false)}));
        }
        javacTask.setClasspath(classpath);
        javacTask.setDestinationDir(artifacts.appendArtifact((ArtifactType)InternalArtifactType.JAVAC, (Task)javacTask, "classes"));
        CompileOptions compileOptions = globalScope.getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, globalScope.getExtension().getCompileSdkVersion(), this.scope.getJava8LangSupportType());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        Boolean includeCompileClasspath = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions().getIncludeCompileClasspath();
        FileCollection processorPath = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR);
        if (Boolean.TRUE.equals(includeCompileClasspath)) {
            processorPath = processorPath.plus(this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.PROCESSED_JAR));
        }
        javacTask.getOptions().setAnnotationProcessorPath(processorPath);
        boolean incremental = AbstractCompilesUtil.isIncremental(project, this.scope, compileOptions, null, LOG);
        if (incremental) {
            LOG.verbose("Using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
            javacTask.getOptions().setIncremental(true);
        } else {
            LOG.verbose("Not using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
        }
        AnnotationProcessorOptions annotationProcessorOptions = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        if (!annotationProcessorOptions.getClassNames().isEmpty()) {
            javacTask.getOptions().getCompilerArgs().add("-processor");
            javacTask.getOptions().getCompilerArgs().add(Joiner.on((char)',').join(annotationProcessorOptions.getClassNames()));
        }
        if (!annotationProcessorOptions.getArguments().isEmpty()) {
            for (Map.Entry<String, String> arg : annotationProcessorOptions.getArguments().entrySet()) {
                javacTask.getOptions().getCompilerArgs().add("-A" + arg.getKey() + "=" + arg.getValue());
            }
        }
        javacTask.getOptions().getCompilerArgumentProviders().addAll(annotationProcessorOptions.getCompilerArgumentProviders());
        javacTask.getOptions().setAnnotationProcessorGeneratedSourcesDirectory(this.scope.getAnnotationProcessorOutputDir());
        javacTask.annotationProcessorOutputFolder = this.scope.getAnnotationProcessorOutputDir();
        if (isDataBindingEnabled) {
            javacTask.dataBindingArtifactOutputDirectory = this.scope.getBundleArtifactFolderForDataBinding();
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.DATA_BINDING_ARTIFACT, (Collection<? extends File>)ImmutableList.of((Object)this.scope.getBundleArtifactFolderForDataBinding()), (Task)javacTask);
        }
        javacTask.processorListFile = artifacts.getFinalArtifactFiles(InternalArtifactType.ANNOTATION_PROCESSOR_LIST);
        javacTask.variantName = this.scope.getFullVariantName();
    }
}

