/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public abstract class TransformStream {
    private static final PatternSet INCLUDE_CLASSES = new PatternSet().include(new String[]{"**/*.class"}).include(new String[]{"**/*.jar"}).include(new String[]{"META-INF/*.kotlin_module"});
    private static final PatternSet EXCLUDE_CLASSES = new PatternSet().exclude(new String[]{"**/*.class"});
    private static final PatternSet INCLUDE_SO = new PatternSet().include(new String[]{"**/*.so"}).include(new String[]{"**/*.jar"});
    private static final PatternSet INCLUDE_DEX = new PatternSet().include(new String[]{"**/*.dex"}).include(new String[]{"**/*.jar"});
    private static final PatternSet INCLUDE_DATABINDING_BIN = new PatternSet();
    private static final PatternSet INCLUDE_DATABINDING_BASE_LOG = new PatternSet();
    private final String name;
    private final Set<QualifiedContent.ContentType> contentTypes;
    private final Set<? super QualifiedContent.Scope> scopes;
    private final FileCollection fileCollection;

    protected TransformStream(String name, Set<QualifiedContent.ContentType> contentTypes, Set<? super QualifiedContent.Scope> scopes, FileCollection fileCollection) {
        this.name = name;
        this.contentTypes = contentTypes;
        this.scopes = scopes;
        this.fileCollection = fileCollection;
    }

    public String getName() {
        return this.name;
    }

    public Set<QualifiedContent.ContentType> getContentTypes() {
        return this.contentTypes;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public FileCollection getFileCollection() {
        return this.fileCollection;
    }

    public FileTree getAsFileTree() {
        FileTree fileTree = this.fileCollection.getAsFileTree();
        PatternSet pattern = this.getPatternSet();
        if (pattern != null) {
            return fileTree.matching((PatternFilterable)pattern);
        }
        return fileTree;
    }

    private PatternSet getPatternSet() {
        if (this.contentTypes.size() == 1) {
            return TransformStream.getSingleTypePatternSet((QualifiedContent.ContentType)Iterables.getOnlyElement(this.contentTypes));
        }
        if (this.contentTypes.size() == 2 && this.contentTypes.contains((Object)ExtendedContentType.NATIVE_LIBS) && this.contentTypes.contains(QualifiedContent.DefaultContentType.RESOURCES)) {
            return EXCLUDE_CLASSES;
        }
        return null;
    }

    private static PatternSet getSingleTypePatternSet(QualifiedContent.ContentType type) {
        if (type instanceof QualifiedContent.DefaultContentType) {
            switch ((QualifiedContent.DefaultContentType)type) {
                case CLASSES: {
                    return INCLUDE_CLASSES;
                }
                case RESOURCES: {
                    return EXCLUDE_CLASSES;
                }
            }
            throw new RuntimeException("Unsupported DefaultContentType value: " + type);
        }
        if (type instanceof ExtendedContentType) {
            switch ((ExtendedContentType)type) {
                case DEX: 
                case DEX_ARCHIVE: {
                    return INCLUDE_DEX;
                }
                case NATIVE_LIBS: {
                    return INCLUDE_SO;
                }
                case CLASSES_ENHANCED: {
                    return INCLUDE_CLASSES;
                }
                case DATA_BINDING: {
                    return INCLUDE_DATABINDING_BIN;
                }
                case DATA_BINDING_BASE_CLASS_LOG: {
                    return INCLUDE_DATABINDING_BASE_LOG;
                }
            }
            throw new RuntimeException("Unsupported ExtendedContentType value: " + type);
        }
        throw new RuntimeException("Unsupported ContentType implementation: " + type.getClass().getCanonicalName());
    }

    abstract TransformInput asNonIncrementalInput();

    abstract IncrementalTransformInput asIncrementalInput();

    abstract TransformStream makeRestrictedCopy(Set<QualifiedContent.ContentType> var1, Set<? super QualifiedContent.Scope> var2);

    FileCollection getOutputFileCollection(Project project, StreamFilter streamFilter) {
        return this.fileCollection;
    }
}

