/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.DexingType;
import com.android.builder.utils.ExceptionRunnable;
import com.android.builder.utils.FileCache;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class PreDexCallable
implements Callable<Void> {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(PreDexCallable.class);
    private final File from;
    private final File to;
    private final Set<String> hashes;
    private final ProcessOutputHandler outputHandler;
    private final FileCache buildCache;
    private final DexingType dexingType;
    private final DexOptions dexOptions;
    private final AndroidBuilder androidBuilder;
    private final int minSdkVersion;

    public PreDexCallable(File from, File to, Set<String> hashes, ProcessOutputHandler outputHandler, FileCache buildCache, DexingType dexingType, DexOptions dexOptions, AndroidBuilder androidBuilder, int minSdkVersion) {
        this.from = from;
        this.to = to;
        this.hashes = hashes;
        this.outputHandler = outputHandler;
        this.buildCache = buildCache;
        this.dexingType = dexingType;
        this.dexOptions = dexOptions;
        this.androidBuilder = androidBuilder;
        this.minSdkVersion = minSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        logger.verbose("predex called for %s", this.from);
        String hash = PreDexCallable.getFileHash(this.from);
        Set<String> set = this.hashes;
        synchronized (set) {
            if (this.hashes.contains(hash)) {
                logger.verbose("Input with the same hash exists. Pre-dexing skipped.", new Object[0]);
                return null;
            }
            this.hashes.add(hash);
        }
        ExceptionRunnable preDexLibraryAction = () -> {
            FileUtils.deletePath((File)this.to);
            Files.createParentDirs((File)this.to);
            if (this.dexingType.isMultiDex()) {
                FileUtils.mkdirs((File)this.to);
            }
            this.androidBuilder.preDexLibrary(this.from, this.to, this.dexingType.isMultiDex(), this.dexOptions, this.outputHandler, this.minSdkVersion);
        };
        if (this.buildCache != null) {
            FileCache.QueryResult result;
            FileCache.Inputs buildCacheInputs = PreDexCallable.getBuildCacheInputs(this.from, this.androidBuilder.getTargetInfo().getBuildTools().getRevision(), this.dexOptions, this.dexingType.isMultiDex(), this.minSdkVersion);
            try {
                result = this.buildCache.createFile(this.to, buildCacheInputs, preDexLibraryAction);
            }
            catch (ExecutionException exception) {
                throw new RuntimeException(String.format("Unable to pre-dex '%1$s' to '%2$s'", this.from.getAbsolutePath(), this.to.getAbsolutePath()), exception);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Unable to pre-dex '%1$s' to '%2$s' using the build cache at '%3$s'.\n%4$s", this.from.getAbsolutePath(), this.to.getAbsolutePath(), this.buildCache.getCacheDirectory().getAbsolutePath(), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html."), exception);
            }
            if (result.getQueryEvent().equals((Object)FileCache.QueryEvent.CORRUPTED)) {
                Verify.verifyNotNull((Object)result.getCauseOfCorruption());
                logger.verbose("The build cache at '%1$s' contained an invalid cache entry.\nCause: %2$s\nWe have recreated the cache entry.\n%3$s", this.buildCache.getCacheDirectory().getAbsolutePath(), Throwables.getStackTraceAsString((Throwable)result.getCauseOfCorruption()), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html.");
            }
        } else {
            preDexLibraryAction.run();
        }
        return null;
    }

    private static FileCache.Inputs getBuildCacheInputs(File inputFile, Revision buildToolsRevision, DexOptions dexOptions, boolean multiDex, int minSdkVersion) throws IOException {
        FileCache.Inputs.Builder buildCacheInputs = new FileCache.Inputs.Builder(FileCache.Command.PREDEX_LIBRARY);
        buildCacheInputs.putFile(FileCacheInputParams.FILE.name(), inputFile, FileCache.FileProperties.PATH_HASH).putString(FileCacheInputParams.BUILD_TOOLS_REVISION.name(), buildToolsRevision.toString()).putBoolean(FileCacheInputParams.JUMBO_MODE.name(), dexOptions.getJumboMode()).putBoolean(FileCacheInputParams.OPTIMIZE.name(), true).putBoolean(FileCacheInputParams.MULTI_DEX.name(), multiDex).putLong(FileCacheInputParams.MIN_SDK_VERSION.name(), (long)minSdkVersion);
        List additionalParams = dexOptions.getAdditionalParameters();
        for (int i = 0; i < additionalParams.size(); ++i) {
            buildCacheInputs.putString(FileCacheInputParams.ADDITIONAL_PARAMETERS.name() + "[" + i + "]", (String)additionalParams.get(i));
        }
        return buildCacheInputs.build();
    }

    private static String getFileHash(File file) throws IOException {
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = file.isDirectory() ? hashFunction.hashString((CharSequence)file.getPath(), Charsets.UTF_16LE) : Files.hash((File)file, (HashFunction)hashFunction);
        return hashCode.toString();
    }

    private static enum FileCacheInputParams {
        FILE,
        BUILD_TOOLS_REVISION,
        JUMBO_MODE,
        OPTIMIZE,
        MULTI_DEX,
        ADDITIONAL_PARAMETERS,
        MIN_SDK_VERSION;

    }
}

