/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.MergedFlavor;
import com.android.builder.core.VariantAttributesProvider;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildType;
import com.android.builder.model.ClassField;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AssetSet;
import com.android.ide.common.resources.ResourceSet;
import com.android.sdklib.AndroidVersion;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class VariantConfiguration<T extends BuildType, D extends ProductFlavor, F extends ProductFlavor> {
    private String mFullName;
    private String mFlavorName;
    private String mBaseName;
    private String mDirName;
    private List<String> mDirSegments;
    private final D mDefaultConfig;
    private final SourceProvider mDefaultSourceProvider;
    private final T mBuildType;
    private final SourceProvider mBuildTypeSourceProvider;
    private final List<String> mFlavorDimensionNames = Lists.newArrayList();
    private final List<F> mFlavors = Lists.newArrayList();
    private final List<SourceProvider> mFlavorSourceProviders = Lists.newArrayList();
    private SourceProvider mVariantSourceProvider;
    private SourceProvider mMultiFlavorSourceProvider;
    private final VariantType mType;
    private final VariantConfiguration<T, D, F> mTestedConfig;
    private ProductFlavor mMergedFlavor;
    private final Map<String, ClassField> mBuildConfigFields = Maps.newTreeMap();
    private final Map<String, ClassField> mResValues = Maps.newTreeMap();
    private final SigningConfig mSigningConfigOverride;
    private final VariantAttributesProvider mVariantAttributesProvider;
    private final EvalIssueReporter mIssueReporter;
    private static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";
    private static final String MULTIDEX_TEST_RUNNER = "com.android.test.runner.MultiDexTestRunner";
    private static final Boolean DEFAULT_HANDLE_PROFILING = false;
    private static final Boolean DEFAULT_FUNCTIONAL_TEST = false;

    public VariantConfiguration(D defaultConfig2, SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, T buildType, SourceProvider buildTypeSourceProvider, VariantType type, SigningConfig signingConfigOverride, EvalIssueReporter issueReporter, BooleanSupplier isInExecutionPhase) {
        this(defaultConfig2, defaultSourceProvider, mainManifestAttributeSupplier, buildType, buildTypeSourceProvider, type, null, signingConfigOverride, issueReporter, isInExecutionPhase);
    }

    public VariantConfiguration(D defaultConfig2, SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, T buildType, SourceProvider buildTypeSourceProvider, VariantType type, VariantConfiguration<T, D, F> testedConfig, SigningConfig signingConfigOverride, EvalIssueReporter issueReporter, BooleanSupplier isInExecutionPhase) {
        Preconditions.checkNotNull(defaultConfig2);
        Preconditions.checkNotNull((Object)defaultSourceProvider);
        Preconditions.checkNotNull(buildType);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((!type.isTestComponent() || testedConfig != null ? 1 : 0) != 0, (Object)"You have to specify the tested variant for this variant type.");
        Preconditions.checkArgument((type.isTestComponent() || testedConfig == null ? 1 : 0) != 0, (Object)"This variant type doesn't need a tested variant.");
        this.mDefaultConfig = (ProductFlavor)Preconditions.checkNotNull(defaultConfig2);
        this.mDefaultSourceProvider = (SourceProvider)Preconditions.checkNotNull((Object)defaultSourceProvider);
        this.mBuildType = (BuildType)Preconditions.checkNotNull(buildType);
        this.mBuildTypeSourceProvider = buildTypeSourceProvider;
        this.mType = (VariantType)Preconditions.checkNotNull((Object)type);
        this.mTestedConfig = testedConfig;
        this.mSigningConfigOverride = signingConfigOverride;
        this.mIssueReporter = issueReporter;
        this.mMergedFlavor = MergedFlavor.clone(this.mDefaultConfig, (EvalIssueReporter)this.mIssueReporter);
        ManifestAttributeSupplier manifestParser = mainManifestAttributeSupplier != null ? mainManifestAttributeSupplier : new DefaultManifestParser(this.mDefaultSourceProvider.getManifestFile(), isInExecutionPhase, issueReporter);
        this.mVariantAttributesProvider = new VariantAttributesProvider(this.mMergedFlavor, this.mBuildType, this.mType.isTestComponent(), manifestParser, this.mDefaultSourceProvider.getManifestFile(), this.getFullName());
    }

    public String getFullName() {
        if (this.mFullName == null) {
            this.mFullName = VariantConfiguration.computeFullName(this.getFlavorName(), this.mBuildType, this.mType, this.mTestedConfig == null ? null : this.mTestedConfig.getType());
        }
        return this.mFullName;
    }

    public static <B extends BuildType> String computeFullName(String flavorName, B buildType, VariantType type, VariantType testedType) {
        StringBuilder sb = new StringBuilder();
        if (!flavorName.isEmpty()) {
            sb.append(flavorName);
            StringHelper.appendCapitalized((StringBuilder)sb, (String)buildType.getName());
        } else {
            sb.append(buildType.getName());
        }
        if (type.isHybrid()) {
            sb.append("Feature");
        }
        if (type.isTestComponent()) {
            if (testedType != null && testedType.isHybrid()) {
                sb.append("Feature");
            }
            sb.append(type.getSuffix());
        }
        return sb.toString();
    }

    public String computeFullNameWithSplits(String splitName) {
        StringBuilder sb = new StringBuilder();
        String flavorName = this.getFlavorName();
        if (!flavorName.isEmpty()) {
            sb.append(flavorName);
            StringHelper.appendCapitalized((StringBuilder)sb, (String)splitName);
        } else {
            sb.append(splitName);
        }
        StringHelper.appendCapitalized((StringBuilder)sb, (String)this.mBuildType.getName());
        if (this.mType.isTestComponent()) {
            sb.append(this.mType.getSuffix());
        }
        return sb.toString();
    }

    public String getFlavorName() {
        if (this.mFlavorName == null) {
            this.mFlavorName = VariantConfiguration.computeFlavorName(this.mFlavors);
        }
        return this.mFlavorName;
    }

    public static <F extends ProductFlavor> String computeFlavorName(List<F> flavors) {
        if (flavors.isEmpty()) {
            return "";
        }
        return StringHelper.combineAsCamelCase(flavors, ProductFlavor::getName);
    }

    public String getBaseName() {
        if (this.mBaseName == null) {
            StringBuilder sb = new StringBuilder();
            if (!this.mFlavors.isEmpty()) {
                for (ProductFlavor pf : this.mFlavors) {
                    sb.append(pf.getName()).append('-');
                }
            }
            sb.append(this.mBuildType.getName());
            if (this.mType.isTestComponent()) {
                sb.append('-').append(this.mType.getPrefix());
            }
            this.mBaseName = sb.toString();
        }
        return this.mBaseName;
    }

    public String computeBaseNameWithSplits(String splitName) {
        StringBuilder sb = new StringBuilder();
        if (!this.mFlavors.isEmpty()) {
            for (ProductFlavor pf : this.mFlavors) {
                sb.append(pf.getName()).append('-');
            }
        }
        sb.append(splitName).append('-');
        sb.append(this.mBuildType.getName());
        if (this.mType.isTestComponent()) {
            sb.append('-').append(this.mType.getPrefix());
        }
        return sb.toString();
    }

    public String getDirName() {
        if (this.mDirName == null) {
            StringBuilder sb = new StringBuilder(this.mFlavors.size() * 20 + 100);
            if (this.mType.isHybrid()) {
                sb.append("feature/");
            }
            if (this.mType.isTestComponent()) {
                sb.append(this.mType.getPrefix()).append("/");
            }
            if (!this.mFlavors.isEmpty()) {
                StringHelper.combineAsCamelCase((StringBuilder)sb, this.mFlavors, ProductFlavor::getName);
                sb.append('/').append(this.mBuildType.getName());
            } else {
                sb.append(this.mBuildType.getName());
            }
            this.mDirName = sb.toString();
        }
        return this.mDirName;
    }

    public Collection<String> getDirectorySegments() {
        if (this.mDirSegments == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.mType.isHybrid()) {
                builder.add((Object)"feature");
            }
            if (this.mType.isTestComponent()) {
                builder.add((Object)this.mType.getPrefix());
            }
            if (!this.mFlavors.isEmpty()) {
                StringBuilder sb = new StringBuilder(this.mFlavors.size() * 10);
                for (ProductFlavor flavor : this.mFlavors) {
                    StringHelper.appendCamelCase((StringBuilder)sb, (String)flavor.getName());
                }
                builder.add((Object)sb.toString());
                builder.add((Object)this.mBuildType.getName());
            } else {
                builder.add((Object)this.mBuildType.getName());
            }
            this.mDirSegments = builder.build();
        }
        return this.mDirSegments;
    }

    public String computeDirNameWithSplits(String ... splitNames) {
        StringBuilder sb = new StringBuilder();
        if (this.mType.isTestComponent()) {
            sb.append(this.mType.getPrefix()).append("/");
        }
        if (!this.mFlavors.isEmpty()) {
            for (ProductFlavor flavor : this.mFlavors) {
                sb.append(flavor.getName());
            }
            sb.append('/');
        }
        for (String splitName : splitNames) {
            if (splitName == null) continue;
            sb.append(splitName).append('/');
        }
        sb.append(this.mBuildType.getName());
        return sb.toString();
    }

    public List<String> getFlavorNamesWithDimensionNames() {
        List<Object> names;
        if (this.mFlavors.isEmpty()) {
            return Collections.emptyList();
        }
        int count = this.mFlavors.size();
        if (count > 1) {
            names = Lists.newArrayListWithCapacity((int)(count * 2));
            for (int i = 0; i < count; ++i) {
                names.add(((ProductFlavor)this.mFlavors.get(i)).getName());
                names.add(this.mFlavorDimensionNames.get(i));
            }
        } else {
            names = Collections.singletonList(((ProductFlavor)this.mFlavors.get(0)).getName());
        }
        return names;
    }

    public VariantConfiguration addProductFlavor(F productFlavor, SourceProvider sourceProvider, String dimensionName) {
        this.mFlavors.add(productFlavor);
        this.mFlavorSourceProviders.add(sourceProvider);
        this.mFlavorDimensionNames.add(dimensionName);
        this.mMergedFlavor = MergedFlavor.mergeFlavors(this.mDefaultConfig, this.mFlavors, (EvalIssueReporter)this.mIssueReporter);
        this.mVariantAttributesProvider.setMergedFlavor(this.mMergedFlavor);
        this.mFlavorName = null;
        this.mFullName = null;
        this.mVariantAttributesProvider.setFullName(this.getFullName());
        return this;
    }

    public VariantConfiguration setVariantSourceProvider(SourceProvider sourceProvider) {
        this.mVariantSourceProvider = sourceProvider;
        return this;
    }

    public VariantConfiguration setMultiFlavorSourceProvider(SourceProvider sourceProvider) {
        this.mMultiFlavorSourceProvider = sourceProvider;
        return this;
    }

    public SourceProvider getVariantSourceProvider() {
        return this.mVariantSourceProvider;
    }

    public SourceProvider getMultiFlavorSourceProvider() {
        return this.mMultiFlavorSourceProvider;
    }

    public D getDefaultConfig() {
        return this.mDefaultConfig;
    }

    public SourceProvider getDefaultSourceSet() {
        return this.mDefaultSourceProvider;
    }

    public ProductFlavor getMergedFlavor() {
        return this.mMergedFlavor;
    }

    public T getBuildType() {
        return this.mBuildType;
    }

    public SourceProvider getBuildTypeSourceSet() {
        return this.mBuildTypeSourceProvider;
    }

    public boolean hasFlavors() {
        return !this.mFlavors.isEmpty();
    }

    public List<F> getProductFlavors() {
        return this.mFlavors;
    }

    public List<SourceProvider> getFlavorSourceProviders() {
        return this.mFlavorSourceProviders;
    }

    public VariantType getType() {
        return this.mType;
    }

    public VariantConfiguration getTestedConfig() {
        return this.mTestedConfig;
    }

    private String getTestedPackage() {
        return this.mTestedConfig != null ? this.mTestedConfig.getApplicationId() : "";
    }

    public String getOriginalApplicationId() {
        return this.mVariantAttributesProvider.getOriginalApplicationId(this.getTestedPackage());
    }

    public String getApplicationId() {
        return this.mVariantAttributesProvider.getApplicationId(this.getTestedPackage());
    }

    public String getTestApplicationId() {
        return this.mVariantAttributesProvider.getTestApplicationId(this.getTestedPackage());
    }

    public String getTestedApplicationId() {
        if (this.mType.isTestComponent()) {
            Preconditions.checkState((this.mTestedConfig != null ? 1 : 0) != 0);
            if (this.mTestedConfig.mType.isAar()) {
                return this.getApplicationId();
            }
            return this.mTestedConfig.getApplicationId();
        }
        return null;
    }

    public String getIdOverride() {
        return this.mVariantAttributesProvider.getIdOverride();
    }

    public String getVersionName() {
        return this.mVariantAttributesProvider.getVersionName();
    }

    public int getVersionCode() {
        return this.mVariantAttributesProvider.getVersionCode();
    }

    public Supplier<String> getVersionNameSerializableSupplier() {
        return this.mVariantAttributesProvider.getVersionNameSerializableSupplier();
    }

    public IntSupplier getVersionCodeSerializableSupplier() {
        return this.mVariantAttributesProvider.getVersionCodeSerializableSupplier();
    }

    public String getInstrumentationRunner() {
        String runner;
        VariantConfiguration config2 = this;
        if (this.mType.isTestComponent()) {
            config2 = this.getTestedConfig();
            Preconditions.checkState((config2 != null ? 1 : 0) != 0);
        }
        if ((runner = config2.mVariantAttributesProvider.getInstrumentationRunner()) != null) {
            return runner;
        }
        if (this.isLegacyMultiDexMode()) {
            return MULTIDEX_TEST_RUNNER;
        }
        return DEFAULT_TEST_RUNNER;
    }

    public Map<String, String> getInstrumentationRunnerArguments() {
        VariantConfiguration config2 = this;
        if (this.mType.isTestComponent()) {
            config2 = this.getTestedConfig();
            Preconditions.checkState((config2 != null ? 1 : 0) != 0);
        }
        return config2.mMergedFlavor.getTestInstrumentationRunnerArguments();
    }

    public Boolean getHandleProfiling() {
        Boolean handleProfiling;
        VariantConfiguration config2 = this;
        if (this.mType.isTestComponent()) {
            config2 = this.getTestedConfig();
            Preconditions.checkState((config2 != null ? 1 : 0) != 0);
        }
        return (handleProfiling = config2.mVariantAttributesProvider.getHandleProfiling()) != null ? handleProfiling : DEFAULT_HANDLE_PROFILING;
    }

    public Boolean getFunctionalTest() {
        Boolean functionalTest;
        VariantConfiguration config2 = this;
        if (this.mType.isTestComponent()) {
            config2 = this.getTestedConfig();
            Preconditions.checkState((config2 != null ? 1 : 0) != 0);
        }
        return (functionalTest = config2.mVariantAttributesProvider.getFunctionalTest()) != null ? functionalTest : DEFAULT_FUNCTIONAL_TEST;
    }

    public String getTestLabel() {
        return this.mVariantAttributesProvider.getTestLabel();
    }

    public String getPackageFromManifest() {
        return this.mVariantAttributesProvider.getPackageName();
    }

    public AndroidVersion getMinSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getMinSdkVersion();
        }
        ApiVersion minSdkVersion = this.mMergedFlavor.getMinSdkVersion();
        if (minSdkVersion == null) {
            minSdkVersion = DefaultApiVersion.create((Object)new Integer(1));
        }
        return new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
    }

    public int getMinSdkVersionValue() {
        return this.getMinSdkVersion().getFeatureLevel();
    }

    public ApiVersion getTargetSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getTargetSdkVersion();
        }
        ApiVersion targetSdkVersion = this.mMergedFlavor.getTargetSdkVersion();
        if (targetSdkVersion == null) {
            targetSdkVersion = DefaultApiVersion.create((Object)new Integer(-1));
        }
        return targetSdkVersion;
    }

    public File getMainManifest() {
        File defaultManifest = this.mDefaultSourceProvider.getManifestFile();
        if (defaultManifest.isFile()) {
            return defaultManifest;
        }
        return null;
    }

    public List<SourceProvider> getSortedSourceProviders() {
        ArrayList providers = Lists.newArrayListWithExpectedSize((int)(this.mFlavorSourceProviders.size() + 4));
        providers.add(this.mDefaultSourceProvider);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            providers.add(this.mFlavorSourceProviders.get(n));
        }
        if (this.mMultiFlavorSourceProvider != null) {
            providers.add(this.mMultiFlavorSourceProvider);
        }
        if (this.mBuildTypeSourceProvider != null) {
            providers.add(this.mBuildTypeSourceProvider);
        }
        if (this.mVariantSourceProvider != null) {
            providers.add(this.mVariantSourceProvider);
        }
        return providers;
    }

    public List<File> getManifestOverlays() {
        File typeLocation;
        File variantLocation;
        ArrayList inputs = Lists.newArrayList();
        if (this.mVariantSourceProvider != null && (variantLocation = this.mVariantSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        if (this.mBuildTypeSourceProvider != null && (typeLocation = this.mBuildTypeSourceProvider.getManifestFile()).isFile()) {
            inputs.add(typeLocation);
        }
        if (this.mMultiFlavorSourceProvider != null && (variantLocation = this.mMultiFlavorSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        for (SourceProvider sourceProvider : this.mFlavorSourceProviders) {
            File f = sourceProvider.getManifestFile();
            if (!f.isFile()) continue;
            inputs.add(f);
        }
        return inputs;
    }

    public List<File> getNavigationFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<SourceProvider> sourceProviders = this.getSortedSourceProviders();
        for (int n = sourceProviders.size() - 1; n >= 0; --n) {
            Collection resDirs = sourceProviders.get(n).getResDirectories();
            for (File resDir : resDirs) {
                File navigationDir;
                File[] navigationFiles;
                if (resDir == null || (navigationFiles = (navigationDir = new File(resDir.getPath(), "navigation")).listFiles()) == null) continue;
                for (File navigationFile : navigationFiles) {
                    if (navigationFile == null || !navigationFile.isFile()) continue;
                    builder.add((Object)navigationFile);
                }
            }
        }
        return builder.build();
    }

    public Set<File> getSourceFiles(Function<SourceProvider, Collection<File>> f) {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList fileLists = Lists.newArrayListWithExpectedSize((int)providers.size());
        providers.forEach(p -> fileLists.add(f.apply((SourceProvider)p)));
        int numFiles = 0;
        for (Collection files : fileLists) {
            numFiles += files.size();
        }
        HashSet fileSet = Sets.newHashSetWithExpectedSize((int)numFiles);
        fileLists.forEach(fileSet::addAll);
        return fileSet;
    }

    public List<ResourceSet> getResourceSets(boolean validateEnabled) {
        ArrayList resourceSets = Lists.newArrayList();
        Collection mainResDirs = this.mDefaultSourceProvider.getResDirectories();
        ResourceSet resourceSet = new ResourceSet("main", ResourceNamespace.RES_AUTO, null, validateEnabled);
        resourceSet.addSources(mainResDirs);
        resourceSets.add(resourceSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getResDirectories();
            resourceSet = new ResourceSet(sourceProvider.getName(), ResourceNamespace.RES_AUTO, null, validateEnabled);
            resourceSet.addSources(flavorResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFlavorName(), ResourceNamespace.RES_AUTO, null, validateEnabled);
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.mBuildType.getName(), ResourceNamespace.RES_AUTO, null, validateEnabled);
            resourceSet.addSources(typeResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFullName(), ResourceNamespace.RES_AUTO, null, validateEnabled);
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        return resourceSets;
    }

    public List<AssetSet> getSourceFilesAsAssetSets(Function<SourceProvider, Collection<File>> function) {
        ArrayList assetSets = Lists.newArrayList();
        Collection<File> mainResDirs = function.apply(this.mDefaultSourceProvider);
        AssetSet assetSet = new AssetSet("main");
        assetSet.addSources(mainResDirs);
        assetSets.add(assetSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection<File> flavorResDirs = function.apply(sourceProvider);
            assetSet = new AssetSet(((ProductFlavor)this.mFlavors.get(n)).getName());
            assetSet.addSources(flavorResDirs);
            assetSets.add(assetSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection<File> variantResDirs = function.apply(this.mMultiFlavorSourceProvider);
            assetSet = new AssetSet(this.getFlavorName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection<File> typeResDirs = function.apply(this.mBuildTypeSourceProvider);
            assetSet = new AssetSet(this.mBuildType.getName());
            assetSet.addSources(typeResDirs);
            assetSets.add(assetSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection<File> variantResDirs = function.apply(this.mVariantSourceProvider);
            assetSet = new AssetSet(this.getFullName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        return assetSets;
    }

    public int getRenderscriptTarget() {
        ProductFlavor mergedFlavor = this.getMergedFlavor();
        int targetApi = mergedFlavor.getRenderscriptTargetApi() != null ? mergedFlavor.getRenderscriptTargetApi() : -1;
        int minSdk = this.getMinSdkVersionValue();
        return targetApi > minSdk ? targetApi : minSdk;
    }

    public Collection<File> getRenderscriptSourceList() {
        return this.getSourceFiles(SourceProvider::getRenderscriptDirectories);
    }

    public Collection<File> getAidlSourceList() {
        return this.getSourceFiles(SourceProvider::getAidlDirectories);
    }

    public Collection<File> getJniSourceList() {
        return this.getSourceFiles(SourceProvider::getCDirectories);
    }

    public void addBuildConfigField(String type, String name, String value) {
        ClassFieldImpl classField = new ClassFieldImpl(type, name, value);
        this.mBuildConfigFields.put(name, (ClassField)classField);
    }

    public void addResValue(String type, String name, String value) {
        ClassFieldImpl classField = new ClassFieldImpl(type, name, value);
        this.mResValues.put(name, (ClassField)classField);
    }

    public List<Object> getBuildConfigItems() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<Object> list = this.mBuildConfigFields.values();
        if (!list.isEmpty()) {
            fullList.add("Fields from the variant");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        if (!(list = this.mBuildType.getBuildConfigFields().values()).isEmpty()) {
            fullList.add("Fields from build type: " + this.mBuildType.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        for (ProductFlavor flavor : this.mFlavors) {
            list = flavor.getBuildConfigFields().values();
            if (list.isEmpty()) continue;
            fullList.add("Fields from product flavor: " + flavor.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        list = this.mDefaultConfig.getBuildConfigFields().values();
        if (!list.isEmpty()) {
            fullList.add("Fields from default config.");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        return fullList;
    }

    public Map<String, ClassField> getMergedBuildConfigFields() {
        HashMap mergedMap = Maps.newHashMap();
        mergedMap.putAll(this.mDefaultConfig.getBuildConfigFields());
        for (int i = this.mFlavors.size() - 1; i >= 0; --i) {
            mergedMap.putAll(((ProductFlavor)this.mFlavors.get(i)).getBuildConfigFields());
        }
        mergedMap.putAll(this.mBuildType.getBuildConfigFields());
        mergedMap.putAll(this.mBuildConfigFields);
        return mergedMap;
    }

    public Map<String, ClassField> getMergedResValues() {
        HashMap mergedMap = Maps.newHashMap();
        mergedMap.putAll(this.mDefaultConfig.getResValues());
        for (int i = this.mFlavors.size() - 1; i >= 0; --i) {
            mergedMap.putAll(((ProductFlavor)this.mFlavors.get(i)).getResValues());
        }
        mergedMap.putAll(this.mBuildType.getResValues());
        mergedMap.putAll(this.mResValues);
        return mergedMap;
    }

    private static void fillFieldList(List<Object> outList, Set<String> usedFieldNames, Collection<ClassField> list) {
        for (ClassField f : list) {
            String name = f.getName();
            if (usedFieldNames.contains(name)) continue;
            usedFieldNames.add(f.getName());
            outList.add(f);
        }
    }

    public List<Object> getResValues() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<Object> list = this.mResValues.values();
        if (!list.isEmpty()) {
            fullList.add("Values from the variant");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        if (!(list = this.mBuildType.getResValues().values()).isEmpty()) {
            fullList.add("Values from build type: " + this.mBuildType.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        for (ProductFlavor flavor : this.mFlavors) {
            list = flavor.getResValues().values();
            if (list.isEmpty()) continue;
            fullList.add("Values from product flavor: " + flavor.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        list = this.mDefaultConfig.getResValues().values();
        if (!list.isEmpty()) {
            fullList.add("Values from default config.");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        return fullList;
    }

    public SigningConfig getSigningConfig() {
        if (this.mSigningConfigOverride != null) {
            return this.mSigningConfigOverride;
        }
        SigningConfig signingConfig = this.mBuildType.getSigningConfig();
        if (signingConfig != null) {
            return signingConfig;
        }
        return this.mMergedFlavor.getSigningConfig();
    }

    public boolean isSigningReady() {
        SigningConfig signingConfig = this.getSigningConfig();
        return signingConfig != null && signingConfig.isSigningReady();
    }

    public boolean isTestCoverageEnabled() {
        return this.mBuildType.isTestCoverageEnabled();
    }

    public Map<String, Object> getManifestPlaceholders() {
        Map mergedFlavorsPlaceholders = this.mMergedFlavor.getManifestPlaceholders();
        mergedFlavorsPlaceholders.putAll(this.mBuildType.getManifestPlaceholders());
        return mergedFlavorsPlaceholders;
    }

    public boolean isMultiDexEnabled() {
        Boolean value = this.mBuildType.getMultiDexEnabled();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexEnabled();
        if (value != null) {
            return value;
        }
        return this.getMinSdkVersion().getFeatureLevel() >= 21;
    }

    public File getMultiDexKeepFile() {
        File value = this.mBuildType.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        return null;
    }

    public File getMultiDexKeepProguard() {
        File value = this.mBuildType.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        return null;
    }

    public boolean isLegacyMultiDexMode() {
        return this.getDexingType() == DexingType.LEGACY_MULTIDEX;
    }

    public DexingType getDexingType() {
        if (this.getType().isDynamicFeature()) {
            if (this.getBuildType().getMultiDexEnabled() != null || this.getMergedFlavor().getMultiDexEnabled() != null) {
                this.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, "Native multidex is always used for dynamic features. Please remove 'multiDexEnabled true|false' from your build.gradle file.");
            }
            return DexingType.NATIVE_MULTIDEX;
        }
        if (this.isMultiDexEnabled()) {
            return this.getMinSdkVersion().getFeatureLevel() < 21 ? DexingType.LEGACY_MULTIDEX : DexingType.NATIVE_MULTIDEX;
        }
        return DexingType.MONO_DEX;
    }

    public boolean getRenderscriptSupportModeEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptSupportModeEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public boolean getRenderscriptSupportModeBlasEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptSupportModeBlasEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public boolean getRenderscriptNdkModeEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptNdkModeEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public boolean isBundled() {
        return this.mType.isAar();
    }

    protected EvalIssueReporter getIssueReporter() {
        return this.mIssueReporter;
    }
}

