/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.res.namespaced.JarRequest;
import com.android.build.gradle.internal.res.namespaced.JarWorkerRunnable;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.transforms.MergeClassesTransform;
import com.android.ide.common.workers.WorkerExecutorFacade;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/transforms/MergeClassesTransform;", "Lcom/android/build/api/transform/Transform;", "outputJarFile", "Ljava/io/File;", "modulePath", "", "(Ljava/io/File;Ljava/lang/String;)V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "getSecondaryFileOutputs", "", "isIncremental", "", "transform", "", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "Companion", "gradle"})
public final class MergeClassesTransform
extends Transform {
    private final File outputJarFile;
    private final String modulePath;
    private static final Pattern CLASS_PATTERN;
    private static final Pattern KOTLIN_MODULE_PATTERN;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return "mergeClasses";
    }

    @NotNull
    public List<File> getSecondaryFileOutputs() {
        return CollectionsKt.listOf((Object)this.outputJarFile);
    }

    public boolean isIncremental() {
        return false;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<QualifiedContent.Scope> getScopes() {
        Set<QualifiedContent.Scope> set = TransformManager.EMPTY_SCOPES;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.EMPTY_SCOPES");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Set<QualifiedContent.Scope> set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.SCOPE_FULL_PROJECT");
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformInvocation invocation) {
        TransformInput it;
        Iterable $receiver$iv$iv;
        File file;
        Collection collection;
        TransformInput it2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
        Collection collection2 = invocation.getReferencedInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"invocation.referencedInputs");
        Iterable iterable = $receiver$iv = (Iterable)collection2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            TransformInput transformInput = it2 = (TransformInput)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Iterable list$iv$iv = transformInput.getJarInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it2 = (JarInput)item$iv$iv;
            collection = destination$iv$iv;
            TransformInput transformInput = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            file = transformInput.getFile();
            collection.add(file);
        }
        List fromJars = (List)destination$iv$iv;
        Collection collection3 = invocation.getReferencedInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"invocation.referencedInputs");
        Iterable $receiver$iv2 = collection3;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TransformInput transformInput = it = (TransformInput)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Iterable list$iv$iv = transformInput.getDirectoryInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (DirectoryInput)item$iv$iv;
            collection = destination$iv$iv2;
            TransformInput transformInput = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            file = transformInput.getFile();
            collection.add(file);
        }
        List fromDirectories = (List)destination$iv$iv2;
        Predicate classFilter2 = transform.classFilter.1.INSTANCE;
        Context context = invocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"invocation.context");
        WorkerExecutor workerExecutor = context.getWorkerExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)workerExecutor, (String)"invocation.context.workerExecutor");
        WorkerExecutorFacade workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
        Closeable closeable = (Closeable)workers;
        Object object = null;
        try {
            it2 = (WorkerExecutorFacade)closeable;
            Predicate predicate = classFilter2;
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"module-path", (Object)this.modulePath));
            Map map2 = null;
            List list = fromDirectories;
            List list2 = fromJars;
            it2.submit(JarWorkerRunnable.class, (Serializable)new JarRequest(this.outputJarFile, list, list2, map2, map, predicate, 8, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public MergeClassesTransform(@NotNull File outputJarFile, @NotNull String modulePath) {
        Intrinsics.checkParameterIsNotNull((Object)outputJarFile, (String)"outputJarFile");
        Intrinsics.checkParameterIsNotNull((Object)modulePath, (String)"modulePath");
        this.outputJarFile = outputJarFile;
        this.modulePath = modulePath;
    }

    static {
        Companion = new Companion(null);
        CLASS_PATTERN = Pattern.compile(".*\\.class$");
        KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/transforms/MergeClassesTransform$Companion;", "", "()V", "CLASS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getCLASS_PATTERN", "()Ljava/util/regex/Pattern;", "KOTLIN_MODULE_PATTERN", "getKOTLIN_MODULE_PATTERN", "gradle"})
    public static final class Companion {
        private final Pattern getCLASS_PATTERN() {
            return CLASS_PATTERN;
        }

        private final Pattern getKOTLIN_MODULE_PATTERN() {
            return KOTLIN_MODULE_PATTERN;
        }

        private Companion() {
        }

        public static final /* synthetic */ Pattern access$getCLASS_PATTERN$p(Companion $this) {
            return $this.getCLASS_PATTERN();
        }

        public static final /* synthetic */ Pattern access$getKOTLIN_MODULE_PATTERN$p(Companion $this) {
            return $this.getKOTLIN_MODULE_PATTERN();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

