/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.AppClasspathCheckTask;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.BundleTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.CheckMultiApkLibrariesTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.InstantRunSplitApkResourcesBuilder;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesConfigAction;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureApplicationIdsTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTask;
import com.android.build.gradle.internal.transforms.InstantRunDependenciesApkBuilder;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.ide.common.build.ApkInfo;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        this.createAnchorTasks(variantScope);
        this.createCheckManifestTask(variantScope);
        this.handleMicroApp(variantScope);
        this.createDependencyStreams(variantScope);
        this.createApplicationIdWriterTask(variantScope);
        this.taskFactory.create(new MainApkListPersistence.ConfigAction(variantScope));
        this.createBuildArtifactReportTask(variantScope);
        this.createMergeApkManifestsTask(variantScope);
        this.createGenerateResValuesTask(variantScope);
        this.createRenderscriptTask(variantScope);
        this.createMergeResourcesTask(variantScope, true, (ImmutableSet<MergeResources.Flag>)Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]));
        this.createShaderTask(variantScope);
        this.createMergeAssetsTask(variantScope);
        this.createBuildConfigTask(variantScope);
        this.createApkProcessResTask(variantScope);
        this.createProcessJavaResTask(variantScope);
        this.createAidlTask(variantScope);
        this.createNdkTasks(variantScope);
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createExternalNativeBuildJsonGenerators(variantScope);
        this.createExternalNativeBuildTasks(variantScope);
        this.createMergeJniLibFoldersTasks(variantScope);
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.create(new FeatureSetMetadataWriterTask.ConfigAction(variantScope));
            if (this.extension.getDataBinding().isEnabled()) {
                this.taskFactory.create(new DataBindingExportFeatureApplicationIdsTask.ConfigAction(variantScope));
            }
        } else {
            this.taskFactory.create(new FeatureSplitDeclarationWriterTask.ConfigAction(variantScope));
            if (this.extension.getDataBinding().isEnabled()) {
                this.taskFactory.create(new DataBindingExportFeatureInfoTask.ConfigAction(variantScope));
            }
            this.taskFactory.create(new MergeConsumerProguardFilesConfigAction(variantScope));
        }
        this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.MERGE);
        this.createCompileTask(variantScope);
        if (variantScope.getType().isBaseModule()) {
            CheckMultiApkLibrariesTask checkMultiApkLibrariesTask = this.taskFactory.create(new CheckMultiApkLibrariesTask.ConfigAction(variantScope));
            variantScope.getTaskContainer().getMergeJavaResourcesTask().dependsOn(new Object[]{checkMultiApkLibrariesTask});
        }
        ApplicationTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope);
        if (variantScope.getVariantData().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.createSplitTasks(variantScope);
        }
        BuildInfoWriterTask buildInfoWriterTask = this.createInstantRunPackagingTasks(variantScope);
        this.createPackagingTask(variantScope, buildInfoWriterTask);
        this.createLintTasks(variantScope);
        this.taskFactory.create(new FeatureSplitTransitiveDepsWriterTask.ConfigAction(variantScope));
        this.createDynamicBundleTask(variantScope);
    }

    @Override
    protected void createInstallTask(VariantScope variantScope) {
        GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
        VariantType variantType = variantConfiguration.getType();
        if (variantType.isFeatureSplit() || variantType.isHybrid()) {
            return;
        }
        if (variantType.isForTesting() || !(this.extension instanceof BaseAppModuleExtension) || ((BaseAppModuleExtension)this.extension).getDynamicFeatures().isEmpty()) {
            super.createInstallTask(variantScope);
        } else {
            this.taskFactory.create(new InstallVariantViaBundleTask.ConfigAction(variantScope));
        }
    }

    private BuildInfoWriterTask createInstantRunPackagingTasks(VariantScope variantScope) {
        if (!variantScope.getInstantRunBuildContext().isInInstantRunMode() || variantScope.getInstantRunTaskManager() == null) {
            return null;
        }
        BuildInfoWriterTask buildInfoGeneratorTask = this.taskFactory.create(new BuildInfoWriterTask.ConfigAction(variantScope, this.getLogger()));
        variantScope.getInstantRunTaskManager().configureBuildInfoWriterTask(buildInfoGeneratorTask, new Task[0]);
        InternalArtifactType resourcesWithMainManifest = variantScope.getInstantRunBuildContext().useSeparateApkForResources() ? InternalArtifactType.INSTANT_RUN_MAIN_APK_RESOURCES : InternalArtifactType.PROCESSED_RES;
        BuildArtifactsHolder artifacts = variantScope.getArtifacts();
        InstantRunDependenciesApkBuilder dependenciesApkBuilder = new InstantRunDependenciesApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), Aapt2MavenUtils.getAapt2FromMaven(this.globalScope), variantScope.getVariantConfiguration()::getApplicationId, variantScope.getVariantConfiguration().getSigningConfig(), DslAdaptersKt.convert(this.globalScope.getExtension().getAaptOptions()), new File(variantScope.getInstantRunSplitApkOutputFolder(), "dep"), new File(variantScope.getIncrementalDir("ir_dep"), variantScope.getDirName()), artifacts.getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES), artifacts.getFinalArtifactFiles(resourcesWithMainManifest), artifacts.getFinalArtifactFiles(InternalArtifactType.APK_LIST), (ApkInfo)variantScope.getOutputScope().getMainSplit());
        Optional<TransformTask> dependenciesApkBuilderTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, dependenciesApkBuilder);
        dependenciesApkBuilderTask.ifPresent(task -> task.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)}));
        this.taskFactory.create(new InstantRunSplitApkResourcesBuilder.ConfigAction(variantScope));
        InstantRunSliceSplitApkBuilder slicesApkBuilder = new InstantRunSliceSplitApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), Aapt2MavenUtils.getAapt2FromMaven(this.globalScope), variantScope.getVariantConfiguration()::getApplicationId, variantScope.getVariantConfiguration().getSigningConfig(), DslAdaptersKt.convert(this.globalScope.getExtension().getAaptOptions()), new File(variantScope.getInstantRunSplitApkOutputFolder(), "slices"), ApplicationTaskManager.getIncrementalFolder(variantScope, "ir_slices"), artifacts.getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES), artifacts.getFinalArtifactFiles(resourcesWithMainManifest), artifacts.getFinalArtifactFiles(InternalArtifactType.APK_LIST), artifacts.getFinalArtifactFiles(InternalArtifactType.INSTANT_RUN_SPLIT_APK_RESOURCES), (ApkInfo)variantScope.getOutputScope().getMainSplit());
        Optional<TransformTask> transformTaskAndroidTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, slicesApkBuilder);
        if (transformTaskAndroidTask.isPresent()) {
            TransformTask splitApk = transformTaskAndroidTask.get();
            splitApk.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
            variantScope.getTaskContainer().getAssembleTask().dependsOn(new Object[]{splitApk});
            buildInfoGeneratorTask.mustRunAfter(new Object[]{splitApk.getName()});
        }
        variantScope.getTaskContainer().getAssembleTask().dependsOn(new Object[]{buildInfoGeneratorTask});
        return buildInfoGeneratorTask;
    }

    @Override
    protected void postJavacCreation(final VariantScope scope) {
        final BuildableArtifact javacOutput = scope.getArtifacts().getArtifactFiles(InternalArtifactType.JAVAC);
        final FileCollection preJavacGeneratedBytecode = scope.getVariantData().getAllPreJavacGeneratedBytecode();
        final FileCollection postJavacGeneratedBytecode = scope.getVariantData().getAllPostJavacGeneratedBytecode();
        this.taskFactory.create(new TaskConfigAction<Jar>(){

            @Override
            public String getName() {
                return scope.getTaskName("packageAppClasses");
            }

            @Override
            public Class<Jar> getType() {
                return Jar.class;
            }

            @Override
            public void execute(Jar task) {
                File outputFile = scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APP_CLASSES, (Task)task, "classes.jar");
                task.from(new Object[]{javacOutput});
                task.from(new Object[]{preJavacGeneratedBytecode});
                task.from(new Object[]{postJavacGeneratedBytecode});
                task.setDestinationDir(outputFile.getParentFile());
                task.setArchiveName(outputFile.getName());
            }
        });
        ConfigurableFileCollection files = scope.getGlobalScope().getProject().files(new Object[]{javacOutput, preJavacGeneratedBytecode, postJavacGeneratedBytecode});
        scope.getArtifacts().appendArtifact((ArtifactType)AnchorOutputType.ALL_CLASSES, (FileCollection)files);
    }

    @Override
    protected Task createVariantPreBuildTask(VariantScope scope) {
        VariantType variantType = scope.getVariantConfiguration().getType();
        if (variantType.isApk()) {
            AppClasspathCheckTask classpathCheck = this.taskFactory.create(new AppClasspathCheckTask.ConfigAction(scope));
            return (variantType.isTestComponent() ? (AndroidVariantTask)this.taskFactory.create(new TestPreBuildTask.ConfigAction(scope)) : (AndroidVariantTask)this.taskFactory.create(new AppPreBuildTask.ConfigAction(scope))).dependsOn(new Object[]{classpathCheck});
        }
        return super.createVariantPreBuildTask(scope);
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        if (variantScope.consumesFeatureJars()) {
            return TransformManager.SCOPE_FULL_WITH_FEATURES;
        }
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        VariantType variantType = variantConfiguration.getType();
        if (!variantType.isHybrid() && variantType.isBaseModule()) {
            Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
            if (!Boolean.TRUE.equals(unbundledWearApp) && ((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
                Configuration wearApp = variantData.getVariantDependency().getWearAppConfiguration();
                assert (wearApp != null) : "Wear app with no wearApp configuration";
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType());
                    FileCollection files = wearApp.getIncoming().artifactView(config2 -> {
                        ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(setApkArtifact);
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(scope, files);
                }
            } else if (Boolean.TRUE.equals(unbundledWearApp)) {
                this.createGenerateMicroApkDataTask(scope, null);
            }
        }
    }

    private void createApplicationIdWriterTask(VariantScope variantScope) {
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.create(new ModuleMetadataWriterTask.ConfigAction(variantScope));
        }
        ApplicationIdWriterTask applicationIdWriterTask = this.taskFactory.create(new ApplicationIdWriterTask.ConfigAction(variantScope));
        TextResourceFactory resources = this.project.getResources().getText();
        variantScope.getVariantData().applicationIdTextResource = resources.fromFile((Object)applicationIdWriterTask);
    }

    private static File getIncrementalFolder(VariantScope variantScope, String taskName) {
        return new File(variantScope.getIncrementalDir(taskName), variantScope.getDirName());
    }

    private void createDynamicBundleTask(VariantScope scope) {
        if (Boolean.TRUE.equals(scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
            return;
        }
        this.taskFactory.create(new PerModuleBundleTask.ConfigAction(scope));
        if (scope.getType().isBaseModule()) {
            BundleTask bundleTask = this.taskFactory.create(new BundleTask.ConfigAction(scope));
            scope.getTaskContainer().getBundleTask().dependsOn(new Object[]{scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.BUNDLE)});
            BundleToApkTask task = this.taskFactory.create(new BundleToApkTask.ConfigAction(scope));
            if (scope.getVariantConfiguration().getSigningConfig() != null) {
                task.dependsOn(new Object[]{this.getValidateSigningTask(scope)});
                bundleTask.dependsOn(new Object[]{this.getValidateSigningTask(scope)});
            }
            this.taskFactory.create(new ExtractApksTask.ConfigAction(scope));
        }
    }
}

