/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.FolderBasedApkChangeList;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J8\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001aH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/incremental/FolderBasedApkCreator;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;)V", "changedItems", "", "", "getChangedItems", "()Ljava/util/List;", "deletedItems", "getDeletedItems", "close", "", "deleteFile", "entryPath", "hasPendingChangesWithWait", "", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Ljava/util/function/Function;", "isIgnored", "Ljava/util/function/Predicate;", "gradle"})
public final class FolderBasedApkCreator
implements ApkCreator {
    @NotNull
    private final List<String> changedItems;
    @NotNull
    private final List<String> deletedItems;
    private final ApkCreatorFactory.CreationData creationData;

    @NotNull
    public final List<String> getChangedItems() {
        return this.changedItems;
    }

    @NotNull
    public final List<String> getDeletedItems() {
        return this.deletedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZip(@Nullable File zip, @Nullable Function<String, String> transform2, @Nullable Predicate<String> isIgnored) {
        if (zip == null) {
            return;
        }
        Closeable closeable = (Closeable)new ZFile(zip);
        Throwable throwable = null;
        try {
            ZFile it = (ZFile)closeable;
            Set set = it.entries();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"it.entries()");
            Iterable $receiver$iv = set;
            for (Object element$iv : $receiver$iv) {
                FolderBasedApkCreator folderBasedApkCreator;
                StoredEntry entry = (StoredEntry)element$iv;
                FolderBasedApkCreator $receiver = folderBasedApkCreator = this;
                Predicate<String> predicate = isIgnored;
                if (predicate != null) {
                    StoredEntry storedEntry = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                    CentralDirectoryHeader centralDirectoryHeader = storedEntry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                    if (predicate.test(centralDirectoryHeader.getName())) continue;
                }
                Closeable closeable2 = entry.open();
                Throwable throwable2 = null;
                try {
                    InputStream it2 = (InputStream)closeable2;
                    File file = $receiver.creationData.getApkPath();
                    StoredEntry storedEntry = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                    CentralDirectoryHeader centralDirectoryHeader = storedEntry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                    File destinationFile = new File(file, centralDirectoryHeader.getName());
                    destinationFile.getParentFile().mkdirs();
                    Files.copy(it2, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    List<String> list = $receiver.changedItems;
                    CentralDirectoryHeader centralDirectoryHeader2 = entry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader2, (String)"entry.centralDirectoryHeader");
                    String string = centralDirectoryHeader2.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.centralDirectoryHeader.name");
                    boolean bl = list.add(string);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void writeFile(@NotNull File inputFile, @NotNull String entryPath) {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)entryPath, (String)"entryPath");
        File destinationFile = new File(this.creationData.getApkPath(), entryPath);
        destinationFile.getParentFile().mkdirs();
        Files.copy(inputFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.changedItems.add(entryPath);
    }

    public void deleteFile(@NotNull String entryPath) {
        Intrinsics.checkParameterIsNotNull((Object)entryPath, (String)"entryPath");
        Files.deleteIfExists(new File(this.creationData.getApkPath(), entryPath).toPath());
        this.deletedItems.add(entryPath);
    }

    public boolean hasPendingChangesWithWait() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Closeable closeable = new FileWriter(new File(this.creationData.getApkPath(), "__adt_change_list__.json"));
        int n = 8192;
        closeable = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            FolderBasedApkChangeList.Companion.write(this, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public FolderBasedApkCreator(@NotNull ApkCreatorFactory.CreationData creationData) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)creationData, (String)"creationData");
        this.creationData = creationData;
        FolderBasedApkCreator folderBasedApkCreator = this;
        folderBasedApkCreator.changedItems = list = (List)new ArrayList();
        folderBasedApkCreator = this;
        folderBasedApkCreator.deletedItems = list = (List)new ArrayList();
        File apkPath = this.creationData.getApkPath();
        if (!apkPath.exists()) {
            apkPath.mkdirs();
        }
        File file = apkPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"apkPath");
        boolean bl = file.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

