/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.dependency.SourceSetManagerKt;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.variant2.RenamedConfigurationAction;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001a\u0010!\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130#J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0002J \u0010&\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0006\u0010(\u001a\u00020\u0018J\u001a\u0010)\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "buildArtifactActions", "Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;", "(Lorg/gradle/api/Project;ZLcom/android/build/gradle/internal/api/dsl/DslScope;Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "configuredSourceSets", "", "", "logger", "Lorg/gradle/api/logging/Logger;", "sourceSetsContainer", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getSourceSetsContainer", "()Lorg/gradle/api/NamedDomainObjectContainer;", "checkForUnconfiguredSourceSets", "", "createConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "name", "description", "canBeResolved", "createConfigurationsForSourceSet", "sourceSet", "isTestComponent", "executeAction", "action", "Lorg/gradle/api/Action;", "getConfigDesc", "sourceSetName", "getDeprecatedConfigDesc", "replacement", "runBuildableArtifactsActions", "setUpSourceSet", "setUpTestSourceSet", "gradle"})
public final class SourceSetManager {
    @NotNull
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    private final ConfigurationContainer configurations;
    private final Logger logger;
    private final Set<String> configuredSourceSets;
    private final boolean publishPackage;
    private final DslScope dslScope;
    private final DelayedActionsExecutor buildArtifactActions;

    @NotNull
    public final NamedDomainObjectContainer<AndroidSourceSet> getSourceSetsContainer() {
        return this.sourceSetsContainer;
    }

    @NotNull
    public final AndroidSourceSet setUpTestSourceSet(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.setUpSourceSet(name, true);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name, boolean isTestComponent) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        AndroidSourceSet sourceSet = (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(name);
        if (!this.configuredSourceSets.contains(name)) {
            AndroidSourceSet androidSourceSet = sourceSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            this.createConfigurationsForSourceSet(androidSourceSet, isTestComponent);
            this.configuredSourceSets.add(name);
        }
        AndroidSourceSet androidSourceSet = sourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
        return androidSourceSet;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ AndroidSourceSet setUpSourceSet$default(SourceSetManager sourceSetManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sourceSetManager.setUpSourceSet(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name) {
        return SourceSetManager.setUpSourceSet$default(this, name, false, 2, null);
    }

    private final void createConfigurationsForSourceSet(AndroidSourceSet sourceSet, boolean isTestComponent) {
        String providedName;
        String apkName;
        String string;
        String compileName;
        String apiName = sourceSet.getApiConfigurationName();
        String implementationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyName = sourceSet.getCompileOnlyConfigurationName();
        String string2 = compileName = sourceSet.getCompileConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"compileName");
        String string3 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sourceSet.name");
        String string4 = implementationName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"implementationName");
        Configuration compile2 = this.createConfiguration(string2, this.getDeprecatedConfigDesc("Compile", string3, string4), Intrinsics.areEqual((Object)"compile", (Object)compileName) || Intrinsics.areEqual((Object)"testCompile", (Object)compileName));
        compile2.getAllDependencies().whenObjectAdded((Action)new RenamedConfigurationAction("" + implementationName + "' and '" + apiName, compileName, this.dslScope.getDeprecationReporter(), SourceSetManagerKt.getDependencyUrl(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        if (this.publishPackage) {
            String string5 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSet.name");
            String string6 = runtimeOnlyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"runtimeOnlyName");
            string = this.getDeprecatedConfigDesc("Publish", string5, string6);
        } else {
            String string7 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"sourceSet.name");
            String string8 = runtimeOnlyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"runtimeOnlyName");
            string = this.getDeprecatedConfigDesc("Apk", string7, string8);
        }
        String packageConfigDescription = string;
        String string9 = apkName = sourceSet.getPackageConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"apkName");
        Configuration apk = SourceSetManager.createConfiguration$default(this, string9, packageConfigDescription, false, 4, null);
        apk.getAllDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(runtimeOnlyName, apkName, this.dslScope.getDeprecationReporter(), SourceSetManagerKt.getDependencyUrl(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String string10 = providedName = sourceSet.getProvidedConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"providedName");
        String string11 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"sourceSet.name");
        String string12 = compileOnlyName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"compileOnlyName");
        Configuration provided = SourceSetManager.createConfiguration$default(this, string10, this.getDeprecatedConfigDesc("Provided", string11, string12), false, 4, null);
        provided.getAllDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(compileOnlyName, providedName, this.dslScope.getDeprecationReporter(), SourceSetManagerKt.getDependencyUrl(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String string13 = apiName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"apiName");
        String string14 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"sourceSet.name");
        Configuration api = SourceSetManager.createConfiguration$default(this, string13, this.getConfigDesc("API", string14), false, 4, null);
        api.extendsFrom(new Configuration[]{compile2});
        if (isTestComponent) {
            api.getAllDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(implementationName, apiName, this.dslScope.getDeprecationReporter(), SourceSetManagerKt.getDependencyUrl(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        }
        String string15 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"sourceSet.name");
        Configuration implementation = SourceSetManager.createConfiguration$default(this, implementationName, this.getConfigDesc("Implementation only", string15), false, 4, null);
        implementation.extendsFrom(new Configuration[]{api});
        String string16 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"sourceSet.name");
        Configuration runtimeOnly = SourceSetManager.createConfiguration$default(this, runtimeOnlyName, this.getConfigDesc("Runtime only", string16), false, 4, null);
        runtimeOnly.extendsFrom(new Configuration[]{apk});
        String string17 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"sourceSet.name");
        Configuration compileOnly = SourceSetManager.createConfiguration$default(this, compileOnlyName, this.getConfigDesc("Compile only", string17), false, 4, null);
        compileOnly.extendsFrom(new Configuration[]{provided});
        String string18 = sourceSet.getWearAppConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"sourceSet.wearAppConfigurationName");
        Configuration wearConfig = SourceSetManager.createConfiguration$default(this, string18, "Link to a wear app to embed for object '" + sourceSet.getName() + "'.", false, 4, null);
        String string19 = sourceSet.getAnnotationProcessorConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"sourceSet.annotationProcessorConfigurationName");
        SourceSetManager.createConfiguration$default(this, string19, "Classpath for the annotation processor for '" + sourceSet.getName() + "'.", false, 4, null);
    }

    private final Configuration createConfiguration(String name, String description, boolean canBeResolved) {
        Configuration configuration;
        this.logger.info("Creating configuration {}", (Object)name);
        Configuration configuration2 = configuration = (Configuration)this.configurations.maybeCreate(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
        configuration2.setVisible(false);
        configuration.setDescription(description);
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(canBeResolved);
        return configuration;
    }

    static /* bridge */ /* synthetic */ Configuration createConfiguration$default(SourceSetManager sourceSetManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sourceSetManager.createConfiguration(string, string2, bl);
    }

    private final String getConfigDesc(String name, String sourceSetName) {
        return "" + name + " dependencies for '" + sourceSetName + "' sources.";
    }

    private final String getDeprecatedConfigDesc(String name, String sourceSetName, String replacement) {
        return "" + name + " dependencies for '" + sourceSetName + "' sources " + "(deprecated: use '" + replacement + "' instead).";
    }

    public final void checkForUnconfiguredSourceSets() {
        Iterable $receiver$iv = (Iterable)this.sourceSetsContainer;
        for (Object element$iv : $receiver$iv) {
            AndroidSourceSet sourceSet;
            AndroidSourceSet androidSourceSet = sourceSet = (AndroidSourceSet)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            if (this.configuredSourceSets.contains(androidSourceSet.getName())) continue;
            String message = "The SourceSet '" + sourceSet.getName() + "' is not recognized " + "by the Android Gradle Plugin. Perhaps you misspelled something?";
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(message, null, null, 6, null));
        }
    }

    public final void executeAction(@NotNull Action<NamedDomainObjectContainer<AndroidSourceSet>> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        action.execute(this.sourceSetsContainer);
    }

    public final void runBuildableArtifactsActions() {
        this.buildArtifactActions.runAll();
    }

    public SourceSetManager(@NotNull Project project, boolean publishPackage, @NotNull DslScope dslScope, @NotNull DelayedActionsExecutor buildArtifactActions) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        Intrinsics.checkParameterIsNotNull((Object)buildArtifactActions, (String)"buildArtifactActions");
        this.publishPackage = publishPackage;
        this.dslScope = dslScope;
        this.buildArtifactActions = buildArtifactActions;
        NamedDomainObjectContainer namedDomainObjectContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(project, this.publishPackage, this.dslScope, this.buildArtifactActions));
        Intrinsics.checkExpressionValueIsNotNull((Object)namedDomainObjectContainer, (String)"project.container(\n     \u2026e, buildArtifactActions))");
        this.sourceSetsContainer = namedDomainObjectContainer;
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
        this.configurations = configurationContainer;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(this.javaClass)");
        this.logger = logger;
        SourceSetManager sourceSetManager = this;
        sourceSetManager.configuredSourceSets = set = (Set)new LinkedHashSet();
    }
}

