/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.CapturingChangesApkCreator;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/incremental/ApkChangeList;", "", "changes", "", "", "deletions", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "getChanges", "()Ljava/lang/Iterable;", "getDeletions", "Companion", "gradle"})
public final class ApkChangeList {
    @NotNull
    private final Iterable<String> changes;
    @NotNull
    private final Iterable<String> deletions;
    @NotNull
    public static final String CHANGE_LIST_FN = "__adt_change_list__.json";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Iterable<String> getChanges() {
        return this.changes;
    }

    @NotNull
    public final Iterable<String> getDeletions() {
        return this.deletions;
    }

    public ApkChangeList(@NotNull Iterable<String> changes, @NotNull Iterable<String> deletions) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull(deletions, (String)"deletions");
        this.changes = changes;
        this.deletions = deletions;
    }

    @JvmStatic
    @NotNull
    public static final String changeListFileName(@NotNull File apkFile) {
        return Companion.changeListFileName(apkFile);
    }

    @JvmStatic
    public static final void write(@NotNull CapturingChangesApkCreator source, @NotNull Writer writer) {
        Companion.write(source, writer);
    }

    @JvmStatic
    @NotNull
    public static final ApkChangeList read(@NotNull Reader reader) {
        return Companion.read(reader);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/incremental/ApkChangeList$Companion;", "", "()V", "CHANGE_LIST_FN", "", "changeListFileName", "apkFile", "Ljava/io/File;", "read", "Lcom/android/build/gradle/internal/incremental/ApkChangeList;", "reader", "Ljava/io/Reader;", "write", "", "source", "Lcom/android/build/gradle/internal/incremental/CapturingChangesApkCreator;", "writer", "Ljava/io/Writer;", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String changeListFileName(@NotNull File apkFile) {
            Intrinsics.checkParameterIsNotNull((Object)apkFile, (String)"apkFile");
            return FilesKt.getNameWithoutExtension((File)apkFile) + ApkChangeList.CHANGE_LIST_FN;
        }

        @JvmStatic
        public final void write(@NotNull CapturingChangesApkCreator source, @NotNull Writer writer) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            JsonWriter jsonWriter = new JsonWriter(writer);
            jsonWriter.beginObject();
            if (source.getChangedItems().size() > 0) {
                jsonWriter.name("changed").value(Joiner.on((String)",").join((Iterable)source.getChangedItems()));
            }
            if (source.getDeletedItems().size() > 0) {
                jsonWriter.name("deleted").value(Joiner.on((String)",").join((Iterable)source.getDeletedItems()));
            }
            jsonWriter.endObject();
        }

        @JvmStatic
        @NotNull
        public final ApkChangeList read(@NotNull Reader reader) {
            JsonElement element;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = element = jsonParser.parse(reader);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"element");
            JsonElement changed = jsonElement.getAsJsonObject().get("changed");
            Iterable changedItems = changed != null ? Splitter.on((String)",").split((CharSequence)changed.getAsString()) : (Iterable)CollectionsKt.emptyList();
            JsonElement deleted = element.getAsJsonObject().get("deleted");
            Iterable deletedItems = deleted != null ? Splitter.on((String)",").split((CharSequence)deleted.getAsString()) : (Iterable)CollectionsKt.emptyList();
            Iterable iterable = changedItems;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"changedItems");
            Iterable iterable2 = deletedItems;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"deletedItems");
            return new ApkChangeList(iterable, iterable2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

