/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a0\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\bH\u0001\u00a8\u0006\u0015"}, d2={"findPackage", "", "type", "name", "logger", "Lorg/gradle/api/logging/Logger;", "symbolTables", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/ide/common/symbols/SymbolTable;", "generatePublicFile", "", "symbols", "outputDirectory", "Ljava/nio/file/Path;", "getResourceType", "Lcom/android/resources/ResourceType;", "typeString", "maybeFindPackage", "writePublicFile", "writer", "Ljava/io/Writer;", "gradle"})
public final class NamespaceRewriterKt {
    private static final String findPackage(String type, String name, Logger logger, ImmutableList<SymbolTable> symbolTables) {
        String result;
        String string = result = NamespaceRewriterKt.maybeFindPackage(type, name, logger, symbolTables);
        if (string == null) {
            String string2 = "In package " + ((SymbolTable)symbolTables.get(0)).getTablePackage() + " found unknown symbol of type " + "" + type + " and name " + name + '.';
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private static final String maybeFindPackage(String type, String name, Logger logger, ImmutableList<SymbolTable> symbolTables) {
        String canonicalName = SymbolUtils.canonicalizeValueResourceName((String)name);
        ArrayList<String> packages = null;
        String result = null;
        for (SymbolTable table : symbolTables) {
            if (!table.containsSymbol(NamespaceRewriterKt.getResourceType(type), canonicalName)) continue;
            if (result == null) {
                result = table.getTablePackage();
                continue;
            }
            if (packages == null) {
                packages = new ArrayList<String>();
            }
            packages.add(table.getTablePackage());
        }
        if (packages != null && !packages.isEmpty()) {
            logger.warn("In package " + ((SymbolTable)symbolTables.get(0)).getTablePackage() + " multiple options found " + "in its dependencies for resource " + type + ' ' + name + ". " + "Using " + result + ", other available: " + Joiner.on((String)", ").join((Iterable)packages));
        }
        return result;
    }

    private static final ResourceType getResourceType(String typeString) {
        ResourceType resourceType = ResourceType.fromClassName((String)typeString);
        if (resourceType == null) {
            String string = "Unknown type '" + typeString + '\'';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void generatePublicFile(@NotNull SymbolTable symbols, @NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Path values = outputDirectory.resolve("values");
        Files.createDirectories(values, new FileAttribute[0]);
        Path publicFile = values.resolve("auto-namespace-public.xml");
        if (Files.exists(publicFile, new LinkOption[0])) {
            String string = "Internal error: Auto namespaced public file already exists";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Closeable closeable = Files.newBufferedWriter(publicFile, new OpenOption[0]);
        Throwable throwable = null;
        try {
            BufferedWriter it;
            BufferedWriter bufferedWriter = it = (BufferedWriter)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
            NamespaceRewriterKt.writePublicFile(bufferedWriter, symbols);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void writePublicFile(@NotNull Writer writer, @NotNull SymbolTable symbols) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.write("\n<resources>\n\n");
        Iterable $receiver$iv = symbols.getResourceTypes();
        for (Object element$iv : $receiver$iv) {
            ResourceType resourceType = (ResourceType)element$iv;
            Iterable $receiver$iv2 = symbols.getSymbolByResourceType(resourceType);
            for (Object element$iv2 : $receiver$iv2) {
                Symbol symbol = (Symbol)element$iv2;
                writer.write("    <public name=\"");
                writer.write(symbol.getName());
                writer.write("\" type=\"");
                writer.write(resourceType.getName());
                writer.write("\" />\n");
            }
        }
        writer.write("\n</resources>\n");
    }

    @NotNull
    public static final /* synthetic */ String access$findPackage(@NotNull String type, @NotNull String name, @NotNull Logger logger, @NotNull ImmutableList symbolTables) {
        return NamespaceRewriterKt.findPackage(type, name, logger, (ImmutableList<SymbolTable>)symbolTables);
    }

    @Nullable
    public static final /* synthetic */ String access$maybeFindPackage(@NotNull String type, @NotNull String name, @NotNull Logger logger, @NotNull ImmutableList symbolTables) {
        return NamespaceRewriterKt.maybeFindPackage(type, name, logger, (ImmutableList<SymbolTable>)symbolTables);
    }
}

