/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.crash.PluginCrashReporter;
import com.android.build.gradle.internal.tasks.DexMergingTaskKt;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate;", "", "dexingType", "Lcom/android/builder/dexing/DexingType;", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "dexMerger", "Lcom/android/builder/dexing/DexMergerTool;", "minSdkVersion", "", "isDebuggable", "", "mergingThreshold", "mainDexListFile", "Lcom/android/build/api/artifact/BuildableArtifact;", "dexFiles", "Lorg/gradle/api/file/FileCollection;", "outputDir", "Ljava/io/File;", "(Lcom/android/builder/dexing/DexingType;Lcom/android/ide/common/blame/MessageReceiver;Lcom/android/builder/dexing/DexMergerTool;IZILcom/android/build/api/artifact/BuildableArtifact;Lorg/gradle/api/file/FileCollection;Ljava/io/File;)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "run", "", "submitForMerging", "Ljava/util/concurrent/ForkJoinTask;", "Ljava/lang/Void;", "processOutput", "Lcom/android/ide/common/process/ProcessOutput;", "gradle"})
public final class DexMergingTaskDelegate {
    private final ForkJoinPool forkJoinPool;
    private final DexingType dexingType;
    private final MessageReceiver messageReceiver;
    private final DexMergerTool dexMerger;
    private final int minSdkVersion;
    private final boolean isDebuggable;
    private final int mergingThreshold;
    private final BuildableArtifact mainDexListFile;
    private final FileCollection dexFiles;
    private final File outputDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        LoggerWrapper logger = LoggerWrapper.getLogger(DexMergingTaskDelegate.class);
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.messageReceiver});
        ProcessOutput processOutput = null;
        try {
            processOutput = outputHandler.createOutput();
            FileUtils.cleanOutputDir((File)this.outputDir);
            if (this.dexFiles.isEmpty()) {
                return;
            }
            if (this.dexFiles.getFiles().size() >= this.mergingThreshold) {
                ProcessOutput processOutput2 = processOutput;
                Intrinsics.checkExpressionValueIsNotNull((Object)processOutput2, (String)"processOutput");
                this.submitForMerging(processOutput2).join();
            } else {
                for (ProcessOutput file : CollectionsKt.withIndex((Iterable)CollectionsKt.sorted((Iterable)DexMergingTaskKt.access$getAllRegularFiles(this.dexFiles)))) {
                    FilesKt.copyTo$default((File)((File)file.getValue()), (File)FilesKt.resolve((File)this.outputDir, (String)("classes_" + file.getIndex() + ".dex")), (boolean)false, (int)0, (int)6, null);
                }
            }
        }
        catch (Exception e) {
            PluginCrashReporter.maybeReportException(e);
            logger.error(null, Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            throw (Throwable)new TransformException((Throwable)e);
        }
        finally {
            ProcessOutput processOutput3 = processOutput;
            if (processOutput3 != null) {
                ProcessOutput processOutput4;
                ProcessOutput it = processOutput4 = processOutput3;
                try {
                    outputHandler.handleOutput(it);
                    processOutput.close();
                }
                catch (ProcessException processException) {
                }
            }
            this.forkJoinPool.shutdown();
            this.forkJoinPool.awaitTermination(100L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ForkJoinTask<Void> submitForMerging(ProcessOutput processOutput) {
        Collection<Path> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        DexMergerTransformCallable dexMergerTransformCallable;
        Set set = this.dexFiles.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"dexFiles.files");
        Iterable iterable = set;
        File file = this.outputDir;
        ProcessOutput processOutput2 = processOutput;
        DexingType dexingType = this.dexingType;
        MessageReceiver messageReceiver = this.messageReceiver;
        DexMergerTransformCallable dexMergerTransformCallable2 = dexMergerTransformCallable;
        DexMergerTransformCallable dexMergerTransformCallable3 = dexMergerTransformCallable;
        void var4_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            Path path = it.toPath();
            collection.add(path);
        }
        collection = (List)destination$iv$iv;
        BuildableArtifact buildableArtifact = this.mainDexListFile;
        dexMergerTransformCallable2(messageReceiver, dexingType, processOutput2, file, collection.iterator(), buildableArtifact != null ? BuildableArtifactUtil.singlePath(buildableArtifact) : null, this.forkJoinPool, this.dexMerger, this.minSdkVersion, this.isDebuggable);
        DexMergerTransformCallable callable = dexMergerTransformCallable3;
        Future future = this.forkJoinPool.submit((Callable)callable);
        Intrinsics.checkExpressionValueIsNotNull((Object)future, (String)"forkJoinPool.submit(callable)");
        return future;
    }

    public DexMergingTaskDelegate(@NotNull DexingType dexingType, @NotNull MessageReceiver messageReceiver, @NotNull DexMergerTool dexMerger, int minSdkVersion, boolean isDebuggable, int mergingThreshold, @Nullable BuildableArtifact mainDexListFile, @NotNull FileCollection dexFiles, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)dexingType, (String)"dexingType");
        Intrinsics.checkParameterIsNotNull((Object)messageReceiver, (String)"messageReceiver");
        Intrinsics.checkParameterIsNotNull((Object)dexMerger, (String)"dexMerger");
        Intrinsics.checkParameterIsNotNull((Object)dexFiles, (String)"dexFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        this.dexingType = dexingType;
        this.messageReceiver = messageReceiver;
        this.dexMerger = dexMerger;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable;
        this.mergingThreshold = mergingThreshold;
        this.mainDexListFile = mainDexListFile;
        this.dexFiles = dexFiles;
        this.outputDir = outputDir;
        this.forkJoinPool = new ForkJoinPool();
    }
}

