/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.EagerTaskCreationAction;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class PackageForUnitTest
extends DefaultTask {
    BuildableArtifact resApk;
    BuildableArtifact mergedAssets;
    File apkForUnitTest;

    @TaskAction
    public void generateApkForUnitTest() throws IOException {
        FileUtils.copyFile((File)PackageForUnitTest.apkFrom(this.resApk), (File)this.apkForUnitTest);
        URI uri = URI.create("jar:" + this.apkForUnitTest.toURI());
        try (FileSystem apkFs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            final Path apkAssetsPath = apkFs.getPath("/assets", new String[0]);
            for (File mergedAssetsDir : this.mergedAssets.getFiles()) {
                final Path mergedAssetsPath = mergedAssetsDir.toPath();
                Files.walkFileTree(mergedAssetsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        String relativePath = PathUtils.toSystemIndependentPath((Path)mergedAssetsPath.relativize(path));
                        Path destPath = apkAssetsPath.resolve(relativePath);
                        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                        Files.copy(path, destPath, new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    @InputFiles
    public BuildableArtifact getResApk() {
        return this.resApk;
    }

    @InputFiles
    public BuildableArtifact getMergedAssets() {
        return this.mergedAssets;
    }

    @OutputFile
    public File getApkForUnitTest() {
        return this.apkForUnitTest;
    }

    private static File apkFrom(BuildableArtifact compiledResourcesZip) {
        return ((BuildOutput)Iterables.getOnlyElement((Iterable)ExistingBuildElements.from((ArtifactType)InternalArtifactType.PROCESSED_RES, compiledResourcesZip))).getOutputFile();
    }

    public static class CreationAction
    extends EagerTaskCreationAction<PackageForUnitTest> {
        private final VariantScope scope;

        public CreationAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "ForUnitTest");
        }

        @Override
        public Class<PackageForUnitTest> getType() {
            return PackageForUnitTest.class;
        }

        @Override
        public void execute(PackageForUnitTest task) {
            task.resApk = this.scope.getArtifacts().getArtifactFiles(InternalArtifactType.PROCESSED_RES);
            task.mergedAssets = this.scope.getArtifacts().getArtifactFiles(InternalArtifactType.MERGED_ASSETS);
            task.apkForUnitTest = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK_FOR_LOCAL_TEST, (Task)task, "apk-for-local-test.ap_");
        }
    }
}

