/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.incremental.DependencyData;
import com.android.builder.internal.incremental.DependencyDataStore;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.resources.FileStatus;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public class AidlCompile
extends IncrementalTask {
    private static final String DEPENDENCY_STORE = "dependency.store";
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.aidl"});
    private File sourceOutputDir;
    private File packagedDir;
    private Collection<String> packageWhitelist;
    private Supplier<Collection<File>> sourceDirs;
    private FileCollection importDirs;

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSourceFiles() {
        return this.getProject().files(new Object[]{this.sourceDirs.get()}).getAsFileTree().matching((PatternFilterable)PATTERN_SET);
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return false;
    }

    private void compileAllFiles(DependencyFileProcessor dependencyFileProcessor) throws InterruptedException, ProcessException, IOException {
        this.getBuilder().compileAllAidlFiles(this.sourceDirs.get(), this.getSourceOutputDir(), this.getPackagedDir(), this.getPackageWhitelist(), (Collection)this.getImportDirs().getFiles(), dependencyFileProcessor, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
    }

    @Internal
    private Iterable<File> getImportFolders() {
        return Iterables.concat((Iterable)this.getImportDirs().getFiles(), (Iterable)this.sourceDirs.get());
    }

    private void compileSingleFile(File sourceFolder, File file, Iterable<File> importFolders, DependencyFileProcessor dependencyFileProcessor, ProcessOutputHandler processOutputHandler) throws InterruptedException, ProcessException, IOException {
        this.getBuilder().compileAidlFile(sourceFolder, file, this.getSourceOutputDir(), this.getPackagedDir(), this.getPackageWhitelist(), (Iterable)Preconditions.checkNotNull(importFolders), dependencyFileProcessor, processOutputHandler);
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        File destinationDir = this.getSourceOutputDir();
        File parcelableDir = this.getPackagedDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        if (parcelableDir != null) {
            FileUtils.cleanOutputDir((File)parcelableDir);
        }
        DepFileProcessor processor = new DepFileProcessor();
        try {
            this.compileAllFiles(processor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<DependencyData> dataList = processor.getDependencyDataList();
        DependencyDataStore store = new DependencyDataStore();
        store.addData(dataList);
        try {
            store.saveTo(new File(this.getIncrementalFolder(), DEPENDENCY_STORE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        Multimap inputMap;
        File incrementalData = new File(this.getIncrementalFolder(), DEPENDENCY_STORE);
        DependencyDataStore store = new DependencyDataStore();
        try {
            inputMap = store.loadFrom(incrementalData);
        }
        catch (Exception ignored) {
            FileUtils.delete((File)incrementalData);
            this.getProject().getLogger().info("Failed to read dependency store: full task run!");
            this.doFullTaskAction();
            return;
        }
        Iterable<File> importFolders = this.getImportFolders();
        DepFileProcessor processor = new DepFileProcessor();
        LoggedProcessOutputHandler processOutputHandler = new LoggedProcessOutputHandler(this.getILogger());
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        Map mainFileMap = store.getMainFileMap();
        block11: for (Map.Entry<File, FileStatus> entry : changedInputs.entrySet()) {
            FileStatus status = entry.getValue();
            switch (status) {
                case NEW: {
                    executor.execute(() -> this.lambda$doIncrementalTaskAction$0(entry, importFolders, processor, (ProcessOutputHandler)processOutputHandler));
                    break;
                }
                case CHANGED: {
                    Collection impactedData = inputMap.get((Object)entry.getKey().getAbsolutePath());
                    if (impactedData == null) break;
                    for (DependencyData data : impactedData) {
                        executor.execute(() -> this.lambda$doIncrementalTaskAction$1(data, importFolders, processor, (ProcessOutputHandler)processOutputHandler));
                    }
                    continue block11;
                }
                case REMOVED: {
                    DependencyData data2 = (DependencyData)mainFileMap.get(entry.getKey().getAbsolutePath());
                    if (data2 == null) break;
                    executor.execute(() -> {
                        AidlCompile.cleanUpOutputFrom(data2);
                        return null;
                    });
                    store.remove(data2);
                }
            }
        }
        try {
            executor.waitForTasksWithQuickFail(true);
        }
        catch (Throwable t) {
            FileUtils.delete((File)incrementalData);
            throw new RuntimeException(t);
        }
        store.updateAll(processor.getDependencyDataList());
        try {
            store.saveTo(incrementalData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getSourceFolder(File file) {
        File parentDir = file;
        while ((parentDir = parentDir.getParentFile()) != null) {
            if (!this.sourceDirs.get().contains(parentDir)) continue;
            return parentDir;
        }
        throw new IllegalArgumentException(String.format("File '%s' is not in a source dir", file));
    }

    private static void cleanUpOutputFrom(DependencyData dependencyData) throws IOException {
        for (String output2 : dependencyData.getOutputFiles()) {
            FileUtils.delete((File)new File(output2));
        }
        for (String output2 : dependencyData.getSecondaryOutputFiles()) {
            FileUtils.delete((File)new File(output2));
        }
    }

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    @Optional
    public File getPackagedDir() {
        return this.packagedDir;
    }

    public void setPackagedDir(File packagedDir) {
        this.packagedDir = packagedDir;
    }

    @Input
    @Optional
    public Collection<String> getPackageWhitelist() {
        return this.packageWhitelist;
    }

    public void setPackageWhitelist(Collection<String> packageWhitelist) {
        this.packageWhitelist = packageWhitelist;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getImportDirs() {
        return this.importDirs;
    }

    private /* synthetic */ Object lambda$doIncrementalTaskAction$1(DependencyData data, Iterable importFolders, DepFileProcessor processor, ProcessOutputHandler processOutputHandler) throws Exception {
        File file = new File(data.getMainFile());
        this.compileSingleFile(this.getSourceFolder(file), file, importFolders, processor, processOutputHandler);
        return null;
    }

    private /* synthetic */ Object lambda$doIncrementalTaskAction$0(Map.Entry entry, Iterable importFolders, DepFileProcessor processor, ProcessOutputHandler processOutputHandler) throws Exception {
        File file = (File)entry.getKey();
        this.compileSingleFile(this.getSourceFolder(file), file, importFolders, processor, processOutputHandler);
        return null;
    }

    public static class CreationAction
    extends LazyTaskCreationAction<AidlCompile> {
        VariantScope scope;
        private File sourceOutputDir;
        private File packagedDir;

        public CreationAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("compile", "Aidl");
        }

        @Override
        public Class<AidlCompile> getType() {
            return AidlCompile.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            super.preConfigure(taskName);
            this.sourceOutputDir = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR, taskName, "out");
            if (this.scope.getVariantConfiguration().getType().isAar()) {
                this.packagedDir = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.AIDL_PARCELABLE, taskName, "out");
            }
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends AidlCompile> taskProvider) {
            super.handleProvider(taskProvider);
            this.scope.getTaskContainer().setAidlCompileTask(taskProvider);
        }

        @Override
        public void configure(AidlCompile compileTask) {
            GradleVariantConfiguration variantConfiguration = this.scope.getVariantConfiguration();
            compileTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            compileTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            compileTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            compileTask.sourceDirs = variantConfiguration::getAidlSourceList;
            compileTask.importDirs = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.AIDL);
            compileTask.setSourceOutputDir(this.sourceOutputDir);
            if (variantConfiguration.getType().isAar()) {
                compileTask.setPackagedDir(this.packagedDir);
                compileTask.setPackageWhitelist(this.scope.getGlobalScope().getExtension().getAidlPackageWhiteList());
            }
            compileTask.dependsOn(new Object[]{this.scope.getTaskContainer().getPreBuildTask()});
        }
    }

    private static class DepFileProcessor
    implements DependencyFileProcessor {
        List<DependencyData> dependencyDataList = Collections.synchronizedList(Lists.newArrayList());

        private DepFileProcessor() {
        }

        List<DependencyData> getDependencyDataList() {
            return this.dependencyDataList;
        }

        public DependencyData processFile(File dependencyFile) throws IOException {
            DependencyData data = DependencyData.parseDependencyFile((File)dependencyFile);
            if (data != null) {
                this.dependencyDataList.add(data);
            }
            return data;
        }
    }
}

