/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.tasks.AnnotationProcessingTaskCreationAction;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.manifmerger.ManifestProvider;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class ProcessTestManifest
extends ManifestProcessorTask {
    private BuildableArtifact testTargetMetadata;
    private File testManifestFile;
    private boolean onlyTestApk;
    private File tmpDir;
    private Supplier<String> testApplicationId;
    private Supplier<String> testedApplicationId;
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<String> instrumentationRunner;
    private Supplier<Boolean> handleProfiling;
    private Supplier<Boolean> functionalTest;
    private Supplier<Map<String, Object>> placeholdersValues;
    private ArtifactCollection manifests;
    private Supplier<String> testLabel;
    private OutputScope outputScope;

    public OutputScope getOutputScope() {
        return this.outputScope;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        List<ApkData> apkDatas;
        if (this.testedApplicationId == null && this.testTargetMetadata == null) {
            throw new RuntimeException("testedApplicationId and testTargetMetadata are null");
        }
        String testedApplicationId = this.getTestedApplicationId();
        if (!this.onlyTestApk && this.testTargetMetadata != null) {
            BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.testTargetMetadata);
            java.util.Optional<BuildOutput> mainSplit = manifestOutputs.stream().filter(output2 -> output2.getApkInfo().getType() != VariantOutput.OutputType.SPLIT).findFirst();
            if (mainSplit.isPresent()) {
                testedApplicationId = mainSplit.get().getProperties().get("packageId");
            } else {
                throw new RuntimeException("cannot find main APK");
            }
        }
        if ((apkDatas = this.outputScope.getApkDatas()).isEmpty()) {
            throw new RuntimeException("No output defined for test module, please file a bug");
        }
        if (apkDatas.size() > 1) {
            throw new RuntimeException("Test modules only support a single split, this one defines" + Joiner.on((String)",").join(apkDatas));
        }
        ApkData mainApkData = apkDatas.get(0);
        File manifestOutputFolder = Strings.isNullOrEmpty((String)mainApkData.getDirName()) ? ((Directory)this.getManifestOutputDirectory().get()).getAsFile() : ((Directory)this.getManifestOutputDirectory().get()).file(mainApkData.getDirName()).getAsFile();
        FileUtils.mkdirs((File)manifestOutputFolder);
        File manifestOutputFile = new File(manifestOutputFolder, "AndroidManifest.xml");
        this.getBuilder().mergeManifestsForTestVariant(this.getTestApplicationId(), this.getMinSdkVersion(), this.getTargetSdkVersion(), testedApplicationId, this.getInstrumentationRunner(), this.getHandleProfiling(), this.getFunctionalTest(), this.getTestLabel(), this.getTestManifestFile(), this.computeProviders(), this.getPlaceholdersValues(), manifestOutputFile, this.getTmpDir());
        new BuildElements((Collection<BuildOutput>)ImmutableList.of((Object)new BuildOutput(InternalArtifactType.MERGED_MANIFESTS, (ApkInfo)mainApkData, manifestOutputFile))).save(((Directory)this.getManifestOutputDirectory().get()).getAsFile());
    }

    @Override
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @InputFile
    @Optional
    public File getTestManifestFile() {
        return this.testManifestFile;
    }

    public void setTestManifestFile(File testManifestFile) {
        this.testManifestFile = testManifestFile;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Input
    public String getTestApplicationId() {
        return this.testApplicationId.get();
    }

    @Input
    @Optional
    public String getTestedApplicationId() {
        return this.testedApplicationId.get();
    }

    @Input
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    public String getInstrumentationRunner() {
        return this.instrumentationRunner.get();
    }

    @Input
    public Boolean getHandleProfiling() {
        return this.handleProfiling.get();
    }

    @Input
    public Boolean getFunctionalTest() {
        return this.functionalTest.get();
    }

    @Input
    @Optional
    public String getTestLabel() {
        return this.testLabel.get();
    }

    @Input
    public Map<String, Object> getPlaceholdersValues() {
        return this.placeholdersValues.get();
    }

    @InputFiles
    @Optional
    public BuildableArtifact getTestTargetMetadata() {
        return this.testTargetMetadata;
    }

    public List<ManifestProvider> computeProviders() {
        Set artifacts = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)artifacts.size());
        for (ResolvedArtifactResult artifact : artifacts) {
            providers.add(new ProcessApplicationManifest.CreationAction.ManifestProviderImpl(artifact.getFile(), ProcessApplicationManifest.getArtifactName(artifact)));
        }
        return providers;
    }

    @InputFiles
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    public static class CreationAction
    extends AnnotationProcessingTaskCreationAction<ProcessTestManifest> {
        private final VariantScope scope;
        private final BuildableArtifact testTargetMetadata;

        public CreationAction(VariantScope scope, BuildableArtifact testTargetMetadata) {
            super(scope, scope.getTaskName("process", "Manifest"), ProcessTestManifest.class);
            this.scope = scope;
            this.testTargetMetadata = testTargetMetadata;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            super.preConfigure(taskName);
            this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MANIFEST_METADATA, this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS));
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends ProcessTestManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.scope.getTaskContainer().setProcessManifestTask(taskProvider);
        }

        @Override
        public void configure(ProcessTestManifest task) {
            super.configure(task);
            GradleVariantConfiguration config2 = this.scope.getVariantConfiguration();
            task.setTestManifestFile(config2.getMainManifest());
            task.outputScope = this.scope.getOutputScope();
            task.setTmpDir(FileUtils.join((File)this.scope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"tmp", "manifest", this.scope.getDirName()}));
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setVariantName(config2.getFullName());
            task.minSdkVersion = TaskInputHelper.memoize(() -> config2.getMinSdkVersion().getApiString());
            task.targetSdkVersion = TaskInputHelper.memoize(() -> config2.getTargetSdkVersion().getApiString());
            task.testTargetMetadata = this.testTargetMetadata;
            task.testApplicationId = TaskInputHelper.memoize(config2::getTestApplicationId);
            task.testedApplicationId = TaskInputHelper.memoize(config2::getTestedApplicationId);
            VariantConfiguration testedConfig = config2.getTestedConfig();
            task.onlyTestApk = testedConfig != null && testedConfig.getType().isAar();
            task.instrumentationRunner = TaskInputHelper.memoize(config2::getInstrumentationRunner);
            task.handleProfiling = TaskInputHelper.memoize(config2::getHandleProfiling);
            task.functionalTest = TaskInputHelper.memoize(config2::getFunctionalTest);
            task.testLabel = TaskInputHelper.memoize(config2::getTestLabel);
            task.manifests = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            task.placeholdersValues = TaskInputHelper.memoize(config2::getManifestPlaceholders);
            if (this.scope.getTaskContainer().getCheckManifestTask() != null) {
                task.dependsOn(new Object[]{this.scope.getTaskContainer().getCheckManifestTask()});
            }
        }
    }
}

