/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;

public class JavaCompileCreationAction
extends LazyTaskCreationAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(JavaCompileCreationAction.class);
    private final VariantScope scope;
    private File destinationDir;

    public JavaCompileCreationAction(VariantScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void preConfigure(@NotNull String taskName) {
        super.preConfigure(taskName);
        BuildArtifactsHolder artifacts = this.scope.getArtifacts();
        this.destinationDir = artifacts.appendArtifact((ArtifactType)InternalArtifactType.JAVAC, taskName, "classes");
        if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled()) {
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.DATA_BINDING_ARTIFACT, (Collection<? extends Object>)ImmutableList.of((Object)this.scope.getBundleArtifactFolderForDataBinding()), taskName);
        }
    }

    @Override
    public void handleProvider(@NotNull TaskProvider<? extends AndroidJavaCompile> taskProvider) {
        super.handleProvider(taskProvider);
        this.scope.getTaskContainer().setJavacTask(taskProvider);
    }

    @Override
    public void configure(AndroidJavaCompile javacTask) {
        GlobalScope globalScope = this.scope.getGlobalScope();
        Project project = globalScope.getProject();
        BuildArtifactsHolder artifacts = this.scope.getArtifacts();
        javacTask.compileSdkVersion = globalScope.getExtension().getCompileSdkVersion();
        javacTask.mInstantRunBuildContext = this.scope.getInstantRunBuildContext();
        for (ConfigurableFileTree fileTree : this.scope.getVariantData().getJavaSources()) {
            javacTask.source(new Object[]{fileTree});
        }
        javacTask.getOptions().setBootstrapClasspath(this.scope.getBootClasspath());
        javacTask.setClasspath(this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES));
        javacTask.setDestinationDir(this.destinationDir);
        CompileOptions compileOptions = globalScope.getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, globalScope.getExtension().getCompileSdkVersion(), this.scope.getJava8LangSupportType());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        Boolean includeCompileClasspath = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions().getIncludeCompileClasspath();
        FileCollection processorPath = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR);
        if (Boolean.TRUE.equals(includeCompileClasspath)) {
            processorPath = processorPath.plus(this.scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.PROCESSED_JAR));
        }
        javacTask.getOptions().setAnnotationProcessorPath(processorPath);
        boolean incremental = AbstractCompilesUtil.isIncremental(project, this.scope, compileOptions, null, LOG);
        if (incremental) {
            LOG.verbose("Using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
            javacTask.getOptions().setIncremental(true);
        } else {
            LOG.verbose("Not using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
        }
        AnnotationProcessorOptions annotationProcessorOptions = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        if (!annotationProcessorOptions.getClassNames().isEmpty()) {
            javacTask.getOptions().getCompilerArgs().add("-processor");
            javacTask.getOptions().getCompilerArgs().add(Joiner.on((char)',').join(annotationProcessorOptions.getClassNames()));
        }
        if (!annotationProcessorOptions.getArguments().isEmpty()) {
            for (Map.Entry<String, String> arg : annotationProcessorOptions.getArguments().entrySet()) {
                javacTask.getOptions().getCompilerArgs().add("-A" + arg.getKey() + "=" + arg.getValue());
            }
        }
        javacTask.getOptions().getCompilerArgumentProviders().addAll(annotationProcessorOptions.getCompilerArgumentProviders());
        javacTask.getOptions().setAnnotationProcessorGeneratedSourcesDirectory(this.scope.getAnnotationProcessorOutputDir());
        javacTask.annotationProcessorOutputFolder = this.scope.getAnnotationProcessorOutputDir();
        javacTask.processorListFile = artifacts.getFinalArtifactFiles(InternalArtifactType.ANNOTATION_PROCESSOR_LIST);
        javacTask.variantName = this.scope.getFullVariantName();
        javacTask.dependsOn(new Object[]{this.scope.getTaskContainer().getSourceGenTask()});
    }
}

