/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;

/**
 * Class containing a BuildType and associated data (Sourceset for instance).
 */
public class BuildTypeData extends VariantDimensionData {
    @NonNull private final CoreBuildType buildType;
    @Nullable private TaskProvider<Task> assembleTask;
    @Nullable private TaskProvider<Task> bundleTask;

    BuildTypeData(
            @NonNull CoreBuildType buildType,
            @NonNull DefaultAndroidSourceSet sourceSet,
            @Nullable DefaultAndroidSourceSet androidTestSourceSet,
            @Nullable DefaultAndroidSourceSet unitTestSourceSet) {
        super(sourceSet, androidTestSourceSet, unitTestSourceSet);

        this.buildType = buildType;
    }

    @NonNull
    public CoreBuildType getBuildType() {
        return buildType;
    }

    @Nullable
    public TaskProvider<Task> getAssembleTask() {
        return assembleTask;
    }

    public void setAssembleTask(TaskProvider<Task> assembleTask) {
        this.assembleTask = assembleTask;
    }

    @Nullable
    public TaskProvider<Task> getBundleTask() {
        return bundleTask;
    }

    public void setBundleTask(TaskProvider<Task> bundleTask) {
        this.bundleTask = bundleTask;
    }
}
