/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.cxx.configure.AbiConfigurator;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationInvalidationState;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationVariantConfiguration;
import com.android.build.gradle.internal.cxx.configure.NativeBuildSystemVariantConfig;
import com.android.build.gradle.internal.cxx.configure.NativeBuildSystemVariantConfigurationKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorFactory;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.ApiVersion;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;

public abstract class ExternalNativeJsonGenerator {
    final JsonGenerationVariantConfiguration config;
    final List<String> configurationFailures = Lists.newArrayList();
    protected final AndroidBuilder androidBuilder;
    protected final GradleBuildVariant.Builder stats;

    ExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, AndroidBuilder androidBuilder, GradleBuildVariant.Builder stats) {
        this.config = config2;
        this.androidBuilder = androidBuilder;
        this.stats = stats;
        if (!this.getNdkFolder().isDirectory()) {
            this.recordConfigurationError(String.format("NDK not configured (%s).\nDownload the NDK from http://developer.android.com/tools/sdk/ndk/.Then add ndk.dir=path/to/ndk in local.properties.\n(On Windows, make sure you escape backslashes, e.g. C:\\\\ndk rather than C:\\ndk)", this.getNdkFolder()));
        }
    }

    protected void recordConfigurationError(String message) {
        this.configurationFailures.add(message);
        GradleException e = new GradleException(message);
        this.androidBuilder.getLogger().error((Throwable)e, message, new Object[0]);
        this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException((Throwable)e, message));
    }

    protected static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }

    private List<File> getDependentBuildFiles(File json) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!json.exists()) {
            return result;
        }
        NativeBuildConfigValueMini config2 = AndroidBuildGradleJsons.getNativeBuildMiniConfig(json, this.stats);
        return config2.buildFiles;
    }

    public void build() throws IOException, ProcessException {
        this.buildAndPropagateException(false);
    }

    public void build(boolean forceJsonGeneration) {
        try {
            this.diagnostic("building json with force flag %s", forceJsonGeneration);
            this.buildAndPropagateException(forceJsonGeneration);
        }
        catch (IOException | GradleException e) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException(e, this.config.variantName));
        }
        catch (ProcessException e) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_PROCESS_EXCEPTION, new EvalIssueException(String.format("executing external native build for %s %s", this.getNativeBuildSystem().getName(), this.config.makefile), e.getMessage()));
        }
    }

    public List<Callable<Void>> parallelBuild(boolean forceJsonGeneration) {
        ArrayList<Callable<Void>> buildSteps = new ArrayList<Callable<Void>>(this.config.abiConfigurations.size());
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            buildSteps.add(() -> this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, configuration));
        }
        return buildSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void buildForOneConfigurationConvertExceptions(boolean forceJsonGeneration, JsonGenerationAbiConfiguration configuration) {
        try {
            this.buildForOneConfiguration(forceJsonGeneration, configuration);
        }
        catch (IOException | GradleException e) {
            EvalIssueReporter evalIssueReporter = this.androidBuilder.getIssueReporter();
            synchronized (evalIssueReporter) {
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException(e, this.config.variantName));
            }
        }
        catch (ProcessException e) {
            EvalIssueReporter evalIssueReporter = this.androidBuilder.getIssueReporter();
            synchronized (evalIssueReporter) {
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_PROCESS_EXCEPTION, new EvalIssueException(String.format("executing external native build for %s %s", this.getNativeBuildSystem().getName(), this.config.makefile), e.getMessage()));
            }
        }
        return null;
    }

    private static String getPreviousBuildCommand(File commandFile) throws IOException {
        if (!commandFile.exists()) {
            return "";
        }
        return new String(Files.readAllBytes(commandFile.toPath()), Charsets.UTF_8);
    }

    private void buildAndPropagateException(boolean forceJsonGeneration) throws IOException, ProcessException {
        Throwable firstException = null;
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            try {
                this.buildForOneConfiguration(forceJsonGeneration, configuration);
            }
            catch (ProcessException | IOException | GradleException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof GradleException) {
                throw (GradleException)firstException;
            }
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (ProcessException)firstException;
        }
    }

    public void buildForOneAbiName(boolean forceJsonGeneration, String abiName) {
        int built = 0;
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            if (!configuration.getAbi().getName().equals(abiName)) continue;
            ++built;
            this.buildForOneConfigurationConvertExceptions(forceJsonGeneration, configuration);
        }
        assert (built == 1);
    }

    private void checkForConfigurationErrors() {
        if (!this.configurationFailures.isEmpty()) {
            throw new GradleException(Joiner.on((String)"\r\n").join(this.configurationFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildForOneConfiguration(boolean forceJsonGeneration, JsonGenerationAbiConfiguration configuration) throws GradleException, IOException, ProcessException {
        this.checkForConfigurationErrors();
        String abi = configuration.getAbi().getName();
        GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
        variantStats.setAbi(AnalyticsUtil.getAbi(configuration.getAbiPresentationName()));
        variantStats.setDebuggable(this.config.debuggable);
        long startTime = System.currentTimeMillis();
        variantStats.setGenerationStartMs(startTime);
        try {
            this.diagnosticForAbi(abi, "Start JSON generation. Platform version: %s min SDK version: %s", configuration.getAbiPlatformVersion(), configuration.getAbiPresentationName(), configuration.getAbiPlatformVersion());
            ProcessInfoBuilder processBuilder = this.getProcessBuilder(configuration.getAbiPresentationName(), configuration.getAbiPlatformVersion(), configuration.getExpectedJson());
            String currentBuildCommand = processBuilder.toString();
            JsonGenerationInvalidationState invalidationState = new JsonGenerationInvalidationState(forceJsonGeneration, configuration.getExpectedJson(), configuration.getCommandFile(), currentBuildCommand, ExternalNativeJsonGenerator.getPreviousBuildCommand(configuration.getCommandFile()), this.getDependentBuildFiles(configuration.getExpectedJson()));
            if (invalidationState.getRebuild()) {
                this.diagnosticForAbi(abi, "rebuilding JSON %s due to:", configuration.getExpectedJson());
                for (String reason : invalidationState.getRebuildReasons()) {
                    this.diagnosticForAbi(abi, reason, new Object[0]);
                }
                if (this.config.jsonFolder.exists()) {
                    if (invalidationState.getSoftRegeneration()) {
                        this.diagnosticForAbi(abi, "keeping json folder '%s' but regenerating project", configuration.getExpectedJson().getParentFile());
                    } else {
                        this.diagnosticForAbi(abi, "removing stale contents from '%s'", configuration.getExpectedJson().getParentFile());
                        FileUtils.deletePath((File)configuration.getExpectedJson().getParentFile());
                    }
                }
                if (configuration.getExpectedJson().getParentFile().mkdirs()) {
                    this.diagnosticForAbi(abi, "created folder '%s'", configuration.getExpectedJson().getParentFile());
                }
                this.diagnosticForAbi(abi, "executing %s %s", this.getNativeBuildSystem().getName(), processBuilder);
                String buildOutput = this.executeProcess(configuration.getAbiPresentationName(), configuration.getAbiPlatformVersion(), configuration.getExpectedJson());
                this.diagnosticForAbi(abi, "done executing %s", this.getNativeBuildSystem().getName());
                this.diagnosticForAbi(abi, "write build output %s", configuration.getBuildOutputFile().getAbsolutePath());
                Files.write(configuration.getBuildOutputFile().toPath(), buildOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                this.processBuildOutput(buildOutput, configuration.getAbiPresentationName(), configuration.getAbiPlatformVersion());
                if (!configuration.getExpectedJson().exists()) {
                    throw new GradleException(String.format("Expected json generation to create '%s' but it didn't", configuration.getExpectedJson()));
                }
                GradleBuildVariant.Builder builder = this.stats;
                synchronized (builder) {
                    this.removeUnexpectedSoFiles(configuration.getExpectedOutputFolder(), AndroidBuildGradleJsons.getNativeBuildMiniConfig(configuration.getExpectedJson(), this.stats), abi);
                }
                this.diagnosticForAbi(abi, "write command file %s", configuration.getCommandFile().getAbsolutePath());
                Files.write(configuration.getCommandFile().toPath(), currentBuildCommand.getBytes(Charsets.UTF_8), new OpenOption[0]);
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_BUILT);
            } else {
                this.diagnosticForAbi(abi, "JSON '%s' was up-to-date", configuration.getExpectedJson());
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
            }
            this.diagnosticForAbi(abi, "JSON generation completed without problems", new Object[0]);
        }
        catch (ProcessException | IOException | GradleException e) {
            variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
            this.diagnosticForAbi(abi, "JSON generation for ABI: %s completed with problem. Exception: " + e.toString(), new Object[0]);
            throw e;
        }
        finally {
            variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
            GradleBuildVariant.Builder builder = this.stats;
            synchronized (builder) {
                this.stats.addNativeBuildConfig(variantStats);
            }
        }
    }

    private void removeUnexpectedSoFiles(File expectedOutputFolder, NativeBuildConfigValueMini config2, String abi) throws IOException {
        if (!expectedOutputFolder.isDirectory()) {
            return;
        }
        ArrayList expectedSoFiles = Lists.newArrayList();
        for (NativeLibraryValueMini library : config2.libraries.values()) {
            assert (library.output != null);
            expectedSoFiles.add(library.output.toPath());
        }
        try (Stream<Path> paths = Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".so")).filter(path -> !expectedSoFiles.contains(path)).forEach(path -> {
                if (path.toFile().delete()) {
                    this.diagnosticForAbi(abi, "deleted unexpected build output %s in incremental regenerate", path);
                }
            });
        }
    }

    abstract void processBuildOutput(String var1, String var2, int var3) throws IOException;

    abstract ProcessInfoBuilder getProcessBuilder(String var1, int var2, File var3);

    abstract String executeProcess(String var1, int var2, File var3) throws ProcessException, IOException;

    public abstract NativeBuildSystem getNativeBuildSystem();

    abstract Map<Abi, File> getStlSharedObjectFiles();

    void diagnostic(String format, Object ... args) {
        this.androidBuilder.getLogger().info("External native JSON generation. Variant:" + this.config.variantName + " : " + format, args);
    }

    void diagnosticForAbi(String abi, String format, Object ... args) {
        this.androidBuilder.getLogger().info("External native JSON generation. " + this.config.variantName + "|" + abi + " : " + format, args);
    }

    void warn(String format, Object ... args) {
        this.androidBuilder.getLogger().warning(format, args);
    }

    public String getVariantName() {
        return this.config.variantName;
    }

    public static ExternalNativeJsonGenerator create(String projectPath, File projectDir, File buildDir, File externalNativeBuildDir, NativeBuildSystem buildSystem, File makefile, AndroidBuilder androidBuilder, SdkHandler sdkHandler, VariantScope scope) {
        Preconditions.checkNotNull((Object)sdkHandler.getSdkFolder(), (Object)"No Android SDK folder found");
        File ndkFolder = sdkHandler.getNdkFolder();
        if (ndkFolder == null || !ndkFolder.isDirectory()) {
            throw new InvalidUserDataException(String.format("NDK not configured. %s\nDownload it with SDK manager.", ndkFolder == null ? "" : ndkFolder));
        }
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        GradleBuildVariant.Builder stats = ProcessProfileWriter.getOrCreateVariant((String)projectPath, (String)scope.getFullVariantName());
        GlobalScope globalScope = scope.getGlobalScope();
        File intermediates = FileUtils.join((File)globalScope.getIntermediatesDir(), (String[])new String[]{buildSystem.getName(), variantData.getVariantConfiguration().getDirName()});
        File soFolder = new File(intermediates, "lib");
        File externalNativeBuildFolder = ExternalNativeJsonGenerator.findExternalNativeBuildFolder(androidBuilder, projectDir, buildSystem, variantData, buildDir, externalNativeBuildDir);
        File objFolder = new File(intermediates, "obj");
        NdkHandler ndkHandler = globalScope.getNdkHandler();
        ApiVersion minSdkVersion = variantData.getVariantConfiguration().getMergedFlavor().getMinSdkVersion();
        NativeBuildSystemVariantConfig nativeBuildVariantConfig = NativeBuildSystemVariantConfigurationKt.createNativeBuildSystemVariantConfig(buildSystem, variantData.getVariantConfiguration());
        Splits splits = globalScope.getExtension().getSplits();
        if (globalScope.getExtension().getGeneratePureSplits() && splits.getAbi().isUniversalApk()) {
            androidBuilder.getLogger().warning("ABI based configuration splits and universal APK cannot be both set, universal APK will not be build.", new Object[0]);
        }
        ProjectOptions projectOptions = globalScope.getProjectOptions();
        AbiConfigurator abiConfigurator = new AbiConfigurator(globalScope.getErrorHandler(), variantData.getName(), ndkHandler.getSupportedAbis(), ndkHandler.getDefaultAbis(), nativeBuildVariantConfig.externalNativeBuildAbiFilters, nativeBuildVariantConfig.ndkAbiFilters, splits.getAbiFilters(), projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI), projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI));
        Collection<Abi> validAbis = abiConfigurator.getValidAbis();
        List<File> expectedJsons = ExternalNativeBuildTaskUtils.getOutputJsons(externalNativeBuildFolder, abiConfigurator.getAllAbis());
        if (buildSystem == NativeBuildSystem.NDK_BUILD) {
            objFolder = new File(objFolder, "local");
        }
        ArrayList abiConfigurations = Lists.newArrayList();
        for (Abi abi : validAbis) {
            AndroidVersion version = minSdkVersion == null ? null : new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
            abiConfigurations.add(new JsonGenerationAbiConfiguration(abi, externalNativeBuildFolder, objFolder, buildSystem, ndkHandler.findSuitablePlatformVersion(abi.getName(), variantData.getName(), version)));
        }
        assert (ndkHandler.getRevision() != null);
        JsonGenerationVariantConfiguration config2 = new JsonGenerationVariantConfiguration(nativeBuildVariantConfig, variantData.getName(), makefile, sdkHandler.getSdkFolder(), sdkHandler.getNdkFolder(), soFolder, objFolder, externalNativeBuildFolder, ((CoreBuildType)variantConfig.getBuildType()).isDebuggable(), abiConfigurations, ndkHandler.getRevision(), expectedJsons);
        switch (buildSystem) {
            case NDK_BUILD: {
                return new NdkBuildExternalNativeJsonGenerator(config2, androidBuilder, projectDir, stats);
            }
            case CMAKE: {
                return ExternalNativeJsonGenerator.createCmakeExternalNativeJsonGenerator(config2, variantData, sdkHandler, androidBuilder, stats);
            }
        }
        throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
    }

    private static ExternalNativeJsonGenerator createCmakeExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, BaseVariantData variantData, SdkHandler sdkHandler, AndroidBuilder androidBuilder, GradleBuildVariant.Builder stats) {
        Revision cmakeVersion;
        AndroidConfig extension = variantData.getScope().getGlobalScope().getExtension();
        CoreExternalNativeBuild externalNativeBuild = extension.getExternalNativeBuild();
        File cmakeFolder = variantData.getScope().getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_SIDE_BY_SIDE_CMAKE) ? CmakeLocatorKt.findCmakePath(externalNativeBuild.getCmake().getVersion(), sdkHandler, variantData.getName(), variantData.getScope().getGlobalScope().getErrorHandler(), androidBuilder.getLogger()) : ExternalNativeBuildTaskUtils.findCmakeExecutableFolder(externalNativeBuild.getCmake().getVersion(), sdkHandler);
        try {
            cmakeVersion = CmakeUtils.getVersion(new File(cmakeFolder, "bin"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the CMake version located at: " + new File(cmakeFolder, "bin").getAbsolutePath());
        }
        return CmakeExternalNativeJsonGeneratorFactory.createCmakeStrategy(config2, cmakeVersion, androidBuilder, cmakeFolder, stats);
    }

    private static File findExternalNativeBuildFolder(AndroidBuilder androidBuilder, File projectDir, NativeBuildSystem buildSystem, BaseVariantData variantData, File buildDir, File externalNativeBuildDir) {
        if (externalNativeBuildDir == null) {
            return FileUtils.join((File)projectDir, (String[])new String[]{".externalNativeBuild", buildSystem.getName(), variantData.getName()});
        }
        File externalNativeBuildPath = FileUtils.join((File)externalNativeBuildDir, (String[])new String[]{buildSystem.getName(), variantData.getName()});
        if (FileUtils.isFileInDirectory((File)externalNativeBuildPath, (File)buildDir)) {
            File invalidPath = externalNativeBuildPath;
            externalNativeBuildPath = FileUtils.join((File)projectDir, (String[])new String[]{".externalNativeBuild", buildSystem.getName(), variantData.getName()});
            androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, new EvalIssueException(String.format(Locale.getDefault(), "The build staging directory you specified ('%s') is a subdirectory of your project's temporary build directory ('%s').Files in this directory do not persist through clean builds.\nEither use the default build staging directory ('%s'),or specify a path outside the temporary build directory.", invalidPath.getAbsolutePath(), buildDir.getAbsolutePath(), externalNativeBuildPath.getAbsolutePath())));
        }
        return externalNativeBuildPath;
    }

    public void forEachNativeBuildConfiguration(Consumer<JsonReader> callback) throws IOException {
        List<File> files = this.getNativeBuildConfigurationsJsons();
        this.diagnostic("streaming %s JSON files", files.size());
        for (File file : this.getNativeBuildConfigurationsJsons()) {
            if (file.exists()) {
                this.diagnostic("string JSON file %s", file.getAbsolutePath());
                try {
                    JsonReader reader = new JsonReader((Reader)new FileReader(file));
                    Throwable throwable = null;
                    try {
                        callback.accept(reader);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                catch (Throwable e) {
                    this.diagnostic("Error parsing: %s", String.join((CharSequence)"\r\n", Files.readAllLines(file.toPath())));
                    throw e;
                }
            }
            this.diagnostic("streaming fallback JSON for %s", file.getAbsolutePath());
            NativeBuildConfigValueMini fallback = new NativeBuildConfigValueMini();
            fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.config.makefile});
            JsonReader reader = new JsonReader((Reader)new StringReader(new Gson().toJson((Object)fallback)));
            Throwable throwable = null;
            try {
                callback.accept(reader);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    public JsonGenerationVariantConfiguration getConfig() {
        return this.config;
    }

    @InputFile
    public File getMakefile() {
        return this.config.makefile;
    }

    @Input
    public File getObjFolder() {
        return this.config.objFolder;
    }

    public File getJsonFolder() {
        return this.config.jsonFolder;
    }

    @Input
    public File getNdkFolder() {
        return this.config.ndkFolder;
    }

    @Input
    public boolean isDebuggable() {
        return this.config.debuggable;
    }

    @Optional
    @Input
    public List<String> getBuildArguments() {
        return this.config.buildSystem.arguments;
    }

    @Optional
    @Input
    public List<String> getcFlags() {
        return this.config.buildSystem.cFlags;
    }

    @Optional
    @Input
    public List<String> getCppFlags() {
        return this.config.buildSystem.cppFlags;
    }

    @OutputFiles
    public List<File> getNativeBuildConfigurationsJsons() {
        return this.config.generatedJsonFiles;
    }

    @Input
    public File getSoFolder() {
        return this.config.soFolder;
    }

    @Input
    public File getSdkFolder() {
        return this.config.sdkFolder;
    }

    @Input
    public Collection<Abi> getAbis() {
        ArrayList result = Lists.newArrayList();
        for (JsonGenerationAbiConfiguration configuration : this.config.abiConfigurations) {
            result.add(configuration.getAbi());
        }
        return result;
    }
}

