/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.ide.common.build.ApkData;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import org.gradle.api.GradleException;
import org.gradle.api.Task;

public abstract class BaseVariantOutputImpl
implements BaseVariantOutput {
    protected final TaskContainer taskContainer;
    protected final ApkData apkData;

    protected BaseVariantOutputImpl(ApkData apkData, TaskContainer taskContainer) {
        this.apkData = apkData;
        this.taskContainer = taskContainer;
    }

    public OutputFile getMainOutputFile() {
        return this.getApkData().getMainOutputFile();
    }

    protected ApkData getApkData() {
        return this.apkData;
    }

    public File getOutputFile() {
        return this.getApkData().getMainOutputFile().getOutputFile();
    }

    public ImmutableList<OutputFile> getOutputs() {
        return ImmutableList.of((Object)this);
    }

    @Override
    public ProcessAndroidResources getProcessResources() {
        return (ProcessAndroidResources)this.taskContainer.getProcessAndroidResTask().getOrNull();
    }

    @Override
    public ManifestProcessorTask getProcessManifest() {
        return (ManifestProcessorTask)this.taskContainer.getProcessManifestTask().get();
    }

    @Override
    public Task getAssemble() {
        return (Task)this.taskContainer.getAssembleTask().get();
    }

    @Override
    public String getName() {
        return this.getApkData().getBaseName();
    }

    @Override
    public String getBaseName() {
        return this.getApkData().getBaseName();
    }

    @Override
    public String getDirName() {
        return this.getApkData().getDirName();
    }

    public String getOutputType() {
        return this.getApkData().getOutputType();
    }

    public Collection<String> getFilterTypes() {
        return this.getApkData().getFilterTypes();
    }

    public Collection<FilterData> getFilters() {
        return this.getApkData().getFilters();
    }

    public String getFilter(String filterType) {
        return this.getApkData().getFilter(filterType);
    }

    public String getOutputFileName() {
        return this.apkData.getOutputFileName();
    }

    public void setOutputFileName(String outputFileName) {
        if (new File(outputFileName).isAbsolute()) {
            throw new GradleException("Absolute path are not supported when setting an output file name");
        }
        this.apkData.setOutputFileName(outputFileName);
    }
}

