/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AbstractAndroidCompile;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.AndroidXDependency;
import com.android.builder.core.AndroidBuilder;
import com.android.tools.lint.gradle.api.ExtractAnnotationRequest;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public class ExtractAnnotations
extends AbstractAndroidCompile {
    private static final AndroidXDependency ANDROIDX_ANNOTATIONS = AndroidXDependency.fromPreAndroidXDependency("com.android.support", "support-annotations");
    private Supplier<List<String>> bootClasspath;
    private File typedefFile;
    private File output;
    private String encoding;
    private BuildableArtifact classDir;
    private ArtifactCollection libraries;
    FileCollection lintClassPath;
    private String variantName;

    @Override
    @Internal
    @NotNull
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(@NotNull String name) {
        this.variantName = name;
    }

    @InputFiles
    public FileCollection getLintClassPath() {
        return this.lintClassPath;
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        return super.getSource();
    }

    @CompileClasspath
    public List<String> getBootClasspath() {
        return this.bootClasspath.get();
    }

    public void setBootClasspath(Supplier<List<String>> bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    @CompileClasspath
    public FileCollection getLibraries() {
        return this.libraries.getArtifactFiles();
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output2) {
        this.output = output2;
    }

    @OutputFile
    public File getTypedefFile() {
        return this.typedefFile;
    }

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getClassDir() {
        return this.classDir;
    }

    public void setClassDir(BuildableArtifact classDir) {
        this.classDir = classDir;
    }

    @TaskAction
    protected void compile() {
        SourceFileVisitor fileVisitor = new SourceFileVisitor();
        this.getSource().visit((FileVisitor)fileVisitor);
        List sourceFiles = fileVisitor.sourceUnits;
        if (!ExtractAnnotations.containsTypeDefs(sourceFiles)) {
            ExtractAnnotations.writeEmptyTypeDefFile(this.getTypedefFile());
            return;
        }
        List<File> roots = fileVisitor.getSourceRoots();
        FileCollection classpath = this.getClasspath();
        if (classpath != null) {
            for (File jar : classpath) {
                roots.add(jar);
            }
        }
        for (String path : this.getBootClasspath()) {
            roots.add(new File(path));
        }
        ExtractAnnotationRequest request2 = new ExtractAnnotationRequest(this.getTypedefFile(), this.getLogger(), (FileCollection)this.getClassDir().get(), this.getOutput(), sourceFiles, roots);
        FileCollection lintClassPath = this.getLintClassPath();
        if (lintClassPath != null) {
            new ReflectiveLintRunner().extractAnnotations(this.getProject().getGradle(), request2, lintClassPath.getFiles());
        }
    }

    private static void writeEmptyTypeDefFile(File file) {
        if (file == null) {
            return;
        }
        try {
            FileUtils.deleteIfExists((File)file);
            Files.createParentDirs((File)file);
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean containsTypeDefs(List<File> sourceFiles) {
        for (File file : sourceFiles) {
            if (!ExtractAnnotations.containsTypeDefs(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean containsTypeDefs(File file) {
        try (Stream lines = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).lines();){
            boolean bl = lines.anyMatch(line -> line.contains("Def") && (line.contains(SdkConstants.INT_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.INT_DEF_ANNOTATION.newName()) || line.contains(SdkConstants.LONG_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.LONG_DEF_ANNOTATION.newName()) || line.contains(SdkConstants.STRING_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.STRING_DEF_ANNOTATION.newName())));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Input
    public boolean hasAndroidAnnotations() {
        for (ResolvedArtifactResult artifact : this.libraries.getArtifacts()) {
            ModuleComponentIdentifier moduleId;
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            if (!(id instanceof ModuleComponentIdentifier) || (!(moduleId = (ModuleComponentIdentifier)id).getGroup().equals(ANDROIDX_ANNOTATIONS.getGroup()) || !moduleId.getModule().equals(ANDROIDX_ANNOTATIONS.getModule())) && (!moduleId.getGroup().equals(ANDROIDX_ANNOTATIONS.getOldGroup()) || !moduleId.getModule().equals(ANDROIDX_ANNOTATIONS.getOldModule()))) continue;
            return true;
        }
        return false;
    }

    private static class SourceFileVisitor
    extends EmptyFileVisitor {
        private final List<File> sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        private final List<File> sourceRoots = Lists.newArrayList();
        private String mostRecentRoot = "\u0000";
        private static final String BUILD_GENERATED = File.separator + "build" + File.separator + "generated" + File.separator;

        public List<File> getSourceFiles() {
            return this.sourceUnits;
        }

        public List<File> getSourceRoots() {
            return this.sourceRoots;
        }

        public void visitFile(FileVisitDetails details) {
            File file = details.getFile();
            String path = file.getPath();
            if (path.endsWith(".java") && !path.contains(BUILD_GENERATED)) {
                if (!path.startsWith(this.mostRecentRoot)) {
                    String root;
                    File rootFile;
                    RelativePath relativePath = details.getRelativePath();
                    String pathString = relativePath.getPathString();
                    if (path.endsWith(pathString = pathString.replace('/', File.separatorChar)) && !this.sourceRoots.contains(rootFile = new File(root = path.substring(0, path.length() - pathString.length())))) {
                        this.mostRecentRoot = rootFile.getPath();
                        this.sourceRoots.add(rootFile);
                    }
                }
                this.sourceUnits.add(file);
            }
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ExtractAnnotations> {
        private final AndroidConfig extension;
        private File output;
        private File typedefFile;

        public CreationAction(AndroidConfig extension, VariantScope variantScope) {
            super(variantScope);
            this.extension = extension;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("extract", "Annotations");
        }

        @Override
        public Class<ExtractAnnotations> getType() {
            return ExtractAnnotations.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.output = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ANNOTATIONS_ZIP, taskName, "annotations.zip");
            this.typedefFile = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE, taskName, "typedefs.txt");
        }

        @Override
        public void handleProvider(TaskProvider<? extends ExtractAnnotations> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateAnnotationsTask(taskProvider);
        }

        @Override
        public void configure(ExtractAnnotations task) {
            super.configure(task);
            VariantScope variantScope = this.getVariantScope();
            GradleVariantConfiguration variantConfig = variantScope.getVariantConfiguration();
            AndroidBuilder androidBuilder = variantScope.getGlobalScope().getAndroidBuilder();
            task.setDescription("Extracts Android annotations for the " + variantConfig.getFullName() + " variant into the archive file");
            task.setGroup("build");
            task.setOutput(this.output);
            task.setDestinationDir(this.output.getParentFile());
            task.typedefFile = this.typedefFile;
            task.setClassDir(variantScope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES));
            task.setSource(variantScope.getVariantData().getJavaSources());
            task.setEncoding(this.extension.getCompileOptions().getEncoding());
            task.setSourceCompatibility(this.extension.getCompileOptions().getSourceCompatibility().toString());
            task.setClasspath(variantScope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES));
            task.libraries = variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.setBootClasspath(() -> androidBuilder.getBootClasspathAsStrings(false));
            task.lintClassPath = variantScope.getGlobalScope().getProject().getConfigurations().getByName("lintClassPath");
        }
    }
}

