/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;

public class JavaCompileCreationAction
extends VariantTaskCreationAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(JavaCompileCreationAction.class);
    private File destinationDir;

    public JavaCompileCreationAction(VariantScope scope) {
        super(scope);
    }

    @Override
    public String getName() {
        return this.getVariantScope().getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void preConfigure(String taskName) {
        super.preConfigure(taskName);
        VariantScope scope = this.getVariantScope();
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        this.destinationDir = artifacts.appendArtifact((ArtifactType)InternalArtifactType.JAVAC, taskName, "classes");
        if (scope.getGlobalScope().getExtension().getDataBinding().isEnabled()) {
            artifacts.appendArtifact((ArtifactType)InternalArtifactType.DATA_BINDING_ARTIFACT, (Collection<? extends Object>)ImmutableList.of((Object)scope.getBundleArtifactFolderForDataBinding()), taskName);
        }
    }

    @Override
    public void handleProvider(TaskProvider<? extends AndroidJavaCompile> taskProvider) {
        super.handleProvider(taskProvider);
        this.getVariantScope().getTaskContainer().setJavacTask(taskProvider);
    }

    @Override
    public void configure(AndroidJavaCompile task) {
        super.configure(task);
        VariantScope scope = this.getVariantScope();
        GlobalScope globalScope = scope.getGlobalScope();
        Project project = globalScope.getProject();
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        task.compileSdkVersion = globalScope.getExtension().getCompileSdkVersion();
        task.mInstantRunBuildContext = scope.getInstantRunBuildContext();
        for (ConfigurableFileTree fileTree : scope.getVariantData().getJavaSources()) {
            task.source(new Object[]{fileTree});
        }
        task.getOptions().setBootstrapClasspath(scope.getBootClasspath());
        task.setClasspath(scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES));
        task.setDestinationDir(this.destinationDir);
        CompileOptions compileOptions = globalScope.getExtension().getCompileOptions();
        task.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        task.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
        task.getOptions().setEncoding(compileOptions.getEncoding());
        Boolean includeCompileClasspath = scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions().getIncludeCompileClasspath();
        FileCollection processorPath = scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR);
        if (Boolean.TRUE.equals(includeCompileClasspath)) {
            processorPath = processorPath.plus(scope.getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.PROCESSED_JAR));
        }
        task.getOptions().setAnnotationProcessorPath(processorPath);
        boolean incremental = AbstractCompilesUtil.isIncremental(project, scope, compileOptions, null, LOG);
        if (incremental) {
            LOG.verbose("Using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), scope.getFullVariantName()});
            task.getOptions().setIncremental(true);
        } else {
            LOG.verbose("Not using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), scope.getFullVariantName()});
        }
        AnnotationProcessorOptions annotationProcessorOptions = scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        if (!annotationProcessorOptions.getClassNames().isEmpty()) {
            task.getOptions().getCompilerArgs().add("-processor");
            task.getOptions().getCompilerArgs().add(Joiner.on((char)',').join(annotationProcessorOptions.getClassNames()));
        }
        if (!annotationProcessorOptions.getArguments().isEmpty()) {
            for (Map.Entry<String, String> arg : annotationProcessorOptions.getArguments().entrySet()) {
                task.getOptions().getCompilerArgs().add("-A" + arg.getKey() + "=" + arg.getValue());
            }
        }
        task.getOptions().getCompilerArgumentProviders().addAll(annotationProcessorOptions.getCompilerArgumentProviders());
        task.getOptions().setAnnotationProcessorGeneratedSourcesDirectory(scope.getAnnotationProcessorOutputDir());
        task.annotationProcessorOutputFolder = scope.getAnnotationProcessorOutputDir();
        task.processorListFile = artifacts.getFinalArtifactFiles(InternalArtifactType.ANNOTATION_PROCESSOR_LIST);
        task.dependsOn(new Object[]{scope.getTaskContainer().getSourceGenTask()});
    }
}

