/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.ide.common.build.ApkData;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;

public abstract class BaseVariantOutputImpl
implements BaseVariantOutput {
    protected final TaskContainer taskContainer;
    protected final DeprecationReporter deprecationReporter;
    protected final ApkData apkData;

    protected BaseVariantOutputImpl(ApkData apkData, TaskContainer taskContainer, DeprecationReporter deprecationReporter) {
        this.apkData = apkData;
        this.taskContainer = taskContainer;
        this.deprecationReporter = deprecationReporter;
    }

    public OutputFile getMainOutputFile() {
        return this.getApkData().getMainOutputFile();
    }

    protected ApkData getApkData() {
        return this.apkData;
    }

    public File getOutputFile() {
        return this.getApkData().getMainOutputFile().getOutputFile();
    }

    public ImmutableList<OutputFile> getOutputs() {
        return ImmutableList.of((Object)this);
    }

    @Override
    public ProcessAndroidResources getProcessResources() {
        this.deprecationReporter.reportDeprecatedApi("variantOutput.getProcessResourcesProvider()", "variantOutput.getProcessResources()", "TBD", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (ProcessAndroidResources)this.taskContainer.getProcessAndroidResTask().getOrNull();
    }

    @Override
    public TaskProvider<ProcessAndroidResources> getProcessResourcesProvider() {
        return this.taskContainer.getProcessAndroidResTask();
    }

    @Override
    public ManifestProcessorTask getProcessManifest() {
        this.deprecationReporter.reportDeprecatedApi("variantOutput.getProcessManifestProvider()", "variantOutput.getProcessManifest()", "TBD", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (ManifestProcessorTask)this.taskContainer.getProcessManifestTask().get();
    }

    @Override
    public TaskProvider<ManifestProcessorTask> getProcessManifestProvider() {
        return this.taskContainer.getProcessManifestTask();
    }

    @Override
    public Task getAssemble() {
        this.deprecationReporter.reportDeprecatedApi("variant.getAssembleProvider()", "variantOutput.getAssemble()", "TBD", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        return (Task)this.taskContainer.getAssembleTask().get();
    }

    @Override
    public String getName() {
        return this.getApkData().getBaseName();
    }

    @Override
    public String getBaseName() {
        return this.getApkData().getBaseName();
    }

    @Override
    public String getDirName() {
        return this.getApkData().getDirName();
    }

    public String getOutputType() {
        return this.getApkData().getOutputType();
    }

    public Collection<String> getFilterTypes() {
        return this.getApkData().getFilterTypes();
    }

    public Collection<FilterData> getFilters() {
        return this.getApkData().getFilters();
    }

    public String getFilter(String filterType) {
        return this.getApkData().getFilter(filterType);
    }

    public String getOutputFileName() {
        return this.apkData.getOutputFileName();
    }

    public void setOutputFileName(String outputFileName) {
        if (new File(outputFileName).isAbsolute()) {
            throw new GradleException("Absolute path are not supported when setting an output file name");
        }
        this.apkData.setOutputFileName(outputFileName);
    }
}

