/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.api.AnnotationProcessorOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.JavaCompileUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class JavaPreCompileTask
extends AndroidBuilderTask {
    private File processorListFile;
    private String annotationProcessorConfigurationName;
    private ArtifactCollection annotationProcessorConfiguration;
    private ArtifactCollection compileClasspaths;
    private AnnotationProcessorOptions annotationProcessorOptions;
    private boolean isTestComponent;

    void init(File processorListFile, String annotationProcessorConfigurationName, ArtifactCollection annotationProcessorConfiguration, ArtifactCollection compileClasspaths, AnnotationProcessorOptions annotationProcessorOptions, boolean isTestComponent) {
        this.processorListFile = processorListFile;
        this.annotationProcessorConfigurationName = annotationProcessorConfigurationName;
        this.annotationProcessorConfiguration = annotationProcessorConfiguration;
        this.compileClasspaths = compileClasspaths;
        this.annotationProcessorOptions = annotationProcessorOptions;
        this.isTestComponent = isTestComponent;
    }

    @OutputFile
    public File getProcessorListFile() {
        return this.processorListFile;
    }

    @Classpath
    public FileCollection getAnnotationProcessorConfiguration() {
        return this.annotationProcessorConfiguration.getArtifactFiles();
    }

    @Classpath
    public FileCollection getCompileClasspaths() {
        return this.compileClasspaths.getArtifactFiles();
    }

    @TaskAction
    public void preCompile() {
        if (this.annotationProcessorOptions.getIncludeCompileClasspath() == null) {
            FileCollection processorClasspath = this.annotationProcessorConfiguration.getArtifactFiles();
            Collection<Object> violatingProcessors = JavaCompileUtils.detectAnnotationProcessors(this.compileClasspaths).keySet();
            if (!(violatingProcessors = (Collection)violatingProcessors.stream().filter(artifact -> !processorClasspath.contains(artifact.getFile())).collect(Collectors.toList())).isEmpty()) {
                Collection violatingProcessorNames = violatingProcessors.stream().map(artifact -> artifact.getId().getDisplayName()).collect(Collectors.toList());
                String message = "Annotation processors must be explicitly declared now.  The following dependencies on the compile classpath are found to contain annotation processor.  Please add them to the " + this.annotationProcessorConfigurationName + " configuration.\n  - " + Joiner.on((String)"\n  - ").join((Iterable)violatingProcessorNames) + "\nAlternatively, set android.defaultConfig.javaCompileOptions.annotationProcessorOptions.includeCompileClasspath = true to continue with previous behavior.  Note that this option is deprecated and will be removed in the future.\nSee https://developer.android.com/r/tools/annotation-processor-error-message.html for more details.";
                if (this.isTestComponent) {
                    this.getLogger().warn(message);
                } else {
                    throw new RuntimeException(message);
                }
            }
        }
        Map<String, Boolean> annotationProcessors = JavaCompileUtils.detectAnnotationProcessors(this.annotationProcessorOptions, this.annotationProcessorConfiguration, this.compileClasspaths);
        JavaCompileUtils.writeAnnotationProcessorsToJsonFile(annotationProcessors, this.processorListFile);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JavaPreCompileTask> {
        private Provider<RegularFile> apList;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("javaPreCompile");
        }

        @Override
        public Class<JavaPreCompileTask> getType() {
            return JavaPreCompileTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.apList = this.getVariantScope().getArtifacts().createArtifactFile((ArtifactType)InternalArtifactType.ANNOTATION_PROCESSOR_LIST, BuildArtifactsHolder.OperationType.APPEND, taskName, "annotationProcessors.json");
        }

        @Override
        public void configure(JavaPreCompileTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.init(((RegularFile)this.apList.get()).getAsFile(), scope.getVariantData().getType().isTestComponent() ? scope.getVariantData().getType().getPrefix() + "AnnotationProcessor" : "annotationProcessor", scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.PROCESSED_JAR), scope.getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, null), scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions(), scope.getVariantData().getType().isTestComponent());
        }
    }
}

