/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\tJ\r\u0010-\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b0J\n\u00101\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u0014H\u0002J\u000f\u00105\u001a\u0004\u0018\u00010 H\u0000\u00a2\u0006\u0002\b6J\u000e\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0003J\u001e\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0003J?\u0010=\u001a\u00020\u00002\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00052\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0A0@2\u0006\u0010B\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bCJ5\u0010D\u001a\u00020\u00002\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0A0@H\u0000\u00a2\u0006\u0002\bHJ-\u0010I\u001a\u00020\u00002\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00052\b\u0010J\u001a\u0004\u0018\u00010 H\u0000\u00a2\u0006\u0002\bKJ\r\u0010L\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bMJ\u0018\u0010N\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u001aH\u0002J\u0018\u0010Q\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u001aH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001eR\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\r\u00a8\u0006R"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CmakeSearchContext;", "", "cmakeVersionFromDsl", "", "error", "Lkotlin/Function1;", "", "warn", "info", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getCmakeVersionFromDsl", "()Ljava/lang/String;", "getError", "()Lkotlin/jvm/functions/Function1;", "firstError", "getFirstError", "setFirstError", "(Ljava/lang/String;)V", "getInfo", "requestDownloadFromAndroidStudio", "", "getRequestDownloadFromAndroidStudio", "()Z", "setRequestDownloadFromAndroidStudio", "(Z)V", "requestedCmakeVersion", "Lcom/android/repository/Revision;", "getRequestedCmakeVersion", "()Lcom/android/repository/Revision;", "setRequestedCmakeVersion", "(Lcom/android/repository/Revision;)V", "resultCmakeInstallFolder", "Ljava/io/File;", "getResultCmakeInstallFolder", "()Ljava/io/File;", "setResultCmakeInstallFolder", "(Ljava/io/File;)V", "resultCmakeVersion", "getResultCmakeVersion", "setResultCmakeVersion", "unsuitableCmakeReasons", "", "getUnsuitableCmakeReasons", "()Ljava/util/List;", "getWarn", "checkForCmakeVersionAdequatePrecision", "checkForCmakeVersionAdequatePrecision$gradle", "checkForCmakeVersionTooLow", "checkForCmakeVersionTooLow$gradle", "cmakeVersionFromDslNoPlus", "convertSdkVersionToCmakeVersion", "version", "dslVersionHasPlus", "issueVersionNotFoundError", "issueVersionNotFoundError$gradle", "recordUnsuitableCmakeMessage", "message", "tryAcceptFoundCmake", "candidateCmakeInstallFolder", "candidateVersion", "locationTag", "tryFindInPath", "cmakeVersionGetter", "environmentPaths", "Lkotlin/Function0;", "", "tag", "tryFindInPath$gradle", "tryLocalRepositoryPackages", "downloader", "repositoryPackages", "Lcom/android/repository/api/LocalPackage;", "tryLocalRepositoryPackages$gradle", "tryPathFromLocalProperties", "pathFromLocalProperties", "tryPathFromLocalProperties$gradle", "useDefaultCmakeVersionIfNecessary", "useDefaultCmakeVersionIfNecessary$gradle", "versionEquals", "left", "right", "versionGreaterThan", "gradle"})
final class CmakeSearchContext {
    @Nullable
    private File resultCmakeInstallFolder;
    @Nullable
    private Revision resultCmakeVersion;
    @NotNull
    public Revision requestedCmakeVersion;
    @Nullable
    private String firstError;
    @NotNull
    private final List<String> unsuitableCmakeReasons;
    private boolean requestDownloadFromAndroidStudio;
    @NotNull
    private final Function1<String, Unit> error;
    @Nullable
    private final String cmakeVersionFromDsl;
    @NotNull
    private final Function1<String, Unit> warn;
    @NotNull
    private final Function1<String, Unit> info;

    @Nullable
    public final File getResultCmakeInstallFolder() {
        return this.resultCmakeInstallFolder;
    }

    public final void setResultCmakeInstallFolder(@Nullable File file) {
        this.resultCmakeInstallFolder = file;
    }

    @Nullable
    public final Revision getResultCmakeVersion() {
        return this.resultCmakeVersion;
    }

    public final void setResultCmakeVersion(@Nullable Revision revision) {
        this.resultCmakeVersion = revision;
    }

    @NotNull
    public final Revision getRequestedCmakeVersion() {
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        return revision;
    }

    public final void setRequestedCmakeVersion(@NotNull Revision revision) {
        Intrinsics.checkParameterIsNotNull((Object)revision, (String)"<set-?>");
        this.requestedCmakeVersion = revision;
    }

    @Nullable
    public final String getFirstError() {
        return this.firstError;
    }

    public final void setFirstError(@Nullable String string) {
        this.firstError = string;
    }

    @NotNull
    public final List<String> getUnsuitableCmakeReasons() {
        return this.unsuitableCmakeReasons;
    }

    public final boolean getRequestDownloadFromAndroidStudio() {
        return this.requestDownloadFromAndroidStudio;
    }

    public final void setRequestDownloadFromAndroidStudio(boolean bl) {
        this.requestDownloadFromAndroidStudio = bl;
    }

    @NotNull
    public final Function1<String, Unit> getError() {
        return this.error;
    }

    private final String cmakeVersionFromDslNoPlus() {
        if (this.cmakeVersionFromDsl == null) {
            return null;
        }
        return StringsKt.trimEnd((String)this.cmakeVersionFromDsl, (char[])new char[]{'+'});
    }

    private final boolean dslVersionHasPlus() {
        if (this.cmakeVersionFromDsl == null) {
            return false;
        }
        return StringsKt.endsWith$default((CharSequence)this.cmakeVersionFromDsl, (char)'+', (boolean)false, (int)2, null);
    }

    private final boolean versionEquals(Revision left, Revision right) {
        return left.compareTo(right, Revision.PreviewComparison.IGNORE) == 0;
    }

    private final boolean versionGreaterThan(Revision left, Revision right) {
        return left.compareTo(right, Revision.PreviewComparison.IGNORE) > 0;
    }

    public final void tryAcceptFoundCmake(@NotNull File candidateCmakeInstallFolder, @NotNull Revision candidateVersion, @NotNull String locationTag) {
        Intrinsics.checkParameterIsNotNull((Object)candidateCmakeInstallFolder, (String)"candidateCmakeInstallFolder");
        Intrinsics.checkParameterIsNotNull((Object)candidateVersion, (String)"candidateVersion");
        Intrinsics.checkParameterIsNotNull((Object)locationTag, (String)"locationTag");
        if (this.dslVersionHasPlus()) {
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            if (this.versionGreaterThan(revision, candidateVersion)) {
                StringBuilder stringBuilder = new StringBuilder().append("CMake '").append(candidateVersion).append("' found ").append(locationTag).append(" could not satisfy requested version ").append('\'');
                Revision revision2 = this.requestedCmakeVersion;
                if (revision2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                this.recordUnsuitableCmakeMessage(stringBuilder.append(revision2).append("' because it was lower.").toString());
                return;
            }
        } else {
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            if (!this.versionEquals(revision, candidateVersion)) {
                StringBuilder stringBuilder = new StringBuilder().append("CMake '").append(candidateVersion).append("' found ").append(locationTag).append(" did not match requested version ").append('\'');
                Revision revision3 = this.requestedCmakeVersion;
                if (revision3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                this.recordUnsuitableCmakeMessage(stringBuilder.append(revision3).append("'.").toString());
                return;
            }
        }
        if (this.resultCmakeVersion == null) {
            this.info.invoke((Object)("- CMake found " + locationTag + " at '" + candidateCmakeInstallFolder + "' had " + "version '" + candidateVersion + '\''));
            this.resultCmakeVersion = candidateVersion;
            this.resultCmakeInstallFolder = candidateCmakeInstallFolder;
        } else {
            Revision revision = this.resultCmakeVersion;
            if (revision == null) {
                Intrinsics.throwNpe();
            }
            if (candidateVersion.compareTo(revision) > 0) {
                this.info.invoke((Object)("- CMake found " + locationTag + " at '" + candidateCmakeInstallFolder + "' had " + "version '" + candidateVersion + "' and replaces version '" + this.resultCmakeVersion + "' " + "found earlier"));
                this.resultCmakeVersion = candidateVersion;
                this.resultCmakeInstallFolder = candidateCmakeInstallFolder;
            } else {
                this.info.invoke((Object)("- CMake found and skipped " + locationTag + " '" + candidateCmakeInstallFolder + "' which had " + "version '" + candidateVersion + "' which was lower than or equal to a " + "version found earlier."));
            }
        }
    }

    public final void recordUnsuitableCmakeMessage(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.info.invoke((Object)message);
        Collection collection = this.unsuitableCmakeReasons;
        String string = "- " + message;
        collection.add(string);
    }

    @NotNull
    public final CmakeSearchContext useDefaultCmakeVersionIfNecessary$gradle() {
        Revision revision;
        String cmakeVersionFromDslNoPlus = this.cmakeVersionFromDslNoPlus();
        CmakeSearchContext cmakeSearchContext = this;
        if (cmakeVersionFromDslNoPlus == null) {
            this.info.invoke((Object)"No CMake version was specified in build.gradle. Choosing a suitable version.");
            Revision revision2 = CmakeLocatorKt.access$getForkCmakeReportedVersion$p();
            revision = revision2;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"forkCmakeReportedVersion");
        } else {
            Revision revision3;
            CmakeSearchContext cmakeSearchContext2 = cmakeSearchContext;
            try {
                cmakeSearchContext = cmakeSearchContext2;
                revision3 = Revision.parseRevision((String)cmakeVersionFromDslNoPlus);
            }
            catch (NumberFormatException numberFormatException) {
                cmakeSearchContext = cmakeSearchContext2;
                this.error.invoke((Object)("CMake version '" + this.cmakeVersionFromDsl + "' is not formatted correctly."));
                revision3 = CmakeLocatorKt.access$getForkCmakeReportedVersion$p();
            }
            Revision revision4 = revision3;
            revision = revision4;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision4, (String)"try {\n                Re\u2026rtedVersion\n            }");
        }
        cmakeSearchContext.requestedCmakeVersion = revision;
        return this;
    }

    @NotNull
    public final CmakeSearchContext checkForCmakeVersionTooLow$gradle() {
        block8: {
            block7: {
                Revision revision = this.requestedCmakeVersion;
                if (revision == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (revision.getMajor() < 3) break block7;
                Revision revision2 = this.requestedCmakeVersion;
                if (revision2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (revision2.getMajor() != 3) break block8;
                Revision revision3 = this.requestedCmakeVersion;
                if (revision3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (revision3.getMinor() >= 6) break block8;
            }
            StringBuilder stringBuilder = new StringBuilder().append("CMake version '");
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            this.error.invoke((Object)stringBuilder.append(revision).append("' is too low. Use 3.7.0 or higher.").toString());
            Revision revision4 = CmakeLocatorKt.access$getForkCmakeReportedVersion$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision4, (String)"forkCmakeReportedVersion");
            this.requestedCmakeVersion = revision4;
        }
        return this;
    }

    @NotNull
    public final CmakeSearchContext checkForCmakeVersionAdequatePrecision$gradle() {
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        if (revision.toIntArray(true).length < 3) {
            StringBuilder stringBuilder = new StringBuilder().append("CMake version '");
            Revision revision2 = this.requestedCmakeVersion;
            if (revision2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            this.error.invoke((Object)stringBuilder.append(revision2).append("' does not have enough precision. Use major.minor.micro in version.").toString());
            Revision revision3 = CmakeLocatorKt.access$getForkCmakeReportedVersion$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision3, (String)"forkCmakeReportedVersion");
            this.requestedCmakeVersion = revision3;
        }
        return this;
    }

    @NotNull
    public final CmakeSearchContext tryPathFromLocalProperties$gradle(@NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @Nullable File pathFromLocalProperties) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
        boolean bl2 = bl = this.resultCmakeInstallFolder == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (pathFromLocalProperties == null) {
            return this;
        }
        File binDir = new File(pathFromLocalProperties, "bin");
        Revision version = (Revision)cmakeVersionGetter.invoke((Object)binDir);
        if (version == null) {
            this.error.invoke((Object)("Could not get version from cmake.dir path '" + pathFromLocalProperties + "'."));
            return this;
        }
        if (this.cmakeVersionFromDsl == null) {
            this.info.invoke((Object)("- Found CMake '" + version + "' via cmake.dir='" + pathFromLocalProperties + "'."));
            this.resultCmakeInstallFolder = pathFromLocalProperties;
            this.resultCmakeVersion = version;
        } else {
            this.tryAcceptFoundCmake(pathFromLocalProperties, version, "from cmake.dir");
            if (this.resultCmakeInstallFolder == null) {
                StringBuilder stringBuilder = new StringBuilder().append("CMake '").append(version).append("' found via cmake.dir='").append(pathFromLocalProperties).append("' does not match ").append("requested version '");
                Revision revision = this.requestedCmakeVersion;
                if (revision == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                this.error.invoke((Object)stringBuilder.append(revision).append("'.").toString());
            }
        }
        return this;
    }

    @NotNull
    public final CmakeSearchContext tryLocalRepositoryPackages$gradle(@NotNull Function1<? super String, Unit> downloader, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Iterable $receiver$iv;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull(repositoryPackages, (String)"repositoryPackages");
        if (this.resultCmakeInstallFolder != null) {
            return this;
        }
        this.info.invoke((Object)"Trying to locate CMake in local SDK repository.");
        Iterable $receiver$iv2 = iterable = ($receiver$iv = (Iterable)repositoryPackages.invoke());
        for (Object element$iv : $receiver$iv2) {
            LocalPackage pkg = (LocalPackage)element$iv;
            boolean bl = false;
            File file = pkg.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pkg.location");
            Revision revision = pkg.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"pkg.version");
            this.tryAcceptFoundCmake(file, this.convertSdkVersionToCmakeVersion(revision), "in SDK");
        }
        if (this.resultCmakeInstallFolder != null) {
            return this;
        }
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        Revision revision2 = CmakeLocatorKt.access$getForkCmakeReportedVersion$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"forkCmakeReportedVersion");
        if (this.versionEquals(revision, revision2)) {
            Object v6;
            block8: {
                this.info.invoke((Object)("- Downloading '" + CmakeLocatorKt.access$getForkCmakeSdkVersionRevision$p() + "'."));
                downloader.invoke((Object)"3.6.4111459");
                Iterable iterable2 = iterable = (Iterable)repositoryPackages.invoke();
                for (Object t : iterable2) {
                    LocalPackage it = (LocalPackage)t;
                    boolean bl = false;
                    Revision revision3 = it.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)revision3, (String)"it.version");
                    Revision revision4 = CmakeLocatorKt.access$getForkCmakeSdkVersionRevision$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)revision4, (String)"forkCmakeSdkVersionRevision");
                    if (!this.versionEquals(revision3, revision4)) continue;
                    v6 = t;
                    break block8;
                }
                v6 = null;
            }
            LocalPackage res = v6;
            if (res != null) {
                File file = res.getLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"res.location");
                Revision revision5 = res.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)revision5, (String)"res.version");
                this.tryAcceptFoundCmake(file, this.convertSdkVersionToCmakeVersion(revision5), "in SDK");
            }
            if (this.resultCmakeInstallFolder == null) {
                this.requestDownloadFromAndroidStudio = true;
            }
            return this;
        }
        return this;
    }

    private final Revision convertSdkVersionToCmakeVersion(Revision version) {
        if (Intrinsics.areEqual((Object)version, (Object)CmakeLocatorKt.access$getForkCmakeSdkVersionRevision$p())) {
            Revision revision = CmakeLocatorKt.access$getForkCmakeReportedVersion$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"forkCmakeReportedVersion");
            return revision;
        }
        return version;
    }

    @NotNull
    public final CmakeSearchContext tryFindInPath$gradle(@NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
        Intrinsics.checkParameterIsNotNull(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.resultCmakeInstallFolder != null) {
            return this;
        }
        this.info.invoke((Object)("Trying to locate CMake " + tag + '.'));
        boolean found = false;
        for (File cmakeFolder : (List)environmentPaths.invoke()) {
            try {
                File cmakeInstallPath;
                Revision version;
                if ((Revision)cmakeVersionGetter.invoke((Object)cmakeFolder) == null) {
                    continue;
                }
                if (found) {
                    this.info.invoke((Object)("- CMake " + version + " was found " + tag + " at " + cmakeFolder + " after" + " another version. Ignoring it."));
                    continue;
                }
                File file = cmakeInstallPath = cmakeFolder.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"cmakeInstallPath");
                this.tryAcceptFoundCmake(file, version, tag);
                found = true;
            }
            catch (IOException e) {
                this.warn.invoke((Object)("Could not execute cmake at '" + cmakeFolder + "' to get version. Skipping."));
            }
        }
        return this;
    }

    @Nullable
    public final File issueVersionNotFoundError$gradle() {
        String unsuitableCMakes;
        String string;
        if (this.resultCmakeInstallFolder != null && !this.requestDownloadFromAndroidStudio) {
            return this.resultCmakeInstallFolder;
        }
        if (this.unsuitableCmakeReasons.isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(CmakeLocatorKt.access$getNewline$p());
            Iterable iterable = this.unsuitableCmakeReasons;
            String string2 = CmakeLocatorKt.access$getNewline$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"newline");
            string = unsuitableCMakes = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString();
        }
        if (this.firstError != null) {
            throw (Throwable)new RuntimeException(this.firstError + unsuitableCMakes);
        }
        if (this.dslVersionHasPlus()) {
            StringBuilder stringBuilder = new StringBuilder().append("CMake '");
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            throw (Throwable)new RuntimeException(stringBuilder.append(revision).append("' or higher was not found in ").append("PATH or by cmake.dir property.").append(unsuitableCMakes).toString());
        }
        StringBuilder stringBuilder = new StringBuilder().append("CMake '");
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        throw (Throwable)new RuntimeException(stringBuilder.append(revision).append("' was not found in ").append("PATH or by cmake.dir property.").append(unsuitableCMakes).toString());
    }

    @Nullable
    public final String getCmakeVersionFromDsl() {
        return this.cmakeVersionFromDsl;
    }

    @NotNull
    public final Function1<String, Unit> getWarn() {
        return this.warn;
    }

    @NotNull
    public final Function1<String, Unit> getInfo() {
        return this.info;
    }

    public CmakeSearchContext(@Nullable String cmakeVersionFromDsl, @NotNull Function1<? super String, Unit> error2, @NotNull Function1<? super String, Unit> warn, @NotNull Function1<? super String, Unit> info) {
        List list;
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        Intrinsics.checkParameterIsNotNull(warn, (String)"warn");
        Intrinsics.checkParameterIsNotNull(info, (String)"info");
        this.cmakeVersionFromDsl = cmakeVersionFromDsl;
        this.warn = warn;
        this.info = info;
        CmakeSearchContext cmakeSearchContext = this;
        cmakeSearchContext.unsuitableCmakeReasons = list = (List)new ArrayList();
        this.error = (Function1)new Function1<String, Unit>(this, error2){
            final /* synthetic */ CmakeSearchContext this$0;
            final /* synthetic */ Function1 $error;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                if (this.this$0.getFirstError() == null) {
                    this.this$0.setFirstError(message);
                }
                this.$error.invoke((Object)message);
            }
            {
                this.this$0 = cmakeSearchContext;
                this.$error = function1;
                super(1);
            }
        };
    }
}

