/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.ide.MajorMinorVersion;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.Version;
import com.google.common.base.Splitter;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ANDROID_GRADLE_PLUGIN_VERSION", "Lcom/android/build/gradle/internal/ide/MajorMinorVersion;", "SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "parseVersion", "version", "", "verifyStudioIsNotOld", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "injectedVersion", "androidGradlePluginVersion", "gradle"})
@JvmName(name="StudioVersions")
public final class StudioVersions {
    private static final Splitter SPLITTER = Splitter.on((char)'.');
    private static final MajorMinorVersion ANDROID_GRADLE_PLUGIN_VERSION;

    public static final void verifyStudioIsNotOld(@NotNull ProjectOptions projectOptions) {
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        StudioVersions.verifyStudioIsNotOld(projectOptions.get(StringOption.IDE_ANDROID_STUDIO_VERSION), ANDROID_GRADLE_PLUGIN_VERSION);
    }

    public static final void verifyStudioIsNotOld(@Nullable String injectedVersion, @NotNull MajorMinorVersion androidGradlePluginVersion) {
        Intrinsics.checkParameterIsNotNull((Object)androidGradlePluginVersion, (String)"androidGradlePluginVersion");
        if (injectedVersion == null) {
            return;
        }
        MajorMinorVersion majorMinorVersion = StudioVersions.parseVersion(injectedVersion);
        if (majorMinorVersion == null) {
            throw (Throwable)new InvalidUserDataException("Invalid injected android studio version '" + injectedVersion + "', expected to be of the form 'w.x.y.z'");
        }
        MajorMinorVersion parsedInjected = majorMinorVersion;
        if (parsedInjected.compareTo(androidGradlePluginVersion) < 0) {
            throw (Throwable)new RuntimeException("This version of Android Studio cannot open this project, please retry with Android Studio " + androidGradlePluginVersion + " or newer.");
        }
    }

    @Nullable
    public static final MajorMinorVersion parseVersion(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Iterator segments = SPLITTER.split((CharSequence)version).iterator();
        if (!segments.hasNext()) {
            return null;
        }
        Object t = segments.next();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"segments.next()");
        Integer n = StringsKt.toIntOrNull((String)((String)t));
        if (n == null) {
            return null;
        }
        int majorVersion = n;
        if (!segments.hasNext()) {
            return null;
        }
        Object t2 = segments.next();
        Intrinsics.checkExpressionValueIsNotNull(t2, (String)"segments.next()");
        Integer n2 = StringsKt.toIntOrNull((String)((String)t2));
        if (n2 == null) {
            return null;
        }
        int minorVersion = n2;
        if (majorVersion < 0 || minorVersion < 0) {
            return null;
        }
        return new MajorMinorVersion(majorVersion, minorVersion);
    }

    static {
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Version.ANDROID_GRADLE_PLUGIN_VERSION");
        MajorMinorVersion majorMinorVersion = StudioVersions.parseVersion(string);
        if (majorMinorVersion == null) {
            Intrinsics.throwNpe();
        }
        ANDROID_GRADLE_PLUGIN_VERSION = majorMinorVersion;
    }
}

