/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.internal.BaseConfigAdapter;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.OldPostProcessingOptions;
import com.android.build.gradle.internal.core.PostProcessingBlockOptions;
import com.android.build.gradle.internal.core.PostProcessingOptions;
import com.android.build.gradle.internal.dependency.AndroidTestResourceArtifactCollection;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.FilteredArtifactCollection;
import com.android.build.gradle.internal.dependency.FilteringSpec;
import com.android.build.gradle.internal.dependency.SubtractingArtifactCollection;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GenericVariantScopeImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantBuildArtifactsHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.DeploymentDevice;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.BootClasspathBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.BaseConfig;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;

public class VariantScopeImpl
extends GenericVariantScopeImpl
implements VariantScope {
    private static final ILogger LOGGER = LoggerWrapper.getLogger(VariantScopeImpl.class);
    private static final String PUBLISH_ERROR_MSG = "Publishing to %1$s with no %1$s configuration object. VariantType: %2$s";
    private final PublishingSpecs.VariantSpec variantPublishingSpec;
    private final GlobalScope globalScope;
    private final BaseVariantData variantData;
    private final TransformManager transformManager;
    private final Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private BuildArtifactsHolder buildArtifactsHolder;
    private final MutableTaskContainer taskContainer = new MutableTaskContainer();
    private InstantRunTaskManager instantRunTaskManager;
    private final Supplier<ConfigurableFileCollection> desugarTryWithResourcesRuntimeJar;
    private FileCollection bootClasspath;
    private final PostProcessingOptions postProcessingOptions;
    private final InstantRunBuildContext instantRunBuildContext;

    public VariantScopeImpl(GlobalScope globalScope, TransformManager transformManager, BaseVariantData variantData) {
        this.globalScope = globalScope;
        this.transformManager = transformManager;
        this.variantData = variantData;
        this.variantPublishingSpec = PublishingSpecs.getVariantSpec(this.getType());
        ProjectOptions projectOptions = globalScope.getProjectOptions();
        this.instantRunBuildContext = new InstantRunBuildContext(variantData.getVariantConfiguration().isInstantRunBuild(globalScope), DeploymentDevice.getDeploymentDeviceAndroidVersion(projectOptions), projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI), projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY), projectOptions.get(BooleanOption.ENABLE_SEPARATE_APK_RESOURCES));
        this.buildArtifactsHolder = new VariantBuildArtifactsHolder(this.getProject(), this.getFullVariantName(), globalScope.getBuildDir(), globalScope.getDslScope());
        this.desugarTryWithResourcesRuntimeJar = Suppliers.memoize(() -> this.getProject().files(new Object[]{FileUtils.join((File)globalScope.getIntermediatesDir(), (String[])new String[]{"processing-tools", "runtime-deps", this.getVariantConfiguration().getDirName(), "desugar_try_with_resources.jar"})}));
        this.postProcessingOptions = this.createPostProcessingOptions();
    }

    private PostProcessingOptions createPostProcessingOptions() {
        BuildType dslBuildType;
        CoreBuildType buildType = (CoreBuildType)this.variantData.getVariantConfiguration().getBuildType();
        if (buildType instanceof BuildType && (dslBuildType = (BuildType)buildType).getPostProcessingConfiguration() == BuildType.PostProcessingConfiguration.POSTPROCESSING_BLOCK) {
            return new PostProcessingBlockOptions(dslBuildType.getPostprocessing(), this.getType().isTestComponent());
        }
        return new OldPostProcessingOptions(buildType, this.globalScope.getProject());
    }

    protected Project getProject() {
        return this.globalScope.getProject();
    }

    @Override
    public PublishingSpecs.VariantSpec getPublishingSpec() {
        return this.variantPublishingSpec;
    }

    @Override
    public MutableTaskContainer getTaskContainer() {
        return this.taskContainer;
    }

    @Override
    public void publishIntermediateArtifact(BuildableArtifact artifact, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Provider file = this.getProject().provider(() -> (File)Iterables.getOnlyElement((Iterable)artifact.getFiles()));
        Preconditions.checkState((!configTypes.isEmpty() ? 1 : 0) != 0);
        VariantDependencies variantDependency = this.getVariantDependencies();
        for (AndroidArtifacts.PublishedConfigType configType : AndroidArtifacts.PublishedConfigType.values()) {
            if (!configTypes.contains((Object)configType)) continue;
            Configuration config2 = variantDependency.getElements(configType);
            Preconditions.checkNotNull((Object)config2, (Object)String.format(PUBLISH_ERROR_MSG, new Object[]{configType, this.getType()}));
            ArtifactPublishingUtil.publishArtifactToConfiguration(config2, file, artifact, artifactType);
        }
    }

    @Override
    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    public BaseVariantData getVariantData() {
        return this.variantData;
    }

    @Override
    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantData.getVariantConfiguration();
    }

    @Override
    public String getFullVariantName() {
        return this.getVariantConfiguration().getFullName();
    }

    @Override
    public boolean useResourceShrinker() {
        if (this.getType().isForTesting() || this.instantRunBuildContext.isInInstantRunMode() || !this.postProcessingOptions.resourcesShrinkingEnabled()) {
            return false;
        }
        if (this.getType().isFeatureSplit() || this.globalScope.hasDynamicFeatures()) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Resource shrinker cannot be used for multi-apk applications"));
            return false;
        }
        if (this.getType().isAar()) {
            if (!this.getProject().getPlugins().hasPlugin("com.android.feature")) {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Resource shrinker cannot be used for libraries."));
            }
            return false;
        }
        if (this.getCodeShrinker() == null) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Removing unused resources requires unused code shrinking to be turned on. See http://d.android.com/r/tools/shrink-resources.html for more information."));
            return false;
        }
        return true;
    }

    @Override
    public boolean isCrunchPngs() {
        Boolean buildTypeOverride = ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isCrunchPngs();
        if (buildTypeOverride != null) {
            return buildTypeOverride;
        }
        Boolean globalOverride = this.globalScope.getExtension().getAaptOptions().getCruncherEnabledOverride();
        if (globalOverride != null) {
            return globalOverride;
        }
        return ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isCrunchPngsDefault();
    }

    @Override
    public boolean consumesFeatureJars() {
        return this.getType().isBaseModule() && ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isMinifyEnabled() && this.globalScope.hasDynamicFeatures();
    }

    @Override
    public boolean getNeedsMainDexListForBundle() {
        return this.getType().isBaseModule() && this.globalScope.hasDynamicFeatures() && this.getVariantConfiguration().getDexingType().getNeedsMainDexList();
    }

    @Override
    public CodeShrinker getCodeShrinker() {
        boolean isTestComponent = this.getType().isTestComponent();
        if (isTestComponent && this.getTestedVariantData().getType().isAar()) {
            return null;
        }
        CodeShrinker codeShrinker = this.postProcessingOptions.getCodeShrinker();
        if (codeShrinker != null && this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_R8)) {
            return CodeShrinker.R8;
        }
        return codeShrinker;
    }

    @Override
    public List<File> getProguardFiles() {
        List<File> result = this.getExplicitProguardFiles();
        if (result.isEmpty()) {
            return this.postProcessingOptions.getDefaultProguardFiles();
        }
        return result;
    }

    @Override
    public List<File> getExplicitProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.EXPLICIT);
    }

    @Override
    public List<File> getTestProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.TEST);
    }

    @Override
    public List<File> getConsumerProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.CONSUMER);
    }

    @Override
    public List<File> getConsumerProguardFilesForFeatures() {
        boolean hasFeaturePlugin = this.getProject().getPlugins().hasPlugin(FeaturePlugin.class);
        boolean includeProguardFiles = hasFeaturePlugin || this.getType().isDynamicFeature();
        List<File> consumerProguardFiles = this.getConsumerProguardFiles();
        if (includeProguardFiles) {
            consumerProguardFiles.addAll(this.getExplicitProguardFiles());
        }
        return ImmutableList.copyOf(consumerProguardFiles);
    }

    private List<File> gatherProguardFiles(ProguardFileType type) {
        GradleVariantConfiguration variantConfiguration = this.getVariantConfiguration();
        ArrayList<File> result = new ArrayList<File>(BaseConfigAdapter.getProguardFiles(variantConfiguration.getDefaultConfig(), type));
        result.addAll(this.postProcessingOptions.getProguardFiles(type));
        for (CoreProductFlavor flavor : variantConfiguration.getProductFlavors()) {
            result.addAll(BaseConfigAdapter.getProguardFiles((BaseConfig)flavor, type));
        }
        return result;
    }

    @Override
    public PostprocessingFeatures getPostprocessingFeatures() {
        return this.postProcessingOptions.getPostprocessingFeatures();
    }

    @Override
    public boolean isTestOnly() {
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        Boolean isTestOnlyOverride = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (isTestOnlyOverride != null) {
            return isTestOnlyOverride;
        }
        return !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) || !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY)) || projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null || this.globalScope.getAndroidBuilder().isPreviewTarget() || this.getMinSdkVersion().getCodename() != null || this.getVariantConfiguration().getTargetSdkVersion().getCodename() != null;
    }

    @Override
    public VariantType getType() {
        return this.variantData.getType();
    }

    @Override
    public DexingType getDexingType() {
        if (this.instantRunBuildContext.isInInstantRunMode()) {
            return DexingType.NATIVE_MULTIDEX;
        }
        return this.variantData.getVariantConfiguration().getDexingType();
    }

    @Override
    public boolean getNeedsMainDexList() {
        return this.getDexingType().getNeedsMainDexList();
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        return this.getVariantConfiguration().getMinSdkVersion();
    }

    @Override
    public String getDirName() {
        return this.getVariantConfiguration().getDirName();
    }

    @Override
    public Collection<String> getDirectorySegments() {
        return this.getVariantConfiguration().getDirectorySegments();
    }

    @Override
    public TransformManager getTransformManager() {
        return this.transformManager;
    }

    @Override
    public String getTaskName(String prefix) {
        return this.getTaskName(prefix, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return this.variantData.getTaskName(prefix, suffix);
    }

    @Override
    public File getNdkDebuggableLibraryFolders(Abi abi) {
        return this.ndkDebuggableLibraryFolders.get((Object)abi);
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public BaseVariantData getTestedVariantData() {
        return this.variantData instanceof TestVariantData ? (BaseVariantData)((Object)((TestVariantData)this.variantData).getTestedVariantData()) : null;
    }

    @Override
    public File getBuildInfoOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/build-info/" + this.getDirName());
    }

    @Override
    public File getReloadDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/reload-dex/" + this.getDirName());
    }

    @Override
    public File getRestartDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/restart-dex/" + this.getDirName());
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/split-apk/" + this.getDirName());
    }

    @Override
    public File getDefaultInstantRunApkLocation() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"instant-run-apk"});
    }

    @Override
    public File getInstantRunPastIterationsFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/builds/" + this.getDirName());
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType) {
        return this.getJavaClasspath(configType, classesType, null);
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        FileCollection mainCollection = this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        mainCollection = mainCollection.plus(this.variantData.getGeneratedBytecode(generatedBytecodeKey));
        if (this.globalScope.getExtension().getAaptOptions().getNamespaced()) {
            BaseVariantData tested;
            mainCollection = mainCollection.plus((FileCollection)this.buildArtifactsHolder.getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR).get());
            mainCollection = mainCollection.plus(this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR));
            mainCollection = mainCollection.plus(this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SHARED_CLASSES));
            if (this.globalScope.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
                FileCollection namespacedClasses = (FileCollection)this.buildArtifactsHolder.getFinalArtifactFiles(InternalArtifactType.NAMESPACED_CLASSES_JAR).get();
                mainCollection = mainCollection.plus(namespacedClasses);
                FileCollection namespacedRClasses = (FileCollection)this.buildArtifactsHolder.getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NAMESPACED_DEPENDENCIES_R_JAR).get();
                mainCollection = mainCollection.plus(namespacedRClasses);
            }
            if ((tested = this.getTestedVariantData()) != null) {
                mainCollection = mainCollection.plus((FileCollection)tested.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR).get());
            }
        } else {
            BaseVariantData tested;
            if (this.buildArtifactsHolder.hasArtifact(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
                BuildableArtifact rJar = this.buildArtifactsHolder.getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR);
                mainCollection = mainCollection.plus((FileCollection)rJar.get());
            }
            if ((tested = this.getTestedVariantData()) != null && tested.getScope().getArtifacts().hasArtifact(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
                BuildableArtifact rJar = tested.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR);
                mainCollection = mainCollection.plus((FileCollection)rJar.get());
            }
        }
        return mainCollection;
    }

    @Override
    public ArtifactCollection getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        ArtifactCollection mainCollection = this.getArtifactCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        return ArtifactCollectionWithExtraArtifact.makeExtraCollection(mainCollection, this.variantData.getGeneratedBytecode(generatedBytecodeKey), this.getProject().getPath());
    }

    @Override
    public boolean keepDefaultBootstrap() {
        if (!JavaVersion.current().isJava8Compatible()) {
            return false;
        }
        VariantScope.Java8LangSupport java8LangSupport = this.getJava8LangSupportType();
        return java8LangSupport == VariantScope.Java8LangSupport.DESUGAR || java8LangSupport == VariantScope.Java8LangSupport.D8 || java8LangSupport == VariantScope.Java8LangSupport.R8;
    }

    @Override
    public File getManifestCheckerDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/manifest-checker/" + this.getDirName());
    }

    @Override
    public File getIncrementalRuntimeSupportJar() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-runtime-classes/" + this.getDirName() + "/instant-run.jar");
    }

    @Override
    public File getInstantRunResourcesFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"instant-run-resources", "resources-" + this.getDirName() + ".ir.ap_"});
    }

    @Override
    public File getIncrementalVerifierDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-verifier/" + this.getDirName());
    }

    @Override
    public BuildArtifactsHolder getArtifacts() {
        return this.buildArtifactsHolder;
    }

    @Override
    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.getArtifactFileCollection(configType, scope, artifactType, null);
    }

    @Override
    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        FileCollection fileCollection;
        ArtifactCollection artifacts = this.computeArtifactCollection(configType, scope, artifactType, attributeMap);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getType().isFeatureSplit() && artifactType != AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS) {
            FileCollection excludedDirectories = this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS, attributeMap).getArtifactFiles();
            fileCollection = new FilteringSpec(artifacts, excludedDirectories).getFilteredFileCollection(this.getProject());
        } else {
            fileCollection = artifacts.getArtifactFiles();
        }
        if (configType.needsTestedComponents()) {
            return this.handleTestedComponent(fileCollection, configType, scope, artifactType, attributeMap, (mainCollection, testedCollection, unused) -> mainCollection.plus(testedCollection), (collection, artifactCollection) -> collection.minus(artifactCollection.getArtifactFiles()), (collection, artifactCollection) -> {
                throw new RuntimeException("Can't do smart subtraction on a file collection");
            });
        }
        return fileCollection;
    }

    @Override
    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        ArtifactCollection artifacts = this.computeArtifactCollection(configType, scope, artifactType);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getType().isFeatureSplit() && artifactType != AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS) {
            FileCollection excludedDirectories = this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS).getArtifactFiles();
            artifacts = new FilteredArtifactCollection(this.getProject(), new FilteringSpec(artifacts, excludedDirectories));
        }
        if (configType.needsTestedComponents()) {
            return this.handleTestedComponent(artifacts, configType, scope, artifactType, Collections.emptyMap(), (artifactResults, collection, variantName) -> ArtifactCollectionWithExtraArtifact.makeExtraCollectionForTest(artifactResults, collection, this.getProject().getPath(), variantName), SubtractingArtifactCollection::new, (testArtifact, testedArtifact) -> new AndroidTestResourceArtifactCollection((ArtifactCollection)testArtifact, (Collection<? extends Dependency>)this.getVariantDependencies().getIncomingRuntimeDependencies(), this.getVariantDependencies().getRuntimeClasspath().getIncoming()));
        }
        return artifacts;
    }

    @Override
    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        return this.computeArtifactCollection(configType, scope, artifactType, attributeMap);
    }

    private Configuration getConfiguration(AndroidArtifacts.ConsumedConfigType configType) {
        switch (configType) {
            case COMPILE_CLASSPATH: {
                return this.getVariantDependencies().getCompileClasspath();
            }
            case RUNTIME_CLASSPATH: {
                return this.getVariantDependencies().getRuntimeClasspath();
            }
            case ANNOTATION_PROCESSOR: {
                return this.getVariantDependencies().getAnnotationProcessorConfiguration();
            }
            case METADATA_VALUES: {
                return (Configuration)Preconditions.checkNotNull((Object)this.getVariantDependencies().getMetadataValuesConfiguration());
            }
        }
        throw new RuntimeException("unknown ConfigType value " + (Object)((Object)configType));
    }

    private ArtifactCollection computeArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        return this.computeArtifactCollection(configType, scope, artifactType, null);
    }

    private ArtifactCollection computeArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap) {
        Configuration configuration = this.getConfiguration(configType);
        Action attributes2 = container -> {
            container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)artifactType.getType());
            if (attributeMap != null) {
                for (Attribute attribute : attributeMap.keySet()) {
                    container.attribute(attribute, attributeMap.get(attribute));
                }
            }
        };
        Spec<ComponentIdentifier> filter = VariantScopeImpl.getComponentFilter(scope);
        boolean lenientMode = Boolean.TRUE.equals(this.globalScope.getProjectOptions().get(BooleanOption.IDE_BUILD_MODEL_ONLY));
        return configuration.getIncoming().artifactView(config2 -> {
            config2.attributes(attributes2);
            if (filter != null) {
                config2.componentFilter(filter);
            }
            config2.lenient(lenientMode);
        }).getArtifacts();
    }

    private static Spec<ComponentIdentifier> getComponentFilter(AndroidArtifacts.ArtifactScope scope) {
        switch (scope) {
            case ALL: {
                return null;
            }
            case EXTERNAL: {
                return id -> !(id instanceof ProjectComponentIdentifier);
            }
            case MODULE: {
                return id -> id instanceof ProjectComponentIdentifier;
            }
        }
        throw new RuntimeException("unknown ArtifactScope value");
    }

    @Override
    public FileCollection getLocalPackagedJars() {
        Configuration configuration = this.getVariantDependencies().getRuntimeClasspath();
        Callable<Collection> dependencies = () -> (ImmutableList)configuration.getAllDependencies().stream().filter(it -> it instanceof SelfResolvingDependency).filter(it -> !(it instanceof ProjectDependency)).map(it -> (SelfResolvingDependency)it).collect(ImmutableList.toImmutableList());
        return this.getProject().files(new Object[]{() -> ((Collection)dependencies.call()).stream().flatMap(it -> it.resolve().stream()).collect(Collectors.toList())}).builtBy(new Object[]{dependencies});
    }

    @Override
    public FileCollection getProvidedOnlyClasspath() {
        FileCollection compile2 = this.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        FileCollection pkg = this.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        return compile2.minus(pkg);
    }

    private File intermediate(String directoryName) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{directoryName, this.getDirName()});
    }

    private File intermediate(String directoryName, String fileName) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{directoryName, this.getDirName(), fileName});
    }

    @Override
    public File getIntermediateJarOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/intermediate-jars/" + this.getDirName());
    }

    @Override
    public File getDefaultMergeResourcesOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "merged", this.getDirName()});
    }

    @Override
    public File getCompiledResourcesOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"res", "compiled", this.getDirName()});
    }

    @Override
    public File getResourceBlameLogDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"blame", "res", this.getDirectorySegments()}));
    }

    @Override
    public File getBuildConfigSourceOutputDir() {
        return new File(this.globalScope.getBuildDir() + "/" + "generated" + "/source/buildConfig/" + this.getDirName());
    }

    private File getGeneratedResourcesDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"res", name, this.getDirectorySegments()}));
    }

    @Override
    public File getGeneratedResOutputDir() {
        return this.getGeneratedResourcesDir("resValues");
    }

    @Override
    public File getGeneratedPngsOutputDir() {
        return this.getGeneratedResourcesDir("pngs");
    }

    @Override
    public File getRenderscriptResOutputDir() {
        return this.getGeneratedResourcesDir("rs");
    }

    @Override
    public File getRenderscriptObjOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"rs", this.getDirectorySegments(), "obj"}));
    }

    @Override
    public File getSourceFoldersJavaResDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "sourceFolderJavaResources/" + this.getDirName());
    }

    @Override
    public File getIncrementalDir(String name) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"incremental", name});
    }

    @Override
    public File getAarClassesJar() {
        return this.intermediate("packaged-classes", "classes.jar");
    }

    @Override
    public File getAarLibsDirectory() {
        return this.intermediate("packaged-classes", "libs");
    }

    @Override
    public File getCoverageReportDir() {
        return new File(this.globalScope.getReportsDir(), "coverage/" + this.getDirName());
    }

    @Override
    public File getClassOutputForDataBinding() {
        return new File(this.globalScope.getGeneratedDir(), "source/dataBinding/trigger/" + this.getDirName());
    }

    @Override
    public File getGeneratedClassListOutputFileForDataBinding() {
        return new File(this.dataBindingIntermediate("class-list"), "_generated.txt");
    }

    @Override
    public File getBundleArtifactFolderForDataBinding() {
        return this.dataBindingIntermediate("bundle-bin");
    }

    private File dataBindingIntermediate(String name) {
        return this.intermediate("data-binding", name);
    }

    @Override
    public File getProcessAndroidResourcesProguardOutputFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"proguard-rules", this.getDirName(), "aapt_rules.txt"});
    }

    @Override
    public File getFullApkPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "full", this.getDirName()}));
    }

    @Override
    public File getInstantRunResourceApkFolder() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"resources", "instant-run", this.getDirName()});
    }

    @Override
    public File getIntermediateDir(InternalArtifactType taskOutputType) {
        return this.intermediate(taskOutputType.name().toLowerCase(Locale.US));
    }

    @Override
    public File getMicroApkManifestFile() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"manifests", "microapk", this.getDirName(), "AndroidManifest.xml"});
    }

    @Override
    public File getMicroApkResDirectory() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"res", "microapk", this.getDirName()});
    }

    @Override
    public File getManifestOutputDirectory() {
        VariantType variantType = this.getType();
        if (variantType.isTestComponent()) {
            if (variantType.isApk()) {
                return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifest", this.getDirName()});
            }
        } else {
            return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "full", this.getDirName()});
        }
        throw new RuntimeException("getManifestOutputDirectory called for an unexpected variant.");
    }

    @Override
    public File getApkLocation() {
        String override = this.globalScope.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
        File defaultLocation = this.instantRunBuildContext.isInInstantRunMode() ? this.getDefaultInstantRunApkLocation() : this.getDefaultApkLocation();
        File baseDirectory = override != null && !this.getType().isHybrid() ? this.getProject().file((Object)override) : defaultLocation;
        return new File(baseDirectory, this.getDirName());
    }

    private File getDefaultApkLocation() {
        return FileUtils.join((File)this.globalScope.getBuildDir(), (String[])new String[]{"outputs", "apk"});
    }

    @Override
    public File getMergedClassesJarFile() {
        String fileName = this.getType().isBaseModule() ? "base.jar" : TaskManager.getFeatureFileName(this.getProject().getPath(), ".jar");
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"merged-classes", this.getDirName(), fileName});
    }

    @Override
    public File getAarLocation() {
        return FileUtils.join((File)this.globalScope.getOutputsDir(), (String[])new String[]{"aar"});
    }

    @Override
    public File getAnnotationProcessorOutputDir() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"source", "apt", this.getDirName()});
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.instantRunBuildContext;
    }

    @Override
    public ImmutableList<File> getInstantRunBootClasspath() {
        SdkHandler sdkHandler = this.globalScope.getSdkHandler();
        AndroidBuilder androidBuilder = this.globalScope.getAndroidBuilder();
        IAndroidTarget androidBuilderTarget = androidBuilder.getTarget();
        File annotationsJar = sdkHandler.getSdkLoader().getSdkInfo(LOGGER).getAnnotationsJar();
        AndroidVersion targetDeviceVersion = DeploymentDevice.getDeploymentDeviceAndroidVersion(this.globalScope.getProjectOptions());
        if (targetDeviceVersion.equals((Object)androidBuilderTarget.getVersion())) {
            return BootClasspathBuilder.computeFullBootClasspath((IAndroidTarget)androidBuilderTarget, (File)annotationsJar);
        }
        IAndroidTarget targetToUse = VariantScopeImpl.getAndroidTarget(sdkHandler, AndroidTargetHash.getPlatformHashString((AndroidVersion)targetDeviceVersion));
        if (targetToUse == null) {
            throw new RuntimeException(String.format("In order to use Instant Run with this device running %1$S, you must install platform %1$S in your SDK", targetDeviceVersion.toString()));
        }
        return BootClasspathBuilder.computeFullBootClasspath((IAndroidTarget)targetToUse, (File)annotationsJar);
    }

    private static IAndroidTarget getAndroidTarget(SdkHandler sdkHandler, String targetHash) {
        File sdkLocation = sdkHandler.getSdkFolder();
        LoggerProgressIndicatorWrapper progressIndicator = new LoggerProgressIndicatorWrapper(LOGGER);
        IAndroidTarget target = AndroidSdkHandler.getInstance((File)sdkLocation).getAndroidTargetManager((ProgressIndicator)progressIndicator).getTargetFromHashString(targetHash, (ProgressIndicator)progressIndicator);
        if (target != null) {
            return target;
        }
        AndroidSdkHandler.resetInstance((File)sdkLocation);
        return AndroidSdkHandler.getInstance((File)sdkLocation).getAndroidTargetManager((ProgressIndicator)progressIndicator).getTargetFromHashString(targetHash, (ProgressIndicator)progressIndicator);
    }

    @Override
    public InstantRunTaskManager getInstantRunTaskManager() {
        return this.instantRunTaskManager;
    }

    @Override
    public void setInstantRunTaskManager(InstantRunTaskManager instantRunTaskManager) {
        this.instantRunTaskManager = instantRunTaskManager;
    }

    @Override
    public TransformVariantScope getTransformVariantScope() {
        return this;
    }

    private <T> T handleTestedComponent(T collection, AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope artifactScope, AndroidArtifacts.ArtifactType artifactType, Map<Attribute<String>, String> attributeMap, TriFunction<T, FileCollection, String, T> plusFunction, BiFunction<T, ArtifactCollection, T> minusFunction, BiFunction<T, ArtifactCollection, T> resourceMinusFunction) {
        VariantType variantType = this.getType();
        if (!variantType.isTestComponent()) {
            return collection;
        }
        T result = collection;
        if (this.variantData instanceof TestVariantData) {
            ImmutableList<AndroidArtifacts.PublishedConfigType> publishedConfigs;
            PublishingSpecs.VariantSpec testedSpec;
            PublishingSpecs.OutputSpec taskOutputSpec;
            TestedVariantData tested = ((TestVariantData)this.variantData).getTestedVariantData();
            VariantScope testedScope = tested.getScope();
            if ((artifactScope == AndroidArtifacts.ArtifactScope.MODULE || artifactScope == AndroidArtifacts.ArtifactScope.ALL) && (taskOutputSpec = (testedSpec = testedScope.getPublishingSpec().getTestingSpec(variantType)).getSpec(artifactType)) != null && (publishedConfigs = taskOutputSpec.getPublishedConfigTypes()).contains((Object)configType.getPublishedTo())) {
                ArtifactType taskOutputType = taskOutputSpec.getOutputType();
                if (testedScope.getArtifacts().hasArtifact(taskOutputType)) {
                    result = plusFunction.apply(result, (FileCollection)testedScope.getArtifacts().getFinalArtifactFiles(taskOutputType).get(), testedScope.getFullVariantName());
                }
            }
            if (tested instanceof ApplicationVariantData && configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && variantType.isTestComponent() && variantType.isApk()) {
                ArtifactCollection testedArtifactCollection = testedScope.getArtifactCollection(configType, artifactScope, artifactType, attributeMap);
                result = artifactType == AndroidArtifacts.ArtifactType.ANDROID_RES ? resourceMinusFunction.apply(result, testedArtifactCollection) : minusFunction.apply(result, testedArtifactCollection);
            }
        }
        return result;
    }

    @Override
    public OutputScope getOutputScope() {
        return this.variantData.getOutputScope();
    }

    @Override
    public VariantDependencies getVariantDependencies() {
        return this.variantData.getVariantDependency();
    }

    @Override
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        if (!this.globalScope.getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            return VariantScope.Java8LangSupport.UNUSED;
        }
        if (this.getProject().getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            return VariantScope.Java8LangSupport.RETROLAMBDA;
        }
        CodeShrinker shrinker = this.getCodeShrinker();
        if (shrinker == CodeShrinker.R8) {
            if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_R8_DESUGARING) && this.isValidJava8Flag(BooleanOption.ENABLE_R8_DESUGARING, BooleanOption.ENABLE_R8)) {
                return VariantScope.Java8LangSupport.R8;
            }
        } else if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8_DESUGARING) && this.isValidJava8Flag(BooleanOption.ENABLE_D8_DESUGARING, BooleanOption.ENABLE_D8)) {
            return VariantScope.Java8LangSupport.D8;
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DESUGAR)) {
            return VariantScope.Java8LangSupport.DESUGAR;
        }
        BooleanOption missingFlag = shrinker == CodeShrinker.R8 ? BooleanOption.ENABLE_R8_DESUGARING : BooleanOption.ENABLE_D8_DESUGARING;
        this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(String.format("Please add '%s=true' to your gradle.properties file to enable Java 8 language support.", missingFlag.name()), this.getVariantConfiguration().getFullName()));
        return VariantScope.Java8LangSupport.INVALID;
    }

    private boolean isValidJava8Flag(BooleanOption flag, BooleanOption ... dependsOn2) {
        ArrayList invalid = null;
        for (BooleanOption requiredFlag : dependsOn2) {
            if (this.globalScope.getProjectOptions().get(requiredFlag)) continue;
            if (invalid == null) {
                invalid = Lists.newArrayList();
            }
            invalid.add("'" + requiredFlag.getPropertyName() + "= false'");
        }
        if (invalid == null) {
            return true;
        }
        String template = "Java 8 language support, as requested by '%s= true' in your gradle.properties file, is not supported when %s.";
        String msg = String.format(template, flag.getPropertyName(), invalid.stream().collect(Collectors.joining(",")));
        this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(msg, this.getVariantConfiguration().getFullName()));
        return false;
    }

    @Override
    public ConfigurableFileCollection getTryWithResourceRuntimeSupportJar() {
        return this.desugarTryWithResourcesRuntimeJar.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getFullVariantName()).toString();
    }

    @Override
    public DexerTool getDexer() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexerTool.D8;
        }
        return DexerTool.DX;
    }

    @Override
    public DexMergerTool getDexMerger() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexMergerTool.D8;
        }
        return DexMergerTool.DX;
    }

    @Override
    public File getOutputProguardMappingFile() {
        return FileUtils.join((File)this.globalScope.getBuildDir(), (String[])new String[]{"outputs", "mapping", "r8", this.getVariantConfiguration().getDirName(), "mapping.txt"});
    }

    @Override
    public FileCollection getBootClasspath() {
        return this.globalScope.getBootClasspath();
    }

    @Override
    public InternalArtifactType getManifestArtifactType() {
        return this.globalScope.getProjectOptions().get(BooleanOption.DEPLOY_AS_INSTANT_APP) ? InternalArtifactType.INSTANT_APP_MANIFEST : (this.instantRunBuildContext.isInInstantRunMode() ? InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS : InternalArtifactType.MERGED_MANIFESTS);
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

