/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import kotlin.jvm.functions.Function2;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

public class InstantRunResourcesApkBuilder
extends AndroidBuilderTask {
    public static final String APK_FILE_NAME = "resources";
    private AndroidBuilder androidBuilder;
    private InstantRunBuildContext instantRunBuildContext;
    private File outputDirectory;
    private CoreSigningConfig signingConf;
    private File supportDirectory;
    private BuildableArtifact resources;
    private InternalArtifactType resInputType;

    @Nested
    @Optional
    public CoreSigningConfig getSigningConf() {
        return this.signingConf;
    }

    @Input
    public String getResInputType() {
        return this.resInputType.name();
    }

    @Input
    public String getPatchingPolicy() {
        return this.instantRunBuildContext.getPatchingPolicy().name();
    }

    @InputFiles
    public BuildableArtifact getResourcesFile() {
        return this.resources;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    protected void doFullTaskAction() {
        if (this.instantRunBuildContext.getPatchingPolicy() != InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
            this.getResInputBuildArtifacts().forEach(buildOutput -> {
                ApkInfo apkInfo = buildOutput.getApkInfo();
                File outputFile = new File(this.outputDirectory, InstantRunResourcesApkBuilder.mangleApkName(apkInfo) + ".apk");
                try {
                    FileUtils.deleteIfExists((File)outputFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            return;
        }
        this.getResInputBuildArtifacts().transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(apkData, input2) -> {
            try {
                if (input2 == null) {
                    return null;
                }
                File outputFile = new File(this.outputDirectory, InstantRunResourcesApkBuilder.mangleApkName(apkData) + ".apk");
                FileUtils.deleteIfExists((File)outputFile);
                Files.createParentDirs((File)outputFile);
                File tempDir = new File(this.supportDirectory, "package_" + InstantRunResourcesApkBuilder.mangleApkName(apkData));
                FileUtils.cleanOutputDir((File)tempDir);
                this.androidBuilder.packageCodeSplitApk(input2, (Set)ImmutableSet.of(), (SigningConfig)this.signingConf, outputFile, tempDir, ApkCreatorFactories.fromProjectProperties(this.getProject(), true));
                this.instantRunBuildContext.addChangedFile(FileType.SPLIT, outputFile);
                return outputFile;
            }
            catch (PackagerException | KeytoolException | IOException e) {
                throw new BuildException("Exception while creating resources split APK", e);
            }
        })).into(InternalArtifactType.INSTANT_RUN_PACKAGED_RESOURCES, this.outputDirectory);
    }

    protected BuildElements getResInputBuildArtifacts() {
        return ExistingBuildElements.from((ArtifactType)this.resInputType, this.resources);
    }

    static String mangleApkName(ApkInfo apkData) {
        return "resources-" + apkData.getBaseName();
    }

    public static class CreationAction
    extends TaskCreationAction<InstantRunResourcesApkBuilder> {
        protected final VariantScope variantScope;
        private final InternalArtifactType resInputType;

        public CreationAction(InternalArtifactType resInputType, VariantScope scope) {
            this.resInputType = resInputType;
            this.variantScope = scope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("processInstantRun", "ResourcesApk");
        }

        @Override
        public Class<InstantRunResourcesApkBuilder> getType() {
            return InstantRunResourcesApkBuilder.class;
        }

        @Override
        public void configure(InstantRunResourcesApkBuilder resourcesApkBuilder) {
            resourcesApkBuilder.setVariantName(this.variantScope.getFullVariantName());
            resourcesApkBuilder.resInputType = this.resInputType;
            resourcesApkBuilder.supportDirectory = this.variantScope.getIncrementalDir(this.getName());
            resourcesApkBuilder.androidBuilder = this.variantScope.getGlobalScope().getAndroidBuilder();
            resourcesApkBuilder.signingConf = this.variantScope.getVariantConfiguration().getSigningConfig();
            resourcesApkBuilder.instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            resourcesApkBuilder.resources = this.variantScope.getArtifacts().getFinalArtifactFiles(this.resInputType);
            resourcesApkBuilder.outputDirectory = this.variantScope.getInstantRunResourceApkFolder();
        }
    }
}

