/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.incremental.CapturingChangesApkCreator;
import com.android.build.gradle.internal.incremental.FolderBasedApkCreator;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.PackagingUtils;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.gradle.api.Project;

public class IncrementalPackagerBuilder {
    private PrivateKey key;
    private X509Certificate certificate;
    private boolean v1SigningEnabled;
    private boolean v2SigningEnabled;
    private File outputFile;
    private ApkFormat apkFormat;
    private int minSdk = 1;
    private NativeLibrariesPackagingMode nativeLibrariesPackagingMode;
    private Predicate<String> noCompressPredicate;
    private Project project;
    private Boolean keepTimestampsInApk;
    private File intermediateDir;
    private String createdBy;
    private boolean debuggableBuild;
    private boolean jniDebuggableBuild;
    private Set<String> abiFilters = new HashSet<String>();
    private File manifest;
    private Collection<String> aaptOptionsNoCompress;
    private EvalIssueReporter issueReporter;
    private BooleanSupplier canParseManifest;

    public IncrementalPackagerBuilder(ApkFormat apkFormat) {
        this.apkFormat = apkFormat;
    }

    public IncrementalPackagerBuilder withSigning(SigningConfig signingConfig) {
        if (signingConfig == null) {
            return this;
        }
        try {
            String error2 = "SigningConfig \"" + signingConfig.getName() + "\" is missing required property \"%s\".";
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile(), (String)error2, (Object)"storeFile")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword(), (String)error2, (Object)"storePassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword(), (String)error2, (Object)"keyPassword")), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias(), (String)error2, (Object)"keyAlias")));
            this.key = certificateInfo.getKey();
            this.certificate = certificateInfo.getCertificate();
            this.v1SigningEnabled = signingConfig.isV1SigningEnabled();
            this.v2SigningEnabled = signingConfig.isV2SigningEnabled();
        }
        catch (KeytoolException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public IncrementalPackagerBuilder withOutputFile(File f) {
        this.outputFile = f;
        return this;
    }

    public IncrementalPackagerBuilder withMinSdk(int minSdk) {
        this.minSdk = minSdk;
        return this;
    }

    public IncrementalPackagerBuilder withNativeLibraryPackagingMode(NativeLibrariesPackagingMode packagingMode) {
        this.nativeLibrariesPackagingMode = packagingMode;
        return this;
    }

    public IncrementalPackagerBuilder withManifest(File manifest) {
        this.manifest = manifest;
        return this;
    }

    public IncrementalPackagerBuilder withNoCompressPredicate(Predicate<String> noCompressPredicate) {
        this.noCompressPredicate = noCompressPredicate;
        return this;
    }

    public IncrementalPackagerBuilder withAaptOptionsNoCompress(Collection<String> aaptOptionsNoCompress) {
        this.aaptOptionsNoCompress = aaptOptionsNoCompress;
        return this;
    }

    public IncrementalPackagerBuilder withProject(Project project) {
        this.project = project;
        return this;
    }

    public IncrementalPackagerBuilder withKeepTimestampsInApk(boolean keepTimestampsInApk) {
        this.keepTimestampsInApk = keepTimestampsInApk;
        return this;
    }

    public IncrementalPackagerBuilder withIntermediateDir(File intermediateDir) {
        this.intermediateDir = intermediateDir;
        return this;
    }

    public IncrementalPackagerBuilder withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public IncrementalPackagerBuilder withDebuggableBuild(boolean debuggableBuild) {
        this.debuggableBuild = debuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withJniDebuggableBuild(boolean jniDebuggableBuild) {
        this.jniDebuggableBuild = jniDebuggableBuild;
        return this;
    }

    public IncrementalPackagerBuilder withAcceptedAbis(Set<String> acceptedAbis) {
        this.abiFilters = ImmutableSet.copyOf(acceptedAbis);
        return this;
    }

    public IncrementalPackagerBuilder withIssueReporter(EvalIssueReporter issueReporter) {
        this.issueReporter = issueReporter;
        return this;
    }

    public IncrementalPackager build() {
        if (this.project != null) {
            this.keepTimestampsInApk = AndroidGradleOptions.keepTimestampsInApk(this.project);
        }
        Preconditions.checkState((this.outputFile != null ? 1 : 0) != 0, (Object)"outputFile == null");
        Preconditions.checkState((this.keepTimestampsInApk != null ? 1 : 0) != 0, (Object)"keepTimestampsInApk == null");
        Preconditions.checkState((this.intermediateDir != null ? 1 : 0) != 0, (Object)"intermediateDir == null");
        if (this.noCompressPredicate == null) {
            this.noCompressPredicate = this.manifest != null ? PackagingUtils.getNoCompressPredicate(this.aaptOptionsNoCompress, (File)this.manifest, () -> true, (EvalIssueReporter)this.issueReporter) : path -> false;
        }
        if (this.nativeLibrariesPackagingMode == null) {
            this.nativeLibrariesPackagingMode = this.manifest != null ? PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)this.manifest, (BooleanSupplier)this.canParseManifest, (EvalIssueReporter)this.issueReporter) : NativeLibrariesPackagingMode.COMPRESSED;
        }
        SigningOptions signingOptions = new SigningOptions(this.key, this.certificate, this.v1SigningEnabled, this.v2SigningEnabled, this.minSdk);
        ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(this.outputFile, signingOptions, null, this.createdBy, this.nativeLibrariesPackagingMode, this.noCompressPredicate::test);
        try {
            return new IncrementalPackager(creationData, this.intermediateDir, this.apkFormat.factory(this.keepTimestampsInApk, this.debuggableBuild), this.abiFilters, this.jniDebuggableBuild);
        }
        catch (PackagerException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ApkFormat {
        FILE{

            @Override
            ApkCreatorFactory factory(boolean keepTimestampsInApk, boolean debuggableBuild) {
                return ApkCreatorFactories.fromProjectProperties(keepTimestampsInApk, debuggableBuild);
            }
        }
        ,
        FILE_WITH_LIST_OF_CHANGES{

            @Override
            ApkCreatorFactory factory(boolean keepTimestampsInApk, boolean debuggableBuild) {
                ApkCreatorFactory apk = ApkCreatorFactories.fromProjectProperties(keepTimestampsInApk, debuggableBuild);
                return creationData -> new CapturingChangesApkCreator(creationData, apk.make(creationData));
            }
        }
        ,
        DIRECTORY{

            @Override
            ApkCreatorFactory factory(boolean keepTimestampsInApk, boolean debuggableBuild) {
                return creationData -> new CapturingChangesApkCreator(creationData, new FolderBasedApkCreator(creationData));
            }
        };


        abstract ApkCreatorFactory factory(boolean var1, boolean var2);
    }
}

