/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.core.CoreSigningConfigImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkerExecutor;

public class PackageSplitRes
extends AndroidBuilderTask {
    private SigningConfig signingConfig;
    private File incrementalDir;
    public BuildableArtifact processedResources;
    public File splitResApkOutputDirectory;
    private final WorkerExecutorFacade workers;

    @InputFiles
    public BuildableArtifact getProcessedResources() {
        return this.processedResources;
    }

    @OutputDirectory
    public File getSplitResApkOutputDirectory() {
        return this.splitResApkOutputDirectory;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    @Inject
    public PackageSplitRes(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @TaskAction
    protected void doFullTaskAction() {
        ExistingBuildElements.from((ArtifactType)InternalArtifactType.DENSITY_OR_LANGUAGE_SPLIT_PROCESSED_RES, this.processedResources).transform(this.workers, PackageSplitResTransformRunnable.class, (Function2<? super ApkInfo, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, file) -> new PackageSplitResTransformParams((ApkInfo)apkInfo, (File)file, this))).into(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, this.splitResApkOutputDirectory);
    }

    public static String getOutputFileNameForSplit(ApkInfo apkData, String archivesBaseName, boolean isSigned) {
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (isSigned ? "" : "-unsigned") + ".apk";
    }

    public static class CreationAction
    extends VariantTaskCreationAction<PackageSplitRes> {
        private File splitResApkOutputDirectory;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("package", "SplitResources");
        }

        @Override
        public Class<PackageSplitRes> getType() {
            return PackageSplitRes.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.splitResApkOutputDirectory = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, taskName, "out");
        }

        @Override
        public void handleProvider(TaskProvider<? extends PackageSplitRes> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setPackageSplitResourcesTask(taskProvider);
        }

        @Override
        public void configure(PackageSplitRes task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            BaseVariantData variantData = scope.getVariantData();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            task.processedResources = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES);
            if (((VariantConfiguration)config2).getSigningConfig() != null) {
                task.signingConfig = new CoreSigningConfigImpl(((VariantConfiguration)config2).getSigningConfig().getName()).initWith(((VariantConfiguration)config2).getSigningConfig());
            }
            task.splitResApkOutputDirectory = this.splitResApkOutputDirectory;
            task.incrementalDir = scope.getIncrementalDir(this.getName());
        }
    }

    private static class PackageSplitResTransformParams
    extends BuildElementsTransformParams {
        private final ApkInfo apkInfo;
        private final File input;
        private final File output;
        private final File incrementalDir;
        private final SigningConfig signingConfig;
        private final boolean keepTimestampsInApk;

        PackageSplitResTransformParams(ApkInfo apkInfo, File input2, PackageSplitRes task) {
            if (input2 == null) {
                throw new RuntimeException("Cannot find processed resources for " + apkInfo);
            }
            this.apkInfo = apkInfo;
            this.input = input2;
            this.output = new File(task.splitResApkOutputDirectory, PackageSplitRes.getOutputFileNameForSplit(apkInfo, (String)task.getProject().getProperties().get("archivesBaseName"), task.signingConfig != null));
            this.incrementalDir = task.incrementalDir;
            this.signingConfig = task.signingConfig;
            this.keepTimestampsInApk = AndroidGradleOptions.keepTimestampsInApk(task.getProject());
        }

        @Override
        public File getOutput() {
            return this.output;
        }
    }

    private static class PackageSplitResTransformRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public PackageSplitResTransformRunnable(PackageSplitResTransformParams params) {
            super(params);
        }

        @Override
        public void run() {
            PackageSplitResTransformParams params = (PackageSplitResTransformParams)this.getParams();
            File intDir = new File(params.incrementalDir, FileUtils.join((String[])new String[]{params.apkInfo.getFilterName(), "tmp"}));
            try {
                FileUtils.cleanOutputDir((File)intDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder(IncrementalPackagerBuilder.ApkFormat.FILE).withSigning(params.signingConfig).withOutputFile(params.output).withKeepTimestampsInApk(params.keepTimestampsInApk).withIntermediateDir(intDir).build();){
                pkg.updateAndroidResources(IncrementalRelativeFileSets.fromZip((File)params.input));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

