/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AarTransformUtil;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class AarTransform
extends ArtifactTransform {
    private final AndroidArtifacts.ArtifactType targetType;
    private final boolean sharedLibSupport;
    private final boolean autoNamespaceDependencies;

    @Inject
    public AarTransform(AndroidArtifacts.ArtifactType targetType, boolean sharedLibSupport, boolean autoNamespaceDependencies) {
        this.targetType = targetType;
        this.sharedLibSupport = sharedLibSupport;
        this.autoNamespaceDependencies = autoNamespaceDependencies;
    }

    public static AndroidArtifacts.ArtifactType[] getTransformTargets() {
        return new AndroidArtifacts.ArtifactType[]{AndroidArtifacts.ArtifactType.NON_NAMESPACED_CLASSES, AndroidArtifacts.ArtifactType.SHARED_CLASSES, AndroidArtifacts.ArtifactType.JAVA_RES, AndroidArtifacts.ArtifactType.SHARED_JAVA_RES, AndroidArtifacts.ArtifactType.JAR, AndroidArtifacts.ArtifactType.MANIFEST, AndroidArtifacts.ArtifactType.NON_NAMESPACED_MANIFEST, AndroidArtifacts.ArtifactType.ANDROID_RES, AndroidArtifacts.ArtifactType.ASSETS, AndroidArtifacts.ArtifactType.SHARED_ASSETS, AndroidArtifacts.ArtifactType.JNI, AndroidArtifacts.ArtifactType.SHARED_JNI, AndroidArtifacts.ArtifactType.AIDL, AndroidArtifacts.ArtifactType.RENDERSCRIPT, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES, AndroidArtifacts.ArtifactType.LINT, AndroidArtifacts.ArtifactType.ANNOTATIONS, AndroidArtifacts.ArtifactType.PUBLIC_RES, AndroidArtifacts.ArtifactType.SYMBOL_LIST, AndroidArtifacts.ArtifactType.DATA_BINDING_ARTIFACT, AndroidArtifacts.ArtifactType.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT, AndroidArtifacts.ArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR, AndroidArtifacts.ArtifactType.RES_STATIC_LIBRARY, AndroidArtifacts.ArtifactType.RES_SHARED_STATIC_LIBRARY};
    }

    public List<File> transform(File input2) {
        switch (this.targetType) {
            case CLASSES: {
                return AarTransformUtil.shouldBeAutoNamespaced(input2, this.autoNamespaceDependencies) || this.isShared(input2) ? Collections.emptyList() : AarTransformUtil.getJars(input2);
            }
            case NON_NAMESPACED_CLASSES: {
                return AarTransformUtil.shouldBeAutoNamespaced(input2, this.autoNamespaceDependencies) ? AarTransformUtil.getJars(input2) : Collections.emptyList();
            }
            case JAVA_RES: 
            case JAR: {
                return this.isShared(input2) ? Collections.emptyList() : AarTransformUtil.getJars(input2);
            }
            case SHARED_CLASSES: 
            case SHARED_JAVA_RES: {
                return this.isShared(input2) ? AarTransformUtil.getJars(input2) : Collections.emptyList();
            }
            case LINT: {
                return AarTransform.listIfExists(FileUtils.join((File)input2, (String[])new String[]{"jars", "lint.jar"}));
            }
            case MANIFEST: {
                if (AarTransformUtil.shouldBeAutoNamespaced(input2, this.autoNamespaceDependencies)) {
                    return Collections.emptyList();
                }
                if (this.isShared(input2)) {
                    return AarTransform.listIfExists(Stream.of(new File(input2, "AndroidManifest.xml"), new File(input2, "SharedLibraryAndroidManifest.xml")));
                }
                return AarTransform.listIfExists(new File(input2, "AndroidManifest.xml"));
            }
            case NON_NAMESPACED_MANIFEST: {
                return AarTransformUtil.shouldBeAutoNamespaced(input2, this.autoNamespaceDependencies) ? AarTransform.listIfExists(new File(input2, "AndroidManifest.xml")) : Collections.emptyList();
            }
            case ANDROID_RES: {
                return AarTransform.listIfExists(new File(input2, "res"));
            }
            case ASSETS: {
                return AarTransform.listIfExists(new File(input2, "assets"));
            }
            case JNI: {
                return AarTransform.listIfExists(new File(input2, "jni"));
            }
            case AIDL: {
                return AarTransform.listIfExists(new File(input2, "aidl"));
            }
            case RENDERSCRIPT: {
                return AarTransform.listIfExists(new File(input2, "rs"));
            }
            case CONSUMER_PROGUARD_RULES: {
                return AarTransform.listIfExists(new File(input2, "proguard.txt"));
            }
            case ANNOTATIONS: {
                return AarTransform.listIfExists(new File(input2, "annotations.zip"));
            }
            case PUBLIC_RES: {
                return AarTransform.listIfExists(new File(input2, "public.txt"));
            }
            case SYMBOL_LIST: {
                return AarTransform.listIfExists(new File(input2, "R.txt"));
            }
            case RES_STATIC_LIBRARY: {
                return this.isShared(input2) ? Collections.emptyList() : AarTransform.listIfExists(new File(input2, "res.apk"));
            }
            case RES_SHARED_STATIC_LIBRARY: {
                return this.isShared(input2) ? AarTransform.listIfExists(new File(input2, "shared.apk")) : Collections.emptyList();
            }
            case COMPILE_ONLY_NAMESPACED_R_CLASS_JAR: {
                return AarTransform.listIfExists(new File(input2, "R.jar"));
            }
            case DATA_BINDING_ARTIFACT: {
                return AarTransform.listIfExists(new File(input2, "data-binding"));
            }
            case DATA_BINDING_BASE_CLASS_LOG_ARTIFACT: {
                return AarTransform.listIfExists(new File(input2, "data-binding-base-class-log"));
            }
        }
        throw new RuntimeException("Unsupported type in AarTransform: " + (Object)((Object)this.targetType));
    }

    private boolean isShared(File explodedAar) {
        return this.sharedLibSupport && new File(explodedAar, "SharedLibraryAndroidManifest.xml").exists();
    }

    private static List<File> listIfExists(File file) {
        return file.exists() ? Collections.singletonList(file) : Collections.emptyList();
    }

    private static List<File> listIfExists(Stream<File> files2) {
        return files2.filter(File::exists).collect(Collectors.toList());
    }
}

