/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InstantAppOutputScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.ModuleMetadata;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.apkzlib.zip.Compressor;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.android.tools.build.apkzlib.zip.compress.DeflateExecutionCompressor;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;

public class BundleInstantApp
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    private File bundleDirectory;
    private String bundleName;
    private FileCollection applicationId;
    private FileCollection apkDirectories;

    @Inject
    public BundleInstantApp(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @TaskAction
    public void taskAction() throws IOException {
        FileUtils.mkdirs((File)this.bundleDirectory);
        File bundleFile = new File(this.bundleDirectory, this.bundleName);
        FileUtils.deleteIfExists((File)bundleFile);
        ZFileOptions zFileOptions = new ZFileOptions();
        zFileOptions.setCompressor((Compressor)new DeflateExecutionCompressor(compressTask -> this.workers.submit(BundleInstantAppRunnable.class, (Serializable)new BundleInstantAppParams(compressTask)), -1));
        try (ZFile file = ZFile.openReadWrite((File)bundleFile, (ZFileOptions)zFileOptions);){
            for (File apkDirectory : this.apkDirectories) {
                for (BuildOutput buildOutput : ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, apkDirectory)) {
                    File apkFile = buildOutput.getOutputFile();
                    FileInputStream fileInputStream = new FileInputStream(apkFile);
                    Throwable throwable = null;
                    try {
                        file.add(apkFile.getName(), (InputStream)fileInputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
            }
        }
        this.workers.await();
        InstantAppOutputScope instantAppOutputScope = new InstantAppOutputScope(ModuleMetadata.load(this.applicationId.getSingleFile()).getApplicationId(), bundleFile, new ArrayList<File>(this.apkDirectories.getFiles()));
        instantAppOutputScope.save(this.bundleDirectory);
    }

    @OutputDirectory
    public File getBundleDirectory() {
        return this.bundleDirectory;
    }

    @Input
    public String getBundleName() {
        return this.bundleName;
    }

    @InputFiles
    public FileCollection getApplicationId() {
        return this.applicationId;
    }

    @InputFiles
    public FileCollection getApkDirectories() {
        return this.apkDirectories;
    }

    private static class BundleInstantAppParams
    implements Serializable {
        private final Runnable compressTask;

        BundleInstantAppParams(Runnable compressTask) {
            this.compressTask = compressTask;
        }
    }

    private static class BundleInstantAppRunnable
    implements Runnable {
        private final BundleInstantAppParams params;

        @Inject
        BundleInstantAppRunnable(BundleInstantAppParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            this.params.compressTask.run();
        }
    }

    public static class CreationAction
    extends TaskCreationAction<BundleInstantApp> {
        private final VariantScope scope;
        private final File bundleDirectory;

        public CreationAction(VariantScope scope, File bundleDirectory) {
            this.scope = scope;
            this.bundleDirectory = bundleDirectory;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "InstantAppBundle");
        }

        @Override
        public Class<BundleInstantApp> getType() {
            return BundleInstantApp.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.INSTANTAPP_BUNDLE, (Collection<? extends Object>)ImmutableList.of((Object)this.scope.getApkLocation()), taskName);
        }

        @Override
        public void configure(BundleInstantApp bundleInstantApp) {
            bundleInstantApp.setVariantName(this.scope.getFullVariantName());
            bundleInstantApp.bundleDirectory = this.bundleDirectory;
            bundleInstantApp.bundleName = this.scope.getGlobalScope().getProjectBaseName() + "-" + this.scope.getVariantConfiguration().getBaseName() + ".zip";
            bundleInstantApp.applicationId = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION);
            bundleInstantApp.apkDirectories = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.APK);
        }
    }
}

