/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.compiling.BuildConfigGenerator;
import com.android.builder.model.ClassField;
import com.android.utils.FileUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public class GenerateBuildConfig
extends AndroidBuilderTask {
    private File sourceOutputDir;
    private Supplier<String> buildConfigPackageName;
    private Supplier<String> appPackageName;
    private Supplier<Boolean> debuggable;
    private Supplier<String> flavorName;
    private Supplier<List<String>> flavorNamesWithDimensionNames;
    private String buildTypeName;
    private Supplier<String> versionName;
    private Supplier<Integer> versionCode;
    private Supplier<List<Object>> items;
    private BuildableArtifact checkManifestResult;

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @Input
    public String getBuildConfigPackageName() {
        return this.buildConfigPackageName.get();
    }

    @Input
    public String getAppPackageName() {
        return this.appPackageName.get();
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable.get();
    }

    @Input
    public String getFlavorName() {
        return this.flavorName.get();
    }

    @Input
    public List<String> getFlavorNamesWithDimensionNames() {
        return this.flavorNamesWithDimensionNames.get();
    }

    @Input
    public String getBuildTypeName() {
        return this.buildTypeName;
    }

    public void setBuildTypeName(String buildTypeName) {
        this.buildTypeName = buildTypeName;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName.get();
    }

    @Input
    public int getVersionCode() {
        return this.versionCode.get();
    }

    @Internal
    public List<Object> getItems() {
        return this.items.get();
    }

    @Input
    public List<String> getItemValues() {
        List<Object> resolvedItems = this.getItems();
        ArrayList list = Lists.newArrayListWithCapacity((int)(resolvedItems.size() * 3));
        for (Object object : resolvedItems) {
            if (object instanceof String) {
                list.add((String)object);
                continue;
            }
            if (!(object instanceof ClassField)) continue;
            ClassField field = (ClassField)object;
            list.add(field.getType());
            list.add(field.getName());
            list.add(field.getValue());
        }
        return list;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public BuildableArtifact getCheckManifestResult() {
        return this.checkManifestResult;
    }

    @TaskAction
    void generate() throws IOException {
        File destinationDir = this.getSourceOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        BuildConfigGenerator generator = new BuildConfigGenerator(this.getSourceOutputDir(), this.getBuildConfigPackageName());
        generator.addField("boolean", "DEBUG", this.isDebuggable() ? "Boolean.parseBoolean(\"true\")" : "false").addField("String", "APPLICATION_ID", '\"' + this.appPackageName.get() + '\"').addField("String", "BUILD_TYPE", '\"' + this.getBuildTypeName() + '\"').addField("String", "FLAVOR", '\"' + this.getFlavorName() + '\"').addField("int", "VERSION_CODE", Integer.toString(this.getVersionCode())).addField("String", "VERSION_NAME", '\"' + Strings.nullToEmpty((String)this.getVersionName()) + '\"').addItems(this.getItems());
        List<String> flavors = this.getFlavorNamesWithDimensionNames();
        int count = flavors.size();
        if (count > 1) {
            for (int i = 0; i < count; i += 2) {
                generator.addField("String", "FLAVOR_" + flavors.get(i + 1), '\"' + flavors.get(i) + '\"');
            }
        }
        generator.generate();
    }

    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateBuildConfig> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("generate", "BuildConfig");
        }

        @Override
        public Class<GenerateBuildConfig> getType() {
            return GenerateBuildConfig.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends GenerateBuildConfig> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setGenerateBuildConfigTask(taskProvider);
        }

        @Override
        public void configure(GenerateBuildConfig task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            BaseVariantData variantData = scope.getVariantData();
            GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
            task.buildConfigPackageName = TaskInputHelper.memoize(variantConfiguration::getOriginalApplicationId);
            task.appPackageName = TaskInputHelper.memoize(variantConfiguration::getApplicationId);
            task.versionName = TaskInputHelper.memoize(variantConfiguration::getVersionName);
            task.versionCode = TaskInputHelper.memoize(variantConfiguration::getVersionCode);
            task.debuggable = TaskInputHelper.memoize(() -> ((CoreBuildType)variantConfiguration.getBuildType()).isDebuggable());
            task.buildTypeName = ((CoreBuildType)variantConfiguration.getBuildType()).getName();
            task.flavorName = variantConfiguration::getFlavorName;
            task.flavorNamesWithDimensionNames = TaskInputHelper.memoize(variantConfiguration::getFlavorNamesWithDimensionNames);
            task.items = TaskInputHelper.memoize(variantConfiguration::getBuildConfigItems);
            task.setSourceOutputDir(scope.getBuildConfigSourceOutputDir());
            task.checkManifestResult = scope.getArtifacts().getFinalArtifactFilesIfPresent(InternalArtifactType.CHECK_MANIFEST_RESULT);
            if (scope.getVariantConfiguration().getType().isTestComponent()) {
                task.dependsOn(new Object[]{scope.getTaskContainer().getProcessManifestTask()});
            }
        }
    }
}

