/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeSearchContext;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0082\u0001\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00030\u00162\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00030\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00132\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00030\u0016\u001a\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\nH\u0002\u001a\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002\u001a\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"FORK_CMAKE_SDK_VERSION", "", "canarySdkPaths", "", "forkCmakeReportedVersion", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "forkCmakeSdkVersionRevision", "newline", "findCmakePath", "Ljava/io/File;", "cmakeVersionFromDsl", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "logger", "Lcom/android/utils/ILogger;", "findCmakePathLogic", "cmakePathFromLocalProperties", "downloader", "Lkotlin/Function1;", "", "environmentPaths", "Lkotlin/Function0;", "cmakeVersion", "repositoryPackages", "Lcom/android/repository/api/LocalPackage;", "getCanarySdkPaths", "sdkRoot", "getCmakeRevisionFromExecutable", "cmakeFolder", "getEnvironmentPaths", "getSdkCmakePackages", "gradle"})
public final class CmakeLocatorKt {
    private static final String FORK_CMAKE_SDK_VERSION = "3.6.4111459";
    private static final Revision forkCmakeSdkVersionRevision = Revision.parseRevision((String)"3.6.4111459");
    private static final List<String> canarySdkPaths = CollectionsKt.listOf((Object)"3.10.4819442");
    private static final Revision forkCmakeReportedVersion = Revision.parseRevision((String)"3.6.0");
    private static final String newline = System.lineSeparator();

    private static final List<File> getEnvironmentPaths() {
        String string = System.getenv("PATH");
        if (string == null) {
            string = "";
        }
        String envPath = string;
        String string2 = System.getProperty("path.separator");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"path.separator\")");
        CharSequence charSequence = string2;
        Regex pathSeparator = new Regex(charSequence);
        charSequence = envPath;
        int n = 0;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)pathSeparator.split(charSequence, n)), (Function1)getEnvironmentPaths.1.INSTANCE), (Function1)getEnvironmentPaths.2.INSTANCE));
    }

    private static final List<File> getCanarySdkPaths(File sdkRoot) {
        if (sdkRoot == null) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)canarySdkPaths), (Function1)((Function1)new Function1<String, File>(sdkRoot){
            final /* synthetic */ File $sdkRoot;

            @NotNull
            public final File invoke(@NotNull String version) {
                Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                return new File(new File(new File(this.$sdkRoot, "cmake"), version), "bin");
            }
            {
                this.$sdkRoot = file;
                super(1);
            }
        })));
    }

    private static final List<LocalPackage> getSdkCmakePackages(SdkHandler sdkHandler, ILogger logger) {
        RepoManager sdkManager;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((File)sdkHandler.getSdkFolder());
        RepoManager repoManager = sdkManager = androidSdkHandler.getSdkManager((ProgressIndicator)new LoggerProgressIndicatorWrapper(logger));
        Intrinsics.checkExpressionValueIsNotNull((Object)repoManager, (String)"sdkManager");
        RepositoryPackages packages = repoManager.getPackages();
        Collection collection = packages.getLocalPackagesForPrefix("cmake");
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"packages.getLocalPackagesForPrefix(FD_CMAKE)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final Revision getCmakeRevisionFromExecutable(File cmakeFolder) {
        if (!cmakeFolder.exists()) {
            return null;
        }
        String cmakeExecutableName = SdkConstants.CURRENT_PLATFORM == 2 ? "cmake.exe" : "cmake";
        File cmakeExecutable = new File(cmakeFolder, cmakeExecutableName);
        if (!cmakeExecutable.exists()) {
            return null;
        }
        return CmakeUtils.getVersion(cmakeFolder);
    }

    @Nullable
    public static final File findCmakePathLogic(@Nullable String cmakeVersionFromDsl, @Nullable File cmakePathFromLocalProperties, @NotNull Function1<? super String, Unit> downloader, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull Function0<? extends List<? extends File>> canarySdkPaths, @NotNull Function1<? super File, ? extends Revision> cmakeVersion, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkParameterIsNotNull(canarySdkPaths, (String)"canarySdkPaths");
        Intrinsics.checkParameterIsNotNull(cmakeVersion, (String)"cmakeVersion");
        Intrinsics.checkParameterIsNotNull(repositoryPackages, (String)"repositoryPackages");
        return new CmakeSearchContext(cmakeVersionFromDsl).useDefaultCmakeVersionIfNecessary$gradle().checkForCmakeVersionTooLow$gradle().checkForCmakeVersionAdequatePrecision$gradle().tryPathFromLocalProperties$gradle(cmakeVersion, cmakePathFromLocalProperties).tryLocalRepositoryPackages$gradle(downloader, repositoryPackages).tryFindInPath$gradle(cmakeVersion, environmentPaths, "in PATH").tryFindInPath$gradle(cmakeVersion, canarySdkPaths, "in SDK canaries").issueVersionNotFoundError$gradle();
    }

    @Nullable
    public static final File findCmakePath(@Nullable String cmakeVersionFromDsl, @NotNull SdkHandler sdkHandler, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        return CmakeLocatorKt.findCmakePathLogic(cmakeVersionFromDsl, sdkHandler.getCmakePathInLocalProp(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(sdkHandler){
            final /* synthetic */ SdkHandler $sdkHandler;

            public final void invoke(@NotNull String version) {
                Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                this.$sdkHandler.installCMake(version);
            }
            {
                this.$sdkHandler = sdkHandler;
                super(1);
            }
        }), (Function0<? extends List<? extends File>>)((Function0)findCmakePath.2.INSTANCE), (Function0<? extends List<? extends File>>)((Function0)new Function0<List<? extends File>>(sdkHandler){
            final /* synthetic */ SdkHandler $sdkHandler;

            @NotNull
            public final List<File> invoke() {
                return CmakeLocatorKt.access$getCanarySdkPaths(this.$sdkHandler.getSdkFolder());
            }
            {
                this.$sdkHandler = sdkHandler;
                super(0);
            }
        }), (Function1<? super File, ? extends Revision>)((Function1)findCmakePath.4.INSTANCE), (Function0<? extends List<? extends LocalPackage>>)((Function0)new Function0<List<? extends LocalPackage>>(sdkHandler, logger){
            final /* synthetic */ SdkHandler $sdkHandler;
            final /* synthetic */ ILogger $logger;

            @NotNull
            public final List<LocalPackage> invoke() {
                return CmakeLocatorKt.access$getSdkCmakePackages(this.$sdkHandler, this.$logger);
            }
            {
                this.$sdkHandler = sdkHandler;
                this.$logger = iLogger;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Revision access$getForkCmakeReportedVersion$p() {
        return forkCmakeReportedVersion;
    }

    public static final /* synthetic */ Revision access$getForkCmakeSdkVersionRevision$p() {
        return forkCmakeSdkVersionRevision;
    }

    public static final /* synthetic */ String access$getNewline$p() {
        return newline;
    }

    public static final /* synthetic */ List access$getEnvironmentPaths() {
        return CmakeLocatorKt.getEnvironmentPaths();
    }

    public static final /* synthetic */ List access$getCanarySdkPaths(File sdkRoot) {
        return CmakeLocatorKt.getCanarySdkPaths(sdkRoot);
    }

    public static final /* synthetic */ Revision access$getCmakeRevisionFromExecutable(File cmakeFolder) {
        return CmakeLocatorKt.getCmakeRevisionFromExecutable(cmakeFolder);
    }

    public static final /* synthetic */ List access$getSdkCmakePackages(SdkHandler sdkHandler, ILogger logger) {
        return CmakeLocatorKt.getSdkCmakePackages(sdkHandler, logger);
    }
}

