/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.api.attributes.VariantAttr;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.level2.ModuleLibraryImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.res.namespaced.AutoNamespaceLocation;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.model.Dependencies;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.caching.CreatingCache;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0007\u001a\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u001e\u001a\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0007H\u0002\u001a\n\u0010!\u001a\u00020\u000b*\u00020\u0004\u001a\f\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020#\"N\u0010\u0000\u001aB\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004 \u0003* \u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"globalLibrary", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Lcom/android/builder/model/level2/Library;", "libraryCache", "Lcom/android/ide/common/caching/CreatingCache;", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "getLibraryCache", "()Lcom/android/ide/common/caching/CreatingCache;", "clearCaches", "", "clone", "Lcom/android/builder/model/Dependencies;", "dependencies", "modelLevel", "", "Lcom/android/builder/model/level2/DependencyGraphs;", "dependencyGraphs", "modelWithFullDependency", "", "findLocalJarsAsStrings", "", "folder", "Ljava/io/File;", "findResStaticLibrary", "explodedAar", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "getGlobalLibMap", "", "instantiateLibrary", "artifact", "addToGlobalCache", "getVariantName", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "gradle"})
@JvmName(name="LibraryUtils")
public final class LibraryUtils {
    @NotNull
    private static final CreatingCache<ResolvedArtifact, Library> libraryCache = new CreatingCache((CreatingCache.ValueFactory)libraryCache.1.INSTANCE);
    private static final HashMap<String, Library> globalLibrary = Maps.newHashMap();

    @Nullable
    public static final String getVariantName(@NotNull ResolvedArtifactResult $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ResolvedVariantResult resolvedVariantResult = $receiver.getVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedVariantResult, (String)"variant");
        VariantAttr variantAttr = (VariantAttr)resolvedVariantResult.getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr != null ? variantAttr.getName() : null;
    }

    @NotNull
    public static final Dependencies clone(@NotNull Dependencies dependencies, int modelLevel) {
        Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
        if (modelLevel >= 4) {
            Dependencies dependencies2 = DependenciesImpl.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencies2, (String)"DependenciesImpl.EMPTY");
            return dependencies2;
        }
        List libraries = CollectionsKt.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List projects = CollectionsKt.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DependencyGraphs clone(@NotNull DependencyGraphs dependencyGraphs, int modelLevel, boolean modelWithFullDependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependencyGraphs, (String)"dependencyGraphs");
        if (modelLevel < 4) {
            DependencyGraphs dependencyGraphs2 = EmptyDependencyGraphs.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyGraphs2, (String)"EmptyDependencyGraphs.EMPTY");
            return dependencyGraphs2;
        }
        Preconditions.checkState((boolean)(dependencyGraphs instanceof ConfigurationDependencyGraphs));
        ConfigurationDependencyGraphs cdg = (ConfigurationDependencyGraphs)dependencyGraphs;
        List<Library> list = cdg.getLibraries();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"cdg.libraries");
        List<Library> libs = list;
        HashMap<String, Library> hashMap = globalLibrary;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"globalLibrary");
        HashMap<String, Library> hashMap2 = hashMap;
        synchronized (hashMap2) {
            boolean bl = false;
            for (Library library : libs) {
                HashMap<String, Library> hashMap3 = globalLibrary;
                Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"globalLibrary");
                Map map2 = hashMap3;
                Library library2 = library;
                Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
                String string = library2.getArtifactAddress();
                Library library3 = library;
                map2.put(string, library3);
            }
            Unit unit = Unit.INSTANCE;
        }
        List<GraphItem> list2 = cdg.getCompileDependencies();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"cdg.compileDependencies");
        List<GraphItem> nodes = list2;
        return modelWithFullDependency ? (DependencyGraphs)new FullDependencyGraphsImpl(nodes, nodes, (List)ImmutableList.of(), (List)ImmutableList.of()) : (DependencyGraphs)new SimpleDependencyGraphsImpl(nodes, cdg.getProvidedLibraries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addToGlobalCache(@NotNull Library $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        HashMap<String, Library> hashMap = globalLibrary;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"globalLibrary");
        HashMap<String, Library> hashMap2 = hashMap;
        synchronized (hashMap2) {
            boolean bl = false;
            HashMap<String, Library> hashMap3 = globalLibrary;
            Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"globalLibrary");
            Map map2 = hashMap3;
            String string = $receiver.getArtifactAddress();
            Library library = $receiver;
            map2.put(string, library);
            map2 = Unit.INSTANCE;
        }
    }

    public static final void clearCaches() {
        globalLibrary.clear();
        libraryCache.clear();
    }

    @NotNull
    public static final Map<String, Library> getGlobalLibMap() {
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)globalLibrary);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.copyOf(globalLibrary)");
        return (Map)immutableMap;
    }

    private static final Library instantiateLibrary(ResolvedArtifact artifact) {
        Library library = null;
        ComponentIdentifier id = artifact.getComponentIdentifier();
        String address = artifact.computeModelAddress();
        if (!(id instanceof ProjectComponentIdentifier) || artifact.isWrappedModule()) {
            if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID) {
                File extractedFolder = (File)Preconditions.checkNotNull((Object)artifact.getExtractedFolder());
                File file = artifact.getArtifactFile();
                File file2 = LibraryUtils.findResStaticLibrary(artifact);
                File file3 = extractedFolder;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"extractedFolder");
                library = new AndroidLibraryImpl(address, file, extractedFolder, file2, LibraryUtils.findLocalJarsAsStrings(file3));
            } else {
                library = new JavaLibraryImpl(address, artifact.getArtifactFile());
            }
        } else {
            String buildId;
            String string = buildId = BuildMappingUtils.getBuildId((ProjectComponentIdentifier)id, artifact.getBuildMapping());
            if (string == null) {
                Intrinsics.throwNpe();
            }
            library = new ModuleLibraryImpl(address, string, ((ProjectComponentIdentifier)id).getProjectPath(), artifact.getVariantName());
        }
        LibraryUtils.addToGlobalCache(library);
        return library;
    }

    @Nullable
    public static final File findResStaticLibrary(@NotNull VariantScope variantScope, @NotNull ResolvedArtifact explodedAar) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        Intrinsics.checkParameterIsNotNull((Object)explodedAar, (String)"explodedAar");
        File file = LibraryUtils.findResStaticLibrary(explodedAar);
        if (file != null) {
            return file;
        }
        GlobalScope globalScope = variantScope.getGlobalScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
        AndroidConfig androidConfig = globalScope.getExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"variantScope.globalScope.extension");
        AaptOptions aaptOptions = androidConfig.getAaptOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"variantScope.globalScope.extension.aaptOptions");
        if (aaptOptions.getNamespaced()) {
            GlobalScope globalScope2 = variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope\n            .globalScope");
            if (globalScope2.getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES)) {
                BuildArtifactsHolder buildArtifactsHolder = variantScope.getArtifacts();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
                BuildArtifactsHolder artifacts = buildArtifactsHolder;
                if (artifacts.hasArtifact(InternalArtifactType.RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES)) {
                    File convertedDirectory = (File)Iterables.get((Iterable)((Iterable)artifacts.getFinalArtifactFiles(InternalArtifactType.RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES)), (int)0);
                    return new File(convertedDirectory, AutoNamespaceLocation.getAutoNamespacedLibraryFileName(explodedAar.getComponentIdentifier()));
                }
            }
        }
        return null;
    }

    private static final File findResStaticLibrary(ResolvedArtifact explodedAar) {
        if (explodedAar.getExtractedFolder() == null) {
            return null;
        }
        File file = new File(explodedAar.getExtractedFolder(), "res.apk");
        return !file.exists() ? null : file;
    }

    private static final List<String> findLocalJarsAsStrings(File folder) {
        String[] stringArray;
        String[] stringArray2;
        File localJarRoot;
        File file = localJarRoot = FileUtils.join((File)folder, (String[])new String[]{"jars", "libs"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localJarRoot");
        if (!file.isDirectory()) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            return (List)immutableList;
        }
        String[] jarFiles2 = localJarRoot.list(findLocalJarsAsStrings.jarFiles.1.INSTANCE);
        if (jarFiles2 != null && !((stringArray2 = (stringArray = jarFiles2)).length == 0)) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (String jarFile : jarFiles2) {
                list.add((Object)("jars" + File.separatorChar + "libs" + File.separatorChar + jarFile));
            }
            ImmutableList immutableList = list.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"list.build()");
            return (List)immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        return (List)immutableList;
    }

    @NotNull
    public static final CreatingCache<ResolvedArtifact, Library> getLibraryCache() {
        return libraryCache;
    }

    public static final /* synthetic */ Library access$instantiateLibrary(ResolvedArtifact artifact) {
        return LibraryUtils.instantiateLibrary(artifact);
    }
}

