/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.ArtifactTypeUtil;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/scope/ProducersMap;", "", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "identifier", "Lkotlin/Function0;", "", "(Lorg/gradle/api/file/DirectoryProperty;Lkotlin/jvm/functions/Function0;)V", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getIdentifier", "()Lkotlin/jvm/functions/Function0;", "producersMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/build/api/artifact/ArtifactType;", "Lcom/android/build/gradle/internal/scope/ProducersMap$Producers;", "getProducers", "artifactType", "hasProducers", "", "republish", "", "from", "to", "Producer", "Producers", "gradle"})
public final class ProducersMap {
    private final ConcurrentHashMap<ArtifactType, Producers> producersMap;
    @NotNull
    private final DirectoryProperty buildDirectory;
    @NotNull
    private final Function0<String> identifier;

    public final boolean hasProducers(@NotNull ArtifactType artifactType) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        return this.producersMap.containsKey(artifactType);
    }

    @NotNull
    public final Producers getProducers(@NotNull ArtifactType artifactType) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        ConcurrentMap $receiver$iv = this.producersMap;
        Object object = $receiver$iv.get(artifactType);
        if (object == null) {
            boolean bl = false;
            Producers producers = new Producers(artifactType, this.identifier, this.buildDirectory);
            Producers default$iv = producers;
            object = $receiver$iv.putIfAbsent(artifactType, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Producers)object;
    }

    public final void republish(@NotNull ArtifactType from, @NotNull ArtifactType to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Map map2 = this.producersMap;
        Producers producers = this.getProducers(from);
        map2.put(to, producers);
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        return this.buildDirectory;
    }

    @NotNull
    public final Function0<String> getIdentifier() {
        return this.identifier;
    }

    public ProducersMap(@NotNull DirectoryProperty buildDirectory, @NotNull Function0<String> identifier) {
        Intrinsics.checkParameterIsNotNull((Object)buildDirectory, (String)"buildDirectory");
        Intrinsics.checkParameterIsNotNull(identifier, (String)"identifier");
        this.buildDirectory = buildDirectory;
        this.identifier = identifier;
        this.producersMap = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ,\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ\u0018\u0010 \u001a\u0014\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\u0018\u00010\u0015J\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010$\u001a\u00020\u0002J\u0016\u0010%\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150&H\u0002J\u0010\u0010'\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/scope/ProducersMap$Producers;", "Ljava/util/ArrayList;", "Lcom/android/build/gradle/internal/scope/ProducersMap$Producer;", "Lkotlin/collections/ArrayList;", "artifactType", "Lcom/android/build/api/artifact/ArtifactType;", "identifier", "Lkotlin/Function0;", "", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "(Lcom/android/build/api/artifact/ArtifactType;Lkotlin/jvm/functions/Function0;Lorg/gradle/api/file/DirectoryProperty;)V", "getArtifactType", "()Lcom/android/build/api/artifact/ArtifactType;", "buildDir", "Ljava/io/File;", "getBuildDir", "()Ljava/io/File;", "getIdentifier", "()Lkotlin/jvm/functions/Function0;", "injectable", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInjectable", "()Lorg/gradle/api/provider/Provider;", "lastProducerTaskName", "getLastProducerTaskName", "add", "", "product", "taskName", "fileName", "getCurrent", "hasMultipleProducers", "", "resolve", "producer", "resolveAll", "", "resolveAllAndReturnLast", "gradle"})
    public static final class Producers
    extends ArrayList<Producer> {
        @NotNull
        private final File buildDir;
        @NotNull
        private final Provider<? extends FileSystemLocation> injectable;
        @NotNull
        private final Provider<String> lastProducerTaskName;
        @NotNull
        private final ArtifactType artifactType;
        @NotNull
        private final Function0<String> identifier;

        @NotNull
        public final File getBuildDir() {
            return this.buildDir;
        }

        @NotNull
        public final Provider<? extends FileSystemLocation> getInjectable() {
            return this.injectable;
        }

        @NotNull
        public final Provider<String> getLastProducerTaskName() {
            return this.lastProducerTaskName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final List<Provider<? extends FileSystemLocation>> resolveAll() {
            List list;
            Producers producers = this;
            synchronized (producers) {
                void $receiver$iv$iv;
                Producers $receiver$iv;
                boolean bl = false;
                boolean multipleProducers = this.hasMultipleProducers();
                Producers producers2 = $receiver$iv = this;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Producer producer = (Producer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Provider<? extends FileSystemLocation> provider = it.resolve(this.buildDir, this.identifier, this.artifactType, multipleProducers);
                    collection.add(provider);
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        @Nullable
        public final Provider<? extends FileSystemLocation> resolveAllAndReturnLast() {
            return (Provider)CollectionsKt.lastOrNull(this.resolveAll());
        }

        public final void add(@NotNull Provider<Provider<? extends FileSystemLocation>> product, @NotNull String taskName, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(product, (String)"product");
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.add(new Producer(product, taskName, fileName));
        }

        @Nullable
        public final Provider<? extends Provider<? extends FileSystemLocation>> getCurrent() {
            Producer producer = (Producer)CollectionsKt.lastOrNull((List)this);
            if (producer == null) {
                return null;
            }
            Producer currentProduct = producer;
            return currentProduct.getOutputProvider().map(new Transformer<S, T>(this, currentProduct){
                final /* synthetic */ Producers this$0;
                final /* synthetic */ Producer $currentProduct;

                @NotNull
                public final Provider<? extends FileSystemLocation> transform(Provider<? extends FileSystemLocation> $noName_0) {
                    return this.$currentProduct.resolve(this.this$0.getBuildDir(), this.this$0.getIdentifier(), this.this$0.getArtifactType(), this.this$0.hasMultipleProducers());
                }
                {
                    this.this$0 = producers;
                    this.$currentProduct = producer;
                }
            });
        }

        @NotNull
        public final Provider<? extends FileSystemLocation> resolve(@NotNull Producer producer) {
            Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
            return producer.resolve(this.buildDir, this.identifier, this.artifactType, this.hasMultipleProducers());
        }

        public final boolean hasMultipleProducers() {
            return this.size() > 1;
        }

        @NotNull
        public final ArtifactType getArtifactType() {
            return this.artifactType;
        }

        @NotNull
        public final Function0<String> getIdentifier() {
            return this.identifier;
        }

        public Producers(@NotNull ArtifactType artifactType, @NotNull Function0<String> identifier, @NotNull DirectoryProperty buildDirectory) {
            Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
            Intrinsics.checkParameterIsNotNull(identifier, (String)"identifier");
            Intrinsics.checkParameterIsNotNull((Object)buildDirectory, (String)"buildDirectory");
            this.artifactType = artifactType;
            this.identifier = identifier;
            Object object = buildDirectory.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"buildDirectory.get()");
            File file = ((Directory)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDirectory.get().asFile");
            this.buildDir = file;
            Provider provider = buildDirectory.flatMap((Transformer)new Transformer<Provider<? extends FileSystemLocation>, Directory>(this){
                final /* synthetic */ Producers this$0;

                @Nullable
                public final Provider<? extends FileSystemLocation> transform(Directory it) {
                    return this.this$0.resolveAllAndReturnLast();
                }
                {
                    this.this$0 = producers;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"buildDirectory.flatMap {\u2026eturnLast()\n            }");
            this.injectable = provider;
            Provider provider2 = this.injectable.map(new Transformer<S, T>(this){
                final /* synthetic */ Producers this$0;

                @NotNull
                public final String transform(FileSystemLocation $noName_0) {
                    return ((Producer)this.this$0.get(this.this$0.size() - 1)).getTaskName();
                }
                {
                    this.this$0 = producers;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"injectable.map { _ -> get(size - 1).taskName }");
            this.lastProducerTaskName = provider2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ4\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u0002\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/scope/ProducersMap$Producer;", "", "outputProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "taskName", "", "fileName", "(Lorg/gradle/api/provider/Provider;Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getOutputProvider", "()Lorg/gradle/api/provider/Provider;", "getTaskName", "resolve", "buildDir", "Ljava/io/File;", "identifier", "Lkotlin/Function0;", "artifactType", "Lcom/android/build/api/artifact/ArtifactType;", "multipleProducers", "", "gradle"})
    public static final class Producer {
        @NotNull
        private final Provider<? extends Provider<? extends FileSystemLocation>> outputProvider;
        @NotNull
        private final String taskName;
        @NotNull
        private final String fileName;

        @NotNull
        public final Provider<? extends FileSystemLocation> resolve(@NotNull File buildDir, @NotNull Function0<String> identifier, @NotNull ArtifactType artifactType, boolean multipleProducers) {
            Intrinsics.checkParameterIsNotNull((Object)buildDir, (String)"buildDir");
            Intrinsics.checkParameterIsNotNull(identifier, (String)"identifier");
            Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
            Provider resolved = (Provider)this.outputProvider.get();
            File fileLocation = FileUtils.join((File)ArtifactTypeUtil.getOutputDir(artifactType, buildDir), (String[])new String[]{(String)identifier.invoke(), multipleProducers ? this.taskName : "", this.fileName});
            Provider provider = resolved;
            if (provider instanceof DirectoryProperty) {
                ((DirectoryProperty)resolved).set(fileLocation);
            } else if (provider instanceof RegularFileProperty) {
                ((RegularFileProperty)resolved).set(fileLocation);
            } else {
                throw (Throwable)new RuntimeException("Property.get() is not a correct instance type : " + resolved.getClass().getName());
            }
            return resolved;
        }

        @NotNull
        public final Provider<? extends Provider<? extends FileSystemLocation>> getOutputProvider() {
            return this.outputProvider;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public Producer(@NotNull Provider<? extends Provider<? extends FileSystemLocation>> outputProvider, @NotNull String taskName, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(outputProvider, (String)"outputProvider");
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.outputProvider = outputProvider;
            this.taskName = taskName;
            this.fileName = fileName;
        }
    }
}

