/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import org.gradle.api.logging.Logging;

public class NdkHandler {
    private final File projectDir;
    private String compileSdkVersion;
    private File ndkDirectory;
    private NdkInfo ndkInfo;
    private Revision revision;

    public NdkHandler(String ndkVersionFromDsl, File projectDir) {
        this.projectDir = projectDir;
        this.relocateNdkFolder();
    }

    public void relocateNdkFolder() {
        this.ndkDirectory = NdkHandler.findNdkDirectory(this.projectDir);
        if (this.ndkDirectory == null || !this.ndkDirectory.exists()) {
            this.ndkInfo = null;
            this.revision = null;
        } else {
            this.revision = NdkHandler.findRevision(this.ndkDirectory);
            this.ndkInfo = this.revision == null ? new DefaultNdkInfo(this.ndkDirectory) : new NdkR14Info(this.ndkDirectory);
        }
    }

    private static Properties readProperties(File file) {
        Properties properties = new Properties();
        try (FileInputStream fis2 = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)fis2, Charsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read %1$s.", file), e);
        }
        return properties;
    }

    public static Revision findRevision(File ndkDirectory) {
        if (ndkDirectory == null) {
            return null;
        }
        File sourceProperties = new File(ndkDirectory, "source.properties");
        if (!sourceProperties.exists()) {
            return null;
        }
        Properties properties = NdkHandler.readProperties(sourceProperties);
        String version = properties.getProperty("Pkg.Revision");
        if (version != null) {
            return Revision.parseRevision((String)version);
        }
        return null;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getPlatformVersion() {
        assert (this.compileSdkVersion != null);
        assert (this.ndkInfo != null);
        return this.ndkInfo.findLatestPlatformVersion(this.compileSdkVersion);
    }

    public void setCompileSdkVersion(String compileSdkVersion) {
        this.compileSdkVersion = compileSdkVersion;
    }

    private static File findNdkDirectory(File projectDir) {
        File ndkDir;
        File localProperties = new File(projectDir, "local.properties");
        Properties properties = new Properties();
        if (localProperties.isFile()) {
            properties = NdkHandler.readProperties(localProperties);
        }
        if ((ndkDir = NdkHandler.findNdkDirectory(properties, projectDir)) == null) {
            return null;
        }
        return NdkHandler.checkNdkDir(ndkDir) ? ndkDir : null;
    }

    private static boolean checkNdkDir(File ndkDir) {
        if (!new File(ndkDir, "platforms").isDirectory()) {
            NdkHandler.invalidNdkWarning("NDK is missing a \"platforms\" directory.", ndkDir);
            return false;
        }
        if (!new File(ndkDir, "toolchains").isDirectory()) {
            NdkHandler.invalidNdkWarning("NDK is missing a \"toolchains\" directory.", ndkDir);
            return false;
        }
        return true;
    }

    private static void invalidNdkWarning(String message, File ndkDir) {
        Logging.getLogger(NdkHandler.class).warn("{}\nIf you are using NDK, verify the ndk.dir is set to a valid NDK directory.  It is currently set to {}.\nIf you are not using NDK, unset the NDK variable from ANDROID_NDK_HOME or local.properties to remove this warning.\n", (Object)message, (Object)ndkDir.getAbsolutePath());
    }

    public static File findNdkDirectory(Properties properties, File projectDir) {
        File ndkBundle;
        String ndkDirProp = properties.getProperty("ndk.dir");
        if (ndkDirProp != null) {
            return new File(ndkDirProp);
        }
        String ndkEnvVar = System.getenv("ANDROID_NDK_HOME");
        if (ndkEnvVar != null) {
            return new File(ndkEnvVar);
        }
        Pair<File, Boolean> sdkLocation = SdkHandler.findSdkLocation(properties, projectDir);
        File sdkFolder = (File)sdkLocation.getFirst();
        if (sdkFolder != null && (ndkBundle = new File(sdkFolder, "ndk-bundle")).isDirectory()) {
            return ndkBundle;
        }
        return null;
    }

    public File getNdkDirectory() {
        return this.ndkDirectory;
    }

    public boolean isConfigured() {
        return this.ndkDirectory != null && this.ndkDirectory.isDirectory();
    }

    private boolean supports64Bits() {
        if (this.getPlatformVersion() == null) {
            return false;
        }
        String targetString = this.getPlatformVersion().replace("android-", "");
        try {
            return Integer.parseInt(targetString) >= 20;
        }
        catch (NumberFormatException ignored) {
            return true;
        }
    }

    public static Collection<Abi> getAbiList() {
        return ImmutableList.copyOf((Object[])Abi.values());
    }

    public static Collection<Abi> getDefaultAbiList() {
        return Abi.getDefaultValues();
    }

    private static Collection<Abi> getAbiList32() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Abi abi : Abi.values()) {
            if (abi.supports64Bits()) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    public Collection<Abi> getSupportedAbis() {
        if (this.ndkInfo != null) {
            return this.supports64Bits() ? this.ndkInfo.getSupportedAbis() : this.ndkInfo.getSupported32BitsAbis();
        }
        return this.supports64Bits() ? NdkHandler.getAbiList() : NdkHandler.getAbiList32();
    }

    public Collection<Abi> getDefaultAbis() {
        if (this.ndkInfo != null) {
            return this.supports64Bits() ? this.ndkInfo.getDefaultAbis() : this.ndkInfo.getDefault32BitsAbis();
        }
        return this.supports64Bits() ? NdkHandler.getAbiList() : NdkHandler.getAbiList32();
    }

    public File getStripExecutable(Abi abi) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.getStripExecutable(abi);
    }

    public int findSuitablePlatformVersion(String abi, String variantName, AndroidVersion androidVersion) {
        Preconditions.checkNotNull((Object)this.ndkInfo);
        return this.ndkInfo.findSuitablePlatformVersion(abi, androidVersion);
    }
}

