/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.scope.ApkInfo;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildElementsTransformParams;
import com.android.build.gradle.internal.scope.BuildElementsTransformRunnable;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.SigningConfigMetadata;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.ide.common.signing.KeytoolException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.gradle.workers.WorkerExecutor;

public class InstantRunResourcesApkBuilder
extends AndroidBuilderTask {
    public static final String APK_FILE_NAME = "resources";
    static boolean doPackageCodeSplitApk = true;
    private AndroidBuilder androidBuilder;
    private InstantRunBuildContext instantRunBuildContext;
    private File outputDirectory;
    private FileCollection signingConf;
    private File supportDirectory;
    private BuildableArtifact resources;
    private InternalArtifactType resInputType;
    private final WorkerExecutorFacade workers;

    @Inject
    public InstantRunResourcesApkBuilder(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @InputFiles
    public FileCollection getSigningConf() {
        return this.signingConf;
    }

    @Input
    public String getResInputType() {
        return this.resInputType.name();
    }

    @Input
    public String getPatchingPolicy() {
        return this.instantRunBuildContext.getPatchingPolicy().name();
    }

    @InputFiles
    public BuildableArtifact getResourcesFile() {
        return this.resources;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    protected void doFullTaskAction() {
        if (this.instantRunBuildContext.getPatchingPolicy() != InstantRunPatchingPolicy.MULTI_APK_SEPARATE_RESOURCES) {
            this.getResInputBuildArtifacts().forEach(buildOutput -> {
                ApkInfo apkInfo = buildOutput.getApkInfo();
                File outputFile = new File(this.outputDirectory, InstantRunResourcesApkBuilder.mangleApkName(apkInfo) + ".apk");
                try {
                    FileUtils.deleteIfExists((File)outputFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            return;
        }
        ArrayList outputFiles = new ArrayList();
        this.getResInputBuildArtifacts().transform(this.workers, ApkBuilderRunnable.class, (Function2<? super ApkInfo, ? super File, ? extends BuildElementsTransformParams>)((Function2)(apkInfo, input2) -> {
            ApkBuilderParams params = new ApkBuilderParams((ApkInfo)apkInfo, (File)input2, this);
            outputFiles.add(params.getOutput());
            return params;
        })).into(InternalArtifactType.INSTANT_RUN_PACKAGED_RESOURCES, this.outputDirectory);
        outputFiles.forEach(it -> this.instantRunBuildContext.addChangedFile(FileType.SPLIT, (File)it));
    }

    protected BuildElements getResInputBuildArtifacts() {
        return ExistingBuildElements.from((ArtifactType)this.resInputType, this.resources);
    }

    static String mangleApkName(ApkInfo apkData) {
        return "resources-" + apkData.getBaseName();
    }

    public static class CreationAction
    extends TaskCreationAction<InstantRunResourcesApkBuilder> {
        protected final VariantScope variantScope;
        private final InternalArtifactType resInputType;

        public CreationAction(InternalArtifactType resInputType, VariantScope scope) {
            this.resInputType = resInputType;
            this.variantScope = scope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("processInstantRun", "ResourcesApk");
        }

        @Override
        public Class<InstantRunResourcesApkBuilder> getType() {
            return InstantRunResourcesApkBuilder.class;
        }

        @Override
        public void configure(InstantRunResourcesApkBuilder resourcesApkBuilder) {
            resourcesApkBuilder.setVariantName(this.variantScope.getFullVariantName());
            resourcesApkBuilder.resInputType = this.resInputType;
            resourcesApkBuilder.supportDirectory = this.variantScope.getIncrementalDir(this.getName());
            resourcesApkBuilder.androidBuilder = this.variantScope.getGlobalScope().getAndroidBuilder();
            resourcesApkBuilder.signingConf = this.variantScope.getSigningConfigFileCollection();
            resourcesApkBuilder.instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            resourcesApkBuilder.resources = this.variantScope.getArtifacts().getFinalArtifactFiles(this.resInputType);
            resourcesApkBuilder.outputDirectory = this.variantScope.getInstantRunResourceApkFolder();
        }
    }

    private static class ApkBuilderParams
    extends BuildElementsTransformParams {
        private final File input;
        private final File outputFile;
        private final File tempDir;
        private final File signingConfigFile;
        private final String createdBy;
        private final boolean keepTimestampsInApk;

        ApkBuilderParams(ApkInfo apkInfo, File input2, InstantRunResourcesApkBuilder task) {
            this.input = input2;
            this.outputFile = new File(task.outputDirectory, InstantRunResourcesApkBuilder.mangleApkName(apkInfo) + ".apk");
            this.tempDir = new File(task.supportDirectory, "package_" + InstantRunResourcesApkBuilder.mangleApkName(apkInfo));
            this.signingConfigFile = SigningConfigMetadata.Companion.getOutputFile(task.signingConf);
            this.createdBy = task.androidBuilder.getCreatedBy();
            this.keepTimestampsInApk = AndroidGradleOptions.keepTimestampsInApk(task.getProject());
        }

        @Override
        public File getOutput() {
            return this.outputFile;
        }
    }

    private static class ApkBuilderRunnable
    extends BuildElementsTransformRunnable {
        @Inject
        public ApkBuilderRunnable(ApkBuilderParams params) {
            super(params);
        }

        @Override
        public void run() {
            ApkBuilderParams params = (ApkBuilderParams)this.getParams();
            try {
                FileUtils.deleteIfExists((File)params.outputFile);
                FileUtils.mkdirs((File)params.outputFile.getParentFile());
                FileUtils.cleanOutputDir((File)params.tempDir);
                if (doPackageCodeSplitApk) {
                    AndroidBuilder.packageCodeSplitApk((File)params.input, (Set)ImmutableSet.of(), (SigningConfig)SigningConfigMetadata.Companion.load(params.signingConfigFile), (File)params.outputFile, (File)params.tempDir, (ApkCreatorFactory)ApkCreatorFactories.fromProjectProperties(params.keepTimestampsInApk, true), (String)params.createdBy);
                }
            }
            catch (PackagerException | KeytoolException | IOException e) {
                throw new BuildException("Exception while creating resources split APK", e);
            }
        }
    }
}

