/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.builder.model.OptionalCompilationStep;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;

public class InstantRunDex
extends Transform {
    private final InstantRunVariantScope variantScope;
    private final int minSdkForDx;
    private final boolean enableDesugaring;
    private final FileCollection bootClasspath;
    private MessageReceiver messageReceiver;

    public InstantRunDex(InstantRunVariantScope transformVariantScope, int minSdkForDx, boolean enableDesugaring, FileCollection bootClasspath, MessageReceiver messageReceiver) {
        this.variantScope = transformVariantScope;
        this.minSdkForDx = minSdkForDx;
        this.enableDesugaring = enableDesugaring;
        this.bootClasspath = bootClasspath;
        this.messageReceiver = messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        File outputFolder = InstantRunBuildType.RELOAD.getOutputFolder(this.variantScope);
        boolean changesAreCompatible = this.variantScope.getInstantRunBuildContext().hasPassedVerification();
        boolean restartDexRequested = this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY);
        if (!changesAreCompatible || restartDexRequested) {
            FileUtils.cleanOutputDir((File)outputFolder);
            return;
        }
        File classesJar = new File(outputFolder, "classes.jar");
        if (classesJar.exists()) {
            FileUtils.delete((File)classesJar);
        }
        Files.createParentDirs((File)classesJar);
        try (JarClassesBuilder jarClassesBuilder = this.getJarClassBuilder(classesJar);){
            for (TransformInput input2 : invocation.getReferencedInputs()) {
                for (DirectoryInput directoryInput : input2.getDirectoryInputs()) {
                    Set types = directoryInput.getContentTypes();
                    if (types.size() != 1 || !types.contains((Object)ExtendedContentType.CLASSES_ENHANCED)) continue;
                    File folder = directoryInput.getFile();
                    if (invocation.isIncremental()) {
                        for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                            File file;
                            if (entry.getValue() == Status.REMOVED || !(file = (File)entry.getKey()).isFile()) continue;
                            jarClassesBuilder.add(folder, file);
                        }
                        continue;
                    }
                    FluentIterable files2 = FileUtils.getAllFiles((File)folder);
                    for (File inputFile : files2) {
                        jarClassesBuilder.add(folder, inputFile);
                    }
                }
            }
        }
        if (jarClassesBuilder.isEmpty()) {
            FileUtils.cleanOutputDir((File)outputFolder);
            return;
        }
        try {
            this.variantScope.getInstantRunBuildContext().startRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_DEX);
            List<Path> classpath = this.getClasspath(invocation);
            this.convertByteCode(classesJar, classpath, outputFolder);
            this.variantScope.getInstantRunBuildContext().addChangedFile(FileType.RELOAD_DEX, new File(outputFolder, "classes.dex"));
        }
        finally {
            this.variantScope.getInstantRunBuildContext().stopRecording(InstantRunBuildContext.TaskType.INSTANT_RUN_DEX);
        }
    }

    @VisibleForTesting
    protected void convertByteCode(File inputJar, List<Path> classpath, File outputFolder) throws IOException {
        try (ClassFileProviderFactory bootClasspathProvider = new ClassFileProviderFactory(this.getBootClasspath());
             ClassFileProviderFactory libraryClasspathProvider = new ClassFileProviderFactory(classpath);
             ClassFileInput classInput = ClassFileInputs.fromPath((Path)inputJar.toPath());){
            DexArchiveBuilder d8DexBuilder = DexArchiveBuilder.createD8DexBuilder((int)this.minSdkForDx, (boolean)true, (ClassFileProviderFactory)bootClasspathProvider, (ClassFileProviderFactory)libraryClasspathProvider, (boolean)this.enableDesugaring, (MessageReceiver)this.messageReceiver);
            d8DexBuilder.convert(classInput.entries(p -> true), outputFolder.toPath(), false);
        }
    }

    @VisibleForTesting
    protected JarClassesBuilder getJarClassBuilder(File outputFile) {
        return new JarClassesBuilder(outputFile);
    }

    private static void copyFileInJar(File inputDir, File inputFile, JarOutputStream jarOutputStream) throws IOException {
        String entryName = inputFile.getPath().substring(inputDir.getPath().length() + 1);
        JarEntry jarEntry = new JarEntry(entryName);
        jarOutputStream.putNextEntry(jarEntry);
        Files.copy((File)inputFile, (OutputStream)jarOutputStream);
        jarOutputStream.closeEntry();
    }

    public String getName() {
        return "instantReloadDex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.CLASSES_ENHANCED), (Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of();
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        if (this.enableDesugaring) {
            return ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS, (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROVIDED_ONLY, (Object)((Object)InternalScope.MAIN_SPLIT));
        }
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT);
    }

    public Map<String, Object> getParameterInputs() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"changesAreCompatible", (Object)this.variantScope.getInstantRunBuildContext().hasPassedVerification());
        params.put((Object)"restartDexRequested", (Object)this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY));
        params.put((Object)"minSdkForDx", (Object)this.minSdkForDx);
        return params.build();
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)InstantRunBuildType.RELOAD.getOutputFolder(this.variantScope));
    }

    public boolean isIncremental() {
        return true;
    }

    private List<Path> getClasspath(TransformInvocation transformInvocation) {
        if (!this.enableDesugaring) {
            return Collections.emptyList();
        }
        Collection<File> allFiles = TransformInputUtil.getAllFiles(transformInvocation.getReferencedInputs());
        return allFiles.stream().map(File::toPath).collect(Collectors.toList());
    }

    private List<Path> getBootClasspath() {
        if (!this.enableDesugaring) {
            return Collections.emptyList();
        }
        return this.bootClasspath.getFiles().stream().map(File::toPath).collect(Collectors.toList());
    }

    @VisibleForTesting
    static class JarClassesBuilder
    implements Closeable {
        final File outputFile;
        private JarOutputStream jarOutputStream;
        boolean empty = true;

        private JarClassesBuilder(File outputFile) {
            this.outputFile = outputFile;
        }

        void add(File inputDir, File file) throws IOException {
            if (this.jarOutputStream == null) {
                this.jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));
            }
            this.empty = false;
            InstantRunDex.copyFileInJar(inputDir, file, this.jarOutputStream);
        }

        @Override
        public void close() throws IOException {
            if (this.jarOutputStream != null) {
                this.jarOutputStream.close();
            }
        }

        boolean isEmpty() {
            return this.empty;
        }
    }
}

