/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.packaging.ParsedPackagingOptions;
import com.android.build.gradle.internal.pipeline.IncrementalFileMergerTransformUtils;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeJavaResourcesDelegate;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MergeJavaResourcesTransform
extends Transform {
    private final PackagingOptions packagingOptions;
    private final String name;
    private final Set<? super QualifiedContent.Scope> mergeScopes;
    private final Set<QualifiedContent.ContentType> mergedType;
    private final File intermediateDir;
    private final File cacheDir;

    public MergeJavaResourcesTransform(PackagingOptions packagingOptions, Set<? super QualifiedContent.Scope> mergeScopes, QualifiedContent.ContentType mergedType, String name, VariantScope variantScope) {
        this.packagingOptions = packagingOptions;
        this.name = name;
        this.mergeScopes = ImmutableSet.copyOf(mergeScopes);
        this.mergedType = ImmutableSet.of((Object)mergedType);
        this.intermediateDir = variantScope.getIncrementalDir(variantScope.getFullVariantName() + "-" + name);
        this.cacheDir = new File(this.intermediateDir, "zip-cache");
    }

    public String getName() {
        return this.name;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.mergedType;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.mergeScopes;
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.cacheDir);
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of((Object)"exclude", this.packagingOptions.getExcludes(), (Object)"pickFirst", this.packagingOptions.getPickFirsts(), (Object)"merge", this.packagingOptions.getMerges());
    }

    public boolean isIncremental() {
        return true;
    }

    private File incrementalStateFile() {
        return new File(this.intermediateDir, "merge-state");
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException {
        QualifiedContent.ContentType singleMergedType;
        FileUtils.mkdirs((File)this.cacheDir);
        FileCacheByPath zipCache = new FileCacheByPath(this.cacheDir);
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        ParsedPackagingOptions parsedPackagingOptions = new ParsedPackagingOptions(this.packagingOptions);
        boolean full = false;
        if (!this.incrementalStateFile().isFile() || !invocation.isIncremental()) {
            outputProvider.deleteAll();
            full = true;
        }
        Format outputFormat = (singleMergedType = (QualifiedContent.ContentType)Iterables.getOnlyElement(this.mergedType)) == QualifiedContent.DefaultContentType.RESOURCES ? Format.JAR : Format.DIRECTORY;
        File outputLocation = outputProvider.getContentLocation("resources", this.getOutputTypes(), this.getScopes(), outputFormat);
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        HashMap<IncrementalFileMergerInput, QualifiedContent> contentMap = new HashMap<IncrementalFileMergerInput, QualifiedContent>();
        ArrayList<IncrementalFileMergerInput> inputs = new ArrayList<IncrementalFileMergerInput>((Collection<IncrementalFileMergerInput>)IncrementalFileMergerTransformUtils.toInput(invocation, zipCache, cacheUpdates, full, contentMap));
        MergeJavaResourcesDelegate delegate = new MergeJavaResourcesDelegate(inputs, outputLocation, contentMap, parsedPackagingOptions, singleMergedType, this.incrementalStateFile(), invocation.isIncremental() && this.isIncremental());
        delegate.run();
        cacheUpdates.forEach(Runnable::run);
    }
}

